/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.sql.Date;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.MileageRate;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.MileageRateService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class ActualExpenseMileageRateExistsValidation
extends GenericValidation {
    protected ActualExpense actualExpenseForValidation;
    protected MileageRateService mileageRateService;

    public boolean validate(AttributedDocumentEvent event) {
        if (!StringUtils.isBlank((String)this.getActualExpenseForValidation().getExpenseTypeCode())) {
            if (ObjectUtils.isNull((Object)((Object)this.getActualExpenseForValidation().getExpenseType())) || !StringUtils.equals((String)this.getActualExpenseForValidation().getExpenseType().getCode(), (String)this.getActualExpenseForValidation().getExpenseTypeCode())) {
                this.getActualExpenseForValidation().refreshReferenceObject("expenseType");
            }
            if (this.getActualExpenseForValidation().isMileage()) {
                TravelDocument doc = (TravelDocument)event.getDocument();
                Date effectiveDate = doc.getEffectiveDateForMileageRate(this.getActualExpenseForValidation());
                MileageRate rate = this.getMileageRateService().findMileageRateByExpenseTypeCodeAndDate(this.getActualExpenseForValidation().getExpenseTypeCode(), effectiveDate);
                if (ObjectUtils.isNull((Object)((Object)rate))) {
                    GlobalVariables.getMessageMap().putError("expenseTypeCode", "error.actual.expense.missing.mileage.rate", new String[]{this.getActualExpenseForValidation().getExpenseType().getName()});
                    return false;
                }
            }
        }
        return true;
    }

    public MileageRateService getMileageRateService() {
        return this.mileageRateService;
    }

    public void setMileageRateService(MileageRateService mileageRateService) {
        this.mileageRateService = mileageRateService;
    }

    public ActualExpense getActualExpenseForValidation() {
        return this.actualExpenseForValidation;
    }

    public void setActualExpenseForValidation(ActualExpense actualExpenseForValidation) {
        this.actualExpenseForValidation = actualExpenseForValidation;
    }
}

