/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentPresentationController;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.impl.AccountingLineGroupTotalsUnchangedValidation;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.web.format.CurrencyFormatter;
import org.kuali.rice.kim.api.identity.Person;

public class TravelDocumentAccountingLineTotalsValidation
extends AccountingLineGroupTotalsUnchangedValidation {
    protected static Logger LOG = Logger.getLogger(TravelDocumentAccountingLineTotalsValidation.class);
    protected DocumentHelperService documentHelperService;

    public boolean validate(AttributedDocumentEvent event) {
        Person financialSystemUser;
        TravelDocument travelDoc;
        Set<String> currentEditModes;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"validate start");
        }
        if (this.hasRequiredEditMode(currentEditModes = this.getEditModesFromDocument(travelDoc = (TravelDocument)event.getDocument(), financialSystemUser = GlobalVariables.getUserSession().getPerson()), this.getCandidateEditModes())) {
            List<String> foreignDraftAndWireTransferEditModes = this.getForeignDraftAndWireTransferEditModes();
            if (!this.hasRequiredEditMode(currentEditModes, foreignDraftAndWireTransferEditModes)) {
                TravelDocument persistedDocument = (TravelDocument)this.retrievePersistedDocument(travelDoc);
                if (persistedDocument == null) {
                    this.handleNonExistentDocumentWhenApproving(travelDoc);
                    return true;
                }
                if (persistedDocument.getDocumentHeader().getWorkflowDocument().isSaved() && persistedDocument.getTotalAccountLineAmount().isZero()) {
                    return true;
                }
                if (!persistedDocument.getDocumentHeader().getWorkflowDocument().isCompletionRequested() && persistedDocument.getTotalAccountLineAmount().isLessThan((AbstractKualiDecimal)travelDoc.getTotalAccountLineAmount())) {
                    String persistedTotal = (String)new CurrencyFormatter().format((Object)persistedDocument.getTotalAccountLineAmount());
                    String currentTotal = (String)new CurrencyFormatter().format((Object)travelDoc.getTotalAccountLineAmount());
                    GlobalVariables.getMessageMap().putError("sourceAccountingLines", "error.document.singleAccountingLineSectionTotalChanged", new String[]{persistedTotal, currentTotal});
                    return false;
                }
            }
            return true;
        }
        return super.validate(event);
    }

    protected boolean hasRequiredEditMode(Set<String> currentEditModes, List<String> candidateEditModes) {
        for (String editMode : candidateEditModes) {
            if (!currentEditModes.contains(editMode)) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getEditModesFromDocument(AccountingDocument accountingDocument, Person financialSystemUser) {
        TransactionalDocumentAuthorizer documentAuthorizer = (TransactionalDocumentAuthorizer)this.getDocumentHelperService().getDocumentAuthorizer((Document)accountingDocument);
        TransactionalDocumentPresentationController presentationController = (TransactionalDocumentPresentationController)this.getDocumentHelperService().getDocumentPresentationController((Document)accountingDocument);
        Set presentationControllerEditModes = presentationController.getEditModes((Document)accountingDocument);
        Set editModes = documentAuthorizer.getEditModes((Document)accountingDocument, financialSystemUser, presentationControllerEditModes);
        return editModes;
    }

    protected List<String> getCandidateEditModes() {
        ArrayList<String> candidateEdiModes = new ArrayList<String>();
        candidateEdiModes.add("frnEntry");
        candidateEdiModes.add("wireEntry");
        return candidateEdiModes;
    }

    protected List<String> getForeignDraftAndWireTransferEditModes() {
        ArrayList<String> foreignDraftAndWireTransferEditModes = new ArrayList<String>();
        foreignDraftAndWireTransferEditModes.add("frnEntry");
        foreignDraftAndWireTransferEditModes.add("wireEntry");
        return foreignDraftAndWireTransferEditModes;
    }

    public DocumentHelperService getDocumentHelperService() {
        return this.documentHelperService;
    }

    public void setDocumentHelperService(DocumentHelperService documentHelperService) {
        this.documentHelperService = documentHelperService;
    }
}

