/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.TemDistributionAccountingLine;
import org.kuali.kfs.module.tem.document.validation.event.AddDistributionAccountingLineValidationEvent;
import org.kuali.kfs.module.tem.document.validation.event.AssignDistributionAccountingLinesEvent;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class TravelDocumentDistributionAccountingLinesValidation
extends GenericValidation {
    protected DictionaryValidationService dictionaryValidationService;
    protected BusinessObjectService businessObjectService;
    protected AccountingDistributionService accountingDistributionService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        if (event instanceof AddDistributionAccountingLineValidationEvent) {
            AddDistributionAccountingLineValidationEvent distributionEvent = (AddDistributionAccountingLineValidationEvent)event;
            TravelMvcWrapperBean wrapper = distributionEvent.getTravelForm();
            success = this.getDictionaryValidationService().isBusinessObjectValid((BusinessObject)wrapper.getAccountDistributionnewSourceLine(), "");
            TemDistributionAccountingLine line = wrapper.getAccountDistributionnewSourceLine();
            List<TemDistributionAccountingLine> lines = wrapper.getAccountDistributionsourceAccountingLines();
            if (success) {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("chartOfAccountsCode", line.getChartOfAccountsCode());
                fieldValues.put("accountNumber", line.getAccountNumber());
                Account account = (Account)this.getBusinessObjectService().findByPrimaryKey(Account.class, fieldValues);
                if (account == null) {
                    GlobalVariables.getMessageMap().putError("accountNumber", "error.existence", new String[]{"Account Number"});
                    return false;
                }
                if (line.getAccountLinePercent() == null) {
                    line.setAccountLinePercent(new BigDecimal(0));
                }
                if (line.getAmount() == null) {
                    line.setAmount(KualiDecimal.ZERO);
                }
                if (line.getAmount().isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                    GlobalVariables.getMessageMap().putError("amount", "error.tem.distribution.accountingline.amount.or.percent", new String[]{"Amount"});
                    success = false;
                }
                if (line.getAccountLinePercent().doubleValue() < 0.0) {
                    GlobalVariables.getMessageMap().putError("accountLinePercent", "error.tem.distribution.accountingline.amount.or.percent", new String[]{"Percent"});
                    success = false;
                }
                if (line.getAccountLinePercent().doubleValue() == 0.0 && line.getAmount().isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                    GlobalVariables.getMessageMap().putError("amount", "error.tem.distribution.accountingline.amount.or.percent", new String[]{"Amount"});
                    GlobalVariables.getMessageMap().putError("accountLinePercent", "error.tem.distribution.accountingline.amount.or.percent", new String[]{"Percent"});
                    return false;
                }
            }
        } else if (event instanceof AssignDistributionAccountingLinesEvent) {
            GlobalVariables.getMessageMap().clearErrorPath();
            AssignDistributionAccountingLinesEvent distributionEvent = (AssignDistributionAccountingLinesEvent)event;
            TravelMvcWrapperBean wrapper = distributionEvent.getTravelForm();
            if (!this.getAccountingDistributionService().getTotalAmount(wrapper.getAccountDistributionsourceAccountingLines()).equals((Object)wrapper.getDistributionRemainingAmount(true)) || this.getAccountingDistributionService().getTotalPercent(wrapper.getAccountDistributionsourceAccountingLines()).compareTo(new BigDecimal(100)) != 0) {
                GlobalVariables.getMessageMap().putError("accountDistributionsourceAccountingLines[0].accountLinePercent", "error.tem.distribution.accountingline.total", new String[]{wrapper.getDistributionRemainingAmount(true).toString()});
                success = false;
            }
            if (wrapper.getDistribution() != null && !wrapper.getDistribution().isEmpty() && wrapper.getTravelDocument().getExpenseLimit() != null && wrapper.getTravelDocument().getExpenseLimit().isLessThan((AbstractKualiDecimal)wrapper.getDistributionRemainingAmount(true))) {
                int distributionTargetCount = 0;
                for (AccountingDistribution distribution : wrapper.getDistribution()) {
                    if (!distribution.getSelected().booleanValue()) continue;
                    ++distributionTargetCount;
                }
                if (distributionTargetCount > 1) {
                    GlobalVariables.getMessageMap().putError("accountDistributionsourceAccountingLines*,accountDistributionnewSourceLine*", "error.tem.distribution.tooManyTargets", new String[]{Integer.toString(distributionTargetCount), wrapper.getTravelDocument().getExpenseLimit().toString()});
                    success = false;
                }
            }
        }
        return success;
    }

    public DictionaryValidationService getDictionaryValidationService() {
        return (DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class);
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setAccountingDistributionService(AccountingDistributionService accountingDistributionService) {
        this.accountingDistributionService = accountingDistributionService;
    }

    public AccountingDistributionService getAccountingDistributionService() {
        return (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
    }

    public BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }
}

