/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.batch.PerDiemLoadStep;
import org.kuali.kfs.module.tem.batch.businessobject.MealBreakDownStrategy;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.MileageRate;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.dataaccess.PerDiemDao;
import org.kuali.kfs.module.tem.dataaccess.TravelDocumentDao;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.service.PerDiemService;
import org.kuali.kfs.module.tem.service.TemExpenseService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.service.impl.ExpenseServiceBase;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PerDiemServiceImpl
extends ExpenseServiceBase
implements PerDiemService,
TemExpenseService {
    private static Logger LOG = Logger.getLogger(PerDiemServiceImpl.class);
    protected DateTimeService dateTimeService;
    protected ParameterService parameterService;
    protected BusinessObjectService businessObjectService;
    protected StateService stateService;
    protected PerDiemDao perDiemDao;
    protected Map<String, MealBreakDownStrategy> mealBreakDownStrategies;
    protected String allStateCodes;
    protected TravelDocumentDao travelDocumentDao;
    protected TravelExpenseService travelExpenseService;
    List<PerDiem> persistedPerDiems;

    @Override
    public <T extends PerDiem> void breakDownMealsIncidental(List<T> perDiemList) {
        for (PerDiem perDiem : perDiemList) {
            this.breakDownMealsIncidental(perDiem);
        }
    }

    @Override
    public <T extends PerDiem> void breakDownMealsIncidental(T perDiem) {
        String conusIndicator = perDiem.getConusIndicator();
        if (!this.getMealBreakDownStrategies().containsKey(conusIndicator)) {
            throw new RuntimeException("Fail to meal break down strategy for the CONUS indicator: " + conusIndicator);
        }
        MealBreakDownStrategy mealBreakDownStrategy = this.getMealBreakDownStrategies().get(conusIndicator);
        mealBreakDownStrategy.breakDown(perDiem);
    }

    public <T extends PerDiem> List<T> retrieveInactivePerDiem() {
        HashMap<String, Boolean> fieldValues = new HashMap<String, Boolean>();
        fieldValues.put("active", Boolean.FALSE);
        return (List)this.getBusinessObjectService().findMatching(PerDiem.class, fieldValues);
    }

    @Override
    public <T extends PerDiem> void updateTripType(List<T> perDiemList) {
        for (PerDiem perDiem : perDiemList) {
            this.updateTripType(perDiem);
        }
    }

    @Override
    public <T extends PerDiem> void updateTripType(T perDiem) {
        String region = perDiem.getPrimaryDestination().getRegion().getRegionCode();
        String institutionState = this.getInstitutionState();
        String tripTypeCode = this.getInternationalTripTypeCode();
        if (StringUtils.equals((String)region, (String)institutionState)) {
            tripTypeCode = this.getInStateTripTypeCode();
        } else if (this.getAllStateCodes().contains(";" + region.toUpperCase() + ";")) {
            tripTypeCode = this.getOutStateTripTypeCode();
        }
        perDiem.getPrimaryDestination().getRegion().setTripTypeCode(tripTypeCode);
    }

    protected String getInstitutionState() {
        String institutionState = this.getParameterService().getParameterValueAsString(PerDiemLoadStep.class, "INSTITUTION_STATE");
        return institutionState;
    }

    @Override
    public <T extends PerDiem> List<PerDiem> retrievePreviousPerDiem(T perDiem) {
        return (List)this.perDiemDao.findSimilarPerDiems(perDiem);
    }

    @Override
    public <T extends PerDiem> boolean hasExistingPerDiem(T perDiem) {
        if (ObjectUtils.isNull(this.persistedPerDiems)) {
            this.persistedPerDiems = (List)this.businessObjectService.findAll(PerDiem.class);
        }
        boolean retval = this.persistedPerDiems.contains(perDiem);
        return retval;
    }

    protected String getOutStateTripTypeCode() {
        String outStateTripTypeCode = this.getParameterService().getParameterValueAsString(PerDiemLoadStep.class, "OUT_OF_STATE_TRIP_TYPE_CODE");
        return outStateTripTypeCode;
    }

    protected String getInStateTripTypeCode() {
        String inStateTripTypeCode = this.getParameterService().getParameterValueAsString(PerDiemLoadStep.class, "IN_STATE_TRIP_TYPE_CODE");
        return inStateTripTypeCode;
    }

    protected String getInternationalTripTypeCode() {
        String internationalTripTypeCode = this.getParameterService().getParameterValueAsString(PerDiemLoadStep.class, "INTERNATIONAL_TRIP_TYPE_CODE");
        return internationalTripTypeCode;
    }

    @Override
    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public PerDiemDao getPerDiemDao() {
        return this.perDiemDao;
    }

    public void setPerDiemDao(PerDiemDao perDiemDao) {
        this.perDiemDao = perDiemDao;
    }

    public Map<String, MealBreakDownStrategy> getMealBreakDownStrategies() {
        return this.mealBreakDownStrategies;
    }

    public void setMealBreakDownStrategies(Map<String, MealBreakDownStrategy> mealBreakDownStrategies) {
        this.mealBreakDownStrategies = mealBreakDownStrategies;
    }

    public StateService getStateService() {
        return this.stateService;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public void setAllStateCodes(String allStateCodes) {
        this.allStateCodes = allStateCodes;
    }

    public String getAllStateCodes() {
        if (StringUtils.isEmpty((String)this.allStateCodes)) {
            List codes = this.getStateService().findAllStatesInCountry("US");
            StringBuffer sb = new StringBuffer();
            sb.append(";").append("US".toUpperCase()).append(";");
            for (State state : codes) {
                if (!state.isActive()) continue;
                sb.append(state.getCode().toUpperCase()).append(";");
            }
            this.allStateCodes = sb.toString();
        }
        return this.allStateCodes;
    }

    public String getObjectCodeFrom(TravelDocument travelDocument, String paramName) {
        if (travelDocument instanceof TravelReimbursementDocument) {
            int searchIdx;
            TripType tripType;
            String parameterValue = this.getParameterService().getParameterValueAsString(TravelReimbursementDocument.class, paramName);
            String paramSearchStr = "";
            TravelerDetail traveler = travelDocument.getTraveler();
            if (traveler != null) {
                paramSearchStr = paramSearchStr + traveler.getTravelerTypeCode() + "=";
            }
            if ((tripType = travelDocument.getTripType()) != null) {
                paramSearchStr = paramSearchStr + tripType.getCode() + "=";
            }
            if ((searchIdx = parameterValue.indexOf(paramSearchStr)) == -1) {
                return null;
            }
            int endIdx = parameterValue.indexOf(";", searchIdx);
            if (endIdx == -1) {
                return parameterValue.substring(searchIdx + paramSearchStr.length());
            }
            return parameterValue.substring(searchIdx + paramSearchStr.length(), endIdx);
        }
        if (travelDocument.getTripType() != null) {
            return travelDocument.getTripType().getEncumbranceObjCode();
        }
        return null;
    }

    @Override
    public Map<String, AccountingDistribution> getAccountingDistribution(TravelDocument document) {
        HashMap<String, AccountingDistribution> distributionMap = new HashMap<String, AccountingDistribution>();
        if (document.getPerDiemExpenses() != null && document.getPerDiemExpenses().size() > 0) {
            String defaultChartCode = ExpenseUtils.getDefaultChartCode(document);
            String perDiemCode = this.getObjectCodeFrom(document, "PER_DIEM_OBJECT_CODE");
            if (document instanceof TravelAuthorizationDocument) {
                perDiemCode = document.getTripType() != null ? document.getTripType().getEncumbranceObjCode() : null;
            }
            LOG.debug((Object)("Looking up Object Code for chart = " + defaultChartCode + " perDiemObjectCode = " + perDiemCode));
            ObjectCode perDiemObjCode = this.getObjectCodeService().getByPrimaryIdForCurrentYear(defaultChartCode, perDiemCode);
            LOG.debug((Object)("Got per diem object code " + perDiemObjCode));
            AccountingDistribution accountingDistribution = new AccountingDistribution();
            if (perDiemObjCode != null) {
                String key = perDiemObjCode.getCode() + "-" + document.getDefaultCardTypeCode();
                for (PerDiemExpense expense : document.getPerDiemExpenses()) {
                    if (expense.getPersonal().booleanValue()) continue;
                    if (!distributionMap.containsKey(key)) {
                        accountingDistribution.setCardType(document.getDefaultCardTypeCode());
                        accountingDistribution.setObjectCode(perDiemObjCode.getCode());
                        accountingDistribution.setObjectCodeName(perDiemObjCode.getName());
                        distributionMap.put(key, accountingDistribution);
                    }
                    ((AccountingDistribution)distributionMap.get(key)).setSubTotal((KualiDecimal)((AccountingDistribution)distributionMap.get(key)).getSubTotal().add((AbstractKualiDecimal)expense.getMealsAndIncidentals()));
                    ((AccountingDistribution)distributionMap.get(key)).setRemainingAmount((KualiDecimal)((AccountingDistribution)distributionMap.get(key)).getRemainingAmount().add((AbstractKualiDecimal)expense.getMealsAndIncidentals()));
                    LOG.debug((Object)("Set perdiem distribution subtotal to " + accountingDistribution.getSubTotal()));
                }
                if (document.getPerDiemAdjustment() != null && document.getPerDiemAdjustment().isPositive()) {
                    ((AccountingDistribution)distributionMap.get(key)).setSubTotal((KualiDecimal)((AccountingDistribution)distributionMap.get(key)).getSubTotal().subtract((AbstractKualiDecimal)document.getPerDiemAdjustment()));
                    ((AccountingDistribution)distributionMap.get(key)).setRemainingAmount((KualiDecimal)((AccountingDistribution)distributionMap.get(key)).getRemainingAmount().subtract((AbstractKualiDecimal)document.getPerDiemAdjustment()));
                }
                this.distributeLodging(distributionMap, document);
                this.distributeMileage(distributionMap, document);
            } else {
                LOG.error((Object)"PerDiemObjCode is null!");
            }
        }
        return distributionMap;
    }

    protected void distributeLodging(Map<String, AccountingDistribution> distributionMap, TravelDocument document) {
        String defaultChartCode = ExpenseUtils.getDefaultChartCode(document);
        String lodgingCode = this.getObjectCodeFrom(document, "LODGING_OBJECT_CODE");
        if (document instanceof TravelAuthorizationDocument) {
            lodgingCode = document.getTripType() != null ? document.getTripType().getEncumbranceObjCode() : null;
        }
        LOG.debug((Object)("Looking up Object Code for chart = " + defaultChartCode + " lodgingCode = " + lodgingCode));
        ObjectCode lodgingObjCode = this.getObjectCodeService().getByPrimaryIdForCurrentYear(defaultChartCode, lodgingCode);
        LOG.debug((Object)("Got lodging object code " + lodgingObjCode));
        AccountingDistribution accountingDistribution = new AccountingDistribution();
        String key = lodgingObjCode.getCode() + "-" + document.getDefaultCardTypeCode();
        if (document.getPerDiemExpenses() != null) {
            for (PerDiemExpense expense : document.getPerDiemExpenses()) {
                if (!distributionMap.containsKey(key)) {
                    accountingDistribution.setCardType(document.getDefaultCardTypeCode());
                    accountingDistribution.setObjectCode(lodgingObjCode.getCode());
                    accountingDistribution.setObjectCodeName(lodgingObjCode.getName());
                    distributionMap.put(key, accountingDistribution);
                }
                distributionMap.get(key).setSubTotal((KualiDecimal)distributionMap.get(key).getSubTotal().add((AbstractKualiDecimal)expense.getLodgingTotal()));
                distributionMap.get(key).setRemainingAmount((KualiDecimal)distributionMap.get(key).getRemainingAmount().add((AbstractKualiDecimal)expense.getLodgingTotal()));
            }
        }
    }

    protected void distributeMileage(Map<String, AccountingDistribution> distributionMap, TravelDocument document) {
        String defaultChartCode = ExpenseUtils.getDefaultChartCode(document);
        AccountingDistribution accountingDistribution = new AccountingDistribution();
        if (document.getPerDiemExpenses() != null) {
            for (PerDiemExpense expense : document.getPerDiemExpenses()) {
                if (StringUtils.isBlank((String)expense.getMileageRateExpenseTypeCode())) continue;
                String mileageCode = null;
                if (document instanceof TravelAuthorizationDocument && document.getTripType() != null) {
                    mileageCode = document.getTripType().getEncumbranceObjCode();
                } else {
                    String travelerTypeCode = ObjectUtils.isNull((Object)((Object)document.getTraveler())) ? null : document.getTraveler().getTravelerTypeCode();
                    ExpenseTypeObjectCode expenseTypeObjectCode = this.getTravelExpenseService().getExpenseType(expense.getMileageRateExpenseTypeCode(), document.getDocumentTypeName(), document.getTripTypeCode(), travelerTypeCode);
                    if (expenseTypeObjectCode != null) {
                        mileageCode = expenseTypeObjectCode.getFinancialObjectCode();
                    }
                }
                LOG.debug((Object)("Looking up Object Code for chart = " + defaultChartCode + " mileageCode = " + mileageCode));
                ObjectCode mileageObjCode = this.getObjectCodeService().getByPrimaryIdForCurrentYear(defaultChartCode, mileageCode);
                LOG.debug((Object)("Got mileage object code " + mileageObjCode));
                String key = mileageObjCode.getCode() + "-" + document.getDefaultCardTypeCode();
                if (!distributionMap.containsKey(key)) {
                    accountingDistribution.setCardType(document.getDefaultCardTypeCode());
                    accountingDistribution.setObjectCode(mileageObjCode.getCode());
                    accountingDistribution.setObjectCodeName(mileageObjCode.getName());
                    distributionMap.put(key, accountingDistribution);
                }
                distributionMap.get(key).setSubTotal((KualiDecimal)distributionMap.get(key).getSubTotal().add((AbstractKualiDecimal)expense.getMileageTotal()));
                distributionMap.get(key).setRemainingAmount((KualiDecimal)distributionMap.get(key).getRemainingAmount().add((AbstractKualiDecimal)expense.getMileageTotal()));
            }
        }
    }

    @Override
    public KualiDecimal getAllExpenseTotal(TravelDocument document, boolean includeNonReimbursable) {
        KualiDecimal total = KualiDecimal.ZERO;
        for (PerDiemExpense expense : document.getPerDiemExpenses()) {
            if ((!expense.getPersonal().booleanValue() || !includeNonReimbursable) && expense.getPersonal().booleanValue()) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)expense.getDailyTotalForDocument(document));
        }
        return total;
    }

    @Override
    public KualiDecimal getNonReimbursableExpenseTotal(TravelDocument document) {
        return KualiDecimal.ZERO;
    }

    @Override
    public KualiDecimal getMealsAndIncidentalsGrandTotal(TravelDocument travelDocument) {
        KualiDecimal mealsAndIncidentalsTotal = KualiDecimal.ZERO;
        for (PerDiemExpense expense : travelDocument.getPerDiemExpenses()) {
            mealsAndIncidentalsTotal = (KualiDecimal)mealsAndIncidentalsTotal.add((AbstractKualiDecimal)expense.getMealsAndIncidentals());
        }
        return mealsAndIncidentalsTotal;
    }

    @Override
    public KualiDecimal getLodgingGrandTotal(TravelDocument travelDocument) {
        KualiDecimal lodgingTotal = KualiDecimal.ZERO;
        for (PerDiemExpense perDiemExpense : travelDocument.getPerDiemExpenses()) {
            if (perDiemExpense.getPersonal().booleanValue()) continue;
            lodgingTotal = (KualiDecimal)lodgingTotal.add((AbstractKualiDecimal)perDiemExpense.getLodgingTotal());
        }
        return lodgingTotal;
    }

    @Override
    public KualiDecimal getMileageTotalGrandTotal(TravelDocument travelDocument) {
        KualiDecimal mileageTotal = KualiDecimal.ZERO;
        for (PerDiemExpense perDiemExpense : travelDocument.getPerDiemExpenses()) {
            mileageTotal = (KualiDecimal)mileageTotal.add((AbstractKualiDecimal)perDiemExpense.getMileageTotal());
        }
        return mileageTotal;
    }

    @Override
    public KualiDecimal getDailyTotalGrandTotal(TravelDocument travelDocument) {
        KualiDecimal dailyTotal = KualiDecimal.ZERO;
        for (PerDiemExpense perDiemExpense : travelDocument.getPerDiemExpenses()) {
            dailyTotal = (KualiDecimal)dailyTotal.add((AbstractKualiDecimal)perDiemExpense.getDailyTotal());
        }
        return dailyTotal;
    }

    @Override
    public Integer getMilesGrandTotal(TravelDocument travelDocument) {
        Integer milesTotal = 0;
        for (PerDiemExpense perDiemExpense : travelDocument.getPerDiemExpenses()) {
            milesTotal = milesTotal + perDiemExpense.getMiles();
        }
        return milesTotal;
    }

    @Override
    public boolean isPerDiemHandlingLodging() {
        Collection perDiemCategoryValues = this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "PER_DIEM_CATEGORIES");
        for (String perDiemCategoryValue : perDiemCategoryValues) {
            String[] keyValueSplit = perDiemCategoryValue.split("=");
            if (keyValueSplit.length != 2 || !TemConstants.PerDiemType.lodging.name().equalsIgnoreCase(keyValueSplit[0])) continue;
            return "Y".equalsIgnoreCase(keyValueSplit[1]);
        }
        return false;
    }

    @Override
    public PerDiem getPerDiem(int primaryDestinationId, Timestamp perDiemDate, Date effectiveDate) {
        List<PerDiem> possiblePerDiems = this.getTravelDocumentDao().findEffectivePerDiems(primaryDestinationId, effectiveDate);
        Date date = KfsDateUtils.clearTimeFields((Date)new Date(perDiemDate.getTime()));
        if (possiblePerDiems.isEmpty()) {
            return null;
        }
        if (possiblePerDiems.size() == 1) {
            return possiblePerDiems.get(0);
        }
        Collections.sort(possiblePerDiems, new PerDiemComparator());
        PerDiem foundPerDiem = null;
        for (PerDiem perDiem : possiblePerDiems) {
            if (!this.isOnOrAfterSeasonBegin(perDiem.getSeasonBeginMonthAndDay(), perDiemDate)) continue;
            foundPerDiem = perDiem;
        }
        if (foundPerDiem == null) {
            foundPerDiem = possiblePerDiems.get(possiblePerDiems.size() - 1);
        }
        return foundPerDiem;
    }

    protected boolean isOnOrAfterSeasonBegin(String seasonBegin, Timestamp d) {
        if (StringUtils.isBlank((String)seasonBegin)) {
            return true;
        }
        Calendar dCal = Calendar.getInstance();
        dCal.setTime(d);
        int year = dCal.get(1);
        Calendar seasonBeginCal = this.getSeasonBeginMonthDayCalendar(seasonBegin, year);
        if (KfsDateUtils.isSameDay((Calendar)dCal, (Calendar)seasonBeginCal)) {
            return true;
        }
        return dCal.after(seasonBeginCal);
    }

    protected Calendar getSeasonBeginMonthDayCalendar(String seasonBegin, int year) {
        String[] seasonBeginMonthDay = seasonBegin.split("/");
        Calendar seasonBeginCal = Calendar.getInstance();
        seasonBeginCal.set(2, Integer.parseInt(seasonBeginMonthDay[0]) - 1);
        seasonBeginCal.set(5, Integer.parseInt(seasonBeginMonthDay[1]));
        seasonBeginCal.set(1, year);
        return seasonBeginCal;
    }

    @Override
    public void processExpense(TravelDocument travelDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
    }

    @Override
    public void updateExpense(TravelDocument travelDocument) {
    }

    @Override
    public void calculateDistributionTotals(TravelDocument document, Map<String, AccountingDistribution> distributionMap, List<? extends TemExpense> expenses) {
    }

    @Override
    public List<? extends TemExpense> getExpenseDetails(TravelDocument document) {
        return null;
    }

    @Override
    public void setPerDiemCategoriesAndBreakdown(TravelFormBase form) {
        Collection perDiemCats = this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "PER_DIEM_CATEGORIES");
        form.parsePerDiemCategories(perDiemCats);
        Boolean showPerDiemBreakdown = this.parameterService.getParameterValueAsBoolean(TravelAuthorizationDocument.class, "PER_DIEM_AMOUNT_EDITABLE_IND");
        if ("TR".equals(form.getDocTypeName())) {
            showPerDiemBreakdown = this.parameterService.getParameterValueAsBoolean(TravelReimbursementDocument.class, "PER_DIEM_AMOUNT_EDITABLE_IND");
        }
        form.setShowPerDiemBreakdown(showPerDiemBreakdown);
    }

    @Override
    public boolean isMileageRateAvailableForAllPerDiem(TravelDocument doc) {
        String defaultPerDiemMileageRate = this.getDefaultPerDiemMileageRateExpenseType();
        if (StringUtils.isBlank((String)defaultPerDiemMileageRate)) {
            return false;
        }
        if (StringUtils.isBlank((String)doc.getTripTypeCode()) || doc.getTripBegin() == null || doc.getTripEnd() == null) {
            return true;
        }
        Calendar currDay = Calendar.getInstance();
        currDay.setTime(KfsDateUtils.clearTimeFields((java.util.Date)doc.getTripBegin()));
        Calendar lastDay = Calendar.getInstance();
        lastDay.setTime(KfsDateUtils.clearTimeFields((java.util.Date)doc.getTripEnd()));
        while (currDay.before(lastDay) || currDay.equals(lastDay)) {
            Date effectiveDay = doc.getEffectiveDateForPerDiem(new Timestamp(currDay.getTimeInMillis()));
            MileageRate currDayMileageRate = this.getMileageRateService().findMileageRateByExpenseTypeCodeAndDate(defaultPerDiemMileageRate, effectiveDay);
            if (currDayMileageRate == null) {
                return false;
            }
            currDay.add(5, 1);
        }
        return true;
    }

    @Override
    public String getDefaultPerDiemMileageRateExpenseType() {
        String defaultPerDiemMileageRate = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "PER_DIEM_MILEAGE_RATE_EXPENSE_TYPE_CODE", "");
        return defaultPerDiemMileageRate;
    }

    public TravelDocumentDao getTravelDocumentDao() {
        return this.travelDocumentDao;
    }

    public void setTravelDocumentDao(TravelDocumentDao travelDocumentDao) {
        this.travelDocumentDao = travelDocumentDao;
    }

    public TravelExpenseService getTravelExpenseService() {
        return this.travelExpenseService;
    }

    public void setTravelExpenseService(TravelExpenseService travelExpenseService) {
        this.travelExpenseService = travelExpenseService;
    }

    protected class PerDiemComparator
    implements Comparator<PerDiem> {
        protected PerDiemComparator() {
        }

        @Override
        public int compare(PerDiem viola, PerDiem sebastian) {
            int sebastianBeginDay;
            int sebastianBeginMonth;
            if (StringUtils.isBlank((String)viola.getSeasonBeginMonthAndDay())) {
                if (StringUtils.isBlank((String)sebastian.getSeasonBeginMonthAndDay())) {
                    return 0;
                }
                return 1;
            }
            if (StringUtils.isBlank((String)sebastian.getSeasonBeginMonthAndDay())) {
                return -1;
            }
            String[] violaSeasonBegin = viola.getSeasonBeginMonthAndDay().split("/");
            String[] sebastianSeasonBegin = sebastian.getSeasonBeginMonthAndDay().split("/");
            int violaBeginMonth = Integer.parseInt(violaSeasonBegin[0]);
            if (violaBeginMonth != (sebastianBeginMonth = Integer.parseInt(sebastianSeasonBegin[0]))) {
                return violaBeginMonth - sebastianBeginMonth;
            }
            int violaBeginDay = Integer.parseInt(violaSeasonBegin[1]);
            if (violaBeginDay != (sebastianBeginDay = Integer.parseInt(sebastianSeasonBegin[1]))) {
                return violaBeginDay - sebastianBeginDay;
            }
            return 0;
        }
    }
}

