/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TravelDocumentNotificationService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.KfsNotificationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class TravelDocumentNotificationServiceImpl
implements TravelDocumentNotificationService {
    protected static Logger LOG = Logger.getLogger(TravelDocumentNotificationServiceImpl.class);
    private String notificationTemplate;
    private ParameterService parameterService;
    private KfsNotificationService kfsNotificationService;
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private List<String> noNotificationRouteStatusList;

    @Override
    public void sendNotificationOnChange(TravelDocument travelDocument, DocumentRouteStatusChange statusChangeDTO) {
        String documentTypeCode = travelDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        TemConstants.NotificationPreference preference = null;
        if (this.isNotificationEnabled()) {
            TemProfile travelProfile = this.getTravelProfile(travelDocument);
            String newRouteStatus = statusChangeDTO.getNewRouteStatus();
            if (travelProfile == null) {
                LOG.error((Object)"travelProfile is null.");
                return;
            }
            if (travelDocument instanceof TravelAuthorizationDocument) {
                if (!this.verifyDocumentTypeCodes(documentTypeCode, this.getEligibleTravelAuthorizationDocumentTypeCodes())) {
                    return;
                }
                preference = this.getEmailNotificationPreference(preference, newRouteStatus, travelProfile.getNotifyTAFinal(), travelProfile.getNotifyTAStatusChange(), documentTypeCode);
            } else {
                if (!this.verifyDocumentTypeCodes(documentTypeCode, this.getEligibleTravelExpenseDocumentTypeCodes())) {
                    return;
                }
                preference = this.getEmailNotificationPreference(preference, newRouteStatus, travelProfile.getNotifyTERFinal(), travelProfile.getNotifyTERStatusChange(), documentTypeCode);
            }
            this.sendNotificationByPreference(travelDocument, statusChangeDTO, preference);
        }
    }

    private boolean verifyDocumentTypeCodes(String documentTypeCode, Collection<String> eligibleDocumentTypeCodes) {
        return !ObjectUtils.isNull(eligibleDocumentTypeCodes) && eligibleDocumentTypeCodes.contains(documentTypeCode);
    }

    private TemConstants.NotificationPreference getEmailNotificationPreference(TemConstants.NotificationPreference preference, String newRouteStatus, boolean notifyOnFinal, boolean notifyOnStatusChange, String documentTypeCode) {
        if (notifyOnFinal && (DocumentStatus.FINAL.getCode().equals(newRouteStatus) || DocumentStatus.PROCESSED.getCode().equals(newRouteStatus))) {
            preference = "TA".equals(documentTypeCode) ? TemConstants.NotificationPreference.TA_ON_FINAL : TemConstants.NotificationPreference.TER_ON_FINAL;
        } else if (notifyOnStatusChange && !this.getNoNotificationRouteStatusList().contains(newRouteStatus)) {
            preference = "TA".equals(documentTypeCode) ? TemConstants.NotificationPreference.TA_ON_CHANGE : TemConstants.NotificationPreference.TER_ON_CHANGE;
        }
        return preference;
    }

    protected TemProfile getTravelProfile(TravelDocument travelDocument) {
        Integer travelProfileId = travelDocument.getProfileId();
        if (travelProfileId != null) {
            return (TemProfile)this.getBusinessObjectService().findBySinglePrimaryKey(TemProfile.class, (Object)travelProfileId);
        }
        return null;
    }

    protected void sendNotificationByPreference(TravelDocument travelDocument, DocumentRouteStatusChange statusChangeDTO, TemConstants.NotificationPreference preference) {
        if (ObjectUtils.isNull((Object)((Object)preference))) {
            return;
        }
        MailMessage mailMessage = this.buildDocumentStatusChangeMailMessage(travelDocument, statusChangeDTO, preference);
        if (mailMessage != null) {
            this.getKfsNotificationService().sendNotificationByMail(mailMessage);
        } else {
            LOG.error((Object)"mailMessage is null.");
        }
    }

    protected MailMessage buildDocumentStatusChangeMailMessage(TravelDocument travelDocument, DocumentRouteStatusChange statusChangeDTO, TemConstants.NotificationPreference preference) {
        MailMessage mailMessage = new MailMessage();
        String senderEmailAddress = this.getNotificationSender();
        mailMessage.setFromAddress(senderEmailAddress);
        TravelerDetail traveler = travelDocument.getTraveler();
        String travelerEmailAddress = null;
        if (!ObjectUtils.isNull((Object)((Object)traveler)) && !ObjectUtils.isNull((Object)travelDocument.getProfileId())) {
            TemProfile profile = ((TemProfileService)SpringContext.getBean(TemProfileService.class)).findTemProfileById(travelDocument.getProfileId());
            travelerEmailAddress = profile.getEmailAddress();
        } else {
            travelerEmailAddress = traveler.getEmailAddress();
        }
        if (senderEmailAddress != null && travelerEmailAddress != null) {
            mailMessage.addToAddress(travelerEmailAddress);
            String notificationSubject = this.getNotificationSubject(preference);
            mailMessage.setSubject(notificationSubject);
            String notificationBody = this.buildNotificationBody(travelDocument, statusChangeDTO, preference);
            mailMessage.setMessage(notificationBody);
            return mailMessage;
        }
        return null;
    }

    protected String buildNotificationBody(TravelDocument travelDocument, DocumentRouteStatusChange statusChange, TemConstants.NotificationPreference preference) {
        HashMap<String, Object> notificationInformationHolder = new HashMap<String, Object>();
        notificationInformationHolder.put("notificationPreference", preference.getLabel());
        notificationInformationHolder.put("document", travelDocument);
        notificationInformationHolder.put("statusChangeDTO", statusChange);
        String newStatusLabel = (String)KewApiConstants.DOCUMENT_STATUSES.get(statusChange.getNewRouteStatus());
        notificationInformationHolder.put("newRouteStatus", newStatusLabel);
        String oldStatusLabel = (String)KewApiConstants.DOCUMENT_STATUSES.get(statusChange.getOldRouteStatus());
        notificationInformationHolder.put("oldRouteStatus", oldStatusLabel);
        String campusTravelEmailAddress = this.getCampusTravelEmailAddress();
        notificationInformationHolder.put("campusTravelEmailAddress", campusTravelEmailAddress);
        notificationInformationHolder.put(DateTimeService.class.getSimpleName(), this.dateTimeService);
        return this.getKfsNotificationService().generateNotificationContent(this.getNotificationTemplate(), notificationInformationHolder);
    }

    protected Collection<String> getEligibleTravelExpenseDocumentTypeCodes() {
        return this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "SEND_NOTIFICATION_DOCUMENT_TYPES");
    }

    protected Collection<String> getEligibleTravelAuthorizationDocumentTypeCodes() {
        return this.getParameterService().getParameterValuesAsString(TravelAuthorizationDocument.class, "SEND_NOTIFICATION_DOCUMENT_TYPES");
    }

    protected String getNotificationSender() {
        return this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "FROM_EMAIL_ADDRESS");
    }

    protected String getNotificationSubject(TemConstants.NotificationPreference preference) {
        String preferenceCode = preference.getParameterEventCode();
        String subjectParameterName = StringUtils.isBlank((String)preferenceCode) ? "CHANGE_NOTIFICATION_SUBJECT" : preferenceCode + "_NOTIFICATION_SUBJECT";
        Class subjectParameterComponent = preference.getParameterComponentClass() == null ? TemParameterConstants.TEM_DOCUMENT.class : preference.getParameterComponentClass();
        return this.getParameterService().getParameterValueAsString(subjectParameterComponent, subjectParameterName);
    }

    protected String getCampusTravelEmailAddress() {
        return this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "TRAVEL_EMAIL_ADDRESS");
    }

    protected boolean isNotificationEnabled() {
        return this.getParameterService().getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "SEND_NOTIFICATION_ON_WORKFLOW_STATUS_CHANGE_IND");
    }

    protected List<String> getNoNotificationRouteStatusList() {
        if (ObjectUtils.isNull(this.noNotificationRouteStatusList)) {
            this.noNotificationRouteStatusList = new ArrayList<String>();
            this.noNotificationRouteStatusList.add(DocumentStatus.PROCESSED.getCode());
            this.noNotificationRouteStatusList.add(DocumentStatus.INITIATED.getCode());
            this.noNotificationRouteStatusList.add(DocumentStatus.SAVED.getCode());
        }
        return this.noNotificationRouteStatusList;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public KfsNotificationService getKfsNotificationService() {
        return this.kfsNotificationService;
    }

    public void setKfsNotificationService(KfsNotificationService kfsNotificationService) {
        this.kfsNotificationService = kfsNotificationService;
    }

    public String getNotificationTemplate() {
        return this.notificationTemplate;
    }

    public void setNotificationTemplate(String notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

