/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.fp.businessobject.TravelCompanyCode;
import org.kuali.kfs.krad.service.KeyValuesService;
import org.kuali.kfs.module.tem.service.TravelExpenseTypeService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.ConcreteKeyValue;

public class TravelExpenseTypeServiceImpl
implements TravelExpenseTypeService {
    private KeyValuesService keyValuesService;

    @Override
    public Map<String, String> getCompanyNameMapFrom(String expenseTypeCode) {
        HashMap<String, String> retval = new HashMap<String, String>();
        List<TravelCompanyCode> boList = this.getCompanyCodesBy(expenseTypeCode);
        for (TravelCompanyCode element : boList) {
            retval.put(element.getName(), element.getName());
        }
        return retval;
    }

    @Override
    public List<ConcreteKeyValue> getCompanyNamePairsFrom(String expenseTypeCode) {
        List<TravelCompanyCode> boList = this.getCompanyCodesBy(expenseTypeCode);
        ArrayList<ConcreteKeyValue> keyValues = new ArrayList<ConcreteKeyValue>();
        keyValues.add(new ConcreteKeyValue("", ""));
        for (TravelCompanyCode element : boList) {
            if (!element.isActive()) continue;
            keyValues.add(new ConcreteKeyValue(element.getName(), element.getName()));
        }
        return keyValues;
    }

    protected List<TravelCompanyCode> getCompanyCodesBy(String expenseTypeCode) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("expenseTypeObjectCode", expenseTypeCode);
        List boList = (List)this.getKeyValuesService().findMatching(TravelCompanyCode.class, criteria);
        return boList;
    }

    protected KeyValuesService getKeyValuesService() {
        return (KeyValuesService)SpringContext.getBean(KeyValuesService.class);
    }
}

