/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterContract;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTravelerService;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.businessobject.defaultvalue.NextAgencyStagingDataIdFinder;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ExpenseImportByTravelerServiceTest
extends KualiTestBase {
    private ExpenseImportByTravelerService expenseImportByTravelerService;
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;
    private SequenceAccessorService sas;
    private ParameterService parameterService;
    private static final String EMPLOYEE_ID = "123456789";
    private static final String CUSTOMER_NUM = "ABC1234";

    protected void setUp() throws Exception {
        super.setUp();
        this.expenseImportByTravelerService = (ExpenseImportByTravelerService)SpringContext.getBean(ExpenseImportByTravelerService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
        this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    @Test
    @ConfigureContext(shouldCommitTransactions=false)
    public void testValidateAccountingInfo() {
        AgencyStagingData agency = this.createAgencyStagingData();
        TemProfile profile = this.createTemProfile();
        Parameter param = this.parameterService.getParameter(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_AIRFARE_OBJECT_CODE");
        Parameter.Builder builder = Parameter.Builder.create((ParameterContract)param);
        builder.setValue("5000");
        this.parameterService.updateParameter(builder.build());
        this.expenseImportByTravelerService.validateAccountingInfo(agency);
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)agency.getErrorCode().equals("OK"));
        ExpenseImportByTravelerServiceTest.assertTrue((agency.getTripAccountingInformation().size() == 1 ? 1 : 0) != 0);
        TripAccountingInformation accountingInfo = (TripAccountingInformation)agency.getTripAccountingInformation().get(0);
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)StringUtils.equals((String)accountingInfo.getTripAccountNumber(), (String)profile.getDefaultAccount()));
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)StringUtils.equals((String)accountingInfo.getTripSubAccountNumber(), (String)profile.getDefaultSubAccount()));
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)StringUtils.equals((String)accountingInfo.getProjectCode(), (String)profile.getDefaultProjectCode()));
    }

    @Test
    @ConfigureContext(shouldCommitTransactions=false)
    public void testValidateTraveler() {
        TemProfile employee = this.createTemProfile();
        employee.setTravelerTypeCode("EMP");
        employee.setEmployeeId(EMPLOYEE_ID);
        this.businessObjectService.save((PersistableBusinessObject)employee);
        TemProfile customer = this.createTemProfile();
        customer.setTravelerTypeCode("NON");
        customer.setCustomerNumber(CUSTOMER_NUM);
        this.businessObjectService.save((PersistableBusinessObject)customer);
        AgencyStagingData agency = this.createAgencyStagingData();
        agency.setTravelerId("987654321");
        List errors = this.expenseImportByTravelerService.validateTraveler(agency);
        ExpenseImportByTravelerServiceTest.assertTrue((!errors.isEmpty() ? 1 : 0) != 0);
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)agency.getErrorCode().equals("TRAV"));
        agency.setTravelerId(EMPLOYEE_ID);
        agency.setErrorCode("OK");
        TemProfile empProfile = this.expenseImportByTravelerService.getTraveler(agency);
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)empProfile.getEmployeeId().equals(agency.getTravelerId()));
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)agency.getErrorCode().equals("OK"));
        agency = this.createAgencyStagingData();
        agency.setTravelerId(CUSTOMER_NUM);
        agency.setErrorCode("OK");
        TemProfile custProfile = this.expenseImportByTravelerService.getTraveler(agency);
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)custProfile.getCustomerNumber().equals(agency.getTravelerId()));
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)agency.getErrorCode().equals("OK"));
    }

    @Test
    @ConfigureContext(shouldCommitTransactions=false)
    public void testIsDuplicate() {
        AgencyStagingData dbData = this.createAgencyStagingData();
        this.businessObjectService.save((PersistableBusinessObject)dbData);
        AgencyStagingData importData = this.createAgencyStagingData();
        List errors = this.expenseImportByTravelerService.validateDuplicateData(importData);
        ExpenseImportByTravelerServiceTest.assertTrue((!errors.isEmpty() ? 1 : 0) != 0);
        importData.setTravelerId(CUSTOMER_NUM);
        errors = this.expenseImportByTravelerService.validateDuplicateData(importData);
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    @ConfigureContext(shouldCommitTransactions=false)
    public void testAreMandatoryFieldsPresent() {
        AgencyStagingData agency = this.createAgencyStagingData();
        List errors = this.expenseImportByTravelerService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTravelerServiceTest.assertTrue((boolean)errors.isEmpty());
        agency.setTripInvoiceNumber(null);
        errors = this.expenseImportByTravelerService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTravelerServiceTest.assertFalse((boolean)errors.isEmpty());
        agency.setTripExpenseAmount("");
        errors = this.expenseImportByTravelerService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTravelerServiceTest.assertFalse((boolean)errors.isEmpty());
        agency.setTransactionPostingDate(null);
        errors = this.expenseImportByTravelerService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTravelerServiceTest.assertFalse((boolean)errors.isEmpty());
        agency.setAgency(null);
        errors = this.expenseImportByTravelerService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTravelerServiceTest.assertFalse((boolean)errors.isEmpty());
        agency.setAirTicketNumber("");
        errors = this.expenseImportByTravelerService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTravelerServiceTest.assertFalse((boolean)errors.isEmpty());
        agency.setTravelerId(null);
        errors = this.expenseImportByTravelerService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTravelerServiceTest.assertFalse((boolean)errors.isEmpty());
        agency.setCreditCardOrAgencyCode(null);
        errors = this.expenseImportByTravelerService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTravelerServiceTest.assertFalse((boolean)errors.isEmpty());
    }

    protected TemProfile createTemProfile() {
        TemProfile profile = new TemProfile();
        Integer newProfileId = this.sas.getNextAvailableSequenceNumber("TEM_PROFILE_ID_SEQ").intValue();
        profile.setProfileId(newProfileId);
        profile.getTemProfileAddress().setProfileId(newProfileId);
        profile.setDefaultChartCode("BL");
        profile.setDefaultAccount("1031400");
        profile.setDefaultSubAccount("ADV");
        profile.setDefaultProjectCode("KUL");
        profile.setDateOfBirth(this.dateTimeService.getCurrentSqlDate());
        profile.setGender("M");
        profile.setHomeDeptOrgCode("BL");
        profile.setHomeDeptChartOfAccountsCode("BL");
        return profile;
    }

    protected AgencyStagingData createAgencyStagingData() {
        AgencyStagingData agency = new AgencyStagingData();
        NextAgencyStagingDataIdFinder idFinder = new NextAgencyStagingDataIdFinder();
        agency.setId(Integer.valueOf(idFinder.getValue()));
        agency.setImportBy("TRV");
        agency.setCreditCardOrAgencyCode("1234");
        agency.setTravelerName("Traveler Bob");
        agency.setTravelerId(EMPLOYEE_ID);
        agency.setAirTicketNumber("12345678");
        agency.setLodgingItineraryNumber("12345");
        agency.setRentalCarItineraryNumber("54321");
        agency.setAgency("agency name");
        agency.setTransactionPostingDate(this.dateTimeService.getCurrentSqlDate());
        agency.setTripExpenseAmount(new KualiDecimal(123.45));
        agency.setTripInvoiceNumber("invoice12345");
        TripAccountingInformation account = new TripAccountingInformation();
        account.setTripChartCode("BL");
        account.setTripAccountNumber("1031400");
        account.setTripSubAccountNumber("ADV");
        account.setProjectCode("KUL");
        agency.addTripAccountingInformation(account);
        agency.setErrorCode("OK");
        return agency;
    }
}

