/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.junit.Test;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeAware;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.MileageRate;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.PrimaryDestination;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.TravelReimbursementForm;
import org.kuali.kfs.module.tem.service.PerDiemService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.workflow.MockWorkflowDocument;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;

@ConfigureContext
public class TravelDocumentServiceTest
extends KualiTestBase {
    private static final Logger LOG = Logger.getLogger(TravelDocumentServiceTest.class);
    protected static final String AIRFARE_EXPENSE_TYPE = "A";
    protected static final String MILEAGE_EXPENSE_TYPE = "MP";
    private TravelDocumentService travelDocumentService;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;
    private ExpenseTypeObjectCode mileageType = new ExpenseTypeObjectCode();
    private ExpenseTypeObjectCode airfareType = new ExpenseTypeObjectCode();
    private static final int ONE_DAY = 86400;
    private static final int EXPENSE_AMOUNT = 100;
    private static final int MILEAGE = 2;
    private static final int MILEAGE_RATE = 10;
    private static final String AIRLINE_EXPENSE_TYPE_CODE = "A";
    private static final String HOSTED_BREAKFAST = "HB";

    protected void setUp() throws Exception {
        super.setUp();
        this.mileageType.setExpenseTypeCode(MILEAGE_EXPENSE_TYPE);
        this.airfareType.setExpenseTypeCode("A");
        TravelDocumentService travelDocumentServiceTemp = (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
        this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        this.travelDocumentService = (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    public final void testCalculateDailyTotal_oneDay() {
        TravelReimbursementDocument trDoc = new TravelReimbursementDocument();
        TravelReimbursementForm form = new TravelReimbursementForm();
        form.setDocument((Document)trDoc);
        KNSGlobalVariables.setKualiForm((KualiForm)form);
        PerDiemExpense perDiemExpense = new PerDiemExpense(){

            public MileageRate getMileageRate(Date effectiveDate) {
                MileageRate rate = new MileageRate();
                rate.setRate(new BigDecimal(0.45));
                rate.setExpenseTypeCode(TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return rate;
            }
        };
        perDiemExpense.setProrated(false);
        perDiemExpense.setMiles(Integer.valueOf(0));
        perDiemExpense.setBreakfast(Boolean.valueOf(false));
        perDiemExpense.setLunch(Boolean.valueOf(false));
        perDiemExpense.setDinner(Boolean.valueOf(false));
        Map dailyTotal = this.travelDocumentService.calculateDailyTotal(perDiemExpense);
        TravelDocumentServiceTest.assertEquals((Object)KualiDecimal.ZERO, dailyTotal.get("mileageTotal"));
        TravelDocumentServiceTest.assertEquals((Object)KualiDecimal.ZERO, dailyTotal.get("lodgingTotal"));
        TravelDocumentServiceTest.assertEquals((Object)KualiDecimal.ZERO, dailyTotal.get("mealsAndIncidentalsTotal"));
        perDiemExpense.setPersonal(Boolean.valueOf(false));
        perDiemExpense.setMiles(Integer.valueOf(20));
        perDiemExpense.setLodging(new KualiDecimal(575.0));
        perDiemExpense.setBreakfast(Boolean.valueOf(true));
        perDiemExpense.setLunch(Boolean.valueOf(true));
        perDiemExpense.setDinner(Boolean.valueOf(true));
        perDiemExpense.setBreakfastValue(new KualiDecimal(12));
        perDiemExpense.setLunchValue(new KualiDecimal(13));
        perDiemExpense.setDinnerValue(new KualiDecimal(25));
        perDiemExpense.setIncidentalsValue(new KualiDecimal(10));
        dailyTotal = this.travelDocumentService.calculateDailyTotal(perDiemExpense);
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(9), dailyTotal.get("mileageTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(575.0), dailyTotal.get("lodgingTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(60), dailyTotal.get("mealsAndIncidentalsTotal"));
    }

    public final void testCalculateDailyTotals_threeDays() {
        TravelReimbursementDocument trDoc = new TravelReimbursementDocument();
        TravelReimbursementForm form = new TravelReimbursementForm();
        form.setDocument((Document)trDoc);
        KNSGlobalVariables.setKualiForm((KualiForm)form);
        PerDiemExpense perDiemExpense = new PerDiemExpense(){

            public MileageRate getMileageRate(Date effectiveDate) {
                MileageRate rate = new MileageRate();
                rate.setRate(new BigDecimal(0.45));
                rate.setExpenseTypeCode(TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return rate;
            }
        };
        perDiemExpense.setMiles(Integer.valueOf(0));
        perDiemExpense.setBreakfast(Boolean.valueOf(false));
        perDiemExpense.setLunch(Boolean.valueOf(false));
        perDiemExpense.setDinner(Boolean.valueOf(false));
        Calendar cal = Calendar.getInstance();
        perDiemExpense.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        ArrayList<PerDiemExpense> perDiemExpenses = new ArrayList<PerDiemExpense>();
        perDiemExpenses.add(perDiemExpense);
        PerDiemExpense perDiemExpense2 = this.copyPerDiem(perDiemExpense);
        cal.add(5, 1);
        perDiemExpense2.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        perDiemExpenses.add(perDiemExpense2);
        PerDiemExpense perDiemExpense3 = this.copyPerDiem(perDiemExpense2);
        cal.add(5, 1);
        perDiemExpense2.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        perDiemExpenses.add(perDiemExpense3);
        List dailyTotals = this.travelDocumentService.calculateDailyTotals(perDiemExpenses);
        TravelDocumentServiceTest.assertEquals((Object)KualiDecimal.ZERO, ((Map)dailyTotals.get(0)).get("mileageTotal"));
        TravelDocumentServiceTest.assertEquals((Object)KualiDecimal.ZERO, ((Map)dailyTotals.get(0)).get("lodgingTotal"));
        TravelDocumentServiceTest.assertEquals((Object)KualiDecimal.ZERO, ((Map)dailyTotals.get(0)).get("mealsAndIncidentalsTotal"));
        perDiemExpense.setMiles(Integer.valueOf(20));
        perDiemExpense.setLodging(new KualiDecimal(75.0));
        perDiemExpense.setBreakfast(Boolean.valueOf(true));
        perDiemExpense.setLunch(Boolean.valueOf(true));
        perDiemExpense.setDinner(Boolean.valueOf(true));
        perDiemExpense.setPersonal(Boolean.valueOf(false));
        perDiemExpense.setBreakfastValue(new KualiDecimal(12));
        perDiemExpense.setLunchValue(new KualiDecimal(13));
        perDiemExpense.setDinnerValue(new KualiDecimal(25));
        perDiemExpense.setIncidentalsValue(new KualiDecimal(10));
        perDiemExpense2.setMiles(Integer.valueOf(30));
        perDiemExpense2.setLodging(new KualiDecimal(75.0));
        perDiemExpense2.setBreakfast(Boolean.valueOf(true));
        perDiemExpense2.setLunch(Boolean.valueOf(true));
        perDiemExpense2.setDinner(Boolean.valueOf(true));
        perDiemExpense2.setPersonal(Boolean.valueOf(false));
        perDiemExpense2.setBreakfastValue(new KualiDecimal(12));
        perDiemExpense2.setLunchValue(new KualiDecimal(13));
        perDiemExpense2.setDinnerValue(new KualiDecimal(25));
        perDiemExpense2.setIncidentalsValue(new KualiDecimal(10));
        perDiemExpense3.setMiles(Integer.valueOf(40));
        perDiemExpense3.setLodging(new KualiDecimal(55.0));
        perDiemExpense3.setBreakfast(Boolean.valueOf(true));
        perDiemExpense3.setLunch(Boolean.valueOf(true));
        perDiemExpense3.setDinner(Boolean.valueOf(true));
        perDiemExpense3.setPersonal(Boolean.valueOf(false));
        perDiemExpense3.setBreakfastValue(new KualiDecimal(12));
        perDiemExpense3.setLunchValue(new KualiDecimal(13));
        perDiemExpense3.setDinnerValue(new KualiDecimal(25));
        perDiemExpense3.setIncidentalsValue(new KualiDecimal(10));
        ArrayList<PerDiemExpense> perDiemExpenses2 = new ArrayList<PerDiemExpense>();
        perDiemExpenses2.add(perDiemExpense);
        perDiemExpenses2.add(perDiemExpense2);
        perDiemExpenses2.add(perDiemExpense3);
        List dailyTotals2 = this.travelDocumentService.calculateDailyTotals(perDiemExpenses2);
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(9.0), ((Map)dailyTotals2.get(0)).get("mileageTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(75), ((Map)dailyTotals2.get(0)).get("lodgingTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(60), ((Map)dailyTotals2.get(0)).get("mealsAndIncidentalsTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(13.5), ((Map)dailyTotals2.get(1)).get("mileageTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(75), ((Map)dailyTotals2.get(1)).get("lodgingTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(60), ((Map)dailyTotals2.get(1)).get("mealsAndIncidentalsTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(18.0), ((Map)dailyTotals2.get(2)).get("mileageTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(55), ((Map)dailyTotals2.get(2)).get("lodgingTotal"));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(60), ((Map)dailyTotals2.get(2)).get("mealsAndIncidentalsTotal"));
    }

    public final void testUpdatePerDiemExpenses_addDay() {
        PerDiemExpense perDiemExpense = new PerDiemExpense(){

            public MileageRate getMileageRate(Date effectiveDate) {
                MileageRate rate = new MileageRate();
                rate.setRate(new BigDecimal(0.45));
                rate.setExpenseTypeCode(TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return rate;
            }
        };
        Calendar cal = Calendar.getInstance();
        perDiemExpense.setMiles(Integer.valueOf(20));
        perDiemExpense.setLodging(new KualiDecimal(75.0));
        perDiemExpense.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        perDiemExpense.setBreakfast(Boolean.valueOf(true));
        perDiemExpense.setLunch(Boolean.valueOf(true));
        perDiemExpense.setDinner(Boolean.valueOf(true));
        PerDiemExpense perDiemExpense2 = this.copyPerDiem(perDiemExpense);
        cal.add(5, 1);
        perDiemExpense2.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        perDiemExpense2.setMiles(Integer.valueOf(30));
        perDiemExpense2.setLodging(new KualiDecimal(75.0));
        perDiemExpense2.setBreakfast(Boolean.valueOf(true));
        perDiemExpense2.setLunch(Boolean.valueOf(true));
        perDiemExpense2.setDinner(Boolean.valueOf(true));
        PerDiemExpense perDiemExpense3 = this.copyPerDiem(perDiemExpense2);
        cal.add(5, 1);
        perDiemExpense2.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        perDiemExpense3.setMiles(Integer.valueOf(40));
        perDiemExpense3.setLodging(new KualiDecimal(55.0));
        perDiemExpense3.setBreakfast(Boolean.valueOf(true));
        perDiemExpense3.setLunch(Boolean.valueOf(true));
        perDiemExpense3.setDinner(Boolean.valueOf(true));
        ArrayList<PerDiemExpense> perDiemExpenses = new ArrayList<PerDiemExpense>();
        perDiemExpenses.add(perDiemExpense);
        perDiemExpenses.add(perDiemExpense2);
        perDiemExpenses.add(perDiemExpense3);
        Timestamp startDate = perDiemExpense.getMileageDate();
        cal.add(5, 1);
        Timestamp endDate = new Timestamp(cal.getTimeInMillis());
        TravelAuthorizationDocument td = new TravelAuthorizationDocument();
        td.setDocumentNumber("1");
        td.setPrimaryDestinationId(Integer.valueOf(23242));
        this.setDocumentHeader((TravelDocument)td);
        this.travelDocumentService.updatePerDiemItemsFor((TravelDocument)td, perDiemExpenses, new Integer(1), startDate, endDate);
        TravelDocumentServiceTest.assertEquals((int)4, (int)perDiemExpenses.size());
    }

    protected void setDocumentHeader(TravelDocument td) {
        MockWorkflowDocument workflowDocument = new MockWorkflowDocument(){

            public boolean isStandardSaveAllowed() {
                return false;
            }

            public boolean isInitiated() {
                return false;
            }

            public boolean isSaved() {
                return false;
            }

            public boolean isEnroute() {
                return true;
            }

            public boolean userIsRoutedByUser(Person user) {
                return false;
            }

            public Set<Person> getAllPriorApprovers() {
                return null;
            }

            public DateTime getDateCreated() {
                DateTime today = new DateTime();
                return today;
            }
        };
        FinancialSystemDocumentHeader dh = new FinancialSystemDocumentHeader();
        dh.setDocumentNumber("1");
        dh.setWorkflowDocument((WorkflowDocument)workflowDocument);
        td.setDocumentHeader((DocumentHeader)dh);
    }

    public final void testUpdatePerDiemExpenses_shiftAndAddADay() {
        PerDiemExpense perDiemExpense = new PerDiemExpense(){

            public MileageRate getMileageRate(Date effectiveDate) {
                MileageRate rate = new MileageRate();
                rate.setRate(new BigDecimal(0.45));
                rate.setExpenseTypeCode(TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return rate;
            }
        };
        Date today = this.dateTimeService.getCurrentSqlDateMidnight();
        Calendar cal = Calendar.getInstance();
        cal.setTime(today);
        perDiemExpense.setMiles(Integer.valueOf(20));
        perDiemExpense.setLodging(new KualiDecimal(75.0));
        perDiemExpense.setMileageDate(new Timestamp(today.getTime()));
        perDiemExpense.setBreakfast(Boolean.valueOf(true));
        perDiemExpense.setLunch(Boolean.valueOf(true));
        perDiemExpense.setDinner(Boolean.valueOf(true));
        PerDiemExpense perDiemExpense2 = this.copyPerDiem(perDiemExpense);
        cal.add(5, 1);
        perDiemExpense2.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        perDiemExpense2.setMiles(Integer.valueOf(30));
        perDiemExpense2.setLodging(new KualiDecimal(75.0));
        perDiemExpense2.setBreakfast(Boolean.valueOf(true));
        perDiemExpense2.setLunch(Boolean.valueOf(true));
        perDiemExpense2.setDinner(Boolean.valueOf(true));
        PerDiemExpense perDiemExpense3 = this.copyPerDiem(perDiemExpense2);
        cal.add(5, 1);
        perDiemExpense3.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        perDiemExpense3.setMiles(Integer.valueOf(40));
        perDiemExpense3.setLodging(new KualiDecimal(55.0));
        perDiemExpense3.setBreakfast(Boolean.valueOf(true));
        perDiemExpense3.setLunch(Boolean.valueOf(true));
        perDiemExpense3.setDinner(Boolean.valueOf(true));
        ArrayList<PerDiemExpense> perDiemExpenses = new ArrayList<PerDiemExpense>();
        perDiemExpenses.add(perDiemExpense);
        perDiemExpenses.add(perDiemExpense2);
        perDiemExpenses.add(perDiemExpense3);
        Calendar moveBackOneDay = Calendar.getInstance();
        moveBackOneDay.setTime(perDiemExpense.getMileageDate());
        moveBackOneDay.add(5, -1);
        Timestamp startDate = new Timestamp(moveBackOneDay.getTimeInMillis());
        Timestamp endDate = perDiemExpense2.getMileageDate();
        TravelAuthorizationDocument td = new TravelAuthorizationDocument();
        td.setDocumentNumber("1");
        td.setPrimaryDestinationId(Integer.valueOf(23242));
        this.setDocumentHeader((TravelDocument)td);
        this.travelDocumentService.updatePerDiemItemsFor((TravelDocument)td, perDiemExpenses, Integer.valueOf(1), startDate, endDate);
        TravelDocumentServiceTest.assertEquals((int)3, (int)perDiemExpenses.size());
        TravelDocumentServiceTest.assertEquals((Object)startDate, (Object)((PerDiemExpense)perDiemExpenses.get(0)).getMileageDate());
        TravelDocumentServiceTest.assertEquals((Object)endDate, (Object)((PerDiemExpense)perDiemExpenses.get(2)).getMileageDate());
    }

    public final void testUpdatePerDiemExpenses_emptyList() {
        ArrayList perDiemExpenses = new ArrayList();
        Date today = this.dateTimeService.getCurrentSqlDateMidnight();
        Calendar cal = Calendar.getInstance();
        cal.setTime(today);
        cal.add(5, 5);
        Timestamp endDate = new Timestamp(cal.getTimeInMillis());
        TravelAuthorizationDocument td = new TravelAuthorizationDocument();
        td.setDocumentNumber("1");
        td.setPrimaryDestinationId(Integer.valueOf(23242));
        this.setDocumentHeader((TravelDocument)td);
        this.travelDocumentService.updatePerDiemItemsFor((TravelDocument)td, perDiemExpenses, Integer.valueOf(1), new Timestamp(today.getTime()), endDate);
        TravelDocumentServiceTest.assertEquals((int)6, (int)perDiemExpenses.size());
        TravelDocumentServiceTest.assertEquals((Object)today, (Object)((PerDiemExpense)perDiemExpenses.get(0)).getMileageDate());
        TravelDocumentServiceTest.assertEquals((Object)endDate, (Object)((PerDiemExpense)perDiemExpenses.get(5)).getMileageDate());
    }

    public final void testUpdatePerDiemExpenses_removeDay() {
        List<PerDiemExpense> perDiemExpenses = this.createAListOfPerDiems();
        if (!perDiemExpenses.isEmpty()) {
            Timestamp startDate = perDiemExpenses.get(0).getMileageDate();
            Timestamp endDate = perDiemExpenses.get(1).getMileageDate();
            TravelAuthorizationDocument td = new TravelAuthorizationDocument();
            td.setDocumentNumber("1");
            td.setPrimaryDestinationId(Integer.valueOf(23242));
            this.setDocumentHeader((TravelDocument)td);
            this.travelDocumentService.updatePerDiemItemsFor((TravelDocument)td, perDiemExpenses, Integer.valueOf(1), startDate, endDate);
            TravelDocumentServiceTest.assertEquals((int)2, (int)perDiemExpenses.size());
            TravelDocumentServiceTest.assertEquals((Object)startDate, (Object)perDiemExpenses.get(0).getMileageDate());
            TravelDocumentServiceTest.assertEquals((Object)endDate, (Object)perDiemExpenses.get(1).getMileageDate());
        } else {
            TravelDocumentServiceTest.assertTrue((boolean)true);
        }
    }

    public final void testCopyDownPerDiemExpenses_topDown() {
        List<PerDiemExpense> mileages = this.createAListOfPerDiems();
        if (!mileages.isEmpty()) {
            Timestamp testDate1 = mileages.get(1).getMileageDate();
            Timestamp testDate2 = mileages.get(2).getMileageDate();
            mileages.get(0).setLodging(new KualiDecimal(25));
            TravelAuthorizationDocument ta = new TravelAuthorizationDocument();
            ta.setTripBegin(mileages.get(0).getMileageDate());
            ta.setTripEnd(mileages.get(mileages.size() - 1).getMileageDate());
            ta.setPrimaryDestinationId(mileages.get(0).getPrimaryDestinationId());
            this.travelDocumentService.copyDownPerDiemExpense((TravelDocument)ta, 0, mileages);
            TravelDocumentServiceTest.assertEquals((int)3, (int)mileages.size());
            TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(25), (Object)mileages.get(1).getLodging());
            TravelDocumentServiceTest.assertEquals((Object)testDate1, (Object)mileages.get(1).getMileageDate());
            TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(0), (Object)mileages.get(2).getLodging());
            TravelDocumentServiceTest.assertEquals((Object)testDate2, (Object)mileages.get(2).getMileageDate());
        } else {
            TravelDocumentServiceTest.assertTrue((boolean)true);
        }
    }

    public final void testCopyDownPerDiemExpenses_middleDown() {
        List<PerDiemExpense> mileages = this.createAListOfPerDiems();
        if (!mileages.isEmpty()) {
            Timestamp testDate1 = mileages.get(1).getMileageDate();
            Timestamp testDate2 = mileages.get(2).getMileageDate();
            mileages.get(0).setLodging(new KualiDecimal(25));
            mileages.get(1).setLodging(new KualiDecimal(50));
            mileages.get(1).setMiles(Integer.valueOf(20));
            TravelAuthorizationDocument ta = new TravelAuthorizationDocument();
            ta.setTripBegin(mileages.get(0).getMileageDate());
            ta.setTripEnd(mileages.get(mileages.size() - 1).getMileageDate());
            ta.setPrimaryDestinationId(mileages.get(0).getPrimaryDestinationId());
            this.travelDocumentService.copyDownPerDiemExpense((TravelDocument)ta, 1, mileages);
            TravelDocumentServiceTest.assertEquals((int)3, (int)mileages.size());
            TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(50), (Object)mileages.get(1).getLodging());
            TravelDocumentServiceTest.assertEquals((Object)testDate1, (Object)mileages.get(1).getMileageDate());
            TravelDocumentServiceTest.assertEquals((Object)KualiDecimal.ZERO, (Object)mileages.get(2).getLodging());
            TravelDocumentServiceTest.assertEquals((Object)new Integer(20), (Object)mileages.get(2).getMiles());
            TravelDocumentServiceTest.assertEquals((Object)testDate2, (Object)mileages.get(2).getMileageDate());
        } else {
            TravelDocumentServiceTest.assertTrue((boolean)true);
        }
    }

    public final void testCopyDownPerDiemExpenses_lastOneDown() {
        List<PerDiemExpense> mileages = this.createAListOfPerDiems();
        if (!mileages.isEmpty()) {
            Timestamp testDate1 = mileages.get(1).getMileageDate();
            Timestamp testDate2 = mileages.get(2).getMileageDate();
            mileages.get(0).setLodging(new KualiDecimal(25));
            mileages.get(1).setLodging(new KualiDecimal(50));
            mileages.get(1).setMiles(Integer.valueOf(20));
            mileages.get(2).setLodging(new KualiDecimal(30));
            mileages.get(2).setMiles(Integer.valueOf(10));
            TravelAuthorizationDocument ta = new TravelAuthorizationDocument();
            ta.setTripBegin(mileages.get(0).getMileageDate());
            ta.setTripEnd(mileages.get(mileages.size() - 1).getMileageDate());
            ta.setPrimaryDestinationId(mileages.get(0).getPrimaryDestinationId());
            this.travelDocumentService.copyDownPerDiemExpense((TravelDocument)ta, 2, mileages);
            TravelDocumentServiceTest.assertEquals((int)3, (int)mileages.size());
            TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(50), (Object)mileages.get(1).getLodging());
            TravelDocumentServiceTest.assertEquals((Object)testDate1, (Object)mileages.get(1).getMileageDate());
            TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal(30), (Object)mileages.get(2).getLodging());
            TravelDocumentServiceTest.assertEquals((Object)new Integer(10), (Object)mileages.get(2).getMiles());
            TravelDocumentServiceTest.assertEquals((Object)testDate2, (Object)mileages.get(2).getMileageDate());
        } else {
            TravelDocumentServiceTest.assertTrue((boolean)true);
        }
    }

    private PerDiemExpense copyPerDiem(PerDiemExpense perDiemExpense) {
        PerDiemExpense currentPerDiemExpense = new PerDiemExpense(){

            public MileageRate getMileageRate(Date effectiveDate) {
                MileageRate rate = new MileageRate();
                rate.setRate(new BigDecimal(0.45));
                rate.setExpenseTypeCode(TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return rate;
            }
        };
        currentPerDiemExpense.setMiles(perDiemExpense.getMiles());
        currentPerDiemExpense.setLodging(perDiemExpense.getLodging());
        currentPerDiemExpense.setBreakfast(perDiemExpense.getBreakfast());
        currentPerDiemExpense.setLunch(perDiemExpense.getLunch());
        currentPerDiemExpense.setDinner(perDiemExpense.getDinner());
        currentPerDiemExpense.setMileageDate(perDiemExpense.getMileageDate());
        return currentPerDiemExpense;
    }

    private List<PerDiemExpense> createAListOfPerDiems() {
        PerDiemExpense perDiemExpense = new PerDiemExpense(){

            public MileageRate getMileageRate(Date effectiveDate) {
                MileageRate rate = new MileageRate();
                rate.setRate(new BigDecimal(0.45));
                rate.setExpenseTypeCode(TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return rate;
            }
        };
        Date today = this.dateTimeService.getCurrentSqlDateMidnight();
        Calendar cal = Calendar.getInstance();
        cal.setTime(today);
        perDiemExpense.setMiles(Integer.valueOf(20));
        PerDiem perDiem = this.findSomePerDiem(new Date(cal.getTimeInMillis()));
        ArrayList<PerDiemExpense> perDiemExpenses = new ArrayList<PerDiemExpense>();
        if (perDiem != null) {
            perDiemExpense.setPrimaryDestinationId(perDiem.getPrimaryDestinationId());
            perDiemExpense.setLodging(perDiem.getLodging());
            perDiemExpense.setMileageDate(new Timestamp(today.getTime()));
            perDiemExpense.setBreakfast(Boolean.valueOf(true));
            perDiemExpense.setLunch(Boolean.valueOf(true));
            perDiemExpense.setDinner(Boolean.valueOf(true));
            PerDiemExpense perDiemExpense2 = this.copyPerDiem(perDiemExpense);
            cal.add(5, 1);
            perDiemExpense2.setMileageDate(new Timestamp(cal.getTimeInMillis()));
            perDiemExpense2.setPrimaryDestinationId(perDiem.getPrimaryDestinationId());
            perDiemExpense2.setMiles(Integer.valueOf(30));
            perDiemExpense2.setLodging(perDiem.getLodging());
            perDiemExpense2.setBreakfast(Boolean.valueOf(true));
            perDiemExpense2.setLunch(Boolean.valueOf(true));
            perDiemExpense2.setDinner(Boolean.valueOf(true));
            PerDiemExpense perDiemExpense3 = this.copyPerDiem(perDiemExpense2);
            cal.add(5, 1);
            perDiemExpense3.setMileageDate(new Timestamp(cal.getTimeInMillis()));
            perDiemExpense3.setPrimaryDestinationId(perDiem.getPrimaryDestinationId());
            perDiemExpense3.setMiles(Integer.valueOf(40));
            perDiemExpense3.setLodging(perDiem.getLodging());
            perDiemExpense3.setBreakfast(Boolean.valueOf(true));
            perDiemExpense3.setLunch(Boolean.valueOf(true));
            perDiemExpense3.setDinner(Boolean.valueOf(true));
            perDiemExpenses.add(perDiemExpense);
            perDiemExpenses.add(perDiemExpense2);
            perDiemExpenses.add(perDiemExpense3);
        }
        return perDiemExpenses;
    }

    private PerDiem findSomePerDiem(Date date) {
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        PerDiemService perDiemService = (PerDiemService)SpringContext.getBean(PerDiemService.class);
        HashMap<String, Boolean> fieldValues = new HashMap<String, Boolean>();
        fieldValues.put("active", Boolean.TRUE);
        ArrayList dests = new ArrayList();
        dests.addAll(boService.findMatching(PrimaryDestination.class, fieldValues));
        if (dests.size() > 1) {
            Random r = new Random();
            int priDestIndex = r.nextInt(dests.size());
            PerDiem perDiem = perDiemService.getPerDiem(((PrimaryDestination)dests.get(priDestIndex)).getId().intValue(), new Timestamp(date.getTime()), date);
            while (perDiem == null || ObjectUtils.equals((Object)perDiem.getPrimaryDestinationId(), (Object)Integer.MAX_VALUE)) {
                priDestIndex = r.nextInt(dests.size());
                perDiem = perDiemService.getPerDiem(((PrimaryDestination)dests.get(priDestIndex)).getId().intValue(), new Timestamp(date.getTime()), date);
            }
            return perDiem;
        }
        return null;
    }

    public final void testCalculateMileage_mileageRatePresent() {
        TravelReimbursementDocument trDoc = new TravelReimbursementDocument();
        TravelReimbursementForm form = new TravelReimbursementForm();
        form.setDocument((Document)trDoc);
        KNSGlobalVariables.setKualiForm((KualiForm)form);
        ActualExpense actualExpense = new ActualExpense(){

            public MileageRate getMileageRate(Date effectiveDate) {
                MileageRate rate = new MileageRate();
                rate.setId(Integer.valueOf(1));
                rate.setRate(new BigDecimal(0.45));
                rate.setExpenseTypeCode(TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return rate;
            }

            public ExpenseType getExpenseType() {
                BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
                ExpenseType mileageExpenseType = (ExpenseType)boService.findBySinglePrimaryKey(ExpenseType.class, (Object)TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return mileageExpenseType;
            }
        };
        actualExpense.setTravelExpenseTypeCode(this.mileageType);
        actualExpense.setMiles(Integer.valueOf(50));
        actualExpense.setExpenseTypeCode(MILEAGE_EXPENSE_TYPE);
        ActualExpense actualExpense2 = new ActualExpense(){

            public MileageRate getMileageRate(Date effectiveDate) {
                MileageRate rate = new MileageRate();
                rate.setId(Integer.valueOf(1));
                rate.setRate(new BigDecimal(0.45));
                rate.setExpenseTypeCode(TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return rate;
            }

            public ExpenseType getExpenseType() {
                BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
                ExpenseType mileageExpenseType = (ExpenseType)boService.findBySinglePrimaryKey(ExpenseType.class, (Object)TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return mileageExpenseType;
            }
        };
        actualExpense2.setTravelExpenseTypeCode(this.mileageType);
        actualExpense2.setMiles(Integer.valueOf(50));
        actualExpense2.setMileageOtherRate(new BigDecimal(0.5));
        actualExpense2.setExpenseTypeCode(MILEAGE_EXPENSE_TYPE);
        ActualExpense actualExpense3 = new ActualExpense(){

            public ExpenseType getExpenseType() {
                BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
                ExpenseType airfareExpenseType = (ExpenseType)boService.findBySinglePrimaryKey(ExpenseType.class, (Object)"A");
                return airfareExpenseType;
            }
        };
        actualExpense3.setTravelExpenseTypeCode(this.airfareType);
        actualExpense3.setExpenseTypeCode("A");
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal((double)actualExpense.getMiles().intValue() * 0.45), (Object)this.travelDocumentService.calculateMileage(actualExpense));
        TravelDocumentServiceTest.assertEquals((Object)new KualiDecimal((double)actualExpense2.getMiles().intValue() * 0.5), (Object)this.travelDocumentService.calculateMileage(actualExpense2));
        TravelDocumentServiceTest.assertEquals((Object)KualiDecimal.ZERO, (Object)this.travelDocumentService.calculateMileage(actualExpense3));
    }

    @Test
    public void testIsHostedMeal() {
        boolean isHostedMeal = false;
        isHostedMeal = this.travelDocumentService.isHostedMeal(null);
        TravelDocumentServiceTest.assertFalse((boolean)isHostedMeal);
        ActualExpense ote = new ActualExpense();
        ote.setExpenseTypeCode(HOSTED_BREAKFAST);
        isHostedMeal = this.travelDocumentService.isHostedMeal((ExpenseTypeAware)ote);
        TravelDocumentServiceTest.assertTrue((boolean)isHostedMeal);
        ote.setExpenseTypeCode("A");
        isHostedMeal = this.travelDocumentService.isHostedMeal((ExpenseTypeAware)ote);
        TravelDocumentServiceTest.assertFalse((boolean)isHostedMeal);
    }

    @Test
    public void testCalculateProratePercentage() {
        PerDiemExpense perDiemExpense = new PerDiemExpense();
        perDiemExpense.setMiles(Integer.valueOf(20));
        perDiemExpense.setLodging(new KualiDecimal(75.0));
        Calendar cal = Calendar.getInstance();
        perDiemExpense.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        perDiemExpense.setBreakfast(Boolean.valueOf(true));
        perDiemExpense.setLunch(Boolean.valueOf(true));
        perDiemExpense.setDinner(Boolean.valueOf(true));
        perDiemExpense.setProrated(true);
        perDiemExpense.setBreakfastValue(new KualiDecimal(12));
        perDiemExpense.setLunchValue(new KualiDecimal(13));
        perDiemExpense.setDinnerValue(new KualiDecimal(25));
        perDiemExpense.setIncidentalsValue(new KualiDecimal(10));
        perDiemExpense.setPrimaryDestinationId(Integer.valueOf(22342));
        Integer proratePercentage = this.travelDocumentService.calculateProratePercentage(perDiemExpense, "P", perDiemExpense.getMileageDate());
        TravelDocumentServiceTest.assertFalse((boolean)proratePercentage.equals(100));
    }

    @Test
    public void testCalculatePerDiemPercentageFromTimestamp() {
        PerDiemExpense perDiemExpense = new PerDiemExpense(){

            public MileageRate getMileageRate(Date effectiveDate) {
                MileageRate rate = new MileageRate();
                rate.setRate(new BigDecimal(0.45));
                rate.setExpenseTypeCode(TravelDocumentServiceTest.MILEAGE_EXPENSE_TYPE);
                return rate;
            }
        };
        perDiemExpense.setMiles(Integer.valueOf(20));
        perDiemExpense.setLodging(new KualiDecimal(75.0));
        Calendar cal = Calendar.getInstance();
        cal.set(10, 12);
        perDiemExpense.setMileageDate(new Timestamp(cal.getTimeInMillis()));
        perDiemExpense.setBreakfast(Boolean.valueOf(true));
        perDiemExpense.setLunch(Boolean.valueOf(true));
        perDiemExpense.setDinner(Boolean.valueOf(true));
        Integer perDiemPercentage = this.travelDocumentService.calculatePerDiemPercentageFromTimestamp(perDiemExpense, perDiemExpense.getMileageDate());
        TravelDocumentServiceTest.assertFalse((boolean)perDiemPercentage.equals(100));
    }

    @Test
    public void testCheckNonEmployeeTravelerTypeCode() {
        TravelDocumentServiceTest.assertFalse((boolean)this.travelDocumentService.checkNonEmployeeTravelerTypeCode(null));
        TravelDocumentServiceTest.assertFalse((boolean)this.travelDocumentService.checkNonEmployeeTravelerTypeCode("EMP"));
        TravelDocumentServiceTest.assertTrue((boolean)this.travelDocumentService.checkNonEmployeeTravelerTypeCode("NON"));
    }

    @Test
    public void testGetAdvancesTotalFor() {
        KualiDecimal advancesTotal = this.travelDocumentService.getAdvancesTotalFor(null);
        TravelDocumentServiceTest.assertNotNull((Object)advancesTotal);
        TravelDocumentServiceTest.assertTrue((boolean)advancesTotal.isZero());
        advancesTotal = this.travelDocumentService.getAdvancesTotalFor((TravelDocument)new TravelAuthorizationDocument());
        TravelDocumentServiceTest.assertNotNull((Object)advancesTotal);
        TravelDocumentServiceTest.assertTrue((boolean)advancesTotal.isZero());
    }
}

