/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;

@Entity
@Table(name="TEM_MILEAGE_RT_T")
public class MileageRate
extends PersistableBusinessObjectBase {
    public static final String CACHE_NAME = "KFS/MileageRate";
    private Integer id;
    private String expenseTypeCode;
    private BigDecimal rate;
    private Date activeFromDate;
    private Date activeToDate;
    private ExpenseType expenseType;

    @Id
    @GeneratedValue(generator="TEM_MILEAGE_RT_ID_SEQ")
    @SequenceGenerator(name="TEM_MILEAGE_RT_ID_SEQ", sequenceName="TEM_MILEAGE_RT_ID_SEQ", allocationSize=5)
    @Column(name="id", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="rt", precision=19, scale=2, nullable=false)
    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    @Column(name="actv_from_dt", nullable=false)
    public Date getActiveFromDate() {
        return this.activeFromDate;
    }

    public void setActiveFromDate(Date activeFromDate) {
        this.activeFromDate = activeFromDate;
    }

    @Column(name="actv_to_dt", nullable=false)
    public Date getActiveToDate() {
        return this.activeToDate;
    }

    public void setActiveToDate(Date activeToDate) {
        this.activeToDate = activeToDate;
    }

    @Column(name="exp_typ_cd", nullable=false)
    public String getExpenseTypeCode() {
        return this.expenseTypeCode;
    }

    public void setExpenseTypeCode(String expenseTypeCode) {
        this.expenseTypeCode = expenseTypeCode;
    }

    @ManyToOne
    @JoinColumn(name="EXP_TYP_CD")
    public ExpenseType getExpenseType() {
        return this.expenseType;
    }

    public void setExpenseType(ExpenseType expenseType) {
        this.expenseType = expenseType;
    }

    protected LinkedHashMap<String, String> toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("id", Integer.toString(this.id));
        if (this.rate != null) {
            map.put("rate", this.rate.toString());
        }
        return map;
    }

    public String getCodeAndRate() {
        return this.getExpenseTypeCode() + " " + "-" + " " + "$" + this.getRate().toString();
    }
}

