/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.dataaccess.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.OjbCollectionAware;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.dataaccess.TravelDocumentDao;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.TravelRelocationDocument;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class TravelDocumentDaoOjb
extends PlatformAwareDaoBaseOjb
implements TravelDocumentDao,
OjbCollectionAware {
    public static Logger LOG = Logger.getLogger(TravelDocumentDaoOjb.class);

    @Override
    public List<TravelDocument> findDocuments(Class<?> travelDocumentClass, String travelDocumentNumber) {
        Criteria c = new Criteria();
        c.addEqualTo("travelDocumentIdentifier", (Object)travelDocumentNumber);
        LOG.debug((Object)("Creating query for type " + travelDocumentClass + " using criteria " + c));
        ArrayList<TravelDocument> retval = new ArrayList<TravelDocument>();
        Collection documents = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(travelDocumentClass, c));
        for (TravelDocument document : documents) {
            retval.add(document);
        }
        return retval;
    }

    @Override
    public List<String> findDocumentNumbers(Class<?> travelDocumentClass, String travelDocumentNumber) {
        Criteria c = new Criteria();
        c.addEqualTo("travelDocumentIdentifier", (Object)travelDocumentNumber);
        LOG.debug((Object)("Creating query for type " + travelDocumentClass + " using criteria " + c));
        ArrayList<String> retval = new ArrayList<String>();
        Collection documents = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(travelDocumentClass, c));
        for (TravelDocument document : documents) {
            retval.add(document.getDocumentNumber());
        }
        return retval;
    }

    @Override
    public List<PerDiem> findEffectivePerDiems(int primaryDestinationId, Date effectiveDate) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("primaryDestinationId", (Object)new Integer(primaryDestinationId));
        Criteria dateBetweenCriteria = new Criteria();
        Criteria dateNullCriteria = new Criteria();
        dateBetweenCriteria.addGreaterOrEqualThan((Object)"effectiveToDate", (Object)effectiveDate);
        dateBetweenCriteria.addLessOrEqualThan((Object)"effectiveFromDate", (Object)effectiveDate);
        dateNullCriteria.addIsNull("effectiveToDate");
        dateBetweenCriteria.addOrCriteria(dateNullCriteria);
        criteria.addAndCriteria(dateBetweenCriteria);
        QueryByCriteria query = QueryFactory.newQuery(PerDiem.class, (Criteria)criteria);
        ArrayList<PerDiem> possiblePerDiems = new ArrayList<PerDiem>();
        possiblePerDiems.addAll(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query));
        return possiblePerDiems;
    }

    @Override
    public List<TravelAdvance> getOutstandingTravelAdvanceByInvoice(Set<String> arInvoiceDocNumbers) {
        if (ObjectUtils.isNull(arInvoiceDocNumbers) || arInvoiceDocNumbers.isEmpty()) {
            return new ArrayList<TravelAdvance>();
        }
        Criteria criteria = new Criteria();
        criteria.addIn("arInvoiceDocNumber", arInvoiceDocNumbers);
        criteria.addIsNull("taxRamificationNotificationDate");
        QueryByCriteria query = QueryFactory.newQuery(TravelAdvance.class, (Criteria)criteria);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public Object[] findLatestTaxableRamificationNotificationDate() {
        this.getPersistenceBrokerTemplate().clearCache();
        Criteria criteria = new Criteria();
        criteria.addNotNull("taxRamificationNotificationDate");
        ReportQueryByCriteria query = QueryFactory.newReportQuery(TravelAdvance.class, (Criteria)criteria);
        String selectionField = "max(taxRamificationNotificationDate)";
        query.setAttributes(new String[]{selectionField});
        query.setDistinct(true);
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        return (Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)iterator);
    }

    @Override
    public Collection<? extends TEMReimbursementDocument> getReimbursementDocumentsByHeaderStatus(String statusCode, boolean immediatesOnly) {
        return this.getTravelDocumentsByHeaderStatus(TravelReimbursementDocument.class, statusCode, immediatesOnly, "travelPayment");
    }

    @Override
    public Collection<? extends TEMReimbursementDocument> getRelocationDocumentsByHeaderStatus(String statusCode, boolean immediatesOnly) {
        return this.getTravelDocumentsByHeaderStatus(TravelRelocationDocument.class, statusCode, immediatesOnly, "travelPayment");
    }

    @Override
    public Collection<? extends TEMReimbursementDocument> getEntertainmentDocumentsByHeaderStatus(String statusCode, boolean immediatesOnly) {
        return this.getTravelDocumentsByHeaderStatus(TravelEntertainmentDocument.class, statusCode, immediatesOnly, "travelPayment");
    }

    @Override
    public Collection<? extends TravelAuthorizationDocument> getAuthorizationsAndAmendmentsByHeaderStatus(String statusCode, boolean immediatesOnly) {
        ArrayList<? extends TravelDocument> documents = new ArrayList<TravelDocument>();
        documents.addAll(this.getTravelDocumentsByHeaderStatus(TravelAuthorizationDocument.class, statusCode, immediatesOnly, "advanceTravelPayment"));
        return documents;
    }

    protected Collection<? extends TravelDocument> getTravelDocumentsByHeaderStatus(Class<? extends TravelDocument> documentClazz, String statusCode, boolean immediatesOnly, String travelPaymentProperty) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getReimbursableDocumentsByHeaderStatus() started");
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)statusCode);
        criteria.addEqualTo(travelPaymentProperty + ".paymentMethodCode", (Object)"P");
        if (immediatesOnly) {
            criteria.addEqualTo(travelPaymentProperty + ".immediatePaymentIndicator", (Object)Boolean.TRUE);
        }
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(documentClazz, criteria));
    }

    @Override
    public Collection<? extends TEMReimbursementDocument> getReimbursementDocumentsNeedingCorporateCardExtraction() {
        return this.getUnExtractedCorporateCardTravelDocuments(TravelReimbursementDocument.class);
    }

    @Override
    public Collection<? extends TEMReimbursementDocument> getEntertainmentDocumentsNeedingCorporateCardExtraction() {
        return this.getUnExtractedCorporateCardTravelDocuments(TravelEntertainmentDocument.class);
    }

    @Override
    public Collection<? extends TEMReimbursementDocument> getRelocationDocumentsNeedingCorporateCardExtraction() {
        return this.getUnExtractedCorporateCardTravelDocuments(TravelRelocationDocument.class);
    }

    protected Collection<? extends TravelDocument> getUnExtractedCorporateCardTravelDocuments(Class<? extends TravelDocument> documentClazz) {
        Criteria criteria = new Criteria();
        ArrayList<String> statusCodes = new ArrayList<String>();
        statusCodes.add("E");
        statusCodes.add("A");
        criteria.addIn("documentHeader.financialDocumentStatusCode", statusCodes);
        criteria.addIsNull("corporateCardPaymentExtractDate");
        Criteria expenseCriteria = new Criteria();
        expenseCriteria.addEqualTo("cardType", (Object)"CORP");
        expenseCriteria.addEqualTo("expenseLineTypeCode", (Object)"I");
        expenseCriteria.addEqualTo("historicalTravelExpense.creditCardAgency.paymentIndicator", (Object)Boolean.TRUE);
        ReportQueryByCriteria expensesSubQuery = QueryFactory.newReportQuery(ImportedExpense.class, (Criteria)expenseCriteria);
        expensesSubQuery.setAttributes(new String[]{"documentNumber"});
        criteria.addIn((Object)"documentNumber", (Query)expensesSubQuery);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(documentClazz, criteria));
    }

    @Override
    public Collection<? extends TEMReimbursementDocument> findMatchingTrips(Integer temProfileId, Timestamp tripBegin, Timestamp tripEnd) {
        Criteria criteria = new Criteria();
        Criteria orEndDateCriteria = new Criteria();
        criteria.addEqualTo("temProfileId", (Object)temProfileId);
        criteria.addEqualTo("tripBegin", (Object)tripBegin);
        orEndDateCriteria.addEqualTo("tripEnd", (Object)tripEnd);
        criteria.addOrCriteria(orEndDateCriteria);
        criteria.addNotIn("documentHeader.financialDocumentStatusCode", Arrays.asList("?"));
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(TravelReimbursementDocument.class, criteria));
    }
}

