/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.beans.PropertyChangeEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.fp.document.DisbursementVoucherDocument;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.HeldEncumbranceEntry;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TransportationModeDetail;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TravelPayment;
import org.kuali.kfs.module.tem.businessobject.TravelerDetailEmergencyContact;
import org.kuali.kfs.module.tem.document.TravelAuthorizationAmendmentDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationCloseDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.service.TemExpenseService;
import org.kuali.kfs.sys.batch.service.PaymentSourceExtractionService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.PaymentSourceWireTransfer;
import org.kuali.kfs.sys.businessobject.WireCharge;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.PaymentSource;
import org.kuali.kfs.sys.document.service.PaymentSourceHelperService;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.DeleteAccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.ReviewAccountingLineEvent;
import org.kuali.kfs.sys.service.AccountingLineService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TEM_TRVL_AUTH_DOC_T")
public class TravelAuthorizationDocument
extends TravelDocumentBase
implements PaymentSource,
AmountTotaling {
    protected static Logger LOG = Logger.getLogger(TravelAuthorizationDocument.class);
    private KualiDecimal perDiemAdjustment;
    private String cellPhoneNumber;
    private String regionFamiliarity;
    private List<TransportationModeDetail> transportationModes = new ArrayList<TransportationModeDetail>();
    private TravelAdvance travelAdvance;
    private TravelPayment advanceTravelPayment;
    private PaymentSourceWireTransfer wireTransfer;
    private List<TemSourceAccountingLine> advanceAccountingLines;
    private List<TravelAdvance> travelAdvancesForTrip;
    private Integer nextAdvanceLineNumber = new Integer(1);
    private String holdRequestorprincipalId;
    protected static volatile PersonService personService;
    protected static volatile ConfigurationService configurationService;
    protected static volatile PaymentSourceHelperService paymentSourceHelperService;
    protected static volatile OptionsService optionsService;
    protected static volatile UniversityDateService universityDateService;
    protected static volatile OffsetDefinitionService offsetDefinitionService;

    public TravelAuthorizationAmendmentDocument toCopyTAA() throws WorkflowException {
        TravelAuthorizationAmendmentDocument doc = (TravelAuthorizationAmendmentDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("TAA");
        this.toCopyTravelAuthorizationDocument(doc);
        doc.setActualExpenses(this.getTravelDocumentService().copyActualExpenses(this.getActualExpenses(), doc.getDocumentNumber()));
        doc.getDocumentHeader().setDocumentDescription("(Description will be filled upon submit)");
        doc.setApplicationDocumentStatus("In Process");
        doc.initiateAdvancePaymentAndLines();
        return doc;
    }

    protected void initiateAdvancePaymentAndLines() {
        this.setDefaultBankCode();
        this.setTravelAdvance(new TravelAdvance());
        this.getTravelAdvance().setDocumentNumber(this.getDocumentNumber());
        this.setAdvanceTravelPayment(new TravelPayment());
        this.getAdvanceTravelPayment().setDocumentNumber(this.getDocumentNumber());
        this.getAdvanceTravelPayment().setDocumentationLocationCode(this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "DOCUMENTATION_LOCATION_CODE", this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "DOCUMENTATION_LOCATION_CODE")));
        this.getAdvanceTravelPayment().setCheckStubText(this.getConfigurationService().getPropertyValueAsString("message.document.tem.ta.advance.checkText.holdingText"));
        Date currentDate = TravelAuthorizationDocument.getDateTimeService().getCurrentSqlDate();
        this.getAdvanceTravelPayment().setDueDate(currentDate);
        this.updatePayeeTypeForAuthorization();
        this.setWireTransfer(new PaymentSourceWireTransfer());
        this.getWireTransfer().setDocumentNumber(this.getDocumentNumber());
        this.setAdvanceAccountingLines(new ArrayList<TemSourceAccountingLine>());
        this.resetNextAdvanceLineNumber();
        TemSourceAccountingLine accountingLine = this.initiateAdvanceAccountingLine();
        this.addAdvanceAccountingLine(accountingLine);
    }

    public TravelAuthorizationCloseDocument toCopyTAC() throws WorkflowException {
        TravelAuthorizationCloseDocument doc = (TravelAuthorizationCloseDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("TAC");
        this.toCopyTravelAuthorizationDocument(doc);
        doc.setActualExpenses(this.getTravelDocumentService().copyActualExpenses(this.getActualExpenses(), doc.getDocumentNumber()));
        return doc;
    }

    public TravelAuthorizationDocument toCopyTA() throws WorkflowException {
        TravelAuthorizationDocument doc = (TravelAuthorizationDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("TA");
        this.toCopyTravelAuthorizationDocument(doc);
        doc.getDocumentHeader().setDocumentDescription("(Description will be filled upon submit)");
        doc.getDocumentHeader().setOrganizationDocumentNumber("");
        doc.setApplicationDocumentStatus("In Process");
        doc.setTravelDocumentIdentifier(null);
        doc.initiateAdvancePaymentAndLines();
        return doc;
    }

    protected void toCopyTravelAuthorizationDocument(TravelAuthorizationDocument copyToDocument) {
        String documentID = copyToDocument.getDocumentNumber();
        BeanUtils.copyProperties((Object)this, (Object)copyToDocument, (String[])new String[]{"documentHeader"});
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setDocumentNumber(documentID);
        BeanUtils.copyProperties((Object)copyToDocument.getDocumentHeader(), (Object)documentHeader, (String[])new String[]{"documentNumber", "objectId", "versionNumber"});
        documentHeader.setOrganizationDocumentNumber(this.getDocumentHeader().getOrganizationDocumentNumber());
        copyToDocument.setDocumentHeader((DocumentHeader)documentHeader);
        copyToDocument.setTransportationModes(this.getTravelDocumentService().copyTransportationModeDetails(this.getTransportationModes(), documentID));
        copyToDocument.setPerDiemExpenses(this.getTravelDocumentService().copyPerDiemExpenses(this.getPerDiemExpenses(), documentID));
        copyToDocument.setSpecialCircumstances(this.getTravelDocumentService().copySpecialCircumstances(this.getSpecialCircumstances(), documentID));
        copyToDocument.setTravelerDetailId(null);
        copyToDocument.setTraveler(this.getTravelerService().copyTravelerDetail(this.getTraveler(), documentID));
        copyToDocument.setGroupTravelers(this.getTravelDocumentService().copyGroupTravelers(this.getGroupTravelers(), documentID));
        copyToDocument.setImportedExpenses(new ArrayList<ImportedExpense>());
        copyToDocument.getNotes().clear();
        copyToDocument.getDocumentHeader().setDocumentDescription(this.getDocumentHeader().getDocumentDescription());
        copyToDocument.setTravelDocumentIdentifier(this.getTravelDocumentIdentifier());
        copyToDocument.setDocumentNumber(documentID);
        copyToDocument.setGeneralLedgerPendingEntries(new ArrayList());
        ArrayList<TemSourceAccountingLine> newList = new ArrayList<TemSourceAccountingLine>();
        int sequence = 1;
        for (TemSourceAccountingLine line : copyToDocument.getEncumbranceSourceAccountingLines()) {
            line.setSequenceNumber(new Integer(sequence));
            ++sequence;
            newList.add(line);
        }
        copyToDocument.setSourceAccountingLines(newList);
        copyToDocument.setNextSourceLineNumber(new Integer(sequence));
        copyToDocument.initiateAdvancePaymentAndLines();
    }

    @Override
    public void toCopy() throws WorkflowException {
        super.toCopy();
        this.travelAdvancesForTrip = null;
        this.setTravelDocumentIdentifier(null);
        if (!(this instanceof TravelAuthorizationCloseDocument)) {
            this.initiateAdvancePaymentAndLines();
        }
    }

    public boolean shouldRevertToOriginalAuthorizationOnCopy() {
        return false;
    }

    @Override
    @Column(name="PER_DIEM_ADJ", precision=19, scale=2)
    public KualiDecimal getPerDiemAdjustment() {
        return this.perDiemAdjustment == null ? KualiDecimal.ZERO : this.perDiemAdjustment;
    }

    @Override
    public void setPerDiemAdjustment(KualiDecimal perDiemAdjustment) {
        this.perDiemAdjustment = perDiemAdjustment == null ? KualiDecimal.ZERO : perDiemAdjustment;
    }

    @Column(name="CELL_PH_NUM", length=10)
    public String getCellPhoneNumber() {
        return this.cellPhoneNumber;
    }

    public void setCellPhoneNumber(String cellPhoneNumber) {
        this.cellPhoneNumber = cellPhoneNumber;
    }

    @Column(name="rgn_famil")
    public String getRegionFamiliarity() {
        return this.regionFamiliarity;
    }

    public void setRegionFamiliarity(String regionFamiliarity) {
        this.regionFamiliarity = regionFamiliarity;
    }

    @Override
    @Transient
    public List<TransportationModeDetail> getTransportationModes() {
        return this.transportationModes;
    }

    @Override
    public void setTransportationModes(List<TransportationModeDetail> transportationModes) {
        this.transportationModes = transportationModes;
    }

    public void addTransportationMode(TransportationModeDetail transportationModeDetail) {
        transportationModeDetail.setDocumentNumber(this.documentNumber);
        this.transportationModes.add(transportationModeDetail);
    }

    @Transient
    public void setTransportationModeCodes(List<String> selectedTransportationModes) {
        for (String string : selectedTransportationModes) {
            TransportationModeDetail detail = new TransportationModeDetail();
            detail.setTransportationModeCode(string);
            detail.setDocumentNumber(this.documentNumber);
            if (this.transportationModes.contains((Object)detail)) continue;
            this.addTransportationMode(detail);
        }
        if (selectedTransportationModes.size() != this.transportationModes.size()) {
            ListIterator<TransportationModeDetail> iter = this.transportationModes.listIterator();
            while (iter.hasNext()) {
                TransportationModeDetail detail = iter.next();
                if (selectedTransportationModes.contains(detail.getTransportationModeCode())) continue;
                iter.remove();
            }
        }
    }

    @Transient
    public List<String> getTransportationModeCodes() {
        ArrayList<String> codes = new ArrayList<String>();
        for (TransportationModeDetail mode : this.transportationModes) {
            codes.add(mode.getTransportationModeCode());
        }
        return codes;
    }

    public void addActualExpenseLine(ActualExpense line) {
        line.setDocumentLineNumber(this.getActualExpenses().size() + 1);
        String sequenceName = line.getSequenceName();
        Long sequenceNumber = this.getSequenceAccessorService().getNextAvailableSequenceNumber(sequenceName, ActualExpense.class);
        line.setId(sequenceNumber);
        line.setDocumentNumber(this.documentNumber);
        this.notifyChangeListeners(new PropertyChangeEvent(this, "actualExpenses", null, line));
        this.getActualExpenses().add(line);
        this.logErrors();
    }

    public TravelAdvance getTravelAdvance() {
        return this.travelAdvance;
    }

    public void setTravelAdvance(TravelAdvance travelAdvance) {
        this.travelAdvance = travelAdvance;
    }

    @Override
    public void initiateDocument() {
        super.initiateDocument();
        this.setApplicationDocumentStatus("In Process");
        this.tripProgenitor = true;
        Calendar calendar = TravelAuthorizationDocument.getDateTimeService().getCurrentCalendar();
        calendar.add(5, 1);
        this.setTripBegin(new Timestamp(calendar.getTimeInMillis()));
        calendar.add(5, 2);
        this.setTripEnd(new Timestamp(calendar.getTimeInMillis()));
        this.initiateAdvancePaymentAndLines();
    }

    protected TemSourceAccountingLine initiateAdvanceAccountingLine() {
        try {
            TemSourceAccountingLine accountingLine = this.getAdvanceAccountingLineClass().newInstance();
            accountingLine.setDocumentNumber(this.getDocumentNumber());
            accountingLine.setFinancialDocumentLineTypeCode("A");
            accountingLine.setSequenceNumber(new Integer(1));
            accountingLine.setCardType("ADVANCE");
            if (this.allParametersForAdvanceAccountingLinesSet()) {
                accountingLine.setChartOfAccountsCode(this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_CHART"));
                accountingLine.setAccountNumber(this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_ACCOUNT"));
                accountingLine.setFinancialObjectCode(this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_OBJECT_CODE"));
            }
            return accountingLine;
        }
        catch (InstantiationException ie) {
            LOG.error((Object)("Could not instantiate new advance accounting line of type: " + this.getAdvanceAccountingLineClass().getName()));
            throw new RuntimeException("Could not instantiate new advance accounting line of type: " + this.getAdvanceAccountingLineClass().getName(), ie);
        }
        catch (IllegalAccessException iae) {
            LOG.error((Object)("Illegal access attempting to instantiate advance accounting line of class " + this.getAdvanceAccountingLineClass().getName()));
            throw new RuntimeException("Illegal access attempting to instantiate advance accounting line of class " + this.getAdvanceAccountingLineClass().getName(), iae);
        }
    }

    public void addEmergencyContactLine(TravelerDetailEmergencyContact line) {
        if (!ObjectUtils.isNull((Object)((Object)this.getTraveler()))) {
            line.setFinancialDocumentLineNumber(this.getTraveler().getEmergencyContacts().size() + 1);
            line.setDocumentNumber(this.documentNumber);
            line.setTravelerDetailId(this.getTraveler().getId());
            this.getTraveler().getEmergencyContacts().add(line);
        }
    }

    public void addPerDiemExpensesLine(PerDiemExpense line) {
        line.setDocumentNumber(this.documentNumber);
        this.perDiemExpenses.add(line);
    }

    @Override
    public boolean canReturn() {
        return this.getDocumentHeader().getWorkflowDocument().isEnroute();
    }

    @Override
    @Transient
    public KualiDecimal getEncumbranceTotal() {
        TemExpenseService service = (TemExpenseService)SpringContext.getBean(TemExpense.class, (String)"perDiemService");
        KualiDecimal encTotal = service.getAllExpenseTotal(this, false);
        service = (TemExpenseService)SpringContext.getBean(TemExpense.class, (String)"actualExpenseService");
        encTotal = (KualiDecimal)service.getAllExpenseTotal(this, false).add((AbstractKualiDecimal)encTotal);
        if (ObjectUtils.isNotNull((Object)this.perDiemAdjustment) && this.perDiemAdjustment.isPositive()) {
            encTotal = (KualiDecimal)encTotal.subtract((AbstractKualiDecimal)this.perDiemAdjustment);
        }
        KualiDecimal encTotalWithExpenseLimit = this.applyExpenseLimit(encTotal);
        return encTotalWithExpenseLimit;
    }

    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        AccountingLine accountingLine;
        super.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        if (postable instanceof AccountingLine && "A".equals((accountingLine = (AccountingLine)postable).getFinancialDocumentLineTypeCode())) {
            this.customizeAdvanceExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
            return;
        }
        this.customizeExpenseExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
    }

    protected void customizeExpenseExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        String balanceType;
        explicitEntry.setTransactionEncumbranceUpdateCode("R");
        explicitEntry.setTransactionDebitCreditCode("D");
        explicitEntry.setDocumentNumber(this.getDocumentNumber());
        String referenceDocumentNumber = this.getTravelDocumentIdentifier();
        if (ObjectUtils.isNotNull((Object)referenceDocumentNumber)) {
            explicitEntry.setReferenceFinancialDocumentNumber(referenceDocumentNumber);
            explicitEntry.setReferenceFinancialDocumentTypeCode("TA");
            explicitEntry.setReferenceFinancialSystemOriginationCode("01");
        }
        if (StringUtils.isNotEmpty((String)(balanceType = this.getTravelEncumbranceService().getEncumbranceBalanceTypeByTripType(this)))) {
            explicitEntry.setFinancialBalanceTypeCode(balanceType);
        }
        explicitEntry.setOrganizationDocumentNumber(this.getTravelDocumentIdentifier());
    }

    protected void customizeAdvanceExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        String paymentDocumentType = StringUtils.isBlank((String)this.getTravelAdvancePaymentDocumentType()) ? "TACA" : this.getTravelAdvancePaymentDocumentType();
        explicitEntry.setFinancialDocumentTypeCode(paymentDocumentType);
        String description = MessageFormat.format(this.getConfigurationService().getPropertyValueAsString("travelAuthorization.message.advanceAccountingLines.glpeDescription"), TravelAuthorizationDocument.getDataDictionaryService().getDocumentTypeNameByClass(this.getClass()), this.getDocumentNumber());
        int maxLength = TravelAuthorizationDocument.getDataDictionaryService().getAttributeMaxLength(GeneralLedgerPendingEntry.class, "transactionLedgerEntryDescription");
        explicitEntry.setTransactionLedgerEntryDescription(StringUtils.abbreviate((String)description, (int)maxLength));
        explicitEntry.setOrganizationDocumentNumber(this.getTravelDocumentIdentifier());
    }

    public boolean customizeOffsetGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail accountingLine, GeneralLedgerPendingEntry explicitEntry, GeneralLedgerPendingEntry offsetEntry) {
        AccountingLine postable;
        boolean customized = super.customizeOffsetGeneralLedgerPendingEntry(accountingLine, explicitEntry, offsetEntry);
        if (accountingLine instanceof AccountingLine && "A".equals((postable = (AccountingLine)accountingLine).getFinancialDocumentLineTypeCode())) {
            return customized && this.customizeAdvanceOffsetGeneralLedgerPendingEntry(accountingLine, explicitEntry, offsetEntry);
        }
        return customized && this.customizeExpenseOffsetGeneralLedgerPendingEntry(accountingLine, explicitEntry, offsetEntry);
    }

    public boolean customizeExpenseOffsetGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail accountingLine, GeneralLedgerPendingEntry explicitEntry, GeneralLedgerPendingEntry offsetEntry) {
        String balanceType;
        boolean customized = false;
        offsetEntry.setTransactionEncumbranceUpdateCode("R");
        offsetEntry.setTransactionDebitCreditCode("C");
        offsetEntry.setDocumentNumber(this.getDocumentNumber());
        String referenceDocumentNumber = this.getTravelDocumentIdentifier();
        if (ObjectUtils.isNotNull((Object)referenceDocumentNumber)) {
            offsetEntry.setReferenceFinancialDocumentNumber(referenceDocumentNumber);
            offsetEntry.setReferenceFinancialDocumentTypeCode("TA");
            offsetEntry.setReferenceFinancialSystemOriginationCode("01");
        }
        if (StringUtils.isNotEmpty((String)(balanceType = this.getTravelEncumbranceService().getEncumbranceBalanceTypeByTripType(this)))) {
            offsetEntry.setFinancialBalanceTypeCode(balanceType);
            customized = true;
        }
        offsetEntry.setOrganizationDocumentNumber(this.getTravelDocumentIdentifier());
        return customized;
    }

    public boolean customizeAdvanceOffsetGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail accountingLine, GeneralLedgerPendingEntry explicitEntry, GeneralLedgerPendingEntry offsetEntry) {
        String paymentDocumentType = StringUtils.isBlank((String)this.getTravelAdvancePaymentDocumentType()) ? "TACA" : this.getTravelAdvancePaymentDocumentType();
        offsetEntry.setFinancialDocumentTypeCode(paymentDocumentType);
        offsetEntry.setOrganizationDocumentNumber(this.getTravelDocumentIdentifier());
        return true;
    }

    public String getTravelAdvancePaymentDocumentType() {
        if (this.shouldProcessAdvanceForDocument()) {
            if ("P".equals(this.getAdvanceTravelPayment().getPaymentMethodCode())) {
                return "TACA";
            }
            if ("F".equals(this.getAdvanceTravelPayment().getPaymentMethodCode()) || "W".equals(this.getAdvanceTravelPayment().getPaymentMethodCode())) {
                return "TAWF";
            }
        }
        return "";
    }

    @Override
    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        if ("Closed".equals(this.getAppDocStatus()) || "Cancelled".equals(this.getAppDocStatus())) {
            return true;
        }
        boolean success = super.generateDocumentGeneralLedgerPendingEntries(sequenceHelper);
        if (this.shouldProcessAdvanceForDocument() && this.getTravelAdvance().getTravelAdvanceRequested() != null) {
            if (!StringUtils.isBlank((String)this.getAdvanceTravelPayment().getPaymentMethodCode())) {
                if ("W".equals(this.getAdvanceTravelPayment().getPaymentMethodCode()) && !this.getWireTransfer().isWireTransferFeeWaiverIndicator()) {
                    LOG.debug((Object)"generating wire charge gl pending entries.");
                    WireCharge wireCharge = TravelAuthorizationDocument.getPaymentSourceHelperService().retrieveWireChargeForDate(this.getTravelAdvance().getDueDate());
                    if (wireCharge == null) {
                        wireCharge = TravelAuthorizationDocument.getPaymentSourceHelperService().retrieveCurrentYearWireCharge();
                    }
                    GeneralLedgerPendingEntry chargeEntry = TravelAuthorizationDocument.getPaymentSourceHelperService().processWireChargeDebitEntries((PaymentSource)this, sequenceHelper, wireCharge);
                    TravelAuthorizationDocument.getPaymentSourceHelperService().processWireChargeCreditEntries((PaymentSource)this, sequenceHelper, wireCharge, chargeEntry);
                }
                if ("W".equals(this.getAdvanceTravelPayment().getPaymentMethodCode()) || "F".equals(this.getAdvanceTravelPayment().getPaymentMethodCode())) {
                    TravelAuthorizationDocument.getPaymentSourceHelperService().generateDocumentBankOffsetEntries((PaymentSource)this, sequenceHelper, "TAWF", (KualiDecimal)this.getTravelAdvance().getTravelAdvanceRequested().negated());
                }
            }
            if (!GlobalVariables.getMessageMap().hasErrors()) {
                for (TemSourceAccountingLine advanceAccountingLine : this.getAdvanceAccountingLines()) {
                    this.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)advanceAccountingLine, sequenceHelper);
                    sequenceHelper.increment();
                }
            }
        }
        return success;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (DocumentStatus.PROCESSED.getCode().equals(statusChangeEvent.getNewRouteStatus())) {
            LOG.debug((Object)("New route status is " + statusChangeEvent.getNewRouteStatus()));
            this.getDocumentHeader().setOrganizationDocumentNumber(this.getTravelDocumentIdentifier());
            if (!(this instanceof TravelAuthorizationCloseDocument)) {
                try {
                    this.updateAndSaveAppDocStatus("Open For Reimbursement");
                }
                catch (WorkflowException ex) {
                    ex.printStackTrace();
                }
                this.getTravelAuthorizationService().createCustomerInvoice(this);
                if (this.getGeneralLedgerPendingEntries() != null && !this.getGeneralLedgerPendingEntries().isEmpty()) {
                    if (this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "HOLD_NEW_FISCAL_YEAR_ENCUMBRANCES_IND").booleanValue()) {
                        ArrayList<GeneralLedgerPendingEntry> survivingEntries = new ArrayList<GeneralLedgerPendingEntry>();
                        ArrayList<HeldEncumbranceEntry> heldEntries = new ArrayList<HeldEncumbranceEntry>();
                        boolean shouldHoldEncumbrance = this.shouldHoldEncumbrance();
                        boolean shouldHoldAdvance = this.shouldHoldAdvance();
                        for (GeneralLedgerPendingEntry glpe : this.getGeneralLedgerPendingEntries()) {
                            if (shouldHoldEncumbrance && this.isEncumbrancePendingEntry(glpe) || shouldHoldAdvance && this.isAdvancePendingEntry(glpe)) {
                                if (!glpe.isTransactionEntryOffsetIndicator()) {
                                    HeldEncumbranceEntry hee = this.getTravelEncumbranceService().convertPendingEntryToHeldEncumbranceEntry(glpe);
                                    heldEntries.add(hee);
                                }
                                this.getBusinessObjectService().delete((PersistableBusinessObject)glpe);
                                continue;
                            }
                            glpe.setFinancialDocumentApprovedCode("A");
                            survivingEntries.add(glpe);
                        }
                        if (!heldEntries.isEmpty()) {
                            this.getBusinessObjectService().save(heldEntries);
                        }
                        this.setGeneralLedgerPendingEntries(survivingEntries);
                    } else {
                        for (GeneralLedgerPendingEntry glpe : this.getGeneralLedgerPendingEntries()) {
                            glpe.setFinancialDocumentApprovedCode("A");
                        }
                    }
                    ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save(this.getGeneralLedgerPendingEntries());
                }
                if (this.shouldProcessAdvanceForDocument() && this.getAdvanceTravelPayment().isImmediatePaymentIndicator()) {
                    ((PaymentSourceExtractionService)SpringContext.getBean(PaymentSourceExtractionService.class, (String)"travelAuthorizationsExtractService")).extractSingleImmediatePayment((PaymentSource)this);
                }
            }
        }
    }

    protected boolean shouldHoldEncumbrance() {
        if (this.getTripEnd() == null) {
            return false;
        }
        Date tripEnd = new Date(this.getTripEnd().getTime());
        return this.getTravelEncumbranceService().shouldHoldEntries(tripEnd);
    }

    protected boolean shouldHoldAdvance() {
        if (this.shouldProcessAdvanceForDocument() && this.getTravelAdvance().getDueDate() != null) {
            return this.getTravelEncumbranceService().shouldHoldEntries(this.getTravelAdvance().getDueDate());
        }
        return false;
    }

    protected boolean isEncumbrancePendingEntry(GeneralLedgerPendingEntry glpe) {
        return StringUtils.equals((String)glpe.getFinancialDocumentTypeCode(), (String)"TA") || StringUtils.equals((String)glpe.getFinancialDocumentTypeCode(), (String)"TAA") || StringUtils.equals((String)glpe.getFinancialDocumentTypeCode(), (String)"TAC");
    }

    protected boolean isAdvancePendingEntry(GeneralLedgerPendingEntry glpe) {
        return StringUtils.equals((String)glpe.getFinancialDocumentTypeCode(), (String)"TACA") || StringUtils.equals((String)glpe.getFinancialDocumentTypeCode(), (String)"TAWF");
    }

    protected void retirePreviousAuthorizations() {
        List<Document> relatedDocs = this.getTravelDocumentService().getDocumentsRelatedTo(this, "TA", "TAA");
        DocumentAttributeIndexingQueue documentAttributeIndexingQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
        try {
            for (Document document : relatedDocs) {
                if (document.getDocumentNumber().equals(this.getDocumentNumber())) continue;
                ((TravelAuthorizationDocument)document).updateAndSaveAppDocStatus("Retired Version");
                documentAttributeIndexingQueue.indexDocument(document.getDocumentNumber());
            }
        }
        catch (WorkflowException we) {
            throw new RuntimeException("Workflow document exception while updating related documents", we);
        }
    }

    public List getSourceAccountingLines() {
        return super.getSourceAccountingLines();
    }

    public List<TemSourceAccountingLine> getEncumbranceSourceAccountingLines() {
        ArrayList<TemSourceAccountingLine> encumbranceLines = new ArrayList<TemSourceAccountingLine>();
        for (TemSourceAccountingLine line : this.getSourceAccountingLines()) {
            if (!"ENCUMBRANCE".equals(line.getCardType())) continue;
            encumbranceLines.add(line);
        }
        return encumbranceLines;
    }

    @Override
    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        if ("Closed".equals(this.getAppDocStatus()) || "Cancelled".equals(this.getAppDocStatus())) {
            return new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
        }
        return super.getGeneralLedgerPendingEntrySourceDetails();
    }

    public TravelPayment getAdvanceTravelPayment() {
        return this.advanceTravelPayment;
    }

    public void setAdvanceTravelPayment(TravelPayment advanceTravelPayment) {
        this.advanceTravelPayment = advanceTravelPayment;
    }

    public List<TemSourceAccountingLine> getAdvanceAccountingLines() {
        return this.advanceAccountingLines;
    }

    public void setAdvanceAccountingLines(List<TemSourceAccountingLine> advanceAccountingLines) {
        this.advanceAccountingLines = advanceAccountingLines;
    }

    public void addAdvanceAccountingLine(TemSourceAccountingLine line) {
        line.setSequenceNumber(this.getNextAdvanceLineNumber());
        this.advanceAccountingLines.add(line);
        this.nextAdvanceLineNumber = new Integer(this.getNextAdvanceLineNumber() + 1);
    }

    public TemSourceAccountingLine getAdvanceAccountingLine(int index) {
        while (this.getAdvanceAccountingLines().size() <= index) {
            this.getAdvanceAccountingLines().add(this.createNewAdvanceAccountingLine());
        }
        return this.getAdvanceAccountingLines().get(index);
    }

    public TemSourceAccountingLine createNewAdvanceAccountingLine() {
        try {
            TemSourceAccountingLine accountingLine = this.getAdvanceAccountingLineClass().newInstance();
            accountingLine.setFinancialDocumentLineTypeCode("A");
            accountingLine.setCardType("ADVANCE");
            accountingLine.setFinancialObjectCode(this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_OBJECT_CODE", ""));
            return accountingLine;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("unable to create a new source accounting line for advances", iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("unable to create a new source accounting line for advances", ie);
        }
    }

    public Class<? extends TemSourceAccountingLine> getAdvanceAccountingLineClass() {
        return TemSourceAccountingLine.class;
    }

    public Integer getNextAdvanceLineNumber() {
        return this.nextAdvanceLineNumber;
    }

    protected void resetNextAdvanceLineNumber() {
        this.nextAdvanceLineNumber = new Integer(1);
    }

    public KualiDecimal getAdvanceTotal() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (TemSourceAccountingLine accountingLine : this.getAdvanceAccountingLines()) {
            if (accountingLine.getAmount() == null) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountingLine.getAmount());
        }
        return total;
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("TravelHasSpecialRequest")) {
            return this.requiresSpecialRequestReviewRouting();
        }
        if (nodeName.equals("TravelIsInternational")) {
            return this.requiresInternationalTravelReviewRouting();
        }
        if (nodeName.equals("TravelNeedsRiskManagement")) {
            return this.requiresRiskManagementReviewRouting();
        }
        if (nodeName.equals("TravelAdvanceRequested")) {
            return this.requiresTravelAdvanceReviewRouting();
        }
        if (nodeName.equals("TravelRequiresDivisionApproval")) {
            return this.requiresDivisionApprovalRouting();
        }
        if (nodeName.equals("TravelRequiresTravelerApproval")) {
            return this.requiresTravelerApprovalRouting();
        }
        if (StringUtils.equals((String)"RequiresBudgetReview", (String)nodeName)) {
            return this.isBudgetReviewRequired();
        }
        if (nodeName.equals("RequiresSeparationOfDuties")) {
            return this.requiresSeparationOfDutiesRouting();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    public boolean requiresTravelerApprovalRouting() {
        return this.getTravelDocumentService().requiresTravelerApproval(this);
    }

    public boolean requiresTravelAdvanceReviewRouting() {
        return this.shouldProcessAdvanceForDocument() && this.getTravelAdvance().getTravelAdvanceRequested().isPositive();
    }

    public boolean requiresRiskManagementReviewRouting() {
        if (ObjectUtils.isNotNull((Object)this.getTripTypeCode()) && this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "INTERNATIONAL_TRIP_TYPES").contains(this.getTripTypeCode())) {
            return true;
        }
        return !ObjectUtils.isNull((Object)((Object)this.getTraveler())) && this.getTraveler().isLiabilityInsurance();
    }

    public void postProcessSave(KualiDocumentEvent event) {
        super.postProcessSave(event);
    }

    @Override
    public void setTemProfile(TemProfile temProfile) {
        super.setTemProfile(temProfile);
        if (!ObjectUtils.isNull((Object)((Object)this.getTravelAdvance()))) {
            this.getTravelAdvance().setTravelAdvancePolicy(false);
        }
    }

    public void logErrors() {
        super.logErrors();
    }

    protected TravelAuthorizationService getTravelAuthorizationService() {
        return (TravelAuthorizationService)SpringContext.getBean(TravelAuthorizationService.class);
    }

    @Override
    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getTransportationModes());
        return managedLists;
    }

    @Override
    public KualiDecimal getReimbursableTotal() {
        return this.getEncumbranceTotal();
    }

    @Override
    public String getReportPurpose() {
        return this.getTripDescription();
    }

    @Override
    public void populateVendorPayment(DisbursementVoucherDocument disbursementVoucherDocument) {
        super.populateVendorPayment(disbursementVoucherDocument);
        String locationCode = this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "DOCUMENTATION_LOCATION_CODE", this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "DOCUMENTATION_LOCATION_CODE"));
        String startDate = new SimpleDateFormat("MM/dd/yyyy").format(this.getTripBegin());
        String endDate = new SimpleDateFormat("MM/dd/yyyy").format(this.getTripEnd());
        String checkStubText = this.getTravelDocumentIdentifier() + ", " + this.getPrimaryDestinationName() + ", " + startDate + " - " + endDate;
        disbursementVoucherDocument.setDisbursementVoucherDocumentationLocationCode(locationCode);
        disbursementVoucherDocument.setDisbVchrCheckStubText(checkStubText);
    }

    @Override
    public String getDefaultCardTypeCode() {
        return this.isTripGenerateEncumbrance() ? "ENCUMBRANCE" : "";
    }

    @Override
    public boolean hasCustomDVDistribution() {
        return true;
    }

    @Override
    public Map<String, String> getDisapprovedAppDocStatusMap() {
        return TemConstants.TravelAuthorizationStatusCodeKeys.getDisapprovedAppDocStatusMap();
    }

    @Override
    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return postable instanceof AccountingLine && "A".equals(((AccountingLine)postable).getFinancialDocumentLineTypeCode());
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        super.prepareForSave(event);
        if (!(this instanceof TravelAuthorizationCloseDocument) && !ObjectUtils.isNull((Object)((Object)this.getTravelAdvance()))) {
            this.getTravelAdvance().setTravelDocumentIdentifier(this.getTravelDocumentIdentifier());
            String checkStubPrefix = this.getConfigurationService().getPropertyValueAsString("message.document.tem.ta.advance.checkText.prefix");
            this.getAdvanceTravelPayment().setCheckStubText(checkStubPrefix + " " + this.getDocumentHeader().getDocumentDescription());
            this.getAdvanceTravelPayment().setDueDate(this.getTravelAdvance().getDueDate());
            this.getAdvanceTravelPayment().setDocumentNumber(this.getDocumentNumber());
            this.updatePayeeTypeForAuthorization();
        }
        if (this.maskTravelDocumentIdentifierAndOrganizationDocNumber()) {
            this.getDocumentHeader().setOrganizationDocumentNumber(null);
        }
    }

    public void updatePayeeTypeForAuthorization() {
        if (!ObjectUtils.isNull((Object)((Object)this.getTraveler())) && !ObjectUtils.isNull((Object)((Object)this.getAdvanceTravelPayment()))) {
            if (this.getTravelerService().isEmployee(this.getTraveler())) {
                this.getAdvanceTravelPayment().setPayeeTypeCode("E");
            } else {
                this.getAdvanceTravelPayment().setPayeeTypeCode("C");
            }
        }
    }

    public PaymentSourceWireTransfer getWireTransfer() {
        return this.wireTransfer;
    }

    public void setWireTransfer(PaymentSourceWireTransfer wireTransfer) {
        this.wireTransfer = wireTransfer;
    }

    public boolean shouldProcessAdvanceForDocument() {
        return !ObjectUtils.isNull((Object)((Object)this.getTravelAdvance())) && this.getTravelAdvance().isAtLeastPartiallyFilledIn();
    }

    public Date getCancelDate() {
        return this.getAdvanceTravelPayment().getCancelDate();
    }

    public boolean hasAttachment() {
        return this.getAdvanceTravelPayment().isAttachmentCode();
    }

    public String getPaymentMethodCode() {
        return this.getAdvanceTravelPayment().getPaymentMethodCode();
    }

    public String getCampusCode() {
        Person initiator = TravelAuthorizationDocument.getPersonService().getPerson(this.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        return initiator.getCampusCode();
    }

    public boolean allParametersForAdvanceAccountingLinesSet() {
        return !StringUtils.isBlank((String)this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_ACCOUNT", "")) && !StringUtils.isBlank((String)this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_CHART", ""));
    }

    public void propagateAdvanceInformationIfNeeded() {
        if (!ObjectUtils.isNull((Object)((Object)this.getTravelAdvance())) && this.getTravelAdvance().getTravelAdvanceRequested() != null) {
            if (!ObjectUtils.isNull((Object)((Object)this.getAdvanceTravelPayment()))) {
                this.getAdvanceTravelPayment().setCheckTotalAmount(this.getTravelAdvance().getTravelAdvanceRequested());
            }
            TemSourceAccountingLine maxAmountLine = this.getAccountingLineWithLargestAmount();
            if (!"Awaiting Fiscal Officer Review".equals(this.getFinancialSystemDocumentHeader().getApplicationDocumentStatus())) {
                this.getAdvanceAccountingLines().get(0).setAmount(this.getTravelAdvance().getTravelAdvanceRequested());
            }
            if (!(this.allParametersForAdvanceAccountingLinesSet() || "Awaiting Fiscal Officer Review".equals(this.getFinancialSystemDocumentHeader().getApplicationDocumentStatus()) || this.advanceAccountingLinesHaveBeenModified(maxAmountLine) || maxAmountLine == null)) {
                this.getAdvanceAccountingLines().get(0).setChartOfAccountsCode(maxAmountLine.getChartOfAccountsCode());
                this.getAdvanceAccountingLines().get(0).setAccountNumber(maxAmountLine.getAccountNumber());
                this.getAdvanceAccountingLines().get(0).setSubAccountNumber(maxAmountLine.getSubAccountNumber());
            }
            if (this.getTravelAdvance().getDueDate() != null && !ObjectUtils.isNull((Object)((Object)this.getAdvanceTravelPayment()))) {
                this.getAdvanceTravelPayment().setDueDate(this.getTravelAdvance().getDueDate());
            }
        }
    }

    protected TemSourceAccountingLine getAccountingLineWithLargestAmount() {
        if (this.getSourceAccountingLines() == null || this.getSourceAccountingLines().isEmpty()) {
            return null;
        }
        TemSourceAccountingLine max = (TemSourceAccountingLine)this.getSourceAccountingLines().get(0);
        for (int count = 1; count < this.getSourceAccountingLines().size(); ++count) {
            TemSourceAccountingLine curr = (TemSourceAccountingLine)this.getSourceAccountingLines().get(count);
            if (!curr.getAmount().isGreaterThan((AbstractKualiDecimal)max.getAmount())) continue;
            max = curr;
        }
        return max;
    }

    protected boolean advanceAccountingLinesHaveBeenModified(TemSourceAccountingLine maxAmountLine) {
        if (this.getAdvanceAccountingLines() == null || this.getAdvanceAccountingLines().isEmpty()) {
            return true;
        }
        if (this.getAdvanceAccountingLines().size() > 1) {
            return true;
        }
        if (maxAmountLine == null) {
            return false;
        }
        return StringUtils.equals((String)this.getAdvanceAccountingLines().get(0).getChartOfAccountsCode(), (String)maxAmountLine.getChartOfAccountsCode()) && StringUtils.equals((String)this.getAdvanceAccountingLines().get(0).getAccountNumber(), (String)maxAmountLine.getAccountNumber()) && StringUtils.equals((String)this.getAdvanceAccountingLines().get(0).getSubAccountNumber(), (String)maxAmountLine.getSubAccountNumber());
    }

    public List generateSaveEvents() {
        List events = super.generateSaveEvents();
        if (!ObjectUtils.isNull((Object)((Object)this.getTravelAdvance())) && this.getTravelAdvance().isAtLeastPartiallyFilledIn() && !this.getDocumentHeader().getWorkflowDocument().isInitiated() && !this.getDocumentHeader().getWorkflowDocument().isSaved()) {
            List persistedAdvanceAccountingLines = this.getPersistedAdvanceAccountingLinesForComparison();
            List currentAdvanceAccountingLines = this.getAdvanceAccountingLinesForComparison();
            List advanceEvents = this.generateEventsForAdvanceAccountingLines(persistedAdvanceAccountingLines, currentAdvanceAccountingLines);
            events.addAll(advanceEvents);
        }
        return events;
    }

    protected List generateEventsForAdvanceAccountingLines(List<TemSourceAccountingLine> persistedAdvanceAccountingLines, List<TemSourceAccountingLine> currentAdvanceAccountingLines) {
        ArrayList<Object> events = new ArrayList<Object>();
        Map persistedLineMap = this.buildAccountingLineMap(persistedAdvanceAccountingLines);
        String errorPathPrefix = "document.advanceAccountingLines";
        String groupErrorPathPrefix = "document.advanceAccountingLiness";
        int index = 0;
        for (TemSourceAccountingLine currentLine : currentAdvanceAccountingLines) {
            String indexedErrorPathPrefix = "document.advanceAccountingLines[" + index + "]";
            Integer key = currentLine.getSequenceNumber();
            AccountingLine persistedLine = (AccountingLine)persistedLineMap.get(key);
            if (persistedLine != null) {
                ReviewAccountingLineEvent reviewEvent = new ReviewAccountingLineEvent(indexedErrorPathPrefix, (Document)this, (AccountingLine)currentLine);
                events.add(reviewEvent);
                persistedLineMap.remove(key);
                continue;
            }
            AddAccountingLineEvent addEvent = new AddAccountingLineEvent(indexedErrorPathPrefix, (Document)this, (AccountingLine)currentLine);
            events.add(addEvent);
        }
        ArrayList remainingPersistedLines = new ArrayList();
        remainingPersistedLines.addAll(persistedLineMap.values());
        for (TemSourceAccountingLine persistedLine : remainingPersistedLines) {
            DeleteAccountingLineEvent deleteEvent = new DeleteAccountingLineEvent("document.advanceAccountingLiness", (Document)this, (AccountingLine)persistedLine, true);
            events.add(deleteEvent);
        }
        return events;
    }

    public boolean maskTravelDocumentIdentifierAndOrganizationDocNumber() {
        boolean vendorPaymentAllowedBeforeFinal = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "VENDOR_PAYMENT_ALLOWED_BEFORE_FINAL_APPROVAL_IND");
        return !vendorPaymentAllowedBeforeFinal && !this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed() && !this.getFinancialSystemDocumentHeader().getWorkflowDocument().isFinal();
    }

    protected List getAdvanceAccountingLinesForComparison() {
        return this.getAdvanceAccountingLines();
    }

    public String getHoldRequestorPersonName() {
        if (StringUtils.isNotBlank((String)this.holdRequestorprincipalId)) {
            Person person = TravelAuthorizationDocument.getPersonService().getPerson(this.holdRequestorprincipalId);
            return person.getName();
        }
        return "";
    }

    public void setHoldRequestorprincipalId(String holdRequestorprincipalId) {
        this.holdRequestorprincipalId = holdRequestorprincipalId;
    }

    protected List getPersistedAdvanceAccountingLinesForComparison() {
        return ((AccountingLineService)SpringContext.getBean(AccountingLineService.class)).getByDocumentHeaderIdAndLineType(this.getAdvanceAccountingLineClass(), this.getDocumentNumber(), "A");
    }

    @Override
    protected boolean shouldRouteByProfileAccount() {
        return this.getBlanketTravel() != false || !this.getTripType().isGenerateEncumbrance() || this.hasOnlyPrepaidExpenses();
    }

    @Override
    public Date getEffectiveDateForMileageRate(ActualExpense expense) {
        if (this.getTripBegin() == null) {
            return new Date(this.getDocumentHeader().getWorkflowDocument().getDateCreated().getMillis());
        }
        return new Date(this.getTripBegin().getTime());
    }

    @Override
    public Date getEffectiveDateForMileageRate(PerDiemExpense expense) {
        if (this.getTripBegin() == null) {
            return new Date(this.getDocumentHeader().getWorkflowDocument().getDateCreated().getMillis());
        }
        return new Date(this.getTripBegin().getTime());
    }

    @Override
    public Date getEffectiveDateForPerDiem(PerDiemExpense expense) {
        if (this.getTripBegin() == null) {
            return new Date(this.getDocumentHeader().getWorkflowDocument().getDateCreated().getMillis());
        }
        return new Date(this.getTripBegin().getTime());
    }

    @Override
    public Date getEffectiveDateForPerDiem(Timestamp expenseDate) {
        if (this.getTripBegin() == null) {
            return new Date(this.getDocumentHeader().getWorkflowDocument().getDateCreated().getMillis());
        }
        return new Date(this.getTripBegin().getTime());
    }

    public PersistableBusinessObject getNoteTarget() {
        if (StringUtils.isBlank((String)this.getTravelDocumentIdentifier()) || this.isTripProgenitor()) {
            return this.getDocumentHeader();
        }
        TravelDocument rootDocument = this.getTravelDocumentService().getRootTravelDocumentWithoutWorkflowDocument(this.getTravelDocumentIdentifier());
        if (rootDocument == null) {
            return this.getDocumentHeader();
        }
        return rootDocument.getDocumentHeader();
    }

    public List<TravelAdvance> getTravelAdvances() {
        if (this.travelAdvancesForTrip == null) {
            this.travelAdvancesForTrip = this.getTravelDocumentService().getTravelAdvancesForTrip(this.getTravelDocumentIdentifier());
        }
        return this.travelAdvancesForTrip;
    }

    protected static PersonService getPersonService() {
        if (personService == null) {
            personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return personService;
    }

    protected static PaymentSourceHelperService getPaymentSourceHelperService() {
        if (paymentSourceHelperService == null) {
            paymentSourceHelperService = (PaymentSourceHelperService)SpringContext.getBean(PaymentSourceHelperService.class);
        }
        return paymentSourceHelperService;
    }

    protected static OptionsService getOptionsService() {
        if (optionsService == null) {
            optionsService = (OptionsService)SpringContext.getBean(OptionsService.class);
        }
        return optionsService;
    }

    protected static UniversityDateService getUniversityDateService() {
        if (universityDateService == null) {
            universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        }
        return universityDateService;
    }

    protected static OffsetDefinitionService getOffsetDefinitionService() {
        if (offsetDefinitionService == null) {
            offsetDefinitionService = (OffsetDefinitionService)SpringContext.getBean(OffsetDefinitionService.class);
        }
        return offsetDefinitionService;
    }
}

