/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.lookup;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.workflow.KFSDocumentSearchCustomizer;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeString;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValue;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValues;

public class TravelDocumentSearchCustomizer
extends KFSDocumentSearchCustomizer {
    public static Logger LOG = Logger.getLogger(TravelDocumentSearchCustomizer.class);

    public DocumentSearchResultValues customizeResults(DocumentSearchCriteria documentSearchCriteria, List<DocumentSearchResult> defaultResults) {
        DocumentSearchResultValues.Builder customResultsBuilder = DocumentSearchResultValues.Builder.create();
        ArrayList<DocumentSearchResultValue.Builder> customResultValueBuilders = new ArrayList<DocumentSearchResultValue.Builder>();
        for (DocumentSearchResult result : defaultResults) {
            ArrayList<DocumentAttributeString.Builder> custAttrBuilders = new ArrayList<DocumentAttributeString.Builder>();
            Document document = result.getDocument();
            if ("TA".equals(document.getDocumentTypeName())) {
                for (DocumentAttribute documentAttribute : result.getDocumentAttributes()) {
                    DocumentAttributeString.Builder builder;
                    if ("travelDocumentIdentifier".equals(documentAttribute.getName()) && this.maskOrgDocNumberAndTravelDocumentIdentifier(document)) {
                        builder = DocumentAttributeString.Builder.create((String)"travelDocumentIdentifier");
                        builder.setValue((Object)"********");
                        custAttrBuilders.add(builder);
                    }
                    if (!"organizationDocumentNumber".equals(documentAttribute.getName()) || !this.maskOrgDocNumberAndTravelDocumentIdentifier(document)) continue;
                    builder = DocumentAttributeString.Builder.create((String)"organizationDocumentNumber");
                    builder.setValue((Object)"********");
                    custAttrBuilders.add(builder);
                }
            }
            DocumentSearchResultValue.Builder builder = DocumentSearchResultValue.Builder.create((String)document.getDocumentId());
            builder.setDocumentAttributes(custAttrBuilders);
            customResultValueBuilders.add(builder);
        }
        customResultsBuilder.setResultValues(customResultValueBuilders);
        return customResultsBuilder.build();
    }

    public boolean maskOrgDocNumberAndTravelDocumentIdentifier(Document document) {
        boolean vendorPaymentAllowedBeforeFinal = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(TravelAuthorizationDocument.class, "VENDOR_PAYMENT_ALLOWED_BEFORE_FINAL_APPROVAL_IND");
        return !vendorPaymentAllowedBeforeFinal && !"P".equals(document.getStatus().getCode()) && !"F".equals(document.getStatus().getCode());
    }

    public boolean isCustomizeResultsEnabled(String documentTypeName) {
        return true;
    }

    public TravelDocument getDocument(String documentNumber) {
        TravelDocument document = null;
        try {
            document = (TravelDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        }
        catch (WorkflowException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return document;
    }

    protected DocumentService getDocumentService() {
        return (DocumentService)SpringContext.getBean(DocumentService.class);
    }
}

