/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.maintenance;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.exception.AuthorizationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.document.authorization.TemProfileAuthorizer;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.kfs.sys.document.FinancialSystemMaintenanceDocument;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class TemProfileMaintainable
extends FinancialSystemMaintainable {
    private static final Logger LOG = Logger.getLogger(TemProfileMaintainable.class);
    protected transient TemProfileAuthorizer authorizer;

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        Person currentUser;
        super.processAfterNew(document, parameters);
        TravelerService travelerService = (TravelerService)SpringContext.getBean(TravelerService.class);
        SequenceAccessorService sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
        TemProfile temProfile = (TemProfile)super.getBusinessObject();
        Integer profileId = temProfile.getProfileId();
        if (ObjectUtils.isNull((Object)profileId)) {
            Integer newProfileId = sas.getNextAvailableSequenceNumber("TEM_PROFILE_ID_SEQ").intValue();
            temProfile.setProfileId(newProfileId);
        }
        String principalId = "";
        if (parameters.containsKey("principalId") && StringUtils.isNotBlank((String)(principalId = parameters.get("principalId")[0]))) {
            Person person = this.getPersonService().getPerson(principalId);
            temProfile.setPrincipal(person);
            temProfile.setPrincipalId(principalId);
            if (travelerService.isKimPersonEmployee(person)) {
                temProfile.setTravelerTypeCode("EMP");
            } else {
                temProfile.setTravelerTypeCode("NON");
            }
            String[] primaryDeptCode = person.getPrimaryDepartmentCode().split("-");
            if (primaryDeptCode != null && primaryDeptCode.length == 2) {
                temProfile.setHomeDeptChartOfAccountsCode(primaryDeptCode[0]);
                temProfile.setHomeDeptOrgCode(primaryDeptCode[1]);
            }
            currentUser = GlobalVariables.getUserSession().getPerson();
            if (!(this.doesProfilePrincipalMatchCurrentUser(principalId) && this.getTemProfileAuthorizer().canEditOwnProfile((BusinessObject)document, currentUser) || this.getTemProfileAuthorizer().canCreateAnyProfile((BusinessObject)document, currentUser))) {
                throw new AuthorizationException(currentUser.getPrincipalName(), "Edit All TEM Profiles", ((Object)((Object)this)).getClass().getSimpleName());
            }
        }
        String customerNumber = "";
        if (parameters.containsKey("customerNumber") && StringUtils.isNotBlank((String)(customerNumber = parameters.get("customerNumber")[0]))) {
            AccountsReceivableCustomer person = this.getAccountsReceivableModuleService().findCustomer(customerNumber);
            temProfile.setCustomer(person);
            temProfile.setCustomerNumber(customerNumber);
            if (travelerService.isCustomerEmployee(person)) {
                temProfile.setTravelerTypeCode("EMP");
            } else {
                temProfile.setTravelerTypeCode("NON");
            }
            currentUser = GlobalVariables.getUserSession().getPerson();
            ChartOrgHolder chartOrg = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPrimaryOrganization(currentUser, "KFS-TEM");
            temProfile.setHomeDeptChartOfAccountsCode(chartOrg.getChartOfAccountsCode());
            temProfile.setHomeDeptOrgCode(chartOrg.getOrganizationCode());
            if (!this.getTemProfileAuthorizer().canCreateAnyProfile((BusinessObject)document, currentUser)) {
                throw new AuthorizationException(currentUser.getPrincipalName(), "Edit All TEM Profiles", ((Object)((Object)this)).getClass().getSimpleName());
            }
        }
        travelerService.populateTemProfile(temProfile);
        if (document.isNew()) {
            if (StringUtils.isNotBlank((String)principalId)) {
                document.getDocumentHeader().setDocumentDescription(this.trimDescription("New Traveler Profile for " + temProfile.getPrincipal().getName()));
            } else if (StringUtils.isNotBlank((String)customerNumber)) {
                document.getDocumentHeader().setDocumentDescription(this.trimDescription("New Traveler Profile for " + temProfile.getCustomer().getCustomerName()));
            }
        }
    }

    protected boolean doesProfilePrincipalMatchCurrentUser(String principalId) {
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        if (currentUser == null) {
            return false;
        }
        return StringUtils.equals((String)principalId, (String)currentUser.getPrincipalId());
    }

    protected void populateInfo(TemProfile profile) {
        ((TravelerService)SpringContext.getBean(TravelerService.class)).populateTemProfile(profile);
        ((TemProfileService)SpringContext.getBean(TemProfileService.class)).updateACHAccountInfo(profile);
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> parameters) {
        this.populateInfo((TemProfile)document.getOldMaintainableObject().getBusinessObject());
        this.populateInfo((TemProfile)document.getNewMaintainableObject().getBusinessObject());
        super.processAfterEdit(document, parameters);
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        TemProfile temProfile;
        super.doRouteStatusChange(documentHeader);
        if (documentHeader.getWorkflowDocument().isProcessed() && "NON".equals((temProfile = (TemProfile)super.getBusinessObject()).getTravelerTypeCode())) {
            this.updateCustomerContactInformation(temProfile);
        }
    }

    protected void updateCustomerContactInformation(TemProfile temProfile) {
        AccountsReceivableCustomer customer = temProfile.getCustomer();
        if (!(ObjectUtils.isNull((Object)customer) || ObjectUtils.isNull((Object)customer.getAccountsReceivableCustomerAddresses()) || customer.getAccountsReceivableCustomerAddresses().isEmpty())) {
            for (AccountsReceivableCustomerAddress customerAddress : customer.getAccountsReceivableCustomerAddresses()) {
                if (!"P".equals(customerAddress.getAccountsReceivableCustomerAddressType().getCustomerAddressTypeCode())) continue;
                customerAddress.setCustomerLine1StreetAddress(temProfile.getTemProfileAddress().getStreetAddressLine1());
                customerAddress.setCustomerLine2StreetAddress(temProfile.getTemProfileAddress().getStreetAddressLine2());
                customerAddress.setCustomerCityName(temProfile.getTemProfileAddress().getCityName());
                customerAddress.setCustomerStateCode(temProfile.getTemProfileAddress().getStateCode());
                customerAddress.setCustomerZipCode(temProfile.getTemProfileAddress().getZipCode());
                customerAddress.setCustomerCountryCode(temProfile.getTemProfileAddress().getCountryCode());
                customerAddress.setCustomerEmailAddress(temProfile.getEmailAddress());
                this.getAccountsReceivableModuleService().saveCustomer(temProfile.getCustomer());
            }
            customer.setCustomerPhoneNumber(temProfile.getPhoneNumber());
            customer.setCustomerEmailAddress(temProfile.getEmailAddress());
            this.getAccountsReceivableModuleService().saveCustomer(temProfile.getCustomer());
        }
    }

    protected boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("ProfileIsTaxManagerRequired")) {
            return this.taxManagerRequiredRouting();
        }
        if (nodeName.equals("TravelRequiresTravelerApproval")) {
            return this.travelerRequiredRouting();
        }
        if (nodeName.equals("ProfileReviewRequired")) {
            return this.travelerRequiredRouting();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    protected void populateChartOfAccountsCodeFields() {
    }

    protected boolean taxManagerRequiredRouting() {
        TemProfile newTemProfile = (TemProfile)this.getParentMaintDoc().getNewMaintainableObject().getBusinessObject();
        TemProfile oldTemProfile = (TemProfile)this.getParentMaintDoc().getOldMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNotNull((Object)oldTemProfile.getProfileId())) {
            if (!newTemProfile.getNonResidentAlien().equals(oldTemProfile.getNonResidentAlien())) {
                return true;
            }
            if (!StringUtils.equalsIgnoreCase((String)newTemProfile.getCitizenship(), (String)oldTemProfile.getCitizenship())) {
                return true;
            }
        } else {
            if (newTemProfile.getNonResidentAlien().booleanValue()) {
                return true;
            }
            if (!StringUtils.isBlank((String)newTemProfile.getCitizenship()) && !newTemProfile.getCitizenship().equals("US")) {
                return true;
            }
        }
        return false;
    }

    protected boolean travelerRequiredRouting() {
        TemProfile newTemProfile = (TemProfile)this.getParentMaintDoc().getNewMaintainableObject().getBusinessObject();
        String initiator = this.getParentMaintDoc().getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        return newTemProfile.getPrincipalId() != null && !newTemProfile.getPrincipalId().equals(initiator);
    }

    protected FinancialSystemMaintenanceDocument getParentMaintDoc() {
        FinancialSystemMaintenanceDocument maintDoc = null;
        try {
            maintDoc = (FinancialSystemMaintenanceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(this.getDocumentNumber());
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        return maintDoc;
    }

    protected void refreshReferences(String referencesToRefresh) {
        super.refreshReferences(this.removeReferenceFromString(referencesToRefresh, "temProfileAddress"));
    }

    protected String removeReferenceFromString(String referencesToRefresh, String referenceToRemove) {
        int index;
        String newReference = referencesToRefresh;
        if (ObjectUtils.isNotNull((Object)newReference) && (index = newReference.indexOf(referenceToRemove)) != -1) {
            if (index == 0) {
                String suffix = "";
                if (newReference.length() != referenceToRemove.length()) {
                    suffix = ",";
                }
                newReference = referencesToRefresh.replaceAll("temProfileAddress" + suffix, "");
            } else {
                newReference = referencesToRefresh.replaceAll(",temProfileAddress", "");
            }
        }
        return newReference;
    }

    protected String trimDescription(String descriptionText) {
        if (descriptionText.length() > 40) {
            descriptionText = descriptionText.substring(0, 39);
        }
        return descriptionText;
    }

    protected Note addCustomerCreatedNote(TemProfile temProfile) {
        String text = "AR Customer ID " + temProfile.getCustomer().getCustomerNumber() + " has been generated";
        Note note = new Note();
        note.setNotePostedTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
        note.setVersionNumber(Long.valueOf(1L));
        note.setNoteText(text);
        note.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
        Person kualiUser = GlobalVariables.getUserSession().getPerson();
        note = this.getNoteService().createNote(note, (PersistableBusinessObject)temProfile, kualiUser.getPrincipalId());
        return note;
    }

    public PersistableBusinessObject getNewCollectionLine(String collectionName) {
        PersistableBusinessObject addLine = super.getNewCollectionLine(collectionName);
        if (collectionName.equals("accounts")) {
            TemProfileAccount account = (TemProfileAccount)addLine;
            TemProfile temProfile = (TemProfile)super.getBusinessObject();
            account.setProfile(temProfile);
            return account;
        }
        return addLine;
    }

    protected AccountsReceivableModuleService getAccountsReceivableModuleService() {
        return (AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class);
    }

    public NoteService getNoteService() {
        return KRADServiceLocator.getNoteService();
    }

    protected TemProfileAuthorizer getTemProfileAuthorizer() {
        if (this.authorizer == null) {
            this.authorizer = (TemProfileAuthorizer)this.getDocumentHelperService().getDocumentAuthorizer("TTP");
        }
        return this.authorizer;
    }
}

