/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.dataaccess.TravelDocumentDao;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.service.TravelPaymentsHelperService;
import org.kuali.kfs.pdp.businessobject.PaymentAccountDetail;
import org.kuali.kfs.pdp.businessobject.PaymentDetail;
import org.kuali.kfs.pdp.businessobject.PaymentGroup;
import org.kuali.kfs.sys.batch.service.PaymentSourceToExtractService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.document.PaymentSource;
import org.kuali.kfs.sys.document.service.PaymentSourceHelperService;
import org.kuali.kfs.sys.document.validation.event.AccountingDocumentSaveWithNoLedgerEntryGenerationEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TravelAuthorizationDocumentExtractionHelperServiceImpl
implements PaymentSourceToExtractService<TravelAuthorizationDocument> {
    Logger LOG = Logger.getLogger(TravelAuthorizationDocumentExtractionHelperServiceImpl.class);
    protected TravelDocumentDao travelDocumentDao;
    protected TravelPaymentsHelperService travelPaymentsHelperService;
    protected DocumentService documentService;
    protected PaymentSourceHelperService paymentSourceHelperService;
    protected ParameterService parameterService;

    public Map<String, List<TravelAuthorizationDocument>> retrievePaymentSourcesByCampus(boolean immediatesOnly) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"retrievePaymentSourcesByCampus() started");
        }
        HashMap<String, List<TravelAuthorizationDocument>> documentsByCampus = new HashMap<String, List<TravelAuthorizationDocument>>();
        List<? extends TravelAuthorizationDocument> authorizations = this.retrieveAllApprovedAuthorizationDocuments(immediatesOnly);
        HashMap<String, String> initiatorCampuses = new HashMap<String, String>();
        for (TravelAuthorizationDocument travelAuthorizationDocument : authorizations) {
            String campusCode = this.getTravelPaymentsHelperService().findCampusForDocument(travelAuthorizationDocument, initiatorCampuses);
            if (StringUtils.isBlank((String)campusCode)) continue;
            ArrayList<TravelAuthorizationDocument> documentsForCampus = (ArrayList<TravelAuthorizationDocument>)documentsByCampus.get(campusCode);
            if (documentsForCampus == null) {
                documentsForCampus = new ArrayList<TravelAuthorizationDocument>();
                documentsByCampus.put(campusCode, documentsForCampus);
            }
            documentsForCampus.add(travelAuthorizationDocument);
        }
        return documentsByCampus;
    }

    protected List<? extends TravelAuthorizationDocument> retrieveAllApprovedAuthorizationDocuments(boolean immediatesOnly) {
        ArrayList<TravelAuthorizationDocument> authorizationsToProcess = new ArrayList<TravelAuthorizationDocument>();
        Collection<? extends TravelAuthorizationDocument> authorizations = this.getTravelDocumentDao().getAuthorizationsAndAmendmentsByHeaderStatus("A", immediatesOnly);
        for (TravelAuthorizationDocument travelAuthorizationDocument : authorizations) {
            if (!travelAuthorizationDocument.shouldProcessAdvanceForDocument()) continue;
            authorizationsToProcess.add(travelAuthorizationDocument);
        }
        return authorizationsToProcess;
    }

    public void cancelPayment(TravelAuthorizationDocument authorizationDoc, Date cancelDate) {
        if (authorizationDoc.getAdvanceTravelPayment().getCancelDate() == null) {
            try {
                authorizationDoc.getAdvanceTravelPayment().setCancelDate(cancelDate);
                this.getPaymentSourceHelperService().handleEntryCancellation((PaymentSource)authorizationDoc, (PaymentSourceToExtractService)this);
                authorizationDoc.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("X");
                this.getDocumentService().saveDocument((Document)authorizationDoc, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
            }
            catch (WorkflowException we) {
                this.LOG.error((Object)("encountered workflow exception while attempting to save Disbursement Voucher: " + authorizationDoc.getDocumentNumber() + " " + (Object)((Object)we)));
                throw new RuntimeException(we);
            }
        }
    }

    public boolean shouldRollBackPendingEntry(GeneralLedgerPendingEntry entry) {
        return StringUtils.equals((String)entry.getFinancialDocumentTypeCode(), (String)"TACA") || StringUtils.equals((String)entry.getFinancialDocumentTypeCode(), (String)"TAWF");
    }

    public void markAsPaid(TravelAuthorizationDocument paymentSource, Date processDate) {
        try {
            paymentSource.getAdvanceTravelPayment().setPaidDate(processDate);
            this.getDocumentService().saveDocument((Document)paymentSource, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        catch (WorkflowException we) {
            this.LOG.error((Object)("encountered workflow exception while attempting to save Disbursement Voucher: " + paymentSource.getDocumentNumber() + " " + (Object)((Object)we)));
            throw new RuntimeException(we);
        }
    }

    public void resetFromExtraction(TravelAuthorizationDocument paymentSource) {
        try {
            paymentSource.getAdvanceTravelPayment().setExtractDate(null);
            paymentSource.getAdvanceTravelPayment().setPaidDate(null);
            paymentSource.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("A");
            this.getDocumentService().saveDocument((Document)paymentSource, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        catch (WorkflowException we) {
            this.LOG.error((Object)("encountered workflow exception while attempting to save Disbursement Voucher: " + paymentSource.getDocumentNumber() + " " + (Object)((Object)we)));
            throw new RuntimeException(we);
        }
    }

    public PaymentGroup createPaymentGroup(TravelAuthorizationDocument authorizationDoc, Date processDate) {
        if (authorizationDoc.shouldProcessAdvanceForDocument()) {
            PaymentGroup pg = this.getTravelPaymentsHelperService().buildGenericPaymentGroup(authorizationDoc.getTraveler(), authorizationDoc.getTemProfile(), authorizationDoc.getAdvanceTravelPayment(), authorizationDoc.getFinancialDocumentBankCode());
            PaymentDetail paymentDetail = this.buildPaymentDetail(authorizationDoc, processDate);
            pg.addPaymentDetails(paymentDetail);
            paymentDetail.setPaymentGroup(pg);
            return pg;
        }
        return null;
    }

    protected PaymentDetail buildPaymentDetail(TravelAuthorizationDocument document, Date processRunDate) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"buildPaymentDetail() started");
        }
        PaymentDetail pd = this.getTravelPaymentsHelperService().buildGenericPaymentDetail(document.getDocumentHeader(), processRunDate, document.getAdvanceTravelPayment(), this.getTravelPaymentsHelperService().getInitiator(document), this.getAchCheckDocumentType(document));
        pd.setPurchaseOrderNbr(document.getTravelDocumentIdentifier());
        pd.setOrganizationDocNbr(document.getTravelDocumentIdentifier());
        List<PaymentAccountDetail> paymentAccounts = this.getTravelPaymentsHelperService().buildGenericPaymentAccountDetails(document.getAdvanceAccountingLines());
        for (PaymentAccountDetail pad : paymentAccounts) {
            pd.addAccountDetail(pad);
        }
        return pd;
    }

    public String getPreDisbursementCustomerProfileUnit() {
        String unit = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "PRE_DISBURSEMENT_EXTRACT_ORGANIZATION");
        return unit;
    }

    public String getPreDisbursementCustomerProfileSubUnit() {
        String subUnit = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "PRE_DISBURSEMENT_EXTRACT_SUB_UNIT");
        return subUnit;
    }

    public void markAsExtracted(TravelAuthorizationDocument document, Date sqlProcessRunDate, KualiInteger paymentGroupId) {
        try {
            document.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("E");
            document.getAdvanceTravelPayment().setExtractDate(sqlProcessRunDate);
            this.getDocumentService().saveDocument((Document)document, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        catch (WorkflowException we) {
            this.LOG.error((Object)("Could not save TravelAuthorizationDocument document #" + document.getDocumentNumber() + ": " + (Object)((Object)we)));
            throw new RuntimeException(we);
        }
    }

    public KualiDecimal getPaymentAmount(TravelAuthorizationDocument document) {
        if (document.shouldProcessAdvanceForDocument()) {
            return document.getAdvanceTravelPayment().getCheckTotalAmount();
        }
        return KualiDecimal.ZERO;
    }

    public String getAchCheckDocumentType(TravelAuthorizationDocument document) {
        return "TACA";
    }

    public boolean handlesAchCheckDocumentType(String achCheckDocumentType) {
        return StringUtils.equals((String)achCheckDocumentType, (String)"TACA");
    }

    public String getImmediateExtractEMailFromAddress() {
        return this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "IMMEDIATE_EXTRACT_NOTIFICATION_FROM_EMAIL_ADDRESS");
    }

    public List<String> getImmediateExtractEmailToAddresses() {
        ArrayList<String> toAddresses = new ArrayList<String>();
        toAddresses.addAll(this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "IMMEDIATE_EXTRACT_NOTIFICATION_TO_EMAIL_ADDRESSES"));
        return toAddresses;
    }

    public boolean shouldExtractPayment(TravelAuthorizationDocument paymentSource) {
        return KualiDecimal.ZERO.isLessThan((AbstractKualiDecimal)this.getPaymentAmount(paymentSource));
    }

    public TravelDocumentDao getTravelDocumentDao() {
        return this.travelDocumentDao;
    }

    public void setTravelDocumentDao(TravelDocumentDao travelDocumentDao) {
        this.travelDocumentDao = travelDocumentDao;
    }

    public TravelPaymentsHelperService getTravelPaymentsHelperService() {
        return this.travelPaymentsHelperService;
    }

    public void setTravelPaymentsHelperService(TravelPaymentsHelperService travelPaymentsHelperService) {
        this.travelPaymentsHelperService = travelPaymentsHelperService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public PaymentSourceHelperService getPaymentSourceHelperService() {
        return this.paymentSourceHelperService;
    }

    public void setPaymentSourceHelperService(PaymentSourceHelperService paymentSourceHelperService) {
        this.paymentSourceHelperService = paymentSourceHelperService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

