/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoice;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.integration.ar.AccountsReceivableOrganizationOptions;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.InfrastructureException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.uif.field.LinkField;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeAware;
import org.kuali.kfs.module.tem.businessobject.GroupTraveler;
import org.kuali.kfs.module.tem.businessobject.GroupTravelerCsvRecord;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.MileageRate;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.PrimaryDestination;
import org.kuali.kfs.module.tem.businessobject.SpecialCircumstances;
import org.kuali.kfs.module.tem.businessobject.SpecialCircumstancesQuestion;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemRegion;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TransportationModeDetail;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.dataaccess.TravelDocumentDao;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.TravelRelocationDocument;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.kfs.module.tem.document.service.MileageRateService;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.exception.UploadParserException;
import org.kuali.kfs.module.tem.service.CsvRecordFactory;
import org.kuali.kfs.module.tem.service.PerDiemService;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.PaymentDocumentationLocation;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TravelDocumentServiceImpl
implements TravelDocumentService {
    protected static Logger LOG = Logger.getLogger(TravelDocumentServiceImpl.class);
    protected DataDictionaryService dataDictionaryService;
    protected DocumentService documentService;
    protected BusinessObjectService businessObjectService;
    protected TravelDocumentDao travelDocumentDao;
    protected TravelAuthorizationService travelAuthorizationService;
    protected DateTimeService dateTimeService;
    protected ParameterService parameterService;
    protected AccountingDocumentRelationshipService accountingDocumentRelationshipService;
    protected TemRoleService temRoleService;
    protected StateService stateService;
    protected ConfigurationService configurationService;
    protected UniversityDateService universityDateService;
    protected List<String> defaultAcceptableFileExtensions;
    protected CsvRecordFactory<GroupTravelerCsvRecord> csvRecordFactory;
    protected List<String> groupTravelerColumns;
    protected volatile AccountsReceivableModuleService accountsReceivableModuleService;
    protected PerDiemService perDiemService;
    protected TravelExpenseService travelExpenseService;
    protected NoteService noteService;
    protected TravelService travelService;
    protected MileageRateService mileageRateService;

    protected PerDiemExpense createPerDiemItem(TravelDocument document, PerDiem newPerDiem, Timestamp ts, boolean prorated, String mileageRateExpenseTypeCode) {
        PerDiemExpense expense = this.newPerDiemExpense();
        expense.setPrimaryDestinationId(newPerDiem.getPrimaryDestinationId());
        expense.setProrated(prorated);
        expense.setMileageDate(ts);
        expense.setPrimaryDestination(newPerDiem.getPrimaryDestination().getPrimaryDestinationName());
        expense.setCountryState(newPerDiem.getPrimaryDestination().getRegion().getRegionName());
        expense.setCounty(newPerDiem.getPrimaryDestination().getCounty());
        this.setPerDiemMealsAndIncidentals(expense, newPerDiem, document.getTripType(), document.getTripEnd(), expense.isProrated());
        KualiDecimal lodgingAmount = this.getPerDiemService().isPerDiemHandlingLodging() && !KfsDateUtils.isSameDay((Date)document.getTripEnd(), (Date)ts) ? newPerDiem.getLodging() : KualiDecimal.ZERO;
        expense.setLodging(lodgingAmount);
        expense.setMileageRateExpenseTypeCode(mileageRateExpenseTypeCode);
        return expense;
    }

    protected PerDiemExpense newPerDiemExpense() {
        return new PerDiemExpense();
    }

    @Override
    public void setPerDiemMealsAndIncidentals(PerDiemExpense expense, PerDiem perDiem, TripType tripType, Timestamp tripEnd, boolean shouldProrate) {
        String perDiemCalcMethod = null;
        if (!ObjectUtils.isNull((Object)((Object)tripType))) {
            perDiemCalcMethod = tripType.getPerDiemCalcMethod();
        }
        expense.setBreakfastValue(perDiem.getBreakfast());
        expense.setLunchValue(perDiem.getLunch());
        expense.setDinnerValue(perDiem.getDinner());
        expense.setIncidentalsValue(perDiem.getIncidentals());
        if (shouldProrate) {
            Integer perDiemPercent = this.calculateProratePercentage(expense, perDiemCalcMethod, tripEnd);
            expense.setDinnerValue(PerDiemExpense.calculateMealsAndIncidentalsProrated(expense.getDinnerValue(), perDiemPercent));
            expense.setLunchValue(PerDiemExpense.calculateMealsAndIncidentalsProrated(expense.getLunchValue(), perDiemPercent));
            expense.setBreakfastValue(PerDiemExpense.calculateMealsAndIncidentalsProrated(expense.getBreakfastValue(), perDiemPercent));
            expense.setIncidentalsValue(PerDiemExpense.calculateMealsAndIncidentalsProrated(expense.getIncidentalsValue(), perDiemPercent));
            this.correctProratedPerDiemExpense(expense, perDiemPercent, perDiem);
        }
    }

    protected void correctProratedPerDiemExpense(PerDiemExpense expense, Integer perDiemPercent, PerDiem perDiem) {
        KualiDecimal mealAndIncidentalLimit = PerDiemExpense.calculateMealsAndIncidentalsProrated(perDiem.getMealsAndIncidentals(), perDiemPercent);
        if (expense.getMealsAndIncidentals().isGreaterThan((AbstractKualiDecimal)mealAndIncidentalLimit)) {
            KualiDecimal delta = (KualiDecimal)expense.getMealsAndIncidentals().subtract((AbstractKualiDecimal)mealAndIncidentalLimit);
            expense.setBreakfastValue((KualiDecimal)expense.getBreakfastValue().subtract((AbstractKualiDecimal)delta));
        }
    }

    protected Collection<Timestamp> dateRange(Timestamp start, Timestamp end) {
        ArrayList<Timestamp> retval = new ArrayList<Timestamp>();
        if (start != null && end != null) {
            Calendar cal = this.getDateTimeService().getCurrentCalendar();
            cal.setTime(start);
            while (!cal.getTime().after(end) || KfsDateUtils.isSameDay((Date)cal.getTime(), (Date)end)) {
                if (KfsDateUtils.isSameDay((Date)cal.getTime(), (Date)end)) {
                    retval.add(new Timestamp(end.getTime()));
                } else {
                    retval.add(new Timestamp(cal.getTime().getTime()));
                }
                cal.add(5, 1);
            }
        }
        return retval;
    }

    @Override
    public void updatePerDiemItemsFor(TravelDocument document, List<PerDiemExpense> perDiemExpenseList, Integer perDiemId, Timestamp start, Timestamp end) {
        String mileageRateExpenseTypeCode = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "PER_DIEM_MILEAGE_RATE_EXPENSE_TYPE_CODE", "");
        boolean datesChanged = false;
        if (perDiemExpenseList != null && !perDiemExpenseList.isEmpty()) {
            Timestamp tempStart = perDiemExpenseList.get(0).getMileageDate();
            Object tempEnd = perDiemExpenseList.get(0).getMileageDate();
            if (perDiemExpenseList.size() > 1) {
                tempEnd = perDiemExpenseList.get(perDiemExpenseList.size() - 1).getMileageDate();
            }
            if (!tempStart.equals(start) || !((Timestamp)tempEnd).equals(end)) {
                datesChanged = true;
            }
        }
        ArrayList<PerDiem> perDiemList = new ArrayList<PerDiem>();
        for (Timestamp eachTimestamp : this.dateRange(start, end)) {
            PerDiem perDiem = this.getPerDiemService().getPerDiem(document.getPrimaryDestinationId(), eachTimestamp, document.getEffectiveDateForPerDiem(eachTimestamp));
            if (perDiem == null || perDiem.getPrimaryDestinationId() == Integer.MAX_VALUE) {
                perDiem = new PerDiem();
                perDiem.setPrimaryDestination(new PrimaryDestination());
                perDiem.getPrimaryDestination().setRegion(new TemRegion());
                perDiem.getPrimaryDestination().getRegion().setTripType(new TripType());
                perDiem.setPrimaryDestinationId(Integer.MAX_VALUE);
                perDiem.getPrimaryDestination().getRegion().setRegionName(document.getPrimaryDestinationCountryState());
                perDiem.getPrimaryDestination().setCounty(document.getPrimaryDestinationCounty());
                perDiem.getPrimaryDestination().getRegion().setTripType(document.getTripType());
                perDiem.getPrimaryDestination().getRegion().setTripTypeCode(document.getTripTypeCode());
                perDiem.getPrimaryDestination().setPrimaryDestinationName(document.getPrimaryDestinationName());
            }
            perDiemList.add(perDiem);
        }
        HashMap<Timestamp, PerDiemExpense> perDiemMapped = new HashMap<Timestamp, PerDiemExpense>();
        int diffStartDays = 0;
        if (perDiemExpenseList.size() > 0 && perDiemExpenseList.get(0).getMileageDate() != null && !datesChanged) {
            diffStartDays = this.dateTimeService.dateDiff((Date)start, (Date)perDiemExpenseList.get(0).getMileageDate(), false);
        }
        Calendar endCal = Calendar.getInstance();
        if (end != null) {
            endCal.setTime(end);
            if (!datesChanged) {
                for (PerDiemExpense perDiemExpense : perDiemExpenseList) {
                    if (diffStartDays != 0) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(perDiemExpense.getMileageDate());
                        cal.add(5, -diffStartDays);
                        perDiemExpense.setMileageDate(new Timestamp(cal.getTimeInMillis()));
                    }
                    if (perDiemExpense.getMileageDate() == null) continue;
                    Calendar currCal = Calendar.getInstance();
                    currCal.setTime(perDiemExpense.getMileageDate());
                    if (endCal.before(currCal)) continue;
                    perDiemMapped.put(perDiemExpense.getMileageDate(), perDiemExpense);
                }
            }
            LOG.debug((Object)("Iterating over date range from " + start + " to " + end));
            int counter = 0;
            for (Timestamp someDate : this.dateRange(start, end)) {
                if (!perDiemMapped.containsKey(someDate)) {
                    boolean prorated = this.shouldProrate(someDate, start, end);
                    PerDiemExpense perDiemExpense = this.createPerDiemItem(document, (PerDiem)((Object)perDiemList.get(counter)), someDate, prorated, mileageRateExpenseTypeCode);
                    perDiemExpense.setDocumentNumber(document.getDocumentNumber());
                    perDiemMapped.put(someDate, perDiemExpense);
                }
                ++counter;
            }
        }
        perDiemExpenseList.clear();
        for (Timestamp timestamp : new TreeSet(perDiemMapped.keySet())) {
            LOG.debug((Object)("Adding " + perDiemMapped.get(timestamp) + " to perdiem list"));
            perDiemExpenseList.add((PerDiemExpense)((Object)perDiemMapped.get(timestamp)));
        }
    }

    protected boolean shouldProrate(Timestamp perDiemDate, Timestamp tripBegin, Timestamp tripEnd) {
        boolean prorated = !KfsDateUtils.isSameDay((Date)tripBegin, (Date)tripEnd) && (KfsDateUtils.isSameDay((Date)perDiemDate, (Date)tripBegin) || KfsDateUtils.isSameDay((Date)perDiemDate, (Date)tripEnd));
        return prorated;
    }

    @Override
    public List<KeyValue> getMileageRateKeyValues(java.sql.Date searchDate) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        TravelDocument document = (TravelDocument)((TravelFormBase)KNSGlobalVariables.getKualiForm()).getDocument();
        String documentType = this.getDocumentType(document);
        String travelerType = ObjectUtils.isNull((Object)((Object)document.getTraveler())) ? null : document.getTraveler().getTravelerTypeCode();
        List<ExpenseType> expenseTypes = this.getTravelExpenseService().getExpenseTypesForDocument(documentType, document.getTripTypeCode(), travelerType, false);
        for (ExpenseType expenseType : expenseTypes) {
            MileageRate mileageRate;
            if (!TemConstants.ExpenseTypeMetaCategory.MILEAGE.getCode().equals(expenseType.getExpenseTypeMetaCategoryCode()) || (mileageRate = this.getMileageRateService().findMileageRateByExpenseTypeCodeAndDate(expenseType.getCode(), searchDate)) == null) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(expenseType.getCode(), expenseType.getCode() + " - " + mileageRate.getRate().toString()));
        }
        Comparator<KeyValue> labelComparator = new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue o1, KeyValue o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        };
        Collections.sort(keyValues, labelComparator);
        return keyValues;
    }

    @Override
    public void copyDownPerDiemExpense(TravelDocument travelDocument, int copyIndex, List<PerDiemExpense> perDiemExpenses) {
        PerDiemExpense lineToCopy = perDiemExpenses.get(copyIndex);
        PerDiemExpense restoredLine = this.getRestoredPerDiemForCopying(travelDocument, lineToCopy);
        ArrayList<PerDiemExpense> tempPerDiemExpenses = new ArrayList<PerDiemExpense>();
        if (copyIndex < perDiemExpenses.size()) {
            for (int i = 0; i < perDiemExpenses.size(); ++i) {
                PerDiemExpense perDiemExpense = new PerDiemExpense();
                if (perDiemExpenses != null && i < copyIndex) {
                    perDiemExpense = perDiemExpenses.get(i);
                } else if (i > copyIndex) {
                    perDiemExpense = this.copyPerDiemExpense(restoredLine);
                    perDiemExpense.setMileageDate(perDiemExpenses.get(i).getMileageDate());
                    if (this.shouldProrate(perDiemExpense.getMileageDate(), travelDocument.getTripBegin(), travelDocument.getTripEnd())) {
                        PerDiem perDiem;
                        perDiemExpense.setProrated(true);
                        if (perDiemExpense.getPrimaryDestinationId() == Integer.MAX_VALUE) {
                            perDiem = this.copyIntoPerDiem(restoredLine);
                            Integer perDiemPercent = this.lookupProratePercentage(perDiemExpense, travelDocument.getTripType().getPerDiemCalcMethod(), travelDocument.getTripEnd());
                            perDiemExpense.setDinnerValue(PerDiemExpense.calculateMealsAndIncidentalsProrated(perDiemExpense.getDinnerValue(), perDiemPercent));
                            perDiemExpense.setLunchValue(PerDiemExpense.calculateMealsAndIncidentalsProrated(perDiemExpense.getLunchValue(), perDiemPercent));
                            perDiemExpense.setBreakfastValue(PerDiemExpense.calculateMealsAndIncidentalsProrated(perDiemExpense.getBreakfastValue(), perDiemPercent));
                            perDiemExpense.setIncidentalsValue(PerDiemExpense.calculateMealsAndIncidentalsProrated(perDiemExpense.getIncidentalsValue(), perDiemPercent));
                        } else {
                            perDiem = this.getPerDiemService().getPerDiem(restoredLine.getPrimaryDestinationId(), perDiemExpense.getMileageDate(), travelDocument.getEffectiveDateForPerDiem(perDiemExpense));
                            this.setPerDiemMealsAndIncidentals(perDiemExpense, perDiem, travelDocument.getTripType(), travelDocument.getTripEnd(), true);
                        }
                    }
                    if (travelDocument.getTripEnd() != null && KfsDateUtils.isSameDay((Date)travelDocument.getTripEnd(), (Date)perDiemExpense.getMileageDate())) {
                        perDiemExpense.setLodging(KualiDecimal.ZERO);
                    }
                } else {
                    perDiemExpense = lineToCopy;
                }
                tempPerDiemExpenses.add(perDiemExpense);
            }
        }
        perDiemExpenses.clear();
        perDiemExpenses.addAll(tempPerDiemExpenses);
    }

    protected PerDiemExpense getRestoredPerDiemForCopying(TravelDocument travelDocument, PerDiemExpense perDiemExpense) {
        PerDiemExpense restoredExpense = this.copyPerDiemExpense(perDiemExpense);
        if (travelDocument.getPrimaryDestinationId() == Integer.MAX_VALUE && this.shouldProrate(perDiemExpense.getMileageDate(), travelDocument.getTripBegin(), travelDocument.getTripEnd())) {
            Integer perDiemPercentage = this.lookupProratePercentage(perDiemExpense, travelDocument.getTripType().getPerDiemCalcMethod(), travelDocument.getTripEnd());
            if (perDiemPercentage != null) {
                KualiDecimal perDiemPercentageDecimal = new KualiDecimal((double)perDiemPercentage.intValue() * 0.01);
                restoredExpense.setBreakfastValue((KualiDecimal)perDiemExpense.getBreakfastValue().divide((AbstractKualiDecimal)perDiemPercentageDecimal));
                restoredExpense.setLunchValue((KualiDecimal)perDiemExpense.getLunchValue().divide((AbstractKualiDecimal)perDiemPercentageDecimal));
                restoredExpense.setDinnerValue((KualiDecimal)perDiemExpense.getDinnerValue().divide((AbstractKualiDecimal)perDiemPercentageDecimal));
                restoredExpense.setIncidentalsValue((KualiDecimal)perDiemExpense.getIncidentalsValue().divide((AbstractKualiDecimal)perDiemPercentageDecimal));
            }
            perDiemExpense.setProrated(false);
        } else {
            PerDiem perDiem = this.getPerDiemService().getPerDiem(perDiemExpense.getPrimaryDestinationId(), perDiemExpense.getMileageDate(), travelDocument.getEffectiveDateForPerDiem(perDiemExpense));
            this.setPerDiemMealsAndIncidentals(restoredExpense, perDiem, travelDocument.getTripType(), travelDocument.getTripEnd(), false);
        }
        return restoredExpense;
    }

    protected PerDiem copyIntoPerDiem(PerDiemExpense perDiemExpense) {
        PerDiem perDiem = new PerDiem();
        perDiem.setPrimaryDestinationId(perDiemExpense.getPrimaryDestinationId());
        perDiem.setBreakfast(perDiemExpense.getBreakfastValue());
        perDiem.setLunch(perDiemExpense.getLunchValue());
        perDiem.setDinner(perDiemExpense.getDinnerValue());
        perDiem.setIncidentals(perDiemExpense.getIncidentalsValue());
        return perDiem;
    }

    @Override
    public Map<String, List<Document>> getDocumentsRelatedTo(TravelDocument document) throws WorkflowException {
        return this.getDocumentsRelatedTo(document.getDocumentNumber());
    }

    @Override
    public Map<String, List<Document>> getDocumentsRelatedTo(String documentNumber) throws WorkflowException {
        HashMap<String, List<Document>> retval = new HashMap<String, List<Document>>();
        Set<String> documentNumbers = this.accountingDocumentRelationshipService.getAllRelatedDocumentNumbers(documentNumber);
        if (!documentNumbers.isEmpty()) {
            for (String documentHeaderId : documentNumbers) {
                Class<?> clazz;
                Document doc = this.documentService.getByDocumentHeaderIdSessionless(documentHeaderId);
                if (doc == null || (clazz = doc.getClass()) == null) continue;
                String docTypeName = this.getDataDictionaryService().getDocumentTypeNameByClass(clazz);
                ArrayList<Document> docs = (ArrayList<Document>)retval.get(docTypeName);
                if (docs == null) {
                    docs = new ArrayList<Document>();
                }
                docs.add(doc);
                retval.put(docTypeName, docs);
            }
        }
        return retval;
    }

    @Override
    public List<Document> getDocumentsRelatedTo(TravelDocument document, String ... documentTypeList) {
        ArrayList<Document> relatedDocumentList = new ArrayList<Document>();
        try {
            Map<String, List<Document>> relatedDocumentMap = this.getDocumentsRelatedTo(document);
            for (String documentType : documentTypeList) {
                if (!relatedDocumentMap.containsKey(documentType)) continue;
                relatedDocumentList.addAll((Collection<Document>)relatedDocumentMap.get(documentType));
            }
        }
        catch (WorkflowException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return relatedDocumentList;
    }

    @Override
    public List<SpecialCircumstances> findActiveSpecialCircumstances(String documentNumber, String documentType) {
        ArrayList<SpecialCircumstances> retval = new ArrayList<SpecialCircumstances>();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("active", true);
        HashSet<String> documentTypesToCheck = new HashSet<String>();
        documentTypesToCheck.add(documentType);
        Set<String> parentDocTypes = this.getTravelService().getParentDocumentTypeNames(documentType);
        documentTypesToCheck.addAll(parentDocTypes);
        criteria.put("documentType", documentTypesToCheck);
        retval.addAll(this.buildSpecialCircumstances(documentNumber, criteria));
        return retval;
    }

    protected List<SpecialCircumstances> buildSpecialCircumstances(String documentNumber, Map<String, Object> criteria) {
        ArrayList<SpecialCircumstances> retval = new ArrayList<SpecialCircumstances>();
        Collection questions = this.getBusinessObjectService().findMatching(SpecialCircumstancesQuestion.class, criteria);
        for (SpecialCircumstancesQuestion question : questions) {
            SpecialCircumstances spc = new SpecialCircumstances();
            spc.setDocumentNumber(documentNumber);
            spc.setQuestionId(question.getId());
            spc.setQuestion(question);
            retval.add(spc);
        }
        return retval;
    }

    @Override
    public List<TravelAuthorizationDocument> findAuthorizationDocuments(String travelDocumentIdentifier) {
        List<String> ids = this.findAuthorizationDocumentNumbers(travelDocumentIdentifier);
        ArrayList<TravelAuthorizationDocument> resultDocumentLists = new ArrayList<TravelAuthorizationDocument>();
        try {
            if (!ids.isEmpty()) {
                for (Document document : this.getDocumentService().getDocumentsByListOfDocumentHeaderIds(TravelAuthorizationDocument.class, ids)) {
                    resultDocumentLists.add((TravelAuthorizationDocument)document);
                }
            }
        }
        catch (WorkflowException wfe) {
            LOG.error((Object)wfe.getMessage(), (Throwable)wfe);
        }
        return resultDocumentLists;
    }

    @Override
    public List<String> findAuthorizationDocumentNumbers(String travelDocumentIdentifier) {
        List<String> ids = this.getTravelDocumentDao().findDocumentNumbers(TravelAuthorizationDocument.class, travelDocumentIdentifier);
        return ids;
    }

    @Override
    public List<TravelReimbursementDocument> findReimbursementDocuments(String travelDocumentIdentifier) {
        List<String> ids = this.getTravelDocumentDao().findDocumentNumbers(TravelReimbursementDocument.class, travelDocumentIdentifier);
        ArrayList<TravelReimbursementDocument> resultDocumentLists = new ArrayList<TravelReimbursementDocument>();
        try {
            if (!ids.isEmpty()) {
                for (Document document : this.getDocumentService().getDocumentsByListOfDocumentHeaderIds(TravelReimbursementDocument.class, ids)) {
                    resultDocumentLists.add((TravelReimbursementDocument)document);
                }
            }
        }
        catch (WorkflowException wfe) {
            throw new RuntimeException(wfe);
        }
        return resultDocumentLists;
    }

    @Override
    public void addAdHocFYIRecipient(Document document) {
        this.addAdHocFYIRecipient(document, document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
    }

    @Override
    public void addAdHocFYIRecipient(Document document, String initiatorUserId) {
        this.addAdHocRecipient(document, initiatorUserId, "F");
    }

    @Override
    public void addAdHocRecipient(Document document, String initiatorUserId, String actionRequested) {
        List adHocRoutePersons = document.getAdHocRoutePersons();
        ArrayList<String> adHocRoutePersonIds = new ArrayList<String>();
        if (!adHocRoutePersons.isEmpty()) {
            for (AdHocRoutePerson ahrp : adHocRoutePersons) {
                adHocRoutePersonIds.add(ahrp.getId());
            }
        }
        if (!adHocRoutePersonIds.contains(initiatorUserId)) {
            if (initiatorUserId != null) {
                Person finSysUser = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(initiatorUserId);
                if (finSysUser != null) {
                    AdHocRoutePerson recipient = this.buildAdHocRecipient(finSysUser.getPrincipalName(), actionRequested);
                    DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer(document);
                    if (documentAuthorizer.canReceiveAdHoc(document, finSysUser, actionRequested)) {
                        adHocRoutePersons.add(recipient);
                    }
                } else {
                    LOG.warn((Object)"finSysUser is null.");
                }
            } else {
                LOG.warn((Object)"initiatorUserId is null.");
            }
        }
    }

    protected AdHocRoutePerson buildAdHocRecipient(String userId, String actionRequested) {
        AdHocRoutePerson adHocRoutePerson = new AdHocRoutePerson();
        adHocRoutePerson.setActionRequested(actionRequested);
        adHocRoutePerson.setId(userId);
        return adHocRoutePerson;
    }

    @Override
    public List<Map<String, KualiDecimal>> calculateDailyTotals(List<PerDiemExpense> perDiemExpenses) {
        ArrayList<Map<String, KualiDecimal>> tripTotals = new ArrayList<Map<String, KualiDecimal>>();
        for (PerDiemExpense perDiemExpense : perDiemExpenses) {
            Map<String, KualiDecimal> dailyTotal = this.calculateDailyTotal(perDiemExpense);
            tripTotals.add(dailyTotal);
        }
        return tripTotals;
    }

    @Override
    public Map<String, KualiDecimal> calculateDailyTotal(PerDiemExpense perDiemExpense) {
        HashMap<String, KualiDecimal> dailyTotals = new HashMap<String, KualiDecimal>();
        dailyTotals.put("mileageTotal", perDiemExpense.getMileageTotal());
        dailyTotals.put("lodgingTotal", perDiemExpense.getLodgingTotal());
        dailyTotals.put("mealsAndIncidentalsTotal", perDiemExpense.getMealsAndIncidentals());
        dailyTotals.put("dailyTotal", perDiemExpense.getDailyTotal());
        return dailyTotals;
    }

    @Override
    public void routeToFiscalOfficer(TravelDocument document, String noteText) throws WorkflowException, Exception {
        Note newNote = this.getDocumentService().createNoteFromDocument((Document)document, noteText);
        document.addNote(newNote);
        this.getNoteService().save(newNote);
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        workflowDocument.returnToPreviousNode(noteText, "Account");
        String messagePattern = this.configurationService.getPropertyValueAsString("message.document.tem.returned.to.fiscal.officer");
        String annotation = MessageFormat.format(messagePattern, GlobalVariables.getUserSession().getPerson().getPrincipalName());
        workflowDocument.adHocToPrincipal(ActionRequestType.FYI, "Account", annotation, workflowDocument.getInitiatorPrincipalId(), "Initiator", true);
        document.refreshReferenceObject("documentHeader");
        document.getFinancialSystemDocumentHeader().updateAndSaveAppDocStatus("Awaiting Fiscal Officer Review");
    }

    @Override
    public Integer calculateProratePercentage(PerDiemExpense perDiemExpense, String perDiemCalcMethod, Timestamp tripEnd) {
        Integer perDiemPercent = 100;
        if (perDiemExpense.isProrated()) {
            perDiemPercent = this.lookupProratePercentage(perDiemExpense, perDiemCalcMethod, tripEnd);
        }
        return perDiemPercent;
    }

    protected Integer lookupProratePercentage(PerDiemExpense perDiemExpense, String perDiemCalcMethod, Timestamp tripEnd) {
        if (perDiemCalcMethod != null && perDiemCalcMethod.equals("P")) {
            try {
                String perDiemPercentage = this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "FIRST_AND_LAST_DAY_PER_DIEM_PERCENTAGE", "100");
                Integer perDiemPercent = Integer.parseInt(perDiemPercentage);
                return perDiemPercent;
            }
            catch (Exception e1) {
                LOG.error((Object)"Failed to process prorate percentage for FIRST_AND_LAST_DAY_PER_DIEM_PERCENTAGE parameter.", (Throwable)e1);
            }
        } else {
            return this.calculatePerDiemPercentageFromTimestamp(perDiemExpense, tripEnd);
        }
        return 100;
    }

    @Override
    public Integer calculatePerDiemPercentageFromTimestamp(PerDiemExpense perDiemExpense, Timestamp tripEnd) {
        if (perDiemExpense.getMileageDate() != null) {
            try {
                Collection quarterTimes = this.parameterService.getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "QUARTER_DAY_TIME_TABLE");
                GregorianCalendar prorateDate = new GregorianCalendar();
                prorateDate.setTime(perDiemExpense.getMileageDate());
                int quadrantIndex = 4;
                for (String qT : quarterTimes) {
                    String[] indexTime = qT.split("=");
                    String[] hourMinute = indexTime[1].split(":");
                    GregorianCalendar qtCal = new GregorianCalendar();
                    qtCal.setTime(perDiemExpense.getMileageDate());
                    qtCal.set(11, Integer.parseInt(hourMinute[0]));
                    qtCal.set(12, Integer.parseInt(hourMinute[1]));
                    if (!((Calendar)prorateDate).equals(qtCal) && !prorateDate.before(qtCal)) continue;
                    quadrantIndex = Integer.parseInt(indexTime[0]);
                    break;
                }
                if (tripEnd != null && !KfsDateUtils.isSameDay((Date)prorateDate.getTime(), (Date)tripEnd)) {
                    return 100 - (quadrantIndex - 1) * 25;
                }
                return quadrantIndex * 25;
            }
            catch (IllegalArgumentException e2) {
                LOG.error((Object)"IllegalArgumentException.", (Throwable)e2);
            }
        }
        return 100;
    }

    @Override
    public PerDiemExpense copyPerDiemExpense(PerDiemExpense perDiemExpense) {
        PerDiemExpense retval = new PerDiemExpense();
        retval.setDocumentNumber(perDiemExpense.getDocumentNumber());
        retval.setCountryState(perDiemExpense.getCountryState());
        retval.setCounty(perDiemExpense.getCounty());
        retval.setPrimaryDestination(perDiemExpense.getPrimaryDestination());
        retval.setMileageDate(perDiemExpense.getMileageDate());
        retval.setMiles(perDiemExpense.getMiles());
        retval.setMileageRateExpenseTypeCode(perDiemExpense.getMileageRateExpenseTypeCode());
        retval.setAccommodationTypeCode(perDiemExpense.getAccommodationTypeCode());
        retval.setAccommodationName(perDiemExpense.getAccommodationName());
        retval.setAccommodationPhoneNum(perDiemExpense.getAccommodationPhoneNum());
        retval.setAccommodationAddress(perDiemExpense.getAccommodationAddress());
        retval.setPrimaryDestinationId(perDiemExpense.getPrimaryDestinationId());
        if (retval.getMiles() == null) {
            retval.setMiles(0);
        }
        if (perDiemExpense.getLodging() == null || perDiemExpense.getLodging().isNegative()) {
            retval.setLodging(KualiDecimal.ZERO);
        } else {
            retval.setLodging(perDiemExpense.getLodging());
        }
        retval.setPersonal(perDiemExpense.getPersonal());
        retval.setBreakfast(perDiemExpense.getBreakfast());
        retval.setLunch(perDiemExpense.getLunch());
        retval.setDinner(perDiemExpense.getDinner());
        retval.setBreakfastValue(perDiemExpense.getBreakfastValue());
        retval.setLunchValue(perDiemExpense.getLunchValue());
        retval.setDinnerValue(perDiemExpense.getDinnerValue());
        retval.setIncidentalsValue(perDiemExpense.getIncidentalsValue());
        LOG.debug((Object)("estimated meals and incidentals " + retval.getMealsAndIncidentals()));
        return retval;
    }

    @Override
    public KualiDecimal calculateMileage(ActualExpense actualExpense) {
        KualiDecimal mileageTotal = KualiDecimal.ZERO;
        if (ObjectUtils.isNotNull((Object)actualExpense.getExpenseTypeCode()) && actualExpense.isMileage()) {
            mileageTotal = actualExpense.getMileageTotal();
        }
        return mileageTotal;
    }

    protected ActualExpense getParentActualExpense(List<ActualExpense> actualExpenses, Long expenseId) {
        if (ObjectUtils.isNotNull(actualExpenses) && ObjectUtils.isNotNull((Object)expenseId)) {
            for (ActualExpense actualExpense : actualExpenses) {
                if (!actualExpense.getId().equals(expenseId)) continue;
                return actualExpense;
            }
        }
        return null;
    }

    @Override
    public void handleNewActualExpense(ActualExpense newActualExpenseLine) {
        if (newActualExpenseLine.getExpenseAmount() != null) {
            BigDecimal rate = newActualExpenseLine.getCurrencyRate();
            KualiDecimal amount = newActualExpenseLine.getExpenseAmount();
            newActualExpenseLine.setConvertedAmount(new KualiDecimal(amount.bigDecimalValue().multiply(rate)));
            LOG.debug((Object)("Set converted amount for " + newActualExpenseLine + " to " + newActualExpenseLine.getConvertedAmount()));
            if (this.isHostedMeal(newActualExpenseLine)) {
                KNSGlobalVariables.getMessageList().add("message.hosted.meal", new String[]{new SimpleDateFormat("MM/dd/yyyy").format(newActualExpenseLine.getExpenseDate()), newActualExpenseLine.getExpenseTypeObjectCode().getExpenseType().getName()});
                newActualExpenseLine.setNonReimbursable(true);
            }
        }
    }

    @Override
    public boolean isHostedMeal(ExpenseTypeAware havingExpenseType) {
        if (ObjectUtils.isNull((Object)havingExpenseType) || StringUtils.isBlank((String)havingExpenseType.getExpenseTypeCode())) {
            return false;
        }
        if (havingExpenseType instanceof PersistableBusinessObject) {
            ((PersistableBusinessObject)havingExpenseType).refreshReferenceObject("expenseType");
        }
        if (ObjectUtils.isNull((Object)((Object)havingExpenseType.getExpenseType()))) {
            return false;
        }
        return havingExpenseType.getExpenseType().isHosted();
    }

    @Override
    public boolean isTravelManager(Person user) {
        return this.getTemRoleService().isTravelManager(user);
    }

    @Override
    public String getMessageFrom(String messageType, String ... args) {
        String strTemp = this.getConfigurationService().getPropertyValueAsString(messageType);
        for (int i = 0; i < args.length; ++i) {
            strTemp = strTemp.replaceAll("\\{" + i + "\\}", args[i]);
        }
        return strTemp;
    }

    @Override
    public boolean isOpen(TravelDocument document) {
        return document.getAppDocStatus().equals("Open For Reimbursement");
    }

    @Override
    public boolean isFinal(TravelDocument document) {
        return document.getDocumentHeader().getWorkflowDocument().isFinal();
    }

    @Override
    public boolean isTravelAuthorizationProcessed(TravelAuthorizationDocument document) {
        return this.isFinal(document) || this.isProcessed(document);
    }

    @Override
    public boolean isTravelAuthorizationOpened(TravelAuthorizationDocument document) {
        return this.isTravelAuthorizationProcessed(document) && this.isOpen(document);
    }

    @Override
    public boolean isProcessed(TravelDocument document) {
        return document.getDocumentHeader().getWorkflowDocument().isProcessed();
    }

    @Override
    public KualiDecimal getAmountDueFromInvoice(String documentNumber, KualiDecimal requestedAmount) {
        try {
            AccountsReceivableCustomerInvoice doc = (AccountsReceivableCustomerInvoice)this.documentService.getByDocumentHeaderId(documentNumber);
            if (doc != null) {
                return doc.getOpenAmount();
            }
        }
        catch (WorkflowException we) {
            throw new RuntimeException(we);
        }
        return requestedAmount;
    }

    @Override
    public TravelAuthorizationDocument findCurrentTravelAuthorization(TravelDocument document) {
        TravelAuthorizationDocument travelDocument = null;
        try {
            Map<String, List<Document>> relatedDocuments = this.getDocumentsRelatedTo(document);
            ArrayList taDocs = relatedDocuments.get("TA");
            List<Document> taaDocs = relatedDocuments.get("TAA");
            List<Document> tacDocs = relatedDocuments.get("TAC");
            if (tacDocs != null && !tacDocs.isEmpty()) {
                travelDocument = (TravelAuthorizationDocument)tacDocs.get(0);
            } else if (taaDocs != null && !taaDocs.isEmpty()) {
                for (Document tempDocument : taaDocs) {
                    if (!this.isTravelAuthorizationOpened((TravelAuthorizationDocument)tempDocument)) continue;
                    travelDocument = (TravelAuthorizationDocument)tempDocument;
                }
            }
            if (travelDocument == null) {
                ArrayList arrayList = taDocs = taDocs == null ? new ArrayList() : taDocs;
                if (taDocs.isEmpty()) {
                    List<TravelAuthorizationDocument> tempTaDocs = this.findAuthorizationDocuments(document.getTravelDocumentIdentifier());
                    if (!tempTaDocs.isEmpty()) {
                        travelDocument = tempTaDocs.get(0);
                    }
                } else {
                    travelDocument = (TravelAuthorizationDocument)taDocs.get(0);
                }
            }
        }
        catch (WorkflowException we) {
            String docNum = document != null && !StringUtils.isBlank((String)document.getDocumentNumber()) ? document.getDocumentNumber() : "???";
            throw new RuntimeException("Could not find documents related to document #" + docNum);
        }
        return travelDocument;
    }

    @Override
    public TravelDocument findRootForTravelReimbursement(String travelDocumentIdentifier) {
        TravelDocument rootTravelDocument = null;
        try {
            Collection<TravelAuthorizationDocument> tempTaDocs = this.getTravelAuthorizationService().find(travelDocumentIdentifier);
            if (!tempTaDocs.isEmpty()) {
                TravelAuthorizationDocument taDoc = null;
                Iterator<TravelAuthorizationDocument> iterator = tempTaDocs.iterator();
                if (iterator.hasNext()) {
                    TravelAuthorizationDocument tempTaDoc;
                    taDoc = tempTaDoc = iterator.next();
                }
                rootTravelDocument = this.findCurrentTravelAuthorization(taDoc);
            } else {
                List<TravelReimbursementDocument> tempTrDocs = this.findReimbursementDocuments(travelDocumentIdentifier);
                if (tempTrDocs.isEmpty()) {
                    LOG.debug((Object)("Did not find any authorizations or reimbursements for travelDocumentIndentifier: " + travelDocumentIdentifier));
                    return null;
                }
                if (tempTrDocs.size() == 1) {
                    rootTravelDocument = tempTrDocs.get(0);
                } else {
                    String rootDocumentNumber = this.getAccountingDocumentRelationshipService().getRootDocumentNumber(tempTrDocs.get(0).getDocumentNumber());
                    TravelDocument tempDoc = (TravelDocument)this.documentService.getByDocumentHeaderIdSessionless(rootDocumentNumber);
                    rootTravelDocument = tempDoc;
                }
            }
        }
        catch (WorkflowException we) {
            throw new RuntimeException("Could not find authorization or reimbursement documents related to trip id #" + travelDocumentIdentifier);
        }
        return rootTravelDocument;
    }

    @Override
    public KualiDecimal getTotalCumulativeReimbursements(TravelDocument document) {
        KualiDecimal trTotal = KualiDecimal.ZERO;
        List<Document> relatedTravelReimbursementDocuments = this.getDocumentsRelatedTo(document, "TR");
        for (Document trDoc : relatedTravelReimbursementDocuments) {
            TravelReimbursementDocument tr = (TravelReimbursementDocument)trDoc;
            if ("X".equals(tr.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode()) || "D".equals(tr.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode())) continue;
            List lines = tr.getSourceAccountingLines();
            for (AccountingLine line : lines) {
                trTotal = (KualiDecimal)trTotal.add((AbstractKualiDecimal)line.getAmount());
            }
        }
        if (document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName().equals("TR")) {
            List lines = document.getSourceAccountingLines();
            for (AccountingLine line : lines) {
                trTotal = (KualiDecimal)trTotal.add((AbstractKualiDecimal)line.getAmount());
            }
        }
        return trTotal;
    }

    @Override
    public KualiDecimal getTotalAuthorizedEncumbrance(TravelDocument document) {
        KualiDecimal taTotal = KualiDecimal.ZERO;
        TravelAuthorizationDocument taDoc = null;
        taDoc = this.findCurrentTravelAuthorization(document);
        if (taDoc != null) {
            List lines = taDoc.getSourceAccountingLines();
            for (AccountingLine line : lines) {
                taTotal = (KualiDecimal)taTotal.add((AbstractKualiDecimal)line.getAmount());
            }
        }
        return taTotal;
    }

    @Override
    public boolean isResponsibleForAccountsOn(TravelDocument document, String principalId) {
        List<String> accounts = this.findAccountsResponsibleFor(document.getSourceAccountingLines(), principalId);
        return accounts != null && accounts.size() > 0;
    }

    protected List<String> findAccountsResponsibleFor(List<SourceAccountingLine> lines, String principalId) {
        HashSet<String> accountList = new HashSet<String>();
        for (AccountingLine accountingLine : lines) {
            Person accountFiscalOfficerUser;
            accountingLine.refreshReferenceObject("account");
            if (accountingLine == null || ObjectUtils.isNull((Object)accountingLine.getAccount()) || (accountFiscalOfficerUser = accountingLine.getAccount().getAccountFiscalOfficerUser()) == null || !accountFiscalOfficerUser.getPrincipalId().equals(principalId)) continue;
            accountList.add(accountingLine.getAccountNumber());
        }
        return new ArrayList<String>(accountList);
    }

    @Override
    public boolean checkNonEmployeeTravelerTypeCode(String travelerTypeCode) {
        boolean foundCode = false;
        if (this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "NON_EMPLOYEE_TRAVELER_TYPE_CODES").contains(travelerTypeCode)) {
            foundCode = true;
        }
        return foundCode;
    }

    @Override
    public String getAllStates(String countryCode) {
        List codes = this.getStateService().findAllStatesInCountry(countryCode);
        StringBuffer sb = new StringBuffer();
        sb.append(";");
        for (State state : codes) {
            if (!state.isActive()) continue;
            sb.append(state.getCode()).append(";");
        }
        return sb.toString();
    }

    @Override
    public <T> List<T> importFile(String fileContents, Class<T> c, String[] attributeNames, Map<String, List<String>> defaultValues, Integer[] attributeMaxLength, String tabErrorKey) {
        if (attributeMaxLength != null && attributeNames.length != attributeMaxLength.length) {
            throw new UploadParserException("Invalid parser configuration, the number of attribute names and attribute max length should be the same");
        }
        return this.importFile(fileContents, c, attributeNames, defaultValues, attributeMaxLength, tabErrorKey, this.getDefaultAcceptableFileExtensions());
    }

    public <T> List<T> importFile(String fileContents, Class<T> c, String[] attributeNames, Map<String, List<String>> defaultValues, Integer[] attributeMaxLength, String tabErrorKey, List<String> fileExtensions) {
        ArrayList<T> importedObjects = new ArrayList<T>();
        Integer lineNo = 0;
        boolean failed = false;
        for (String line : fileContents.split("\n")) {
            Integer n = lineNo;
            Integer n2 = lineNo = Integer.valueOf(lineNo + 1);
            try {
                T o = this.parseLine(line, c, attributeNames, defaultValues, attributeMaxLength, lineNo, tabErrorKey);
                importedObjects.add(o);
            }
            catch (UploadParserException e) {
                failed = true;
            }
        }
        if (failed) {
            throw new UploadParserException("errors in parsing lines in file ", "error.uploadParser.line", new String[0]);
        }
        return importedObjects;
    }

    protected <T> T parseLine(String line, Class<T> c, String[] attributeNames, Map<String, List<String>> defaultValues, Integer[] attributeMaxLength, Integer lineNo, String tabErrorKey) {
        Map<String, String> objectMap = this.retrieveObjectAttributes(line, attributeNames, defaultValues, attributeMaxLength, lineNo, tabErrorKey);
        T obj = this.genObjectWithRetrievedAttributes(objectMap, c, lineNo, tabErrorKey);
        ((PersistableBusinessObject)obj).refresh();
        return obj;
    }

    protected <T> T genObjectWithRetrievedAttributes(Map<String, String> objectMap, Class<T> c, Integer lineNo, String tabErrorKey) {
        T object;
        try {
            object = c.newInstance();
        }
        catch (Exception e) {
            throw new InfrastructureException("unable to complete line population.", e);
        }
        boolean failed = false;
        for (Map.Entry<String, String> entry : objectMap.entrySet()) {
            try {
                try {
                    ObjectUtils.setObjectProperty(object, (String)entry.getKey(), (Object)entry.getValue());
                }
                catch (FormatException e) {
                    String[] errorParams = new String[]{entry.getValue(), entry.getKey(), "" + lineNo};
                    throw new UploadParserException("invalid numeric property value: " + entry.getKey() + " = " + entry.getValue() + " (line " + lineNo + ")", "error.uploadParser.invalidNumericValue", errorParams);
                }
            }
            catch (UploadParserException e) {
                GlobalVariables.getMessageMap().putError(tabErrorKey, e.getErrorKey(), e.getErrorParameters());
                failed = true;
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException("Could not set property while parsing group travelers csv", nsme);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException("Could not set property while parsing group travelers csv", ite);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Could not set property while parsing group travelers csv", iae);
            }
        }
        if (failed) {
            throw new UploadParserException("empty or invalid properties in line " + lineNo + ")", "error.uploadParser.property", "" + lineNo);
        }
        return object;
    }

    protected Map<String, String> retrieveObjectAttributes(String line, String[] attributeNames, Map<String, List<String>> defaultValues, Integer[] attributeMaxLength, Integer lineNo, String tabErrorKey) {
        String[] attributeValues = StringUtils.splitPreserveAllTokens((String)line, (char)',');
        if (attributeNames.length != attributeValues.length) {
            String[] errorParams = new String[]{"" + attributeNames.length, "" + attributeValues.length, "" + lineNo};
            GlobalVariables.getMessageMap().putError(tabErrorKey, "error.uploadParser.wrongPropertyNumber", errorParams);
            throw new UploadParserException("wrong number of properties: " + attributeValues.length + " exist, " + attributeNames.length + " expected (line " + lineNo + ")", "error.uploadParser.wrongPropertyNumber", errorParams);
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            if (defaultValues != null && defaultValues.get(attributeNames[i]) != null) {
                List<String> defaultValue = defaultValues.get(attributeNames[i]);
                boolean found = false;
                for (String value : defaultValue) {
                    if (!attributeValues[i].equalsIgnoreCase(value)) continue;
                    found = true;
                }
                if (!found) {
                    GlobalVariables.getMessageMap().putWarning(tabErrorKey, "error.uploadParser.invalidValue", new String[]{attributeNames[i], attributeValues[i], " " + lineNo});
                    throw new UploadParserException("Invalid value " + attributeValues[i] + " exist, " + "in line (" + lineNo + ")", "error.uploadParser.wrongPropertyNumber", new String[0]);
                }
            }
            if (attributeMaxLength == null || attributeValues[i] == null || attributeValues[i].length() <= attributeMaxLength[i]) continue;
            attributeValues[i] = attributeValues[i].substring(0, attributeMaxLength[i]);
            String[] errorParams = new String[]{"" + attributeNames[i], "" + attributeMaxLength[i], "" + lineNo};
            GlobalVariables.getMessageMap().putWarning(tabErrorKey, "error.uploadParser.excededMaxLength", errorParams);
        }
        HashMap<String, String> objectMap = new HashMap<String, String>();
        for (int i = 0; i < attributeNames.length; ++i) {
            objectMap.put(attributeNames[i], attributeValues[i]);
        }
        return objectMap;
    }

    protected Map<String, List<Integer>> parseHeader(String[] csvHeader) {
        HashMap<String, List<Integer>> retval = new HashMap<String, List<Integer>>();
        Integer i = 0;
        while (i < csvHeader.length) {
            String formattedName;
            if (StringUtils.isBlank((String)csvHeader[i].trim())) {
                formattedName = this.nextHeader(csvHeader, i);
                Integer start = i;
                Integer end = csvHeader.length > i ? this.nextBlankHeader(csvHeader, i) : i;
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                Integer y = start;
                while (y < end) {
                    indexes.add(y);
                    Integer n = y;
                    Integer n2 = y = Integer.valueOf(y + 1);
                }
                retval.put(formattedName, indexes);
            } else {
                formattedName = this.toCamelCase(csvHeader[i]);
                if (StringUtils.isNotBlank((String)formattedName)) {
                    retval.put(formattedName, Arrays.asList(i));
                }
            }
            Integer n = i;
            Integer n3 = i = Integer.valueOf(i + 1);
        }
        return retval;
    }

    protected String nextHeader(String[] headers, int start) {
        for (int i = start + 1; i < headers.length; ++i) {
            if (!StringUtils.isNotBlank((String)headers[i])) continue;
            return this.toCamelCase(headers[i]);
        }
        return "";
    }

    protected Integer nextBlankHeader(String[] headers, int start) {
        for (int i = start + 1; i < headers.length; ++i) {
            if (!StringUtils.isBlank((String)headers[i])) continue;
            return i;
        }
        return -1;
    }

    protected String toProperCase(String s) {
        if (s == null || s.length() < 1) {
            return "";
        }
        char[] arr = s.toLowerCase().toCharArray();
        arr[0] = Character.toUpperCase(arr[0]);
        return new String(arr);
    }

    protected String toCamelCase(String s) {
        StringBuffer buffer = new StringBuffer();
        LinkedList<String> words = new LinkedList<String>(Arrays.asList(s.toLowerCase().trim().replace('_', ' ').split(" ")));
        buffer.append((String)words.remove(0));
        for (String word : words) {
            buffer.append(this.toProperCase(word));
        }
        return buffer.toString();
    }

    @Override
    public List<GroupTraveler> importGroupTravelers(TravelDocument document, String csvData) throws Exception {
        List rows;
        LinkedList<GroupTraveler> retval = new LinkedList<GroupTraveler>();
        BufferedReader bufferedFileReader = new BufferedReader(new StringReader(csvData));
        CSVReader csvReader = new CSVReader((Reader)bufferedFileReader);
        try {
            rows = csvReader.readAll();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ParseException("Could not  parse CSV file data", (Throwable)ex);
        }
        finally {
            try {
                csvReader.close();
            }
            catch (Exception exception) {}
        }
        Map<String, List<Integer>> header = this.getGroupTravelerHeaders();
        for (String[] row : rows) {
            GroupTravelerCsvRecord record = this.createGroupTravelerCsvRecord(header, row);
            GroupTraveler traveler = new GroupTraveler();
            traveler.setGroupTravelerEmpId(record.getGroupTravelerEmpId());
            traveler.setName(record.getName());
            traveler.setGroupTravelerType(record.getGroupTravelerType());
            retval.add(traveler);
        }
        return retval;
    }

    protected GroupTravelerCsvRecord createGroupTravelerCsvRecord(Map<String, List<Integer>> header, String[] record) throws Exception {
        return this.getCsvRecordFactory().newInstance(header, record);
    }

    @Override
    public boolean isUnsuccessful(TravelDocument document) {
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        List unsuccessful = (List)KewApiConstants.DOCUMENT_STATUS_PARENT_TYPES.get("Unsuccessful");
        for (String tempStatus : unsuccessful) {
            if (!status.equals(tempStatus)) continue;
            return true;
        }
        return false;
    }

    protected Map<String, List<Integer>> getGroupTravelerHeaders() {
        HashMap<String, List<Integer>> headers = new HashMap<String, List<Integer>>();
        if (this.getGroupTravelerColumns() != null && !this.getGroupTravelerColumns().isEmpty()) {
            for (int count = 0; count < this.getGroupTravelerColumns().size(); ++count) {
                ArrayList<Integer> countArray = new ArrayList<Integer>(2);
                countArray.add(new Integer(count));
                String columnName = this.getGroupTravelerColumns().get(count);
                headers.put(columnName, countArray);
            }
        }
        return headers;
    }

    @Override
    public List<GroupTraveler> copyGroupTravelers(List<GroupTraveler> groupTravelers, String documentNumber) {
        ArrayList<GroupTraveler> newGroupTravelers = new ArrayList<GroupTraveler>();
        if (groupTravelers != null) {
            for (GroupTraveler groupTraveler : groupTravelers) {
                GroupTraveler newGroupTraveler = new GroupTraveler();
                BeanUtils.copyProperties((Object)((Object)groupTraveler), (Object)((Object)newGroupTraveler));
                newGroupTraveler.setDocumentNumber(documentNumber);
                newGroupTraveler.setVersionNumber(new Long(1L));
                newGroupTraveler.setObjectId(null);
                newGroupTraveler.setId(null);
                newGroupTravelers.add(newGroupTraveler);
            }
        }
        return newGroupTravelers;
    }

    @Override
    public List<? extends TemExpense> copyActualExpenses(List<? extends TemExpense> actualExpenses, String documentNumber) {
        ArrayList<ActualExpense> newActualExpenses = new ArrayList<ActualExpense>();
        if (actualExpenses != null) {
            for (TemExpense temExpense : actualExpenses) {
                ActualExpense actualExpense = (ActualExpense)temExpense;
                ActualExpense newActualExpense = new ActualExpense();
                boolean nullCheck = false;
                if (actualExpense.getExpenseDate() == null) {
                    nullCheck = true;
                    actualExpense.setExpenseDate(new java.sql.Date(0L));
                }
                BeanUtils.copyProperties((Object)actualExpense, (Object)newActualExpense);
                if (nullCheck) {
                    actualExpense.setExpenseDate(null);
                    newActualExpense.setExpenseDate(null);
                }
                List<TemExpense> newDetails = this.copyActualExpenses(actualExpense.getExpenseDetails(), documentNumber);
                newActualExpense.setExpenseDetails(newDetails);
                newActualExpense.setDocumentNumber(documentNumber);
                newActualExpense.setVersionNumber(new Long(1L));
                newActualExpense.setId(null);
                newActualExpense.setObjectId(null);
                newActualExpenses.add(newActualExpense);
            }
        }
        return newActualExpenses;
    }

    private Long getNextActualExpenseId() {
        return ((SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class)).getNextAvailableSequenceNumber("TEM_TRVL_EXP_ID_SEQ");
    }

    @Override
    public List<PerDiemExpense> copyPerDiemExpenses(List<PerDiemExpense> perDiemExpenses, String documentNumber) {
        ArrayList<PerDiemExpense> newPerDiemExpenses = new ArrayList<PerDiemExpense>();
        if (perDiemExpenses != null) {
            for (PerDiemExpense expense : perDiemExpenses) {
                PerDiemExpense newExpense = new PerDiemExpense();
                BeanUtils.copyProperties((Object)((Object)expense), (Object)((Object)newExpense));
                newExpense.setBreakfastValue(expense.getBreakfastValue());
                newExpense.setLunchValue(expense.getLunchValue());
                newExpense.setDinnerValue(expense.getDinnerValue());
                newExpense.setIncidentalsValue(expense.getIncidentalsValue());
                newExpense.setDocumentNumber(documentNumber);
                newExpense.setVersionNumber(new Long(1L));
                newExpense.setObjectId(null);
                newExpense.setId(null);
                newPerDiemExpenses.add(newExpense);
            }
        }
        return newPerDiemExpenses;
    }

    @Override
    public List<TravelAdvance> copyTravelAdvances(List<TravelAdvance> travelAdvances, String documentNumber) {
        ArrayList<TravelAdvance> newTravelAdvances = new ArrayList<TravelAdvance>();
        if (travelAdvances != null) {
            for (TravelAdvance travelAdvance : travelAdvances) {
                TravelAdvance newTravelAdvance = (TravelAdvance)((Object)ObjectUtils.deepCopy((Serializable)((Object)travelAdvance)));
                newTravelAdvance.setDocumentNumber(documentNumber);
                newTravelAdvance.setVersionNumber(new Long(1L));
                newTravelAdvance.setObjectId(null);
                newTravelAdvance.setTravelDocumentIdentifier(travelAdvance.getTravelDocumentIdentifier());
                newTravelAdvances.add(newTravelAdvance);
            }
        }
        return newTravelAdvances;
    }

    @Override
    public List<SpecialCircumstances> copySpecialCircumstances(List<SpecialCircumstances> specialCircumstancesList, String documentNumber) {
        ArrayList<SpecialCircumstances> newSpecialCircumstancesList = new ArrayList<SpecialCircumstances>();
        if (specialCircumstancesList != null) {
            for (SpecialCircumstances specialCircumstances : specialCircumstancesList) {
                SpecialCircumstances newSpecialCircumstances = new SpecialCircumstances();
                BeanUtils.copyProperties((Object)((Object)specialCircumstances), (Object)((Object)newSpecialCircumstances));
                newSpecialCircumstances.setDocumentNumber(documentNumber);
                newSpecialCircumstances.setVersionNumber(new Long(1L));
                newSpecialCircumstances.setObjectId(null);
                newSpecialCircumstances.setId(null);
                newSpecialCircumstancesList.add(newSpecialCircumstances);
            }
        }
        return newSpecialCircumstancesList;
    }

    @Override
    public List<TransportationModeDetail> copyTransportationModeDetails(List<TransportationModeDetail> transportationModeDetails, String documentNumber) {
        ArrayList<TransportationModeDetail> newTransportationModeDetails = new ArrayList<TransportationModeDetail>();
        if (transportationModeDetails != null) {
            for (TransportationModeDetail detail : transportationModeDetails) {
                TransportationModeDetail newDetail = new TransportationModeDetail();
                BeanUtils.copyProperties((Object)((Object)detail), (Object)((Object)newDetail));
                newDetail.setDocumentNumber(documentNumber);
                newDetail.setVersionNumber(new Long(1L));
                newDetail.setObjectId(null);
                newTransportationModeDetails.add(newDetail);
            }
        }
        return newTransportationModeDetails;
    }

    @Override
    public void showNoTravelAuthorizationError(TravelReimbursementDocument document) {
        TravelAuthorizationDocument authorization;
        if (document.getTripType() != null && document.getTripType().getTravelAuthorizationRequired() && (authorization = this.findCurrentTravelAuthorization(document)) == null) {
            GlobalVariables.getMessageMap().putError("document.tripTypeCode", "error.document.tem.triptype.ta.required", new String[]{document.getTripType().getName()});
        }
    }

    @Override
    public KualiDecimal getAdvancesTotalFor(TravelDocument travelDocument) {
        KualiDecimal retval = KualiDecimal.ZERO;
        if (ObjectUtils.isNull((Object)travelDocument)) {
            return retval;
        }
        LOG.debug((Object)("Looking for travel advances for travel: " + travelDocument.getDocumentNumber()));
        TravelAuthorizationDocument authorization = null;
        authorization = this.findCurrentTravelAuthorization(travelDocument);
        if (authorization == null) {
            return retval;
        }
        authorization.refreshReferenceObject("travelAdvance");
        if (authorization.shouldProcessAdvanceForDocument()) {
            retval = (KualiDecimal)retval.add((AbstractKualiDecimal)authorization.getTravelAdvance().getTravelAdvanceRequested());
        }
        return retval;
    }

    @Override
    public String retrieveAddressFromLocationCode(String locationCode) {
        PaymentDocumentationLocation dvDocumentLocation = (PaymentDocumentationLocation)this.businessObjectService.findBySinglePrimaryKey(PaymentDocumentationLocation.class, (Object)locationCode);
        String address = ObjectUtils.isNotNull((Object)dvDocumentLocation) ? dvDocumentLocation.getPaymentDocumentationLocationAddress() : "";
        return address;
    }

    @Override
    public boolean validateSourceAccountingLines(TravelDocument travelDocument, boolean addToErrorPath) {
        boolean success = true;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", travelDocument.getDocumentNumber());
        fieldValues.put("financialDocumentLineTypeCode", "F");
        List currentLines = (List)this.getBusinessObjectService().findMatchingOrderBy(TemSourceAccountingLine.class, fieldValues, "sequenceNumber", true);
        boolean canUpdate = this.isAtTravelNode(travelDocument.getDocumentHeader().getWorkflowDocument());
        for (int i = 0; i < travelDocument.getSourceAccountingLines().size(); ++i) {
            AccountingLine line = (AccountingLine)travelDocument.getSourceAccountingLines().get(i);
            if (addToErrorPath) {
                GlobalVariables.getMessageMap().getErrorPath().add("document.sourceAccountingLine[" + i + "]");
            }
            if (StringUtils.isBlank((String)line.getAccountNumber())) {
                success = false;
                GlobalVariables.getMessageMap().putError("accountNumber", "error.required", new String[]{"Account Number"});
            } else if (!(travelDocument.getAppDocStatus().equalsIgnoreCase("Initiated") || travelDocument.getAppDocStatus().equalsIgnoreCase("In Process") || travelDocument.getAppDocStatus().equalsIgnoreCase("Change In Process") || (i >= currentLines.size() || ((TemSourceAccountingLine)currentLines.get(i)).getAccountNumber().equals(line.getAccountNumber())) && i < currentLines.size())) {
                try {
                    if (!line.getAccount().getAccountFiscalOfficerUser().getPrincipalId().equals(GlobalVariables.getUserSession().getPerson().getPrincipalId()) && !canUpdate) {
                        GlobalVariables.getMessageMap().putError("accountNumber", "error.document.fiscalofficer.account", new String[]{line.getAccountNumber()});
                        success = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isBlank((String)line.getChartOfAccountsCode())) {
                success = false;
                GlobalVariables.getMessageMap().putError("chartOfAccountsCode", "error.required", new String[]{"Chart"});
            }
            if (!addToErrorPath) continue;
            GlobalVariables.getMessageMap().getErrorPath().remove(GlobalVariables.getMessageMap().getErrorPath().size() - 1);
        }
        return success;
    }

    private boolean showPerDiem(List<String> perDiemCats, String perDiemType) {
        for (String category : perDiemCats) {
            String[] pair = category.split("=");
            if (pair[0].equalsIgnoreCase(perDiemType)) {
                return pair[1].equalsIgnoreCase("Y");
            }
            if (pair[0].equalsIgnoreCase(perDiemType)) {
                return pair[1].equalsIgnoreCase("Y");
            }
            if (!pair[0].equalsIgnoreCase(perDiemType)) continue;
            return pair[1].equalsIgnoreCase("Y");
        }
        return false;
    }

    @Override
    public List<TravelAdvance> getOutstandingTravelAdvanceByInvoice(Set<String> arInvoiceDocNumbers) {
        return this.travelDocumentDao.getOutstandingTravelAdvanceByInvoice(arInvoiceDocNumbers);
    }

    @Override
    public java.sql.Date findLatestTaxableRamificationNotificationDate() {
        Object[] returnResult = this.travelDocumentDao.findLatestTaxableRamificationNotificationDate();
        java.sql.Date date = null;
        try {
            date = ObjectUtils.isNotNull((Object)returnResult[0]) ? this.dateTimeService.convertToSqlDate((Timestamp)returnResult[0]) : null;
        }
        catch (java.text.ParseException ex) {
            LOG.error((Object)("Invalid latest taxable ramification notification date " + returnResult[0]));
        }
        return date;
    }

    @Override
    public void detachImportedExpenses(TravelDocument document) {
        for (ImportedExpense importedExpense : document.getImportedExpenses()) {
            ExpenseUtils.assignExpense(importedExpense.getHistoricalTravelExpenseId(), null, null, null, false);
        }
        document.setImportedExpenses(new ArrayList<ImportedExpense>());
        document.setHistoricalTravelExpenses(new ArrayList<HistoricalTravelExpense>());
    }

    @Override
    public void attachImportedExpenses(TravelDocument document) {
        for (ImportedExpense importedExpense : document.getImportedExpenses()) {
            ExpenseUtils.assignExpense(importedExpense.getHistoricalTravelExpenseId(), document.getTravelDocumentIdentifier(), document.getDocumentNumber(), document.getFinancialDocumentTypeCode(), true);
        }
    }

    @Override
    public boolean checkHoldGLPEs(TravelDocument document) {
        if (this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "HOLD_NEW_FISCAL_YEAR_ENCUMBRANCES_IND").booleanValue()) {
            Date endDate = this.getUniversityDateService().getLastDateOfFiscalYear(this.getUniversityDateService().getCurrentFiscalYear());
            if (ObjectUtils.isNotNull((Object)document.getTripBegin()) && document.getTripBegin().after(endDate)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void revertOriginalDocument(TravelDocument travelDocument, String status) {
        DocumentAttributeIndexingQueue documentAttributeIndexingQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
        List<Document> relatedDocumentList = this.getDocumentsRelatedTo(travelDocument, "TA", "TAA");
        for (Document taDocument : relatedDocumentList) {
            if (!taDocument.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus().equals("Pending Amendment")) continue;
            TravelAuthorizationDocument taDoc = (TravelAuthorizationDocument)taDocument;
            try {
                taDoc.updateAndSaveAppDocStatus(status);
            }
            catch (WorkflowException ex1) {
                ex1.printStackTrace();
            }
            try {
                Note cancelNote = this.getDocumentService().createNoteFromDocument((Document)taDoc, "Amemdment Canceled");
                Principal systemUser = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("kfs");
                cancelNote.setAuthorUniversalIdentifier(systemUser.getPrincipalId());
                taDoc.addNote(cancelNote);
                this.getNoteService().save(cancelNote);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            documentAttributeIndexingQueue.indexDocument(taDoc.getDocumentNumber());
        }
    }

    @Override
    public String getDocumentType(TravelDocument document) {
        String documentType = null;
        if (document != null) {
            if (document instanceof TravelAuthorizationDocument) {
                documentType = "TA";
            } else if (document instanceof TravelReimbursementDocument) {
                documentType = "TR";
            } else if (document instanceof TravelEntertainmentDocument) {
                documentType = "ENT";
            } else if (document instanceof TravelRelocationDocument) {
                documentType = "RELO";
            }
        }
        return documentType;
    }

    protected boolean isAtTravelNode(WorkflowDocument workflowDocument) {
        Set nodeNames = workflowDocument.getNodeNames();
        for (String nodeNamesNode : nodeNames) {
            if (!"Travel".equals(nodeNamesNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<TravelAdvance> getTravelAdvancesForTrip(String travelDocumentIdentifier) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("travelDocumentIdentifier", travelDocumentIdentifier);
        ArrayList<TravelAdvance> advances = new ArrayList<TravelAdvance>();
        Collection foundAdvances = this.getBusinessObjectService().findMatchingOrderBy(TravelAdvance.class, criteria, "documentNumber", true);
        for (TravelAdvance foundAdvance : foundAdvances) {
            if (!foundAdvance.isAtLeastPartiallyFilledIn() || !this.isDocumentApprovedOrExtracted(foundAdvance.getDocumentNumber())) continue;
            advances.add(foundAdvance);
        }
        return advances;
    }

    protected boolean isDocumentApprovedOrExtracted(String documentNumber) {
        FinancialSystemDocumentHeader documentHeader = (FinancialSystemDocumentHeader)this.getBusinessObjectService().findBySinglePrimaryKey(FinancialSystemDocumentHeader.class, (Object)documentNumber);
        return "A".equals(documentHeader.getFinancialDocumentStatusCode()) || "E".equals(documentHeader.getFinancialDocumentStatusCode());
    }

    protected boolean isDocumentInitiatedOrEnroute(String documentNumber) {
        FinancialSystemDocumentHeader documentHeader = (FinancialSystemDocumentHeader)this.getBusinessObjectService().findBySinglePrimaryKey(FinancialSystemDocumentHeader.class, (Object)documentNumber);
        return "?".equals(documentHeader.getFinancialDocumentStatusCode()) || "R".equals(documentHeader.getFinancialDocumentStatusCode());
    }

    @Override
    public AccountsReceivableOrganizationOptions getOrgOptions() {
        String chartOfAccountsCode = this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_BILLING_CHART");
        String organizationCode = this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_BILLING_ORGANIZATION");
        return this.getAccountsReceivableModuleService().getOrgOptionsIfExists(chartOfAccountsCode, organizationCode);
    }

    @Override
    public void disableDuplicateExpenses(TravelDocument trDocument, ActualExpense actualExpense) {
        if (trDocument.getPerDiemExpenses() != null && !trDocument.getPerDiemExpenses().isEmpty()) {
            if (actualExpense.getExpenseDetails() != null && !actualExpense.getExpenseDetails().isEmpty()) {
                for (TemExpense temExpense : actualExpense.getExpenseDetails()) {
                    this.checkActualExpenseAgainstPerDiems(trDocument, (ActualExpense)temExpense);
                }
            } else {
                this.checkActualExpenseAgainstPerDiems(trDocument, actualExpense);
            }
        }
    }

    protected void checkActualExpenseAgainstPerDiems(TravelDocument trDocument, ActualExpense actualExpense) {
        int i = 0;
        for (PerDiemExpense perDiemExpense : trDocument.getPerDiemExpenses()) {
            List<DisabledPropertyMessage> messages = this.disableDuplicateExpenseForPerDiem(actualExpense, perDiemExpense, i);
            if (messages != null && !messages.isEmpty()) {
                for (DisabledPropertyMessage message : messages) {
                    message.addToProperties(trDocument.getDisabledProperties());
                }
            }
            ++i;
        }
    }

    protected List<DisabledPropertyMessage> disableDuplicateExpenseForPerDiem(ActualExpense actualExpense, PerDiemExpense perDiemExpense, int perDiemCount) {
        ArrayList<DisabledPropertyMessage> disabledPropertyMessages = new ArrayList<DisabledPropertyMessage>();
        if (actualExpense.getExpenseDate() == null) {
            return disabledPropertyMessages;
        }
        String expenseDate = this.getDateTimeService().toDateString((Date)actualExpense.getExpenseDate());
        String meal = "";
        boolean valid = true;
        if (KfsDateUtils.isSameDay((Date)perDiemExpense.getMileageDate(), (Date)actualExpense.getExpenseDate())) {
            String message;
            String temp;
            if (perDiemExpense.getBreakfast().booleanValue() && actualExpense.isBreakfast() && (actualExpense.getExpenseType().isHosted() || actualExpense.getExpenseType().isGroupTravel())) {
                meal = "breakfast";
                perDiemExpense.setBreakfast(false);
                perDiemExpense.setBreakfastValue(KualiDecimal.ZERO);
                valid = false;
            } else if (perDiemExpense.getLunch().booleanValue() && actualExpense.isLunch() && (actualExpense.getExpenseType().isHosted() || actualExpense.getExpenseType().isGroupTravel())) {
                meal = "lunch";
                perDiemExpense.setLunch(false);
                perDiemExpense.setLunchValue(KualiDecimal.ZERO);
                valid = false;
            } else if (perDiemExpense.getDinner().booleanValue() && actualExpense.isDinner() && (actualExpense.getExpenseType().isHosted() || actualExpense.getExpenseType().isGroupTravel())) {
                meal = "dinner";
                perDiemExpense.setDinner(false);
                perDiemExpense.setDinnerValue(KualiDecimal.ZERO);
                valid = false;
            }
            if (!valid) {
                temp = String.format("document.perDiemExpenses[%d].%s", perDiemCount, meal);
                message = this.getMessageFrom("message.document.tem.mealAlreadyClaimed", expenseDate, meal);
                disabledPropertyMessages.add(new DisabledPropertyMessage(temp, message));
            }
            if (perDiemExpense.getLodging().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && !StringUtils.isBlank((String)actualExpense.getExpenseTypeCode()) && "L".equals(actualExpense.getExpenseTypeCode())) {
                temp = String.format("document.perDiemExpenses[%d].%s", perDiemCount, "LODGING".toLowerCase());
                message = this.getMessageFrom("message.document.tem.lodgingAlreadyClaimed", expenseDate);
                perDiemExpense.setLodging(KualiDecimal.ZERO);
                disabledPropertyMessages.add(new DisabledPropertyMessage(temp, message));
            }
        }
        return disabledPropertyMessages;
    }

    @Override
    public List<String> findMatchingTrips(TravelDocument travelDocument) {
        String travelDocumentIdentifier = travelDocument.getTravelDocumentIdentifier();
        Integer temProfileId = travelDocument.getTemProfileId();
        Timestamp earliestTripBeginDate = null;
        Timestamp greatestTripEndDate = null;
        List<TravelReimbursementDocument> documents = this.findReimbursementDocuments(travelDocumentIdentifier);
        for (TravelReimbursementDocument document : documents) {
            Timestamp tripBegin = document.getTripBegin();
            Timestamp tripEnd = document.getTripEnd();
            if (ObjectUtils.isNull(earliestTripBeginDate) && ObjectUtils.isNull(greatestTripEndDate)) {
                earliestTripBeginDate = tripBegin;
                greatestTripEndDate = tripEnd;
                continue;
            }
            earliestTripBeginDate = tripBegin.before(earliestTripBeginDate) ? tripBegin : earliestTripBeginDate;
            greatestTripEndDate = tripEnd.after(greatestTripEndDate) ? tripEnd : greatestTripEndDate;
        }
        if (documents.isEmpty() && ObjectUtils.isNotNull((Object)travelDocument.getTripBegin()) && ObjectUtils.isNotNull((Object)travelDocument.getTripEnd())) {
            earliestTripBeginDate = this.getTripBeginDate(travelDocument.getTripBegin());
            greatestTripEndDate = this.getTripEndDate(travelDocument.getTripEnd());
        }
        List matchDocs = (List)this.travelDocumentDao.findMatchingTrips(temProfileId, earliestTripBeginDate, greatestTripEndDate);
        ArrayList<String> documentIds = new ArrayList<String>();
        for (TravelReimbursementDocument document : matchDocs) {
            if (travelDocument.getDocumentNumber().equals(document.getDocumentNumber())) continue;
            documentIds.add(document.getDocumentNumber());
        }
        return documentIds;
    }

    private Integer getDuplicateTripDateRangeDays() {
        String tripDateRangeDays = this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "DUPLICATE_TRIP_DATE_RANGE_DAYS");
        Integer days = null;
        if (!StringUtils.isNumeric((String)tripDateRangeDays)) {
            days = TemConstants.DEFAULT_DUPLICATE_TRIP_DATE_RANGE_DAYS;
        }
        days = Integer.parseInt(tripDateRangeDays);
        return days;
    }

    private Timestamp getTripBeginDate(Timestamp tripBeginDate) {
        Timestamp tripBegin = null;
        Integer days = this.getDuplicateTripDateRangeDays();
        try {
            tripBegin = this.dateTimeService.convertToSqlTimestamp(this.dateTimeService.toDateString(DateUtils.addDays((Date)tripBeginDate, (int)(days * -1))));
        }
        catch (java.text.ParseException pe) {
            LOG.error((Object)("Exception while parsing trip begin date" + pe));
        }
        return tripBegin;
    }

    private Timestamp getTripEndDate(Timestamp tripEndDate) {
        Timestamp tripEnd = null;
        Integer days = this.getDuplicateTripDateRangeDays();
        try {
            tripEnd = this.dateTimeService.convertToSqlTimestamp(this.dateTimeService.toDateString(DateUtils.addDays((Date)tripEndDate, (int)days)));
        }
        catch (java.text.ParseException pe) {
            LOG.error((Object)("Exception while parsing trip end date" + pe));
        }
        return tripEnd;
    }

    @Override
    public TravelDocument getParentTravelDocument(String travelDocumentIdentifier) {
        if (ObjectUtils.isNull((Object)travelDocumentIdentifier) || StringUtils.equals((String)travelDocumentIdentifier, (String)"")) {
            LOG.error((Object)"Received a null tripId/travelDocumentIdentifier; returning a null TravelDocument");
            return null;
        }
        try {
            TravelDocument travelDocument = this.findRootForTravelReimbursement(travelDocumentIdentifier);
            if (ObjectUtils.isNotNull((Object)travelDocument)) {
                LOG.debug((Object)("Found " + travelDocument.getDocumentNumber() + " (" + travelDocument.getDocumentTypeName() + ") for travelDocumentIdentifier: " + travelDocumentIdentifier));
                return travelDocument;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("Exception occurred attempting to retrieve an authorization or remibursement travel document for travelDocumentIdentifier: " + travelDocumentIdentifier), (Throwable)exception);
            return null;
        }
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("travelDocumentIdentifier", travelDocumentIdentifier);
        fieldValues.put("tripProgenitor", Boolean.TRUE);
        Collection entDocuments = this.getBusinessObjectService().findMatching(TravelEntertainmentDocument.class, fieldValues);
        if (entDocuments.iterator().hasNext()) {
            TravelDocument ent = (TravelDocument)entDocuments.iterator().next();
            LOG.debug((Object)("Found " + ent.getDocumentNumber() + " (" + ent.getDocumentTypeName() + ") for travelDocumentIdentifier: " + travelDocumentIdentifier));
            return ent;
        }
        Collection reloDocuments = this.getBusinessObjectService().findMatching(TravelRelocationDocument.class, fieldValues);
        if (reloDocuments.iterator().hasNext()) {
            TravelDocument relo = (TravelDocument)reloDocuments.iterator().next();
            LOG.info((Object)("Found " + relo.getDocumentNumber() + " (" + relo.getDocumentTypeName() + ") for travelDocumentIdentifier: " + travelDocumentIdentifier));
            return relo;
        }
        LOG.error((Object)("Unable to find any travel document for given Trip Id: " + travelDocumentIdentifier));
        return null;
    }

    protected KualiDecimal getAccountingLineAmount(TravelDocument travelDoc) {
        KualiDecimal total = KualiDecimal.ZERO;
        if (travelDoc.getSourceAccountingLines() != null && !travelDoc.getSourceAccountingLines().isEmpty()) {
            for (TemSourceAccountingLine accountingLine : travelDoc.getSourceAccountingLines()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)accountingLine.getAmount());
            }
        }
        return total;
    }

    @Override
    public Collection<String> getApprovedTravelDocumentNumbersByTrip(String travelDocumentIdentifier) {
        HashMap<String, String> documentNumbersToReturn = new HashMap<String, String>();
        ArrayList<TravelDocument> travelDocuments = new ArrayList<TravelDocument>();
        TravelDocument travelDocument = this.getParentTravelDocument(travelDocumentIdentifier);
        if (ObjectUtils.isNotNull((Object)travelDocument)) {
            travelDocuments.add(travelDocument);
        }
        travelDocuments.addAll(this.getTravelDocumentDao().findDocuments(TravelReimbursementDocument.class, travelDocumentIdentifier));
        travelDocuments.addAll(this.getTravelDocumentDao().findDocuments(TravelEntertainmentDocument.class, travelDocumentIdentifier));
        travelDocuments.addAll(this.getTravelDocumentDao().findDocuments(TravelRelocationDocument.class, travelDocumentIdentifier));
        for (TravelDocument document : travelDocuments) {
            if (documentNumbersToReturn.containsKey(document.getDocumentNumber()) || !this.isDocumentStatusValidForReconcilingCharges(document)) continue;
            documentNumbersToReturn.put(document.getDocumentNumber(), document.getDocumentNumber());
        }
        return documentNumbersToReturn.values();
    }

    @Override
    public boolean isDocumentStatusValidForReconcilingCharges(TravelDocument travelDocument) {
        boolean vendorPaymentAllowedBeforeFinalReimbursement;
        boolean vendorPaymentAllowedBeforeFinalAuthorization;
        String documentNumber = travelDocument.getDocumentNumber();
        if (this.isDocumentApprovedOrExtracted(documentNumber)) {
            return true;
        }
        if (travelDocument instanceof TravelAuthorizationDocument && (vendorPaymentAllowedBeforeFinalAuthorization = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "VENDOR_PAYMENT_ALLOWED_BEFORE_FINAL_APPROVAL_IND").booleanValue())) {
            return this.isDocumentInitiatedOrEnroute(documentNumber);
        }
        if (travelDocument instanceof TravelReimbursementDocument && (vendorPaymentAllowedBeforeFinalReimbursement = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "VENDOR_PAYMENT_ALLOWED_BEFORE_FINAL_APPROVAL_IND").booleanValue())) {
            return this.isDocumentInitiatedOrEnroute(documentNumber);
        }
        return false;
    }

    @Override
    public void restorePerDiemProperty(TravelDocument document, String property) {
        try {
            String[] perDiemPropertyParts = this.splitPerDiemProperty(property);
            PerDiemExpense perDiemExpense = (PerDiemExpense)((Object)ObjectUtils.getPropertyValue((Object)document, (String)perDiemPropertyParts[0]));
            String mealName = perDiemPropertyParts[1];
            boolean mealProperty = this.isMealProperty(mealName);
            String mealSuffix = mealProperty ? "Value" : "";
            String mealValueName = mealName + mealSuffix;
            KualiDecimal currentMealValue = (KualiDecimal)ObjectUtils.getPropertyValue((Object)((Object)perDiemExpense), (String)mealValueName);
            if (currentMealValue != null && currentMealValue.equals((Object)KualiDecimal.ZERO)) {
                boolean prorated;
                PerDiem perDiem = this.getPerDiemService().getPerDiem(perDiemExpense.getPrimaryDestinationId(), perDiemExpense.getMileageDate(), document.getEffectiveDateForPerDiem(perDiemExpense));
                KualiDecimal mealAmount = (KualiDecimal)ObjectUtils.getPropertyValue((Object)((Object)perDiem), (String)mealName);
                boolean bl = prorated = mealProperty && !KfsDateUtils.isSameDay((Date)document.getTripBegin(), (Date)document.getTripEnd()) && (KfsDateUtils.isSameDay((Date)perDiemExpense.getMileageDate(), (Date)document.getTripBegin()) || KfsDateUtils.isSameDay((Date)perDiemExpense.getMileageDate(), (Date)document.getTripEnd()));
                if (prorated && !ObjectUtils.isNull((Object)((Object)document.getTripType()))) {
                    perDiemExpense.setProrated(true);
                    String perDiemCalcMethod = document.getTripType().getPerDiemCalcMethod();
                    Integer perDiemPercent = this.calculateProratePercentage(perDiemExpense, perDiemCalcMethod, document.getTripEnd());
                    KualiDecimal proratedAmount = PerDiemExpense.calculateMealsAndIncidentalsProrated(mealAmount, perDiemPercent);
                    ObjectUtils.setObjectProperty((Object)((Object)perDiemExpense), (String)mealValueName, (Object)proratedAmount);
                } else {
                    ObjectUtils.setObjectProperty((Object)((Object)perDiemExpense), (String)mealValueName, (Object)mealAmount);
                }
                if (mealProperty) {
                    ObjectUtils.setObjectProperty((Object)((Object)perDiemExpense), (String)mealName, (Object)Boolean.TRUE);
                }
            }
        }
        catch (FormatException fe) {
            throw new RuntimeException("Could not set meal value on per diem expense", fe);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Could not set meal value on per diem expense", iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Could not set meal value on per diem expense", ite);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("Could not set meal value on per diem expense", nsme);
        }
    }

    protected boolean isMealProperty(String property) {
        return StringUtils.equals((String)property, (String)"breakfast") || StringUtils.equals((String)property, (String)"lunch") || StringUtils.equals((String)property, (String)"dinner") || StringUtils.equals((String)property, (String)"incidentals");
    }

    protected String[] splitPerDiemProperty(String property) {
        String deDocumentedProperty = property.replace("document.", "");
        int lastDivider = deDocumentedProperty.lastIndexOf(46);
        String perDiemPart = deDocumentedProperty.substring(0, lastDivider);
        String mealPart = deDocumentedProperty.substring(lastDivider + 1);
        return new String[]{perDiemPart, mealPart};
    }

    @Override
    public TravelDocument getRootTravelDocumentWithoutWorkflowDocument(String travelDocumentIdentifier) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("travelDocumentIdentifier", travelDocumentIdentifier);
        fieldValues.put("tripProgenitor", new Boolean(true));
        for (String documentType : this.getTravelDocumentTypesToCheck()) {
            Class<? extends TravelDocument> docClazz = this.getTravelDocumentForType(documentType);
            Collection matchingDocs = this.getBusinessObjectService().findMatching(docClazz, fieldValues);
            if (matchingDocs == null || matchingDocs.isEmpty()) continue;
            ArrayList foundDocs = new ArrayList();
            foundDocs.addAll(matchingDocs);
            return (TravelDocument)foundDocs.get(0);
        }
        return null;
    }

    protected List<String> getTravelDocumentTypesToCheck() {
        ArrayList<String> documentTypes = new ArrayList<String>();
        documentTypes.add("TA");
        documentTypes.add("ENT");
        documentTypes.add("RELO");
        documentTypes.add("TR");
        return documentTypes;
    }

    protected Class<? extends TravelDocument> getTravelDocumentForType(String documentType) {
        return this.getDataDictionaryService().getDocumentClassByTypeName(documentType);
    }

    @Override
    public List<TemSourceAccountingLine> smooshAccountingLinesToSubAccount(List<TemSourceAccountingLine> originalAccountingLines) {
        Map<SmooshLineKey, KualiDecimal> smooshLines = this.smooshLinesToMap(originalAccountingLines);
        List<TemSourceAccountingLine> unsmooshedLines = this.raiseMapToLines(smooshLines);
        return unsmooshedLines;
    }

    protected Map<SmooshLineKey, KualiDecimal> smooshLinesToMap(List<TemSourceAccountingLine> accountingLines) {
        HashMap<SmooshLineKey, KualiDecimal> smooshLines = new HashMap<SmooshLineKey, KualiDecimal>();
        for (TemSourceAccountingLine line : accountingLines) {
            SmooshLineKey key = new SmooshLineKey(line);
            if (smooshLines.containsKey(key)) {
                KualiDecimal currAmount = (KualiDecimal)smooshLines.get(key);
                KualiDecimal newAmount = (KualiDecimal)currAmount.add((AbstractKualiDecimal)line.getAmount());
                smooshLines.put(key, newAmount);
                continue;
            }
            smooshLines.put(key, line.getAmount());
        }
        return smooshLines;
    }

    protected List<TemSourceAccountingLine> raiseMapToLines(Map<SmooshLineKey, KualiDecimal> smooshLineMap) {
        ArrayList<TemSourceAccountingLine> raisedLines = new ArrayList<TemSourceAccountingLine>();
        for (SmooshLineKey key : smooshLineMap.keySet()) {
            TemSourceAccountingLine line = this.convertKeyAndAmountToLine(key, smooshLineMap.get(key));
            raisedLines.add(line);
        }
        return raisedLines;
    }

    protected TemSourceAccountingLine convertKeyAndAmountToLine(SmooshLineKey key, KualiDecimal amount) {
        TemSourceAccountingLine line = new TemSourceAccountingLine();
        line.setChartOfAccountsCode(key.getChartOfAccountsCode());
        line.setAccountNumber(key.getAccountNumber());
        line.setSubAccountNumber(key.getSubAccountNumber());
        line.setAmount(amount);
        return line;
    }

    @Override
    public List<LinkField> getAgencyLinks(TravelDocument travelDocument) {
        ArrayList<LinkField> agencyLinks = new ArrayList<LinkField>();
        if (this.getConfigurationService().getPropertyValueAsBoolean("config.document.travelRelocation.agencySites.enable")) {
            String agencySitesURL = this.getConfigurationService().getPropertyValueAsString("url.document.travelRelocation.agencySites");
            String target = "_blank";
            if (!StringUtils.isEmpty((String)agencySitesURL)) {
                String[] sites;
                for (String site : sites = agencySitesURL.split(";")) {
                    String[] siteInfo = site.split("=");
                    String url = this.customizeAgencyLink(travelDocument, siteInfo[0], siteInfo[1]);
                    String prefixedUrl = this.prefixUrl(url);
                    LinkField link = new LinkField();
                    link.setHrefText(prefixedUrl);
                    link.setTarget("_blank");
                    link.setLinkLabel(siteInfo[0]);
                    agencyLinks.add(link);
                }
            }
        }
        return agencyLinks;
    }

    @Override
    public String customizeAgencyLink(TravelDocument travelDocument, String agencyName, String link) {
        boolean vendorPaymentAllowedBeforeFinal;
        boolean passTrip = this.getConfigurationService().getPropertyValueAsBoolean("config.document.travelRelocation.agencySites.include.tripId");
        if (!passTrip || StringUtils.isBlank((String)travelDocument.getTravelDocumentIdentifier())) {
            return link;
        }
        if (travelDocument instanceof TravelAuthorizationDocument && !(vendorPaymentAllowedBeforeFinal = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "VENDOR_PAYMENT_ALLOWED_BEFORE_FINAL_APPROVAL_IND").booleanValue())) {
            return link;
        }
        String linkWithTripId = link + "?tripId=" + travelDocument.getTravelDocumentIdentifier();
        return linkWithTripId;
    }

    protected String prefixUrl(String url) {
        String prefixedUrl = url;
        if (!prefixedUrl.startsWith("http")) {
            prefixedUrl = "https://" + prefixedUrl;
        }
        return prefixedUrl;
    }

    @Override
    public boolean isInitiatorTraveler(TravelDocument travelDoc) {
        String initiatorId = travelDoc.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        String travelerId = travelDoc.getTraveler().getPrincipalId();
        boolean is = travelerId != null && initiatorId.equals(travelerId);
        return is;
    }

    @Override
    public boolean requiresTravelerApproval(TravelAuthorizationDocument taDoc) {
        boolean require = taDoc.requiresTravelAdvanceReviewRouting();
        return require &= !taDoc.getTravelAdvance().getTravelAdvancePolicy();
    }

    @Override
    public boolean requiresTravelerApproval(TEMReimbursementDocument trDoc) {
        String travelerTypeCode = trDoc.getTraveler().getTravelerTypeCode();
        if (this.parameterService.getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "NON_EMPLOYEE_TRAVELER_TYPE_CODES").contains(travelerTypeCode)) {
            return false;
        }
        return !this.isInitiatorTraveler(trDoc);
    }

    public AccountsReceivableModuleService getAccountsReceivableModuleService() {
        if (this.accountsReceivableModuleService == null) {
            this.accountsReceivableModuleService = (AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class);
        }
        return this.accountsReceivableModuleService;
    }

    public TravelAuthorizationService getTravelAuthorizationService() {
        return this.travelAuthorizationService;
    }

    public void setTravelAuthorizationService(TravelAuthorizationService travelAuthorizationService) {
        this.travelAuthorizationService = travelAuthorizationService;
    }

    public PerDiemService getPerDiemService() {
        return this.perDiemService;
    }

    public void setPerDiemService(PerDiemService perDiemService) {
        this.perDiemService = perDiemService;
    }

    public List<String> getGroupTravelerColumns() {
        return this.groupTravelerColumns;
    }

    public void setGroupTravelerColumns(List<String> groupTravelerColumns) {
        this.groupTravelerColumns = groupTravelerColumns;
    }

    public TravelExpenseService getTravelExpenseService() {
        return this.travelExpenseService;
    }

    public void setTravelExpenseService(TravelExpenseService travelExpenseService) {
        this.travelExpenseService = travelExpenseService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public TravelService getTravelService() {
        return this.travelService;
    }

    public void setTravelService(TravelService travelService) {
        this.travelService = travelService;
    }

    public MileageRateService getMileageRateService() {
        return this.mileageRateService;
    }

    public void setMileageRateService(MileageRateService mileageRateService) {
        this.mileageRateService = mileageRateService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setTravelDocumentDao(TravelDocumentDao travelDocumentDao) {
        this.travelDocumentDao = travelDocumentDao;
    }

    protected TravelDocumentDao getTravelDocumentDao() {
        return this.travelDocumentDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AccountingDocumentRelationshipService getAccountingDocumentRelationshipService() {
        return this.accountingDocumentRelationshipService;
    }

    public void setAccountingDocumentRelationshipService(AccountingDocumentRelationshipService accountingDocumentRelationshipService) {
        this.accountingDocumentRelationshipService = accountingDocumentRelationshipService;
    }

    public TemRoleService getTemRoleService() {
        return this.temRoleService;
    }

    public void setTemRoleService(TemRoleService temRoleService) {
        this.temRoleService = temRoleService;
    }

    protected ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public StateService getStateService() {
        return this.stateService;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public List<String> getDefaultAcceptableFileExtensions() {
        return this.defaultAcceptableFileExtensions;
    }

    public void setDefaultAcceptableFileExtensions(List<String> defaultAcceptableFileExtensions) {
        this.defaultAcceptableFileExtensions = defaultAcceptableFileExtensions;
    }

    public void setCsvRecordFactory(CsvRecordFactory<GroupTravelerCsvRecord> recordFactory) {
        this.csvRecordFactory = recordFactory;
    }

    public CsvRecordFactory<GroupTravelerCsvRecord> getCsvRecordFactory() {
        return this.csvRecordFactory;
    }

    protected class SmooshLineKey {
        protected String chartOfAccountsCode;
        protected String accountNumber;
        protected String subAccountNumber;

        public SmooshLineKey(TemSourceAccountingLine accountingLine) {
            this.chartOfAccountsCode = accountingLine.getChartOfAccountsCode();
            this.accountNumber = accountingLine.getAccountNumber();
            this.subAccountNumber = accountingLine.getSubAccountNumber();
        }

        public String getChartOfAccountsCode() {
            return this.chartOfAccountsCode;
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public String getSubAccountNumber() {
            return this.subAccountNumber;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.getChartOfAccountsCode());
            hcb.append((Object)this.getAccountNumber());
            hcb.append((Object)this.getSubAccountNumber());
            return hcb.toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SmooshLineKey) || obj == null) {
                return false;
            }
            SmooshLineKey golyadkin = (SmooshLineKey)obj;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)this.getChartOfAccountsCode(), (Object)golyadkin.getChartOfAccountsCode());
            eb.append((Object)this.getAccountNumber(), (Object)golyadkin.getAccountNumber());
            eb.append((Object)this.getSubAccountNumber(), (Object)golyadkin.getSubAccountNumber());
            return eb.isEquals();
        }
    }

    class DisabledPropertyMessage {
        private String key;
        private String message;

        DisabledPropertyMessage(String key, String message) {
            this.key = key;
            this.message = message;
        }

        void addToProperties(Map<String, String> messageMap) {
            messageMap.put(this.key, this.message);
        }
    }
}

