/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTravelerService;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.document.service.AgencyStagingDataRuleHelper;

public class AgencyStagingDataRuleByTraveler
implements AgencyStagingDataRuleHelper {
    public static final String MAINTAINABLE_ERROR_PREFIX = "document.newMaintainableObject.";
    public static final String ADD_LINE_ERROR_PREFIX = "add.";
    protected ExpenseImportByTravelerService expenseImportByTravelerService;

    @Override
    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = this.processCustomDocumentBusinessRules(document);
        return true;
    }

    @Override
    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.processCustomDocumentBusinessRules(document);
    }

    @Override
    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    @Override
    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        boolean result = true;
        if (collectionName.equals("tripAccountingInformation")) {
            TripAccountingInformation accountingLine = (TripAccountingInformation)line;
            Map<String, ErrorMessage> errorMap = this.getExpenseImportByTravelerService().validateAccountingInfoLine(accountingLine);
            if (!errorMap.isEmpty()) {
                for (String errorProperty : errorMap.keySet()) {
                    ErrorMessage error = errorMap.get(errorProperty);
                    if (!ObjectUtils.isNotNull((Object)error)) continue;
                    this.putFieldError("add.tripAccountingInformation." + errorProperty, error.getErrorKey(), error.getMessageParameters());
                }
                result &= false;
            }
        }
        return result;
    }

    public ExpenseImportByTravelerService getExpenseImportByTravelerService() {
        return this.expenseImportByTravelerService;
    }

    public void setExpenseImportByTravelerService(ExpenseImportByTravelerService expenseImportByTravelerService) {
        this.expenseImportByTravelerService = expenseImportByTravelerService;
    }

    protected void putFieldError(String propertyName, String errorConstant, String ... errorParameters) {
        if (!this.errorAlreadyExists(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant, errorParameters);
        }
    }

    protected boolean errorAlreadyExists(String propertyName, String errorConstant) {
        return GlobalVariables.getMessageMap().fieldHasMessage(propertyName, errorConstant);
    }

    protected boolean processCustomDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = true;
        AgencyStagingData data = (AgencyStagingData)document.getNewMaintainableObject().getBusinessObject();
        if (data.isActive()) {
            List<ErrorMessage> errorMessages = this.getExpenseImportByTravelerService().validateMandatoryFieldsPresent(data);
            if (!errorMessages.isEmpty()) {
                result &= false;
            }
            if (!(errorMessages = this.getExpenseImportByTravelerService().validateTraveler(data)).isEmpty()) {
                this.putFieldError("travelerId", "message.batch.tem.agencyDataInvalidTraveler", data.getTravelerId());
                result &= false;
            }
            int i = 0;
            for (TripAccountingInformation account : data.getTripAccountingInformation()) {
                Map<String, ErrorMessage> errorMap = this.getExpenseImportByTravelerService().validateAccountingInfoLine(account);
                if (!errorMap.isEmpty()) {
                    for (String errorProperty : errorMap.keySet()) {
                        ErrorMessage error = errorMap.get(errorProperty);
                        if (!ObjectUtils.isNotNull((Object)error)) continue;
                        this.putFieldError("tripAccountingInformation[" + i + "]." + errorProperty, error.getErrorKey(), error.getMessageParameters());
                        result &= false;
                    }
                }
                ++i;
            }
            if (this.getExpenseImportByTravelerService().isTripDataMissing(data)) {
                this.putFieldError("lodgingItineraryNumber", "message.batch.tem.agencyDataMissingTripData", new String[0]);
                result &= false;
            }
            if (result && !(errorMessages = this.getExpenseImportByTravelerService().validateDuplicateData(data)).isEmpty()) {
                if (this.isErrorListContainsErrorKey(errorMessages, "message.batch.tem.agencyDataMandatoryFields") || this.isErrorListContainsErrorKey(errorMessages, "message.batch.tem.agencyDataAirLodgingRentalMissing")) {
                    result &= false;
                } else {
                    this.putFieldError("travelerId", "message.batch.tem.agencyData.traveler.DuplicateRecord", data.getTravelerId(), data.getItineraryDataString(), data.getCreditCardOrAgencyCode(), data.getTransactionPostingDate().toString(), data.getTripExpenseAmount().toString(), data.getTripInvoiceNumber());
                    result &= false;
                }
            }
        }
        return result;
    }

    protected boolean isErrorListContainsErrorKey(List<ErrorMessage> errors, String errorKey) {
        for (ErrorMessage error : errors) {
            if (!error.getErrorKey().equals(errorKey)) continue;
            return true;
        }
        return false;
    }
}

