/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.businessobject.TravelCompanyCode;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.AbstractExpense;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.bean.AccountingLineDistributionKey;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.UpdateAccountingLineEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;

public class TemAccountingLineAllowedObjectCodeValidation
extends GenericValidation {
    protected TravelDocumentService travelDocumentService;
    protected AccountingDistributionService accountingDistributionService;
    protected ParameterService parameterService;
    protected BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        TemSourceAccountingLine line = null;
        line = event instanceof UpdateAccountingLineEvent ? (TemSourceAccountingLine)((UpdateAccountingLineEvent)event).getUpdatedAccountingLine() : (TemSourceAccountingLine)((AccountingLineEvent)event).getAccountingLine();
        ArrayList holdErrors = new ArrayList();
        holdErrors.addAll(GlobalVariables.getMessageMap().getErrorPath());
        GlobalVariables.getMessageMap().clearErrorPath();
        TravelDocument travelDocument = (TravelDocument)event.getDocument();
        boolean canUpdate = this.isAtTravelNode(event.getDocument().getDocumentHeader().getWorkflowDocument()) || this.isAdvancePaymentMethodException(event.getDocument(), line);
        boolean valid = true;
        String errorPath = "newSourceLine";
        for (TemSourceAccountingLine sourceLine : travelDocument.getSourceAccountingLines()) {
            if (!line.equals(sourceLine)) continue;
            errorPath = "document.sourceAccountingLine[" + travelDocument.getSourceAccountingLines().indexOf(line) + "]";
            break;
        }
        valid = this.getTravelDocumentService().validateSourceAccountingLines(travelDocument, false);
        if (!(travelDocument.getAppDocStatus().equalsIgnoreCase("Initiated") || travelDocument.getAppDocStatus().equalsIgnoreCase("In Process") || travelDocument.getAppDocStatus().equalsIgnoreCase("Change In Process") || line.getAccount().getAccountFiscalOfficerUser().getPrincipalId().equals(currentUser.getPrincipalId()) || canUpdate)) {
            GlobalVariables.getMessageMap().putError("accountNumber", "error.document.fiscalofficer.account", new String[]{line.getAccountNumber()});
            return false;
        }
        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
        if (!(event.getDocument() instanceof TravelAuthorizationDocument) && ObjectUtils.isNotNull((Object)line.getObjectTypeCode())) {
            List<AccountingDistribution> list = this.getAccountingDistributionService().buildDistributionFrom(travelDocument);
            ArrayList<AccountingLineDistributionKey> distributionList = new ArrayList<AccountingLineDistributionKey>();
            ArrayList<String> expectedObjectCodes = new ArrayList<String>();
            for (AccountingDistribution accountingDistribution : list) {
                distributionList.add(new AccountingLineDistributionKey(accountingDistribution.getObjectCode(), accountingDistribution.getCardType()));
                expectedObjectCodes.add(accountingDistribution.getObjectCode());
            }
            String expectedObjectCodesString = StringUtils.join(expectedObjectCodes, (String)", ");
            if (!distributionList.contains(new AccountingLineDistributionKey(line.getFinancialObjectCode(), line.getCardType()))) {
                GlobalVariables.getMessageMap().putError("financialObjectCode", "error.tem.accountingline.objectcode", new String[]{line.getFinancialObjectCode(), line.getCardType(), expectedObjectCodesString});
                valid &= false;
            }
        }
        if (line.getAmount().isLessEqual((AbstractKualiDecimal)KualiDecimal.ZERO) && !travelDocument.getBlanketTravel().booleanValue()) {
            GlobalVariables.getMessageMap().putError("amount", "error.custom", new String[]{"Amount must be greater than zero."});
            valid &= false;
        }
        if (valid) {
            TravelDocument document = (TravelDocument)event.getDocument();
            ArrayList<AbstractExpense> allExpenses = new ArrayList<AbstractExpense>();
            allExpenses.addAll(document.getImportedExpenses());
            allExpenses.addAll(document.getActualExpenses());
            if (allExpenses.size() > 0) {
                boolean bl;
                boolean hasAttachment = false;
                boolean showFlyAmerica = false;
                for (Object note : document.getNotes()) {
                    if (note.getAttachment() == null) continue;
                    hasAttachment = true;
                    break;
                }
                if (bl = this.getParameterService().getParameterValueAsBoolean("KFS-COA", "Account", "FUND_GROUP_DENOTES_CG_IND").booleanValue()) {
                    for (TemExpense temExpense : allExpenses) {
                        String financialObjectCode;
                        if (!temExpense.getExpenseTypeCode().equals("A")) continue;
                        HashMap<String, String> fieldValues = new HashMap<String, String>();
                        fieldValues.put("code", "A");
                        fieldValues.put("name", temExpense.getTravelCompanyCodeName());
                        TravelCompanyCode travelCompany = (TravelCompanyCode)this.getBusinessObjectService().findByPrimaryKey(TravelCompanyCode.class, fieldValues);
                        if (travelCompany == null || !travelCompany.isForeignCompany()) continue;
                        String string = financialObjectCode = temExpense.getExpenseTypeObjectCode() != null ? temExpense.getExpenseTypeObjectCode().getFinancialObjectCode() : null;
                        if (travelDocument instanceof TravelAuthorizationDocument && temExpense instanceof ActualExpense && document.getTripType() != null) {
                            financialObjectCode = document.getTripType().getEncumbranceObjCode();
                        }
                        if (financialObjectCode == null || !financialObjectCode.equals(line.getFinancialObjectCode())) continue;
                        String cg = this.getParameterService().getParameterValueAsString("KFS-COA", "Account", "CG_DENOTING_VALUE");
                        if (line.getAccount() == null) {
                            line.refreshReferenceObject("account");
                        }
                        if (line.getAccount().getSubFundGroup() == null) {
                            line.refreshReferenceObject("subFundGroup");
                        }
                        if (!line.getAccount().getSubFundGroup().getFundGroupCode().equals(cg)) continue;
                        showFlyAmerica = true;
                    }
                }
                if (showFlyAmerica && !hasAttachment) {
                    boolean newLine = true;
                    for (TemSourceAccountingLine sourceLine : travelDocument.getSourceAccountingLines()) {
                        if (!line.equals(sourceLine)) continue;
                        newLine = false;
                    }
                    if (newLine) {
                        GlobalVariables.getMessageMap().clearErrorPath();
                        int n = document.getSourceAccountingLine(document.getSourceAccountingLines().size() - 1).getSequenceNumber() + 1;
                        errorPath = "document.sourceAccountingLine[" + n + "]";
                        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                    }
                    GlobalVariables.getMessageMap().putError("accountNumber", "error.tem.accountingline.cg.accountnumber", new String[0]);
                }
            }
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().getErrorPath().addAll(holdErrors);
        return valid;
    }

    protected boolean isAtTravelNode(WorkflowDocument workflowDocument) {
        Set nodeNames = workflowDocument.getNodeNames();
        for (String nodeNamesNode : nodeNames) {
            if (!"Travel".equals(nodeNamesNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAdvancePaymentMethodException(Document document, TemSourceAccountingLine accountingLine) {
        return StringUtils.equals((String)"A", (String)accountingLine.getFinancialDocumentLineTypeCode()) && document.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames().contains("PaymentMethod");
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public AccountingDistributionService getAccountingDistributionService() {
        return this.accountingDistributionService;
    }

    public void setAccountingDistributionService(AccountingDistributionService accountingDistributionService) {
        this.accountingDistributionService = accountingDistributionService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

