/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelAccommodationInfoRequiredValidation
extends GenericValidation {
    protected ParameterService parameterService;

    public boolean validate(AttributedDocumentEvent event) {
        TravelDocument document = (TravelDocument)event.getDocument();
        document.refreshReferenceObject("tripType");
        TripType tripType = document.getTripType();
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("perDiemExpenses");
        boolean internationalAccommodationInfoRequired = this.getParameterService().getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "INTERNATIONAL_TRIP_REQUIRES_ACCOMMODATION_IND");
        if (tripType != null && this.isInternationalTrip(tripType) && internationalAccommodationInfoRequired) {
            for (PerDiemExpense detail : document.getPerDiemExpenses()) {
                detail.refreshReferenceObject("accommodationType");
                if (ObjectUtils.isNull((Object)((Object)detail.getAccommodationType())) || StringUtils.isBlank((String)detail.getAccommodationTypeCode())) {
                    GlobalVariables.getMessageMap().putError("accommodationTypeCode", "error.required", new String[]{"Accommodation Type"});
                    valid &= false;
                }
                if (StringUtils.isBlank((String)detail.getAccommodationName())) {
                    GlobalVariables.getMessageMap().putError("accommodationName", "error.required", new String[]{"Accommodation Name"});
                    valid &= false;
                }
                if (!StringUtils.isBlank((String)detail.getAccommodationAddress())) continue;
                GlobalVariables.getMessageMap().putError("accommodationAddress", "error.required", new String[]{"Accommodation Address"});
                valid &= false;
            }
        }
        if (!valid) {
            GlobalVariables.getMessageMap().putError("accommodationTypeCode", "error.required", new String[]{"Accommodation Type"});
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("perDiemExpenses");
        return valid;
    }

    protected boolean isInternationalTrip(TripType tripType) {
        Collection internationalTripTypes = this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "INTERNATIONAL_TRIP_TYPES");
        return internationalTripTypes.contains(tripType.getCode());
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

