/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelAuthBlanketTripTypeValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        boolean rulePassed = true;
        TravelAuthorizationDocument taDocument = (TravelAuthorizationDocument)event.getDocument();
        if (!ObjectUtils.isNull((Object)((Object)taDocument.getTripType()))) {
            if (taDocument.isBlanketTravel().booleanValue()) {
                if (!ObjectUtils.isNull(taDocument.getPerDiemExpenses()) && !taDocument.getPerDiemExpenses().isEmpty()) {
                    GlobalVariables.getMessageMap().putError("perDiemExpenses", "error.document.tem.blanketTypeNoEstimate", new String[0]);
                    taDocument.logErrors();
                    rulePassed = false;
                }
                if (!ObjectUtils.isNull(taDocument.getActualExpenses()) && !taDocument.getActualExpenses().isEmpty()) {
                    GlobalVariables.getMessageMap().putError("newActualExpenseLine", "error.document.tem.blanketTypeNoExpenses", new String[0]);
                    taDocument.logErrors();
                    rulePassed = false;
                }
                if (!taDocument.getTripType().isBlanketTravel()) {
                    rulePassed = false;
                    GlobalVariables.getMessageMap().putError("document.tripTypeCode", "error.document.tem.tripTypeNotBlanket", new String[0]);
                }
            }
            if ((taDocument.isBlanketTravel().booleanValue() || this.isNonEncumbranceTrip(taDocument)) && (StringUtils.isBlank((String)taDocument.getTemProfile().getDefaultChartCode()) || StringUtils.isBlank((String)taDocument.getTemProfile().getDefaultAccount()))) {
                rulePassed = false;
                String basePropertyName = taDocument.isBlanketTravel() != false ? "blanketTravel" : "tripTypeCode";
                GlobalVariables.getMessageMap().putError(basePropertyName, "error.document.tem.profileNotCompleteForBlanketTravel", new String[0]);
            }
        }
        return rulePassed;
    }

    protected boolean isNonEncumbranceTrip(TravelAuthorizationDocument travelAuth) {
        return !(travelAuth.getTripType().isGenerateEncumbrance() && !travelAuth.hasOnlyPrepaidExpenses() || travelAuth.getSourceAccountingLines() != null && !travelAuth.getSourceAccountingLines().isEmpty());
    }
}

