/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TravelAuthEstimateDetailNonNegativeValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        KualiDecimal perDiemAdjustment;
        TravelAuthorizationDocument doc = (TravelAuthorizationDocument)event.getDocument();
        List<PerDiemExpense> estimates = doc.getPerDiemExpenses();
        boolean valid = true;
        for (int i = 0; i < estimates.size(); ++i) {
            Integer miles;
            KualiDecimal lodging;
            PerDiemExpense estimate = estimates.get(i);
            if (estimate.getLodging() != null && (lodging = estimate.getLodging()).isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                GlobalVariables.getMessageMap().putError("document.perDiemExpenses[" + i + "].lodging", "error.negativeAmount", new String[]{"Lodging"});
                valid = false;
            }
            if (estimate.getMiles() == null || (miles = estimate.getMiles()) >= 0) continue;
            GlobalVariables.getMessageMap().putError("document.perDiemExpenses[" + i + "].miles", "error.negativeAmount", new String[]{"Miles"});
            valid = false;
        }
        if (doc.getPerDiemAdjustment() != null && (perDiemAdjustment = doc.getPerDiemAdjustment()).isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            GlobalVariables.getMessageMap().putError("document.perDiemAdjustment", "error.negativeAmount", new String[]{"Manual Per Diem Adjustment"});
            valid = false;
        }
        return valid;
    }
}

