/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.document.TaxableRamificationDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.TaxableRamificationForm;
import org.kuali.kfs.sys.DynamicCollectionComparator;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class TaxableRamificationAction
extends FinancialSystemTransactionalDocumentActionBase {
    private static final Logger LOG = Logger.getLogger(TaxableRamificationAction.class);

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        TaxableRamificationForm taxRamificationForm = (TaxableRamificationForm)kualiDocumentFormBase;
        this.refreshRelatedDocuments(taxRamificationForm);
        this.refreshRelatedDocumentNotes(taxRamificationForm);
    }

    protected void refreshRelatedDocuments(TaxableRamificationForm taxRamificationForm) {
        Map<String, List<Document>> relatedDocuments = taxRamificationForm.getRelatedDocuments();
        if (ObjectUtils.isNotNull(relatedDocuments) && !relatedDocuments.isEmpty()) {
            return;
        }
        try {
            TaxableRamificationDocument taxRamificationDocument = taxRamificationForm.getTaxableRamificationDocument();
            TravelAdvance travelAdvance = taxRamificationDocument.getTravelAdvance();
            if (ObjectUtils.isNotNull((Object)((Object)travelAdvance))) {
                String travelDocumentNumber = travelAdvance.getDocumentNumber();
                relatedDocuments = this.getTravelDocumentService().getDocumentsRelatedTo(travelDocumentNumber);
                this.addTravelAuthorizationDocumentToRelated(relatedDocuments, travelAdvance);
                taxRamificationForm.setRelatedDocuments(relatedDocuments);
            }
        }
        catch (WorkflowException ex) {
            LOG.error((Object)("Failed to get related documents" + (Object)((Object)ex)));
            throw new RuntimeException("Failed to get related documents", ex);
        }
    }

    protected void addTravelAuthorizationDocumentToRelated(Map<String, List<Document>> relatedDocuments, TravelAdvance travelAdvance) throws WorkflowException {
        String travelDocumentNumber = travelAdvance.getDocumentNumber();
        Document travelAuthorizationDocument = ((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(travelDocumentNumber);
        String docTypeName = this.getDataDictionaryService().getDocumentTypeNameByClass(TravelAuthorizationDocument.class);
        List<Document> documents = relatedDocuments.get(docTypeName);
        if (documents == null) {
            documents = new ArrayList<Document>();
        }
        documents.add(travelAuthorizationDocument);
        relatedDocuments.put(docTypeName, documents);
    }

    protected void refreshRelatedDocumentNotes(TaxableRamificationForm taxRamificationForm) {
        Map<String, List<Document>> relatedDocuments = taxRamificationForm.getRelatedDocuments();
        if (ObjectUtils.isNull(relatedDocuments) || relatedDocuments.isEmpty()) {
            return;
        }
        Map<String, List<Note>> relatedDocumentNotes = taxRamificationForm.getRelatedDocumentNotes();
        if (ObjectUtils.isNotNull(relatedDocumentNotes) && !relatedDocumentNotes.isEmpty()) {
            return;
        }
        relatedDocumentNotes = new HashMap<String, List<Note>>();
        for (List<Document> documents : relatedDocuments.values()) {
            for (Document document : documents) {
                List listOfNotes = ((NoteService)SpringContext.getBean(NoteService.class)).getByRemoteObjectId(document.getDocumentHeader().getObjectId());
                DynamicCollectionComparator.sort((List)listOfNotes, (DynamicCollectionComparator.SortOrder)DynamicCollectionComparator.SortOrder.DESC, (String[])new String[]{"noteIdentifier"});
                relatedDocumentNotes.put(document.getDocumentNumber(), listOfNotes);
            }
        }
        taxRamificationForm.setRelatedDocumentNotes(relatedDocumentNotes);
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }
}

