/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.exception.AuthorizationException;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.document.CardApplicationDocument;
import org.kuali.kfs.module.tem.document.TemCorporateCardApplicationDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.TemCardApplicationForm;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;

public class TemCardApplicationAction
extends FinancialSystemTransactionalDocumentActionBase {
    private static final String CTS_ACTION = "temCTSCardApplication.do";
    private static final String CORP_ACTION = "temCorporateCardApplication.do";
    private static final String QUESTION_FORWARD = "cardQuestion";
    private static final String ERROR_FORWARD = "cardApplicationError";

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.docHandler(mapping, form, request, response);
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        TemCardApplicationForm applicationForm = (TemCardApplicationForm)form;
        String command = applicationForm.getCommand();
        if (StringUtils.equals((String)"initiate", (String)command)) {
            TemProfile profile = ((TemProfileService)SpringContext.getBean(TemProfileService.class)).findTemProfileByPrincipalId(currentUser.getPrincipalId());
            if (profile == null) {
                applicationForm.setEmptyProfile(true);
                forward = mapping.findForward(ERROR_FORWARD);
            } else if (StringUtils.isEmpty((String)profile.getDefaultAccount())) {
                applicationForm.setEmptyAccount(true);
                forward = mapping.findForward(ERROR_FORWARD);
            }
        }
        return forward;
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemCardApplicationForm applicationForm = (TemCardApplicationForm)form;
        CardApplicationDocument document = (CardApplicationDocument)applicationForm.getDocument();
        if (document.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus().equals("Fiscal Officer Review") && document instanceof TemCorporateCardApplicationDocument && !((TemCorporateCardApplicationDocument)document).isDepartmentHeadAgreement()) {
            GlobalVariables.getMessageMap().putError("departmentHeadAgreement", "error.tem.card.application.agreement.not.checked", new String[]{"Department Head"});
        }
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        if (((TravelDocumentService)SpringContext.getBean(TravelDocumentService.class)).isTravelManager(currentUser) && document.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus().equals("Applied To Bank")) {
            document.sendAcknowledgement();
            document.approvedByBank();
            document.getDocumentHeader().getWorkflowDocument().setApplicationDocumentStatus("Approved By Bank");
            document.saveAppDocStatus();
            DocumentAttributeIndexingQueue documentAttributeIndexingQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
            documentAttributeIndexingQueue.indexDocument(document.getDocumentHeader().getDocumentNumber());
        }
        return super.approve(mapping, form, request, response);
    }

    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemCardApplicationForm applicationForm = (TemCardApplicationForm)form;
        CardApplicationDocument document = (CardApplicationDocument)applicationForm.getDocument();
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        if (((TravelDocumentService)SpringContext.getBean(TravelDocumentService.class)).isTravelManager(currentUser) && document.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus().equals("Applied To Bank")) {
            document.sendAcknowledgement();
        }
        return super.disapprove(mapping, form, request, response);
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemCardApplicationForm applicationForm = (TemCardApplicationForm)form;
        CardApplicationDocument document = (CardApplicationDocument)applicationForm.getDocument();
        if (applicationForm.getDocument().getDocumentHeader().getWorkflowDocument().isInitiated()) {
            if (!document.isUserAgreement()) {
                GlobalVariables.getMessageMap().putError("userAgreement", "error.tem.card.application.agreement.not.checked", new String[]{"User"});
            }
            if (StringUtils.isEmpty((String)document.getDocumentHeader().getDocumentDescription())) {
                GlobalVariables.getMessageMap().putError("document.documentHeader.documentDescription", "error.required", new String[]{"Description"});
            }
        }
        return super.route(mapping, form, request, response);
    }

    public ActionForward applyToBank(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemCardApplicationForm applicationForm = (TemCardApplicationForm)form;
        CardApplicationDocument document = (CardApplicationDocument)applicationForm.getDocument();
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        if (!((TravelDocumentService)SpringContext.getBean(TravelDocumentService.class)).isTravelManager(currentUser)) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Apply To Bank", ((Object)((Object)this)).getClass().getSimpleName());
        }
        document.applyToBank();
        document.getDocumentHeader().getWorkflowDocument().setApplicationDocumentStatus("Applied To Bank");
        document.saveAppDocStatus();
        return mapping.findForward("basic");
    }

    public ActionForward submit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemCardApplicationForm applicationForm = (TemCardApplicationForm)form;
        CardApplicationDocument document = (CardApplicationDocument)applicationForm.getDocument();
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        if (!((TravelDocumentService)SpringContext.getBean(TravelDocumentService.class)).isTravelManager(currentUser)) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Submit", ((Object)((Object)this)).getClass().getSimpleName());
        }
        document.getDocumentHeader().getWorkflowDocument().setApplicationDocumentStatus("Pending Bank Application");
        document.saveAppDocStatus();
        return mapping.findForward("basic");
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        TemCardApplicationForm applicationForm = (TemCardApplicationForm)kualiDocumentFormBase;
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        TemProfile profile = ((TemProfileService)SpringContext.getBean(TemProfileService.class)).findTemProfileByPrincipalId(currentUser.getPrincipalId());
        CardApplicationDocument document = (CardApplicationDocument)applicationForm.getDocument();
        document.getDocumentHeader().getWorkflowDocument().setApplicationDocumentStatus("Application");
        document.setTemProfile(profile);
        document.setTemProfileId(profile.getProfileId());
        profile.getTravelerTypeCode();
        applicationForm.setInitiator(true);
    }

    public ActionForward checkExistingCard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        TemCardApplicationForm applicationForm = (TemCardApplicationForm)form;
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        TemProfile profile = ((TemProfileService)SpringContext.getBean(TemProfileService.class)).findTemProfileByPrincipalId(currentUser.getPrincipalId());
        if (profile == null) {
            applicationForm.setEmptyProfile(true);
            return mapping.findForward(ERROR_FORWARD);
        }
        if (profile.getAccounts() != null && profile.getAccounts().size() > 0) {
            boolean hasCardType = false;
            for (TemProfileAccount account : profile.getAccounts()) {
                if (account.getCreditCardAgency().getTravelCardTypeCode().equals("CTS") && applicationForm.getDocTypeName().equals("CTAP")) {
                    hasCardType = true;
                    break;
                }
                if (!account.getCreditCardAgency().getTravelCardTypeCode().equals("CORP") || !applicationForm.getDocTypeName().equals("CCAP")) continue;
                hasCardType = true;
                break;
            }
            if (hasCardType) {
                ActionMessage message = new ActionMessage("message.tem.card.exists");
                ActionMessages messages = new ActionMessages();
                messages.add("org.apache.struts.action.GLOBAL_MESSAGE", message);
                this.saveMessages(request, messages);
                forward = mapping.findForward("QUESTION_FORWARD");
            }
        }
        if (forward == null) {
            String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
            Properties parameters = new Properties();
            parameters.put("methodToCall", "docHandler");
            parameters.put("command", "initiate");
            parameters.put("docTypeName", applicationForm.getDocTypeName());
            String action = applicationForm.getDocTypeName().equals("CTAP") ? CTS_ACTION : CORP_ACTION;
            String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + action), (Properties)parameters);
            forward = new ActionForward(lookupUrl, true);
        }
        return forward;
    }

    public ActionForward returnToIndex(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("portal");
    }

    public ActionForward openNew(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemCardApplicationForm applicationForm = (TemCardApplicationForm)form;
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "initiate");
        parameters.put("docTypeName", applicationForm.getDocTypeName());
        String action = applicationForm.getDocTypeName().equals("CTAP") ? CTS_ACTION : CORP_ACTION;
        String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + action), (Properties)parameters);
        return new ActionForward(lookupUrl, true);
    }
}

