/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.uif.field.LinkField;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.GroupTraveler;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.PrimaryDestination;
import org.kuali.kfs.module.tem.businessobject.SpecialCircumstances;
import org.kuali.kfs.module.tem.businessobject.TemDistributionAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.authorization.ReturnToFiscalOfficerAuthorizer;
import org.kuali.kfs.module.tem.document.authorization.TravelArrangeableAuthorizer;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.validation.event.AddGroupTravelLineEvent;
import org.kuali.kfs.module.tem.document.validation.event.RecalculateTripDetailTotalEvent;
import org.kuali.kfs.module.tem.document.validation.event.UpdateTripDetailsEvent;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.AddImportedExpenseEvent;
import org.kuali.kfs.module.tem.document.web.struts.QuestionHandler;
import org.kuali.kfs.module.tem.document.web.struts.StrutsInquisitor;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.report.service.TravelReportService;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.module.tem.service.PerDiemService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.module.tem.service.TravelEncumbranceService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.WireCharge;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.SegmentedLookupResultsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentActionBase;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentFormBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.web.util.HtmlUtils;

public abstract class TravelActionBase
extends KualiAccountingDocumentActionBase {
    public static Logger LOG = Logger.getLogger(TravelActionBase.class);
    protected static final String[] methodToCallExclusionArray = new String[]{"recalculate", "calculate", "recalculateTripDetailTotal", "save", "route", "approve", "blanketApprove", "updatePerDiemExpenses"};
    protected static volatile PerDiemService perDiemService;
    protected static volatile DocumentTypeService documentTypeService;
    protected static final String ACCOUNTING_LINES_TOTALS_VALIDATION_BEAN = "TravelDocument-accountingLineTotalsValidation";

    protected DocumentService getDocumentService() {
        return (DocumentService)SpringContext.getBean(DocumentService.class);
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected TravelEncumbranceService getTravelEncumbranceService() {
        return (TravelEncumbranceService)SpringContext.getBean(TravelEncumbranceService.class);
    }

    protected TemRoleService getTemRoleService() {
        return (TemRoleService)SpringContext.getBean(TemRoleService.class);
    }

    public PersonService getPersonService() {
        return (PersonService)SpringContext.getBean(PersonService.class);
    }

    protected TravelReportService getTravelReportService() {
        return (TravelReportService)SpringContext.getBean(TravelReportService.class);
    }

    public AccountingDocumentRelationshipService getAccountingDocumentRelationshipService() {
        return (AccountingDocumentRelationshipService)SpringContext.getBean(AccountingDocumentRelationshipService.class);
    }

    protected TravelerService getTravelerService() {
        return (TravelerService)SpringContext.getBean(TravelerService.class);
    }

    protected TravelService getTravelService() {
        return (TravelService)SpringContext.getBean(TravelService.class);
    }

    protected AccountingDistributionService getAccountingDistributionService() {
        return (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
    }

    protected TemProfileService getTemProfileService() {
        return (TemProfileService)SpringContext.getBean(TemProfileService.class);
    }

    protected PerDiemService getPerDiemService() {
        if (perDiemService == null) {
            perDiemService = (PerDiemService)SpringContext.getBean(PerDiemService.class);
        }
        return perDiemService;
    }

    protected DocumentTypeService getDocumentTypeService() {
        if (documentTypeService == null) {
            documentTypeService = (DocumentTypeService)SpringContext.getBean(DocumentTypeService.class);
        }
        return documentTypeService;
    }

    public ActionForward returnToFiscalOfficer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"Returning to Fiscal Officer");
        QuestionHandler questionHandler = (QuestionHandler)this.getQuestionHandler("ReturnToFiscalOfficer");
        StrutsInquisitor inq = new StrutsInquisitor(mapping, (TravelFormBase)form, this, request, response);
        if (inq.wasQuestionAsked()) {
            return (ActionForward)questionHandler.handleResponse(inq);
        }
        return (ActionForward)questionHandler.askQuestion(inq);
    }

    protected <T> T getQuestionHandler(String question) {
        Object retval = SpringContext.getService((String)question);
        return (T)retval;
    }

    protected ActionForward askQuestionsAndPerformDocumentAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionType, String confirmType, String documentType, String notePrefix, String messageType, String operation) throws Exception {
        LOG.debug((Object)"askQuestionsAndPerformDocumentAction started.");
        TravelFormBase trForm = (TravelFormBase)form;
        TravelDocument document = trForm.getTravelDocument();
        return null;
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.recalculateTripDetailTotalOnly(mapping, form, request, response);
        TravelFormBase travelForm = (TravelFormBase)form;
        if (this.requiresCalculate(travelForm)) {
            GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.document.calculationRequired", new String[]{"routing"});
            return mapping.findForward("basic");
        }
        ActionForward forward = super.route(mapping, (ActionForm)travelForm, request, response);
        this.getTravelDocumentService().attachImportedExpenses(travelForm.getTravelDocument());
        return forward;
    }

    protected void setCanReturnToFisicalOfficer(TravelFormBase form) {
        boolean can = form.getTravelDocument().canReturn();
        if (can) {
            ReturnToFiscalOfficerAuthorizer documentAuthorizer = (ReturnToFiscalOfficerAuthorizer)this.getDocumentAuthorizer((KualiDocumentFormBase)form);
            can = documentAuthorizer.canReturnToFisicalOfficer(form.getTravelDocument(), GlobalVariables.getUserSession().getPerson());
        }
        form.setCanReturn(can);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GlobalVariables.getUserSession().removeObject("profileId");
        GlobalVariables.getUserSession().removeObject("documentTypeCode");
        TravelFormBase travelFormBase = (TravelFormBase)form;
        String methodToCall = travelFormBase.getMethodToCall();
        TravelDocument document = (TravelDocument)travelFormBase.getDocument();
        this.getPerDiemService().setPerDiemCategoriesAndBreakdown(travelFormBase);
        travelFormBase.setDisplayNonEmployeeForm(!this.isEmployee(document.getTraveler()));
        if (!StringUtils.isEmpty((String)methodToCall) && !methodToCall.equalsIgnoreCase("docHandler")) {
            request.setAttribute("certificationStatement", (Object)this.getCertificationStatement(document));
            request.setAttribute("isEmployee", (Object)this.isEmployee(document.getTraveler()));
            request.setAttribute("travelArranger", (Object)this.setTravelArranger((TravelFormBase)form));
            request.setAttribute("travelManager", (Object)this.setTravelManager((TravelFormBase)form));
            request.setAttribute("fiscalOfficer", (Object)this.setFiscalOfficer((TravelFormBase)form));
            request.setAttribute("delinquent", (Object)document.getDelinquentAction());
        }
        if (document.shouldRefreshExpenseTypeObjectCode()) {
            document.refreshExpenseTypeObjectCodesForExpenses();
        }
        ExpenseUtils.calculateMileage(document, document.getActualExpenses());
        this.updateActualExpenseConversionRates(document);
        this.populateForeignCurrencyUrl(travelFormBase);
        ActionForward retval = super.execute(mapping, form, request, response);
        request.setAttribute("certificationStatement", (Object)this.getCertificationStatement(document));
        request.setAttribute("isEmployee", (Object)this.isEmployee(document.getTraveler()));
        request.setAttribute("travelArranger", (Object)this.setTravelArranger((TravelFormBase)form));
        request.setAttribute("travelManager", (Object)this.setTravelManager((TravelFormBase)form));
        request.setAttribute("fiscalOfficer", (Object)this.setFiscalOfficer((TravelFormBase)form));
        request.setAttribute("delinquent", (Object)document.getDelinquentAction());
        this.populateAgencyLinks(travelFormBase);
        if (!StringUtils.isBlank((String)document.getDocumentNumber())) {
            Map<String, List<org.kuali.kfs.krad.document.Document>> relatedDocuments = this.getTravelDocumentService().getDocumentsRelatedTo(document);
            travelFormBase.setRelatedDocuments(relatedDocuments);
            travelFormBase.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(travelFormBase.getTravelDocument()));
        }
        return retval;
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        TravelDocument travelDoc = ((TravelFormBase)kualiDocumentFormBase).getTravelDocument();
        if ((travelDoc.getDocumentHeader().getWorkflowDocument().isEnroute() || travelDoc.getDocumentHeader().getWorkflowDocument().isCompletionRequested()) && travelDoc.getActualExpenses() != null && !travelDoc.getActualExpenses().isEmpty()) {
            ExpenseUtils.calculateMileage(travelDoc, travelDoc.getActualExpenses());
        }
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String lookupResultsSequenceNumber;
        super.refresh(mapping, form, request, response);
        TravelFormBase travelForm = (TravelFormBase)form;
        Collection rawValues = null;
        HashMap segmentedSelection = new HashMap();
        if (StringUtils.equals((String)"multipleValues", (String)travelForm.getRefreshCaller()) && StringUtils.isNotBlank((String)(lookupResultsSequenceNumber = travelForm.getLookupResultsSequenceNumber()))) {
            Set selectedIds = ((SegmentedLookupResultsService)SpringContext.getBean(SegmentedLookupResultsService.class)).retrieveSetOfSelectedObjectIds(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
            for (String selectedId : selectedIds) {
                String selectedObjId = StringUtils.substringBefore((String)selectedId, (String)".");
                String selectedMonthData = StringUtils.substringAfter((String)selectedId, (String)".");
                if (!segmentedSelection.containsKey(selectedObjId)) {
                    segmentedSelection.put(selectedObjId, new HashSet());
                }
                ((Set)segmentedSelection.get(selectedObjId)).add(selectedMonthData);
            }
            LOG.debug((Object)("Asking segmentation service for object ids " + segmentedSelection.keySet()));
            rawValues = ((SegmentedLookupResultsService)SpringContext.getBean(SegmentedLookupResultsService.class)).retrieveSelectedResultBOs(lookupResultsSequenceNumber, segmentedSelection.keySet(), HistoricalTravelExpense.class, GlobalVariables.getUserSession().getPerson().getPrincipalId());
            List<ImportedExpense> newImportedExpenses = ExpenseUtils.convertHistoricalToImportedExpense((List)rawValues, travelForm.getTravelDocument());
            AddImportedExpenseEvent event = new AddImportedExpenseEvent();
            for (ImportedExpense newImportedExpense : newImportedExpenses) {
                travelForm.setNewImportedExpenseLine(newImportedExpense);
                event.update(null, travelForm);
            }
            if (rawValues != null && rawValues.size() > 0) {
                this.save(mapping, (ActionForm)travelForm, request, response);
                KNSGlobalVariables.getMessageList().add("info.document.auto.save", new String[0]);
            }
        }
        ((TravelFormBase)form).setWireChargeMessage(this.retrieveWireChargeMessage());
        String refreshCaller = ((KualiForm)form).getRefreshCaller();
        if (!StringUtils.isBlank((String)refreshCaller)) {
            TravelDocument document = ((TravelFormBase)form).getTravelDocument();
            if ("travelerProfileDocLookupable".equals(refreshCaller)) {
                this.performRequesterRefresh(document, (TravelFormBase)form, request);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        this.validateLookupInquiryFullParameter(request, form, fullParameter);
        String boClassName = StringUtils.substringBetween((String)fullParameter, (String)"(!!", (String)"!!)");
        if (!StringUtils.isBlank((String)boClassName) && boClassName.equals(HistoricalTravelExpense.class.getName())) {
            TravelDocument document = travelForm.getTravelDocument();
            boolean success = true;
            if (document.getTemProfileId() == null) {
                String identifier = TemConstants.documentProfileNames().get(document.getFinancialDocumentTypeCode());
                GlobalVariables.getMessageMap().putError("document.firstName", "error.document.tem.travel.import.profile.missing", new String[]{identifier});
                success = false;
            }
            if (!success) {
                return mapping.findForward("basic");
            }
            travelForm.setRefreshCaller("multipleValues");
            GlobalVariables.getUserSession().addObject("profileId", (Object)document.getTemProfileId());
            GlobalVariables.getUserSession().addObject("arrangerProfileId", (Object)this.getTemProfileService().findTemProfileByPrincipalId(GlobalVariables.getUserSession().getPrincipalId()).getProfileId());
            GlobalVariables.getUserSession().addObject("documentTypeCode", (Object)document.getFinancialDocumentTypeCode());
        }
        return super.performLookup(mapping, form, request, response);
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward retval = super.docHandler(mapping, form, request, response);
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelDocument travelDocument = travelForm.getTravelDocument();
        this.initializeNewActualExpenseLines(travelForm.getNewActualExpenseLines(), travelDocument.getActualExpenses());
        if (travelDocument instanceof TravelAuthorizationDocument || travelDocument instanceof TravelReimbursementDocument) {
            this.updateCustomPrimaryDestination(travelDocument);
        }
        return retval;
    }

    protected void updateCustomPrimaryDestination(TravelDocument travelDocument) {
        if (travelDocument.getPrimaryDestinationId() != null && travelDocument.getPrimaryDestinationId() == Integer.MAX_VALUE) {
            PrimaryDestination destination = travelDocument.getPrimaryDestination();
            destination.setPrimaryDestinationName(travelDocument.getPrimaryDestinationName());
            destination.setCounty(travelDocument.getPrimaryDestinationCounty());
            destination.getRegion().setRegionName(travelDocument.getPrimaryDestinationCountryState());
            travelDocument.setPrimaryDestinationIndicator(true);
        }
    }

    protected void initializeNewActualExpenseLines(List<ActualExpense> newActualExpenseLines, List<ActualExpense> actualExpenses) {
        if (actualExpenses != null && !actualExpenses.isEmpty()) {
            if (newActualExpenseLines == null) {
                newActualExpenseLines = new ArrayList<ActualExpense>();
            }
            newActualExpenseLines.clear();
            for (ActualExpense actualExpense : actualExpenses) {
                ActualExpense newActualExpenseLine = new ActualExpense();
                newActualExpenseLine.setExpenseDate(actualExpense.getExpenseDate());
                newActualExpenseLine.setExpenseTypeObjectCodeId(actualExpense.getExpenseTypeObjectCodeId());
                newActualExpenseLine.setExpenseParentId(actualExpense.getId());
                newActualExpenseLines.add(newActualExpenseLine);
            }
        }
    }

    public ActionForward enablePrimaryDestinationFields(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase baseForm = (TravelFormBase)form;
        TravelDocumentBase document = (TravelDocumentBase)baseForm.getDocument();
        document.setPrimaryDestinationIndicator(true);
        document.setPrimaryDestinationId(Integer.MAX_VALUE);
        if (document.getPrimaryDestination() != null) {
            document.getPrimaryDestination().setId(Integer.MAX_VALUE);
            document.getPrimaryDestination().setVersionNumber(null);
            document.getPrimaryDestination().setObjectId(null);
        } else {
            document.setPrimaryDestination(new PrimaryDestination());
            document.getPrimaryDestination().setId(Integer.MAX_VALUE);
            document.getPrimaryDestination().setPrimaryDestinationName(document.getPrimaryDestinationName());
            document.getPrimaryDestination().getRegion().setRegionName(document.getPrimaryDestinationCountryState());
            document.getPrimaryDestination().setCounty(document.getPrimaryDestinationCounty());
            document.getPrimaryDestination().getRegion().setTripTypeCode(document.getTripTypeCode());
            document.getPrimaryDestination().getRegion().setTripType(document.getTripType());
        }
        return mapping.findForward("basic");
    }

    protected String getCertificationStatement(TravelDocument document) {
        if (this.isEmployee(document.getTraveler())) {
            return this.getEmployeeCertificationStatement();
        }
        return this.getNonEmployeeCertificationStatement();
    }

    protected String getEmployeeCertificationStatement() {
        return this.getCertificationStatementFrom("EMPLOYEE_CERTIFICATION_STATEMENT");
    }

    protected String getNonEmployeeCertificationStatement() {
        return this.getCertificationStatementFrom("NON_EMPLOYEE_CERTIFICATION_STATEMENT");
    }

    protected String getCertificationStatementFrom(String parameter) {
        return this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, parameter);
    }

    protected boolean isEmployee(TravelerDetail traveler) {
        if (traveler == null) {
            return false;
        }
        return this.getTravelerService().isEmployee(traveler);
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        TravelDocument document = (TravelDocument)kualiDocumentFormBase.getDocument();
        document.initiateDocument();
        List<SpecialCircumstances> specialCircumstances = this.getTravelDocumentService().findActiveSpecialCircumstances(document.getDocumentHeader().getDocumentNumber(), kualiDocumentFormBase.getDocTypeName());
        document.setSpecialCircumstances(specialCircumstances);
    }

    public <T> T newMvcDelegate(ActionForm form) throws Exception {
        Object retval = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{this.getMvcWrapperInterface()}, new TravelMvcWrapperInvocationHandler<ActionForm>(form));
        return (T)retval;
    }

    protected abstract Class<? extends TravelMvcWrapperBean> getMvcWrapperInterface();

    protected boolean requiresCalculate(TravelFormBase travelForm) {
        boolean requiresCalculate = true;
        requiresCalculate = !travelForm.isCalculated();
        return requiresCalculate;
    }

    protected <T> T getDocumentAuthorizer(KualiDocumentFormBase form) {
        return (T)this.getDocumentHelperService().getDocumentAuthorizer(form.getDocument());
    }

    protected Integer getLineNumberFromParameter(String parameterKey) {
        int beginIndex = parameterKey.lastIndexOf("[") + 1;
        int endIndex = parameterKey.lastIndexOf("]");
        return Integer.parseInt(parameterKey.substring(beginIndex, endIndex));
    }

    public ActionForward updatePerDiemExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase reqForm = (TravelFormBase)form;
        TravelDocument document = reqForm.getTravelDocument();
        ParameterService paramService = (ParameterService)SpringContext.getBean(ParameterService.class);
        if (((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new UpdateTripDetailsEvent("tripInfoUpdateTripDetails", reqForm.getDocument()))) {
            this.getTravelDocumentService().updatePerDiemItemsFor(document, document.getPerDiemExpenses(), document.getPrimaryDestinationId(), document.getTripBegin(), document.getTripEnd());
        }
        reqForm.getNewSourceLine().setAmount(this.getAccountingLineAmountToFillIn(reqForm));
        return mapping.findForward("basic");
    }

    public ActionForward clearPerDiemExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase reqForm = (TravelFormBase)form;
        TravelDocument document = reqForm.getTravelDocument();
        document.setPerDiemExpenses(new ArrayList<PerDiemExpense>());
        return mapping.findForward("basic");
    }

    public ActionForward copyDownPerDiemExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase reqForm = (TravelFormBase)form;
        TravelDocument document = reqForm.getTravelDocument();
        int copyIndex = this.getSelectedLine(request);
        this.getTravelDocumentService().copyDownPerDiemExpense(document, copyIndex, document.getPerDiemExpenses());
        return mapping.findForward("basic");
    }

    public ActionForward addActualExpenseLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(mvcWrapper);
        return mapping.findForward("basic");
    }

    public ActionForward addActualExpenseDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, this.getSelectedLine(request)});
        return mapping.findForward("basic");
    }

    public ActionForward deleteActualExpenseLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, this.getSelectedLine(request)});
        return mapping.findForward("basic");
    }

    public ActionForward deleteActualExpenseDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        int[] lineNumbers = this.getSelectedDetailLine(request);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, lineNumbers[0], lineNumbers[1]});
        return mapping.findForward("basic");
    }

    protected void displayPDF(HttpServletRequest request, HttpServletResponse response, File reportFile, StringBuilder fileName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String contentDisposition = "";
        try {
            ArrayList master = new ArrayList();
            PdfCopy writer = null;
            String reportName = reportFile.getAbsolutePath();
            PdfReader reader = new PdfReader(reportName);
            reader.consolidateNamedDestinations();
            int n = reader.getNumberOfPages();
            List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
            if (bookmarks != null) {
                master.addAll(bookmarks);
            }
            Document pdfDoc = new Document(reader.getPageSizeWithRotation(1));
            writer = new PdfCopy(pdfDoc, (OutputStream)baos);
            pdfDoc.open();
            int i = 0;
            while (i < n) {
                PdfImportedPage page = writer.getImportedPage(reader, ++i);
                writer.addPage(page);
            }
            writer.freeReader(reader);
            if (!master.isEmpty()) {
                writer.setOutlines(master);
            }
            pdfDoc.close();
            StringBuffer sbContentDispValue = new StringBuffer();
            String useJavascript = request.getParameter("useJavascript");
            if (useJavascript == null || useJavascript.equalsIgnoreCase("false")) {
                sbContentDispValue.append("attachment");
            } else {
                sbContentDispValue.append("inline");
            }
            sbContentDispValue.append("; filename=");
            sbContentDispValue.append((CharSequence)fileName);
            contentDisposition = sbContentDispValue.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.setContentType("application/pdf");
        response.setHeader("Content-Disposition", contentDisposition);
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setContentLength(baos.size());
        ServletOutputStream sos = response.getOutputStream();
        baos.writeTo((OutputStream)sos);
        sos.flush();
        sos.close();
    }

    public ActionForward customPerDiemExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase reqForm = (TravelFormBase)form;
        TravelDocument document = reqForm.getTravelDocument();
        int copyIndex = this.getSelectedLine(request);
        PerDiemExpense expense = document.getPerDiemExpenses().get(copyIndex);
        expense.setPrimaryDestinationId(Integer.MAX_VALUE);
        expense.setPrimaryDestination("");
        expense.setCountryState("");
        expense.setCounty("");
        expense.setLodging(KualiDecimal.ZERO);
        expense.setIncidentalsValue(KualiDecimal.ZERO);
        expense.setBreakfastValue(KualiDecimal.ZERO);
        expense.setLunchValue(KualiDecimal.ZERO);
        expense.setDinnerValue(KualiDecimal.ZERO);
        return mapping.findForward("basic");
    }

    public ActionForward refreshAfterPrimaryDestinationLookup(ActionMapping mapping, TravelFormBase reqForm, HttpServletRequest request) {
        String refreshCaller = reqForm.getRefreshCaller();
        TravelDocument document = reqForm.getTravelDocument();
        boolean isPrimaryDestinationLookupable = "primaryDestinationLookupable".equals(refreshCaller);
        if (refreshCaller == null) {
            return null;
        }
        if (!isPrimaryDestinationLookupable) {
            return null;
        }
        Map parameters = request.getParameterMap();
        Set parameterKeys = parameters.keySet();
        for (String parameterKey : parameterKeys) {
            if (!StringUtils.containsIgnoreCase((String)parameterKey, (String)"perDiemExpenses")) continue;
            int estimateLineNum = this.getLineNumberFromParameter(parameterKey);
            PerDiemExpense expense = document.getPerDiemExpenses().get(estimateLineNum);
            String[] priDestId = (String[])parameters.get(parameterKey);
            PerDiem perDiem = null;
            perDiem = expense.getPrimaryDestinationId() != Integer.MAX_VALUE && expense.getPrimaryDestinationId().equals(new Integer(priDestId[0])) ? this.getPerDiemService().getPerDiem(expense.getPrimaryDestinationId(), expense.getMileageDate(), document.getEffectiveDateForPerDiem(expense.getMileageDate())) : this.getPerDiemService().getPerDiem(new Integer(priDestId[0]), expense.getMileageDate(), document.getEffectiveDateForPerDiem(expense.getMileageDate()));
            if (perDiem != null) {
                expense.setPrimaryDestinationId(perDiem.getPrimaryDestinationId());
                expense.setPrimaryDestination(perDiem.getPrimaryDestination().getPrimaryDestinationName());
                expense.setCountryState(perDiem.getPrimaryDestination().getRegion().getRegionName());
                expense.setCounty(perDiem.getPrimaryDestination().getCounty());
                boolean shouldProrate = document.isOnTripBegin(expense) || document.isOnTripEnd(expense);
                this.getTravelDocumentService().setPerDiemMealsAndIncidentals(expense, perDiem, document.getTripType(), document.getTripEnd(), shouldProrate);
                expense.setLodging(perDiem.getLodging());
            }
            return null;
        }
        Integer primaryDestinationId = document.getPrimaryDestinationId();
        if (primaryDestinationId == null) {
            if (document.getPrimaryDestination().getId() != null) {
                document.setPerDiemExpenses(new ArrayList<PerDiemExpense>());
            }
        } else if (document.getPrimaryDestination().getId() != null && primaryDestinationId.intValue() != document.getPrimaryDestination().getId().intValue()) {
            document.setPerDiemExpenses(new ArrayList<PerDiemExpense>());
        }
        if (isPrimaryDestinationLookupable) {
            PrimaryDestination primaryDestination = new PrimaryDestination();
            primaryDestination.setId(primaryDestinationId);
            document.setPrimaryDestinationIndicator(false);
            primaryDestination = (PrimaryDestination)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).retrieve((PersistableBusinessObject)primaryDestination);
            document.setPrimaryDestination(primaryDestination);
            document.setPrimaryDestinationId(primaryDestination.getId());
            document.setTripType(primaryDestination.getRegion().getTripType());
            document.setTripTypeCode(primaryDestination.getRegion().getTripTypeCode().toUpperCase());
            return null;
        }
        return null;
    }

    protected KualiDecimal getAccountingLineAmountToFillIn(TravelFormBase travelReqForm) {
        KualiDecimal amount = KualiDecimal.ZERO;
        TravelDocument travelDocument = travelReqForm.getTravelDocument();
        KualiDecimal amountToBePaid = travelDocument.getTotalAccountLineAmount();
        List accountingLines = travelDocument.getSourceAccountingLines();
        KualiDecimal accountingTotal = KualiDecimal.ZERO;
        for (TemSourceAccountingLine accountingLine : accountingLines) {
            accountingTotal = (KualiDecimal)accountingTotal.add((AbstractKualiDecimal)accountingLine.getAmount());
        }
        if (!ObjectUtils.isNull((Object)amountToBePaid) && amountToBePaid.isGreaterEqual((AbstractKualiDecimal)accountingTotal)) {
            amount = (KualiDecimal)amountToBePaid.subtract((AbstractKualiDecimal)accountingTotal);
        }
        if (travelDocument.getExpenseLimit() != null && travelDocument.getExpenseLimit().isPositive()) {
            if (accountingTotal.isGreaterEqual((AbstractKualiDecimal)travelDocument.getExpenseLimit())) {
                return KualiDecimal.ZERO;
            }
            if (amount.isGreaterThan((AbstractKualiDecimal)travelDocument.getExpenseLimit())) {
                return (KualiDecimal)travelDocument.getExpenseLimit().subtract((AbstractKualiDecimal)accountingTotal);
            }
        }
        return amount;
    }

    public ActionForward recalculateTripDetailTotal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<PerDiemExpense> estimates;
        KNSGlobalVariables.getMessageList().remove((Object)new ErrorMessage("message.recalculate.successful", new String[0]));
        TravelFormBase travelReqForm = (TravelFormBase)form;
        TravelDocumentBase travelReqDoc = (TravelDocumentBase)travelReqForm.getDocument();
        if (((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new RecalculateTripDetailTotalEvent("", travelReqForm.getDocument())) && (estimates = travelReqDoc.getPerDiemExpenses()) != null && !estimates.isEmpty()) {
            this.getTravelDocumentService().updatePerDiemItemsFor(travelReqDoc, estimates, null, travelReqDoc.getTripBegin(), travelReqDoc.getTripEnd());
        }
        if (!travelReqDoc.isValidExpenses()) {
            return mapping.findForward("basic");
        }
        travelReqForm.getNewSourceLine().setAmount(this.getAccountingLineAmountToFillIn(travelReqForm));
        LOG.debug((Object)("Recalculating travel auth document " + travelReqDoc.getTravelDocumentIdentifier()));
        travelReqForm.setCalculated(true);
        KNSGlobalVariables.getMessageList().add("message.recalculate.successful", new String[0]);
        this.showAccountDistribution(request, travelReqForm.getDocument());
        request.setAttribute("showReports", (Object)(!travelReqDoc.getDocumentHeader().getWorkflowDocument().isInitiated() ? 1 : 0));
        if (travelReqDoc.getReimbursableTotal() != null && travelReqDoc.getExpenseLimit() != null && travelReqDoc.getReimbursableTotal().isGreaterThan((AbstractKualiDecimal)travelReqDoc.getExpenseLimit())) {
            GlobalVariables.getMessageMap().putWarning("document.estimateAmount", "error.custom", new String[]{"Travel expense is exceeding the expense limit."});
        }
        return mapping.findForward("basic");
    }

    protected void showAccountDistribution(HttpServletRequest request, org.kuali.kfs.krad.document.Document document) {
        if (document instanceof TravelDocumentBase) {
            boolean showAccountDistribution = this.getParameterService().getParameterValueAsBoolean(document.getClass(), "DISPLAY_ACCOUNTING_DISTRIBUTION_TAB_IND");
            request.setAttribute("accountDistribution", (Object)showAccountDistribution);
        }
    }

    public ActionForward recalculateTripDetailTotalOnly(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = this.recalculateTripDetailTotal(mapping, form, request, response);
        KNSGlobalVariables.getMessageList().remove((Object)new ErrorMessage("message.recalculate.successful", new String[0]));
        return actionForward;
    }

    protected boolean setTravelArranger(TravelFormBase form) {
        TravelDocument baseTravelDocument;
        TravelDocument travelDocument = form.getTravelDocument();
        if (!StringUtils.isBlank((String)travelDocument.getTravelDocumentIdentifier()) && (baseTravelDocument = this.getTravelDocumentService().getParentTravelDocument(travelDocument.getTravelDocumentIdentifier())) != null && !StringUtils.equals((String)baseTravelDocument.getDocumentNumber(), (String)travelDocument.getDocumentNumber())) {
            return false;
        }
        TemProfile profile = null;
        String profileId = null;
        String homeDepartment = null;
        if (ObjectUtils.isNotNull((Object)travelDocument.getTemProfileId()) && ObjectUtils.isNotNull((Object)((Object)(profile = (TemProfile)this.getBusinessObjectService().findBySinglePrimaryKey(TemProfile.class, (Object)travelDocument.getTemProfileId()))))) {
            homeDepartment = profile.getHomeDepartment();
            profileId = profile.getProfileId().toString();
        }
        return this.getTemRoleService().isTravelArranger(GlobalVariables.getUserSession().getPerson(), homeDepartment, profileId, travelDocument.getDocumentTypeName());
    }

    protected boolean setTravelManager(TravelFormBase reqForm) {
        return this.getTravelDocumentService().isTravelManager(GlobalVariables.getUserSession().getPerson());
    }

    protected boolean setFiscalOfficer(TravelFormBase reqForm) {
        boolean workflowCheck = false;
        try {
            List nodes = reqForm.getWorkflowDocument().getRouteNodeInstances();
            for (RouteNodeInstance routeNode : nodes) {
                if (!routeNode.getName().equals("Account")) continue;
                workflowCheck = true;
            }
            workflowCheck &= reqForm.getWorkflowDocument().isEnroute();
        }
        catch (RuntimeException e) {
            LOG.info((Object)"Could not retrieve the workflow document. This is most likely normal and ok in this case.");
        }
        return this.getTravelDocumentService().isResponsibleForAccountsOn(reqForm.getTravelDocument(), GlobalVariables.getUserSession().getPerson().getPrincipalId()) && workflowCheck;
    }

    protected List<String> getCalculateIgnoreList() {
        return Arrays.asList(methodToCallExclusionArray);
    }

    public ActionForward addRelatedDocumentLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelReqForm = (TravelFormBase)form;
        AccountingDocumentRelationship adr = travelReqForm.getNewAccountingDocumentRelationship();
        if (adr.getRelDocumentNumber() == null || !NumberUtils.isDigits((String)adr.getRelDocumentNumber())) {
            GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newAccountingDocumentRelationship*", "relDocumentNumber"), "error.document.tem.travel.relatedDocument.relDocumentNumberRequired", new String[0]);
        } else if (this.getDocumentService().documentExists(adr.getRelDocumentNumber())) {
            adr.setDocumentNumber(travelReqForm.getDocument().getDocumentNumber());
            adr.setPrincipalId(GlobalVariables.getUserSession().getPerson().getPrincipalId());
            this.getAccountingDocumentRelationshipService().save(adr);
            travelReqForm.setNewAccountingDocumentRelationship(new AccountingDocumentRelationship());
        } else {
            GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newAccountingDocumentRelationship*", "relDocumentNumber"), "error.document.tem.travel.relatedDocument.documentNotFound", new String[]{adr.getRelDocumentNumber()});
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRelatedDocumentLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelReqForm = (TravelFormBase)form;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String relDocumentNumber = StringUtils.substringBetween((String)parameterName, (String)"deleteRelatedDocumentLine.", (String)".");
            List<AccountingDocumentRelationship> adrList = this.getAccountingDocumentRelationshipService().find(new AccountingDocumentRelationship(travelReqForm.getDocument().getDocumentNumber(), relDocumentNumber));
            if (adrList != null && adrList.size() == 1 && adrList.get(0).getPrincipalId().equals(GlobalVariables.getUserSession().getPerson().getPrincipalId())) {
                this.getAccountingDocumentRelationshipService().delete(adrList.get(0));
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward addGroupTravelerLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelReqForm = (TravelFormBase)form;
        TravelDocumentBase travelReqDoc = (TravelDocumentBase)travelReqForm.getDocument();
        GroupTraveler newGroupTravelerLine = travelReqForm.getNewGroupTravelerLine();
        boolean rulePassed = true;
        if (rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddGroupTravelLineEvent("newGroupTravelerLine", travelReqForm.getDocument(), newGroupTravelerLine))) {
            travelReqDoc.addGroupTravelerLine(newGroupTravelerLine);
            travelReqForm.setNewGroupTravelerLine(new GroupTraveler());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteGroupTravelerLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelReqForm = (TravelFormBase)form;
        TravelDocumentBase travelReqDoc = (TravelDocumentBase)travelReqForm.getDocument();
        int deleteIndex = this.getLineToDelete(request);
        travelReqDoc.getGroupTravelers().remove(deleteIndex);
        return mapping.findForward("basic");
    }

    public ActionForward uploadGroupTravelerImportFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, new String(travelForm.getGroupTravelerImportFile().getFileData())});
        return mapping.findForward("basic");
    }

    public ActionForward payDVToVendor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String url = this.getKualiConfigurationService().getPropertyValueAsString("application.url") + "/" + "temDV.do?methodToCall=docHandler&command=initiate&docTypeName=DV&temDocID=" + HtmlUtils.htmlEscape((String)((TravelFormBase)form).getTravelDocument().getDocumentNumber());
        return new ActionForward(url, true);
    }

    public ActionForward addImportedExpenseLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(mvcWrapper);
        return mapping.findForward("basic");
    }

    public ActionForward addImportedExpenseDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, this.getSelectedLine(request)});
        return mapping.findForward("basic");
    }

    public ActionForward deleteImportedExpenseLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, this.getSelectedLine(request)});
        this.checkImportedExpenseAccountingLine(travelForm.getTravelDocument());
        this.save(mapping, (ActionForm)travelForm, request, response);
        KNSGlobalVariables.getMessageList().add("info.document.auto.save", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward deleteImportedExpenseDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        int[] lineNumbers = this.getSelectedDetailLine(request);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, lineNumbers[0], lineNumbers[1]});
        return mapping.findForward("basic");
    }

    protected int[] getSelectedDetailLine(HttpServletRequest request) {
        int[] selectedLines = new int[2];
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String lineNumbers = StringUtils.substringBetween((String)parameterName, (String)".line", (String)".");
            selectedLines[0] = Integer.parseInt(lineNumbers.split("-")[0]);
            selectedLines[1] = Integer.parseInt(lineNumbers.split("-")[1]);
        }
        return selectedLines;
    }

    public ActionForward deleteSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.deleteSourceLine(mapping, form, request, response);
        TravelFormBase travelForm = (TravelFormBase)form;
        travelForm.setAnchor("sourceAnchor");
        travelForm.setDistribution(new ArrayList<AccountingDistribution>());
        travelForm.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(travelForm.getTravelDocument()));
        return forward;
    }

    public ActionForward deleteDistributionLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        travelForm.setAnchor("distributionAnchor");
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        int deleteIndex = this.getLineToDelete(request);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, deleteIndex});
        return mapping.findForward("basic");
    }

    public ActionForward insertDistributionLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelDocument travelDocument = travelForm.getTravelDocument();
        travelForm.getAccountDistributionnewSourceLine().setCardType(travelDocument.getDefaultAccountingLineCardAgencyType());
        travelForm.setAnchor("distributionAnchor");
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(mvcWrapper);
        return mapping.findForward("basic");
    }

    protected void deleteAccountingLine(boolean isSource, KualiAccountingDocumentFormBase financialDocumentForm, int deleteIndex) {
        financialDocumentForm.setAnchor("sourceAnchor");
        super.deleteAccountingLine(isSource, financialDocumentForm, deleteIndex);
    }

    protected void insertAccountingLine(boolean isSource, KualiAccountingDocumentFormBase financialDocumentForm, AccountingLine line) {
        financialDocumentForm.setAnchor("sourceAnchor");
        super.insertAccountingLine(isSource, financialDocumentForm, line);
    }

    public ActionForward selectAllDistributions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("anchoraccountingDistributionAnchor", (Object)"anchoraccountingDistributionAnchor");
        TravelFormBase travelForm = (TravelFormBase)form;
        int index = this.getSelectedLine(request);
        boolean selected = false;
        if (index == Integer.parseInt("0")) {
            selected = true;
        }
        for (AccountingDistribution accountingDistribution : travelForm.getDistribution()) {
            accountingDistribution.setSelected(selected);
        }
        return mapping.findForward("basic");
    }

    protected void initializeAssignAccounts(TravelFormBase travelForm) {
        TravelDocument travelDocument = travelForm.getTravelDocument();
        TemDistributionAccountingLine newLine = this.getAccountingDistributionService().distributionToDistributionAccountingLine(travelForm.getDistribution());
        travelForm.setAccountDistributionsourceAccountingLines(new ArrayList<TemDistributionAccountingLine>());
        travelForm.setAccountDistributionnextSourceLineNumber(new Integer(1));
        newLine.setAccountLinePercent(new BigDecimal(100));
        newLine.setCardType(travelDocument.getDefaultAccountingLineCardAgencyType());
        if (!ObjectUtils.isNull((Object)((Object)travelDocument.getTemProfile()))) {
            newLine.setChartOfAccountsCode(travelDocument.getTemProfile().getDefaultChartCode());
            newLine.setAccountNumber(travelDocument.getTemProfile().getDefaultAccount());
            newLine.setSubAccountNumber(travelDocument.getTemProfile().getDefaultSubAccount());
            newLine.setProjectCode(travelDocument.getTemProfile().getDefaultProjectCode());
        }
        travelForm.setAccountDistributionnewSourceLine(newLine);
    }

    public ActionForward distributeAccountingLines(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        travelForm.setAnchor("distributionAnchor");
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(mvcWrapper);
        return mapping.findForward("basic");
    }

    public ActionForward resetAccountingLines(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelDocument document = travelForm.getTravelDocument();
        document.setNextSourceLineNumber(new Integer(1));
        document.setSourceAccountingLines(new ArrayList());
        travelForm.setDistribution(new ArrayList<AccountingDistribution>());
        travelForm.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(document));
        travelForm.setAnchor("sourceAnchor");
        return mapping.findForward("basic");
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.recalculateTripDetailTotalOnly(mapping, form, request, response);
        ActionForward forward = super.approve(mapping, form, request, response);
        return forward;
    }

    protected boolean isFinal(TravelFormBase reqForm) {
        return reqForm.getTransactionalDocument().getDocumentHeader().getWorkflowDocument().isFinal();
    }

    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelDocument document = travelForm.getTravelDocument();
        this.getTravelDocumentService().detachImportedExpenses(document);
        return super.disapprove(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.cancel(mapping, form, request, response);
        if (forward.getName() != null && forward.getName().equals("portal")) {
            TravelFormBase travelForm = (TravelFormBase)form;
            TravelDocument document = travelForm.getTravelDocument();
            this.getTravelDocumentService().detachImportedExpenses(document);
        }
        return forward;
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.close(mapping, form, request, response);
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelDocument document = travelForm.getTravelDocument();
        if (forward.getName() != null && forward.getName().equals("portal") && document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            this.getTravelDocumentService().detachImportedExpenses(document);
        }
        return forward;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.recalculateTripDetailTotalOnly(mapping, form, request, response);
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelDocument document = travelForm.getTravelDocument();
        ActionForward forward = super.save(mapping, form, request, response);
        return forward;
    }

    public void checkImportedExpenseAccountingLine(TravelDocument document) {
        if (!document.getSourceAccountingLines().isEmpty() && document.getImportedExpenses().isEmpty()) {
            ArrayList<TemSourceAccountingLine> filteredAccountingLine = new ArrayList<TemSourceAccountingLine>();
            List<String> cardTypes = this.getTravelService().getTravelCardTypes();
            for (TemSourceAccountingLine line : document.getSourceAccountingLines()) {
                if (cardTypes.contains(line.getCardType())) continue;
                filteredAccountingLine.add(line);
            }
            document.setSourceAccountingLines(filteredAccountingLine);
        }
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.recalculateTripDetailTotalOnly(mapping, form, request, response);
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelDocument document = travelForm.getTravelDocument();
        ActionForward forward = super.blanketApprove(mapping, form, request, response);
        this.getTravelDocumentService().attachImportedExpenses(document);
        return forward;
    }

    protected boolean isProcessed(TravelFormBase reqForm) {
        return reqForm.getTransactionalDocument().getDocumentHeader().getWorkflowDocument().isProcessed();
    }

    protected void refreshRelatedDocuments(TravelFormBase form) {
        try {
            Map<String, List<org.kuali.kfs.krad.document.Document>> relatedDocuments = this.getTravelDocumentService().getDocumentsRelatedTo(form.getTravelDocument());
            form.setRelatedDocuments(relatedDocuments);
            form.setRelatedDocumentNotes(null);
            form.getRelatedDocumentNotes();
        }
        catch (WorkflowException ex) {
            ex.printStackTrace();
        }
    }

    protected String retrieveWireChargeMessage() {
        String message = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("message.payment.wireCharge");
        WireCharge wireCharge = new WireCharge();
        wireCharge.setUniversityFiscalYear(((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear());
        wireCharge = (WireCharge)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).retrieve((PersistableBusinessObject)wireCharge);
        Object[] args = new Object[]{wireCharge.getDomesticChargeAmt(), wireCharge.getForeignChargeAmt()};
        return MessageFormat.format(message, args);
    }

    protected void setCanCalculate(TravelFormBase form) {
        boolean can;
        boolean bl = can = !this.isFinal(form) && !this.isProcessed(form);
        if (can) {
            TravelArrangeableAuthorizer documentAuthorizer = (TravelArrangeableAuthorizer)this.getDocumentAuthorizer((KualiDocumentFormBase)form);
            can = documentAuthorizer.canCalculate(form.getTravelDocument(), GlobalVariables.getUserSession().getPerson());
        }
        form.setCanCalculate(can);
    }

    protected void populateForeignCurrencyUrl(TravelFormBase form) {
        String currencyUrl = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "FOREIGN_CURRENCY_URL");
        form.setForeignCurrencyUrl(currencyUrl);
    }

    protected void populateAgencyLinks(TravelFormBase form) {
        List<LinkField> agencyLinks = this.getTravelDocumentService().getAgencyLinks(form.getTravelDocument());
        form.setAgencyLinks(agencyLinks);
        boolean shouldDisplay = this.getKualiConfigurationService().getPropertyValueAsBoolean("config.document.travelRelocation.agencySites.enable");
        form.setShouldDisplayAgencyLinks(shouldDisplay);
    }

    protected void updateActualExpenseConversionRates(TravelDocument doc) {
        for (ActualExpense expense : doc.getActualExpenses()) {
            if (expense.getExpenseDetails() == null || expense.getExpenseDetails().isEmpty()) continue;
            for (TemExpense temExpense : expense.getExpenseDetails()) {
                temExpense.setCurrencyRate(expense.getCurrencyRate());
            }
        }
    }

    protected AccountingDocumentRelationship buildRelationshipToProgenitorDocument(TravelDocument progenitorDocument, TravelDocument createdDocument) {
        String progenitorType = progenitorDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        String createdType = createdDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        AccountingDocumentRelationship relationship = new AccountingDocumentRelationship(progenitorDocument.getDocumentNumber(), createdDocument.getDocumentNumber(), progenitorType + " - " + createdType);
        relationship.setPrincipalId(GlobalVariables.getUserSession().getPrincipalId());
        return relationship;
    }

    protected void disablePerDiemExpenes(TravelDocument document) {
        for (ActualExpense actualExpense : document.getActualExpenses()) {
            this.getTravelDocumentService().disableDuplicateExpenses(document, actualExpense);
        }
        for (String key : document.getDisabledProperties().keySet()) {
            GlobalVariables.getMessageMap().putInfo(key, "message.generic", new String[]{document.getDisabledProperties().get(key)});
        }
    }

    protected abstract void performRequesterRefresh(TravelDocument var1, TravelFormBase var2, HttpServletRequest var3);

    protected void updateAccountsWithNewProfile(TravelFormBase form, TemProfile profile) {
        if (profile != null) {
            SourceAccountingLine acctLine;
            if (form.getNewSourceLine() != null) {
                acctLine = (TemSourceAccountingLine)form.getNewSourceLine();
                acctLine.setChartOfAccountsCode(profile.getDefaultChartCode());
                acctLine.setAccountNumber(profile.getDefaultAccount());
                acctLine.setSubAccountNumber(profile.getDefaultSubAccount());
                acctLine.setProjectCode(profile.getDefaultProjectCode());
            }
            if (form.getAccountDistributionnewSourceLine() != null) {
                acctLine = form.getAccountDistributionnewSourceLine();
                acctLine.setChartOfAccountsCode(profile.getDefaultChartCode());
                acctLine.setAccountNumber(profile.getDefaultAccount());
                acctLine.setSubAccountNumber(profile.getDefaultSubAccount());
                acctLine.setProjectCode(profile.getDefaultProjectCode());
            }
        }
    }

    protected String getResolvedUrlForDocumentType(String documentType) {
        DocumentType docType = this.getDocumentTypeService().getDocumentTypeByName(documentType);
        return docType.getResolvedDocumentHandlerUrl();
    }

    protected String buildNewReimbursementUrl(TravelDocument travelDoc) {
        Properties props = new Properties();
        props.put("travelDocumentIdentifier", travelDoc.getTravelDocumentIdentifier());
        props.put("docTypeName", "TR");
        props.put("command", "initiate");
        String docUrlBase = this.getResolvedUrlForDocumentType("TR");
        String url = UrlFactory.parameterizeUrl((String)docUrlBase, (Properties)props);
        return url;
    }

    class TravelMvcWrapperInvocationHandler<MvcClass>
    implements InvocationHandler {
        private MvcClass mvcObj;

        public TravelMvcWrapperInvocationHandler(MvcClass mvcObj) {
            this.mvcObj = mvcObj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            return method.invoke(this.mvcObj, args);
        }
    }
}

