/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.businessobject.Attendee;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.service.TravelEntertainmentDocumentService;
import org.kuali.kfs.module.tem.document.web.bean.TravelEntertainmentMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.TravelActionBase;
import org.kuali.kfs.module.tem.document.web.struts.TravelEntertainmentForm;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.pdf.Coversheet;
import org.kuali.kfs.module.tem.report.EntertainmentHostCertificationReport;
import org.kuali.kfs.module.tem.report.NonEmployeeCertificationReport;
import org.kuali.kfs.module.tem.report.service.NonEmployeeCertificationReportService;
import org.kuali.kfs.module.tem.report.service.TravelEntertainmentHostCertificationService;
import org.kuali.kfs.module.tem.report.util.BarcodeHelper;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class TravelEntertainmentAction
extends TravelActionBase {
    public static Logger LOG = Logger.getLogger(TravelEntertainmentAction.class);
    public static final String[] ATTENDEE_ATTRIBUTE_NAMES = new String[]{"attendeeType", "company", "title", "name"};
    public static final Integer[] MAX_LENGTH = new Integer[]{10, 40, 40, 40};

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward retval = super.docHandler(mapping, form, request, response);
        TravelEntertainmentForm entForm = (TravelEntertainmentForm)form;
        TravelEntertainmentDocument document = entForm.getEntertainmentDocument();
        this.initializeNewAttendeeLines(entForm.getNewAttendeeLines(), document.getAttendee());
        return retval;
    }

    @Override
    protected void createDocument(KualiDocumentFormBase form) throws WorkflowException {
        super.createDocument(form);
        TravelEntertainmentForm entForm = (TravelEntertainmentForm)form;
        TravelEntertainmentDocument document = entForm.getEntertainmentDocument();
        String identifierStr = entForm.getTravelDocumentIdentifier();
        String fromDocumentNumber = entForm.getFromDocumentNumber();
        if (!StringUtils.isBlank((String)identifierStr) && !StringUtils.isBlank((String)fromDocumentNumber)) {
            LOG.debug((Object)("Creating reimbursement for document number " + identifierStr));
            document.setTravelDocumentIdentifier(identifierStr);
            TravelEntertainmentDocument travelDocument = (TravelEntertainmentDocument)this.getDocumentService().getByDocumentHeaderId(fromDocumentNumber);
            LOG.debug((Object)("Setting traveler with id " + travelDocument.getTravelerDetailId()));
            document.setTravelerDetailId(travelDocument.getTravelerDetailId());
            document.refreshReferenceObject("traveler");
            LOG.debug((Object)("Traveler is " + (Object)((Object)document.getTraveler()) + " with customer number " + document.getTraveler().getCustomerNumber()));
            if (document.getTraveler().getPrincipalId() != null) {
                document.getTraveler().setPrincipalName(this.getPersonService().getPerson(document.getTraveler().getPrincipalId()).getPrincipalName());
            }
            document.setHostProfileId(travelDocument.getHostProfileId());
            document.setHostName(travelDocument.getHostName());
            document.setHostAsPayee(travelDocument.getHostAsPayee());
            document.setEventTitle(travelDocument.getEventTitle());
            document.setPurposeCode(travelDocument.getPurposeCode());
            document.setTripBegin(travelDocument.getTripBegin());
            document.setTripEnd(travelDocument.getTripEnd());
            document.setSpouseIncluded(travelDocument.getSpouseIncluded());
            document.setDescription(travelDocument.getDescription());
            document.setAttendeeListAttached(travelDocument.getAttendeeListAttached());
            document.setAttendee(travelDocument.getAttendee());
            document.setNumberOfAttendees(travelDocument.getNumberOfAttendees());
            document.setPrimaryDestinationId(travelDocument.getPrimaryDestinationId());
            document.setPaymentMethod(travelDocument.getPaymentMethod());
            document.setExpenseLimit(travelDocument.getExpenseLimit());
            document.configureTraveler(travelDocument.getTemProfileId(), travelDocument.getTraveler());
            document.getDocumentHeader().setOrganizationDocumentNumber(travelDocument.getDocumentHeader().getOrganizationDocumentNumber());
            document.updatePayeeTypeForReimbursable();
            AccountingDocumentRelationship relationship = this.buildRelationshipToProgenitorDocument(travelDocument, document);
            this.getBusinessObjectService().save((PersistableBusinessObject)relationship);
        } else {
            document.setTripProgenitor(true);
        }
        this.initializeAssignAccounts(entForm);
    }

    @Override
    protected void loadDocument(KualiDocumentFormBase form) throws WorkflowException {
        super.loadDocument(form);
        TravelEntertainmentForm entForm = (TravelEntertainmentForm)form;
        TravelEntertainmentDocument document = entForm.getEntertainmentDocument();
        this.refreshCollectionsFor(document);
        entForm.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(entForm.getTravelDocument()));
        this.initializeAssignAccounts(entForm);
    }

    protected void populateFromPreviousENTDoc(TravelEntertainmentDocument document, String temDocId) {
        TravelEntertainmentDocument entDocument = (TravelEntertainmentDocument)this.getBusinessObjectService().findBySinglePrimaryKey(TravelEntertainmentDocument.class, (Object)temDocId);
        document.setTravelerDetailId(entDocument.getTravelerDetailId());
        document.refreshReferenceObject("traveler");
        if (document.getAttendee() != null) {
            document.setAttendee(entDocument.getAttendee());
        }
        if (document.getTraveler() != null) {
            document.setTraveler(entDocument.getTraveler());
        }
        document.setHostProfileId(entDocument.getHostProfileId());
        document.setTemProfileId(entDocument.getTemProfileId());
        document.setEventTitle(entDocument.getEventTitle());
        document.setPurposeCode(entDocument.getPurposeCode());
        document.setPaymentMethod(entDocument.getPaymentMethod());
        document.setTripBegin(entDocument.getTripBegin());
        document.setTripEnd(entDocument.getTripEnd());
        document.setSpouseIncluded(entDocument.getSpouseIncluded());
        document.setDescription(entDocument.getDescription());
        document.updatePayeeTypeForReimbursable();
        try {
            WorkflowDocument entDocWorkflowDocument = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).loadWorkflowDocument(entDocument.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
            entDocument.getDocumentHeader().setWorkflowDocument(entDocWorkflowDocument);
            AccountingDocumentRelationship relationship = this.buildRelationshipToProgenitorDocument(entDocument, document);
            this.getBusinessObjectService().save((PersistableBusinessObject)relationship);
        }
        catch (WorkflowException we) {
            throw new RuntimeException("Could not load workflow document for old entertainment document " + temDocId, we);
        }
        List notes = this.getNoteService().getByRemoteObjectId(entDocument.getNoteTarget().getObjectId());
        document.setNotes(notes);
    }

    protected void initializeNewAttendeeLines(List<Attendee> newAttendeeLines, List<Attendee> attendees) {
        for (Attendee attendee : attendees) {
            if (!ObjectUtils.isNull((Object)((Object)attendee))) continue;
            Attendee newAttendeeLine = new Attendee();
            newAttendeeLine.setAttendeeType(attendee.getAttendeeType());
            newAttendeeLine.setCompany(attendee.getCompany());
            newAttendeeLine.setName(attendee.getName());
            newAttendeeLine.setTitle(attendee.getTitle());
            newAttendeeLines.add(newAttendeeLine);
        }
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward retval = super.execute(mapping, form, request, response);
        TravelEntertainmentForm entForm = (TravelEntertainmentForm)form;
        TravelEntertainmentDocument document = (TravelEntertainmentDocument)((TravelEntertainmentForm)form).getDocument();
        String travelIdentifier = document.getTravelDocumentIdentifier();
        this.initializeNames(entForm, document);
        this.setButtonPermissions(entForm);
        if (ObjectUtils.isNotNull(document.getActualExpenses())) {
            document.enableExpenseTypeSpecificFields(document.getActualExpenses());
        }
        if (!this.getCalculateIgnoreList().contains(entForm.getMethodToCall())) {
            this.recalculateTripDetailTotalOnly(mapping, form, request, response);
        }
        this.refreshRelatedDocuments(entForm);
        this.showAccountDistribution(request, (Document)document);
        request.setAttribute("showReports", (Object)(!document.getDocumentHeader().getWorkflowDocument().isInitiated() ? 1 : 0));
        entForm.setCanPrintHostCertification(document.canShowHostCertification());
        KualiDecimal paymentTotal = document.getPaymentAmount();
        if (paymentTotal != null && !ObjectUtils.isNull((Object)((Object)document.getTravelPayment()))) {
            document.getTravelPayment().setCheckTotalAmount(paymentTotal);
        }
        if (entForm.getAccountDistributionsourceAccountingLines() == null || entForm.getAccountDistributionsourceAccountingLines().isEmpty()) {
            this.initializeAssignAccounts(entForm);
        }
        return retval;
    }

    private void initializeNames(TravelEntertainmentForm entForm, TravelEntertainmentDocument document) {
        if (document.getHostProfile() != null) {
            document.setHostName(document.getHostProfile().getLastName() + "," + document.getHostProfile().getFirstName() + " " + (document.getHostProfile().getMiddleName() == null ? " " : document.getHostProfile().getMiddleName()));
        }
        entForm.getNewAttendeeLines().get(0).setName(this.getTravelerCompleteName(document.getAttendeeDetail()));
    }

    private String getTravelerCompleteName(TravelerDetail travelerdetail) {
        String completeName = "";
        if (this.validateTravelerDetailName(travelerdetail)) {
            completeName = travelerdetail.getLastName() + "," + travelerdetail.getFirstName() + " " + (travelerdetail.getMiddleName() == null ? " " : travelerdetail.getMiddleName());
        }
        return completeName;
    }

    private boolean validateTravelerDetailName(TravelerDetail travelerdetail) {
        if (travelerdetail == null) {
            return false;
        }
        if (travelerdetail.getLastName() == null) {
            return false;
        }
        if (travelerdetail.getFirstName() == null) {
            return false;
        }
        return !travelerdetail.getLastName().equals("") || !travelerdetail.getFirstName().equals("");
    }

    public ActionForward recalculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.recalculateTripDetailTotal(mapping, form, request, response);
    }

    protected void refreshCollectionsFor(TravelEntertainmentDocument entDoc) {
        if (!entDoc.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            LOG.debug((Object)"Refreshing objects in entertainment document");
            entDoc.refreshReferenceObject("traveler");
            entDoc.refreshReferenceObject("actualExpenses");
            entDoc.refreshReferenceObject("specialCircumstances");
        }
    }

    @Override
    protected void performRequesterRefresh(TravelDocument document, TravelFormBase travelForm, HttpServletRequest request) {
        TravelEntertainmentDocument entDoc = (TravelEntertainmentDocument)document;
        if (entDoc.getHostAsPayee().booleanValue()) {
            entDoc.setHostName(document.getTraveler().getFirstName() + " " + document.getTraveler().getLastName());
        } else {
            entDoc.setHostName("");
        }
        entDoc.updatePayeeTypeForReimbursable();
        this.updateAccountsWithNewProfile(travelForm, document.getTemProfile());
    }

    public ActionForward printCoversheet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelEntertainmentForm entForm = (TravelEntertainmentForm)form;
        String documentNumber = request.getParameter("documentNumber");
        if (documentNumber != null && !documentNumber.isEmpty()) {
            entForm.setDocument((Document)this.getEntertainmentDocumentService().find(documentNumber));
        }
        TravelEntertainmentDocument document = entForm.getEntertainmentDocument();
        Coversheet cover = this.getEntertainmentDocumentService().generateCoversheetFor(document);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        cover.print(stream);
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)stream, (String)String.format("%s_cover_sheet.pdf", document.getTravelDocumentIdentifier()));
        return null;
    }

    public ActionForward viewNonEmployeeForms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelEntertainmentForm entForm = (TravelEntertainmentForm)form;
        entForm.setDocument((Document)this.getEntertainmentDocumentService().find(request.getParameter("documentNumber")));
        TravelEntertainmentDocument entertainment = entForm.getEntertainmentDocument();
        NonEmployeeCertificationReport report = this.getNonEmployeeCertificationReportService().buildReport(entertainment);
        BarcodeHelper barcode = new BarcodeHelper();
        report.setBarcodeImage(barcode.generateBarcodeImage(entertainment.getDocumentNumber()));
        File reportFile = this.getNonEmployeeCertificationReportService().generateReport(report);
        StringBuilder fileName = new StringBuilder();
        fileName.append(entertainment.getTravelDocumentIdentifier());
        fileName.append("_Non_Employee_Certification");
        fileName.append(".pdf");
        if (reportFile.length() == 0L) {
            return mapping.findForward("basic");
        }
        this.displayPDF(request, response, reportFile, fileName);
        return null;
    }

    public ActionForward viewEntertainmentCertification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelEntertainmentForm entForm = (TravelEntertainmentForm)form;
        String documentNumber = request.getParameter("documentNumber");
        if (documentNumber != null && !documentNumber.isEmpty()) {
            entForm.setDocument((Document)this.getEntertainmentDocumentService().find(documentNumber));
        }
        TravelEntertainmentDocument document = entForm.getEntertainmentDocument();
        entForm.setDocument((Document)this.getEntertainmentDocumentService().find(request.getParameter("documentNumber")));
        EntertainmentHostCertificationReport report = this.getEntertainmentHostCertificationService().buildReport(document);
        BarcodeHelper barcode = new BarcodeHelper();
        report.setBarcodeImage(barcode.generateBarcodeImage(document.getDocumentNumber()));
        File reportFile = this.getEntertainmentHostCertificationService().generateEntertainmentHostCertReport(report);
        StringBuilder fileName = new StringBuilder();
        fileName.append(document.getTravelDocumentIdentifier());
        fileName.append("_Entertainment_Certification");
        fileName.append(".pdf");
        if (reportFile.length() == 0L) {
            return mapping.findForward("basic");
        }
        this.displayPDF(request, response, reportFile, fileName);
        return null;
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelEntertainmentForm entertainment = (TravelEntertainmentForm)form;
        TravelDocument document = entertainment.getTravelDocument();
        document.getTraveler().getEmergencyContacts().clear();
        return super.route(mapping, form, request, response);
    }

    public ActionForward addAttendeeLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelEntertainmentMvcWrapperBean mvcWrapper = (TravelEntertainmentMvcWrapperBean)this.newMvcDelegate(form);
        mvcWrapper.setNewAttendeeLine(mvcWrapper.getNewAttendeeLines().get(this.getSelectedLine(request)));
        travelForm.getObservable().notifyObservers(mvcWrapper);
        return mapping.findForward("basic");
    }

    public ActionForward deleteAttendeeLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelForm = (TravelFormBase)form;
        TravelMvcWrapperBean mvcWrapper = (TravelMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, this.getSelectedLine(request)});
        return mapping.findForward("basic");
    }

    public ActionForward importAttendees(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelEntertainmentForm travelForm = (TravelEntertainmentForm)form;
        TravelEntertainmentMvcWrapperBean mvcWrapper = (TravelEntertainmentMvcWrapperBean)this.newMvcDelegate(form);
        travelForm.getObservable().notifyObservers(new Object[]{mvcWrapper, new String(travelForm.getAttendeesImportFile().getFileData())});
        return mapping.findForward("basic");
    }

    public ActionForward newEntertainment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelEntertainmentDocument entDoc = ((TravelEntertainmentForm)form).getEntertainmentDocument();
        String url = this.buildNewEntertainmentUrl(entDoc);
        return new ActionForward(url, true);
    }

    protected String buildNewEntertainmentUrl(TravelEntertainmentDocument entDoc) {
        Properties props = new Properties();
        props.put("travelDocumentIdentifier", entDoc.getTravelDocumentIdentifier());
        props.put("docTypeName", "ENT");
        props.put("fromDocumentNumber", entDoc.getDocumentNumber());
        props.put("command", "initiate");
        String docUrlBase = this.getResolvedUrlForDocumentType("ENT");
        String url = UrlFactory.parameterizeUrl((String)docUrlBase, (Properties)props);
        return url;
    }

    protected void setButtonPermissions(TravelEntertainmentForm form) {
        this.setCanCalculate(form);
    }

    public ActionForward downloadBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.downloadBOAttachment(mapping, form, request, response);
    }

    protected void setContactMasking(TravelEntertainmentForm entForm) {
        entForm.setCanUnmask(entForm.isUserDocumentInitiator());
    }

    protected TravelEntertainmentHostCertificationService getEntertainmentHostCertificationService() {
        return (TravelEntertainmentHostCertificationService)SpringContext.getBean(TravelEntertainmentHostCertificationService.class);
    }

    protected TravelEntertainmentDocumentService getEntertainmentDocumentService() {
        return (TravelEntertainmentDocumentService)SpringContext.getBean(TravelEntertainmentDocumentService.class);
    }

    protected NonEmployeeCertificationReportService getNonEmployeeCertificationReportService() {
        return (NonEmployeeCertificationReportService)SpringContext.getBean(NonEmployeeCertificationReportService.class);
    }

    @Override
    protected Class<? extends TravelMvcWrapperBean> getMvcWrapperInterface() {
        return TravelEntertainmentMvcWrapperBean.class;
    }
}

