/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.document.TravelRelocationDocument;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelReimbursementService;
import org.kuali.kfs.module.tem.document.web.bean.TravelRelocationMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.PersonService;

public class TravelRelocationForm
extends TravelFormBase
implements TravelRelocationMvcWrapperBean {
    public static Logger LOG = Logger.getLogger(TravelRelocationForm.class);
    private List<Serializable> history;
    private List<AccountingDistribution> distribution;
    private Date startDate;
    private Date endDate;
    private boolean canReturn;
    private boolean canCertify;
    private boolean canUnmask = false;
    private String travelDocumentIdentifier;

    @Override
    public void populate(HttpServletRequest request) {
        Timestamp startDateIn = this.getTravelRelocationDocument().getTripBegin();
        Timestamp endDateIn = this.getTravelRelocationDocument().getTripEnd();
        super.populate(request);
        Timestamp currentStart = this.getTravelRelocationDocument().getTripBegin();
        Timestamp currentEnd = this.getTravelRelocationDocument().getTripEnd();
        if (currentStart != null) {
            this.setStartDate(currentStart);
        }
        if (currentEnd != null) {
            this.setEndDate(currentEnd);
        }
    }

    protected Map<String, ExtraButton> createButtonsMap() {
        HashMap<String, ExtraButton> result = new HashMap<String, ExtraButton>();
        ExtraButton newRelocationButton = new ExtraButton();
        newRelocationButton.setExtraButtonProperty("methodToCall.newRelocation");
        newRelocationButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_newrelocation.png");
        newRelocationButton.setExtraButtonAltText("New Relocation");
        result.put(newRelocationButton.getExtraButtonProperty(), newRelocationButton);
        result.putAll(this.createPaymentExtraButtonMap());
        return result;
    }

    @Override
    public List<ExtraButton> getExtraButtons() {
        super.getExtraButtons();
        Map<String, ExtraButton> buttonsMap = this.createButtonsMap();
        LOG.debug((Object)"Creating button map");
        if (!((TravelDocumentService)SpringContext.getBean(TravelDocumentService.class)).isUnsuccessful(this.getTravelDocument()) && this.getTravelRelocationDocument().canPayDVToVendor()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.payDVToVendor"));
        }
        if (this.getDocumentActions().keySet().contains("canNewRelocation")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.newRelocation"));
        }
        return this.extraButtons;
    }

    @Override
    public boolean isDefaultOpenPaymentInfoTab() {
        String appDocStatus = this.getDocument().getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus();
        if ("Awaiting Moving And Relocation Manager Review".equals(appDocStatus)) {
            return true;
        }
        return super.isDefaultOpenPaymentInfoTab();
    }

    @Override
    public boolean canCertify() {
        return this.canCertify;
    }

    @Override
    public boolean getCanCertify() {
        return this.canCertify;
    }

    @Override
    public void setCanCertify(boolean canCertify) {
        this.canCertify = canCertify;
    }

    @Override
    public TravelRelocationDocument getTravelRelocationDocument() {
        return (TravelRelocationDocument)this.getDocument();
    }

    @Override
    protected String getDocumentIdentifierFieldName() {
        return "travelDocumentIdentifier";
    }

    protected String getDefaultDocumentTypeName() {
        return "RELO";
    }

    @Override
    public List<Serializable> getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(List<Serializable> history) {
        this.history = history;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    protected TravelService getTravelService() {
        return (TravelService)SpringContext.getBean(TravelService.class);
    }

    protected TravelReimbursementService getTravelReimbursementService() {
        return (TravelReimbursementService)SpringContext.getBean(TravelReimbursementService.class);
    }

    public PersonService getPersonService() {
        return (PersonService)SpringContext.getBean(PersonService.class);
    }

    protected TravelAuthorizationService getTravelAuthorizationService() {
        return (TravelAuthorizationService)SpringContext.getBean(TravelAuthorizationService.class);
    }

    @Override
    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    public boolean isCanUnmask() {
        return this.canUnmask;
    }

    public void setCanUnmask(boolean canUnmask) {
        this.canUnmask = canUnmask;
    }

    @Override
    public String getTravelPaymentFormAction() {
        return "temTravelRelocation";
    }

    public String getTravelDocumentIdentifier() {
        return this.travelDocumentIdentifier;
    }

    public void setTravelDocumentIdentifier(String travelDocumentIdentifier) {
        this.travelDocumentIdentifier = travelDocumentIdentifier;
    }
}

