/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.workflow;

import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.workflow.TEMSecurityAttribute;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kim.api.identity.Person;

public class TravelAuthorizationDocumentSecurityAttribute
extends TEMSecurityAttribute {
    private DocumentHelperService documentHelperService;
    private DocumentService documentService;

    @Override
    public boolean isAuthorizedForDocument(String principalId, Document document) {
        boolean authorized = super.isAuthorizedForDocument(principalId, document) && this.canOpen(GlobalVariables.getUserSession().getPerson(), document.getDocumentTypeName(), document.getDocumentId()) != false;
        TravelDocument travelDocument = this.getDocument(document.getDocumentId());
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean arrangerAccess = true;
        if (!user.getPrincipalId().equals(travelDocument.getTraveler().getPrincipalId())) {
            arrangerAccess = this.getTemRoleService().isTravelArranger(user, "", travelDocument.getTemProfileId().toString(), "TR");
        }
        return authorized && arrangerAccess;
    }

    protected TemRoleService getTemRoleService() {
        return (TemRoleService)SpringContext.getBean(TemRoleService.class);
    }
}

