/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report.service.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.report.ExpenseSummaryReport;
import org.kuali.kfs.module.tem.report.service.ExpenseSummaryReportService;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ExpenseSummaryReportServiceImpl
implements ExpenseSummaryReportService {
    public static Logger LOG = Logger.getLogger(ExpenseSummaryReportServiceImpl.class);
    protected ConfigurationService configurationService;
    protected ParameterService parameterService;
    protected PersonService personService;
    protected TravelAuthorizationService travelAuthorizationService;
    protected AccountingDistributionService accountingDistributionService;
    protected TravelDocumentService travelDocumentService;
    protected DateTimeService dateTimeService;

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.configurationService = ConfigurationService2;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Override
    public ExpenseSummaryReport buildReport(TravelDocument travelDocument) {
        List<AccountingDistribution> accountingDistributions;
        Object ta;
        boolean showTAEstimate;
        LOG.info((Object)"Building report objects");
        ExpenseSummaryReport retval = new ExpenseSummaryReport();
        if (!ObjectUtils.isNull((Object)((Object)travelDocument.getTraveler()))) {
            retval.setTraveler(travelDocument.getTraveler().getFirstName() + " " + travelDocument.getTraveler().getLastName());
        }
        String initiatorId = travelDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        Person initiator = this.getPersonService().getPerson(initiatorId);
        retval.setInitiator(initiator.getFirstName() + " " + initiator.getLastName());
        try {
            retval.setBeginDate(travelDocument.getTripBegin() != null ? this.dateTimeService.convertToSqlDate(travelDocument.getTripBegin()) : new Date());
            retval.setEndDate(travelDocument.getTripEnd() != null ? this.dateTimeService.convertToSqlDate(travelDocument.getTripEnd()) : new Date());
        }
        catch (ParseException pe) {
            LOG.error((Object)("error while parsing date " + pe));
        }
        retval.setLocations(travelDocument.getPrimaryDestinationName());
        retval.setPurpose(travelDocument.getReportPurpose() == null ? "" : travelDocument.getReportPurpose());
        retval.setTripId(travelDocument.getTravelDocumentIdentifier() + "");
        retval.setInstitution(this.getParameterService().getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "INSTITUTION_NAME"));
        ArrayList<ExpenseSummaryReport.Detail> expenses = new ArrayList<ExpenseSummaryReport.Detail>();
        ArrayList<ExpenseSummaryReport.Detail> summary = new ArrayList<ExpenseSummaryReport.Detail>();
        ArrayList<ExpenseSummaryReport.Detail> perDiemMilageList = new ArrayList<ExpenseSummaryReport.Detail>();
        ArrayList<ExpenseSummaryReport.Detail> perDiemLodgingList = new ArrayList<ExpenseSummaryReport.Detail>();
        ArrayList<ExpenseSummaryReport.Detail> perDiemMealList = new ArrayList<ExpenseSummaryReport.Detail>();
        for (PerDiemExpense perDiemExpense : travelDocument.getPerDiemExpenses()) {
            if (perDiemExpense.getMileageTotal().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                ExpenseSummaryReport.Detail perDiemMilage = new ExpenseSummaryReport.Detail("Per Diem Milage", "TRANSPORTATION", perDiemExpense.getMileageTotal(), perDiemExpense.getMileageDate());
                perDiemMilageList.add(perDiemMilage);
            }
            if (perDiemExpense.getLodgingTotal().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                ExpenseSummaryReport.Detail perDiemLodging = new ExpenseSummaryReport.Detail("Per Diem Lodging", "LODGING", perDiemExpense.getLodgingTotal(), perDiemExpense.getMileageDate());
                perDiemLodgingList.add(perDiemLodging);
            }
            if (!perDiemExpense.getMealsAndIncidentals().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            ExpenseSummaryReport.Detail perDiemMeal = new ExpenseSummaryReport.Detail("Per Diem Meals", "MEALS", perDiemExpense.getMealsAndIncidentals(), perDiemExpense.getMileageDate());
            perDiemMealList.add(perDiemMeal);
        }
        if (perDiemMilageList.size() > 0) {
            expenses.addAll(perDiemMilageList);
        }
        if (perDiemLodgingList.size() > 0) {
            expenses.addAll(perDiemLodgingList);
        }
        if (perDiemMealList.size() > 0) {
            expenses.addAll(perDiemMealList);
        }
        LOG.info((Object)"Adding details from other expenses");
        LOG.debug((Object)("There are " + travelDocument.getActualExpenses().size() + " other expenses"));
        for (ActualExpense expense : travelDocument.getActualExpenses()) {
            expense.refreshReferenceObject("expenseTypeObjectCode");
            if (expense.getNonReimbursable().booleanValue()) {
                LOG.debug((Object)"Adding detail for non reimbursable item");
                expenses.add(new ExpenseSummaryReport.Detail(expense.getExpenseTypeObjectCode().getExpenseType().getName(), "NONREIMBURSABLE", expense.getConvertedAmount(), expense.getExpenseDate()));
            }
            String expenseType = "OTHER";
            if (this.isTransportationExpense(expense)) {
                expenseType = "TRANSPORTATION";
            } else if (this.isLodgingExpense(expense)) {
                expenseType = "LODGING";
            } else if (this.isMealsExpense(expense)) {
                expenseType = "MEALS";
            }
            expenses.add(new ExpenseSummaryReport.Detail(expense.getExpenseTypeObjectCode().getExpenseType().getName(), expenseType, expense.getConvertedAmount(), expense.getExpenseDate()));
        }
        KualiDecimal expenseLimit = travelDocument.getExpenseLimit() == null ? KualiDecimal.ZERO : travelDocument.getExpenseLimit();
        KualiDecimal manualPerDiemAdjustment = travelDocument.getPerDiemAdjustment();
        KualiDecimal ctsTotal = travelDocument.getCTSTotal();
        KualiDecimal corporateCardTotal = travelDocument.getCorporateCardTotal();
        KualiDecimal maxExpense = travelDocument.getReimbursableTotal();
        String totalExpenseName = "Owed to Payee";
        KualiDecimal owed = maxExpense;
        boolean isTR = travelDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName().equals("TR");
        KualiDecimal advanceTotal = KualiDecimal.ZERO;
        if (isTR) {
            advanceTotal = this.getTravelDocumentService().getAdvancesTotalFor(travelDocument);
            owed = (KualiDecimal)maxExpense.subtract((AbstractKualiDecimal)advanceTotal);
            if (advanceTotal.isGreaterThan((AbstractKualiDecimal)maxExpense)) {
                totalExpenseName = "Owed to Institution";
                owed = (KualiDecimal)advanceTotal.subtract((AbstractKualiDecimal)maxExpense);
            }
        }
        summary.add(new ExpenseSummaryReport.Detail("Expense Total", "SUMMARY", travelDocument.getDocumentGrandTotal(), travelDocument.getTripBegin()));
        summary.add(new ExpenseSummaryReport.Detail("Manual Per Diem Adj", "SUMMARY", manualPerDiemAdjustment, travelDocument.getTripBegin()));
        summary.add(new ExpenseSummaryReport.Detail("Expense Limit", "SUMMARY", travelDocument.getExpenseLimit(), travelDocument.getTripBegin()));
        summary.add(new ExpenseSummaryReport.Detail("Less CTS Charges", "SUMMARY", ctsTotal, travelDocument.getTripBegin()));
        summary.add(new ExpenseSummaryReport.Detail("Corp Credit Card Charges", "SUMMARY", corporateCardTotal, travelDocument.getTripBegin()));
        if (isTR) {
            summary.add(new ExpenseSummaryReport.Detail("Less Advances", "SUMMARY", advanceTotal, travelDocument.getTripBegin()));
        }
        summary.add(new ExpenseSummaryReport.Detail(totalExpenseName, "SUMMARY", owed, travelDocument.getTripBegin()));
        if (isTR && (showTAEstimate = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "DISPLAY_TRAVEL_AUTHORIZATION_ESTIMATE_IN_SUMMARY_REPORT_IND").booleanValue()) && (ta = this.getTravelDocumentService().findCurrentTravelAuthorization(travelDocument)) != null) {
            summary.add(new ExpenseSummaryReport.Detail("Expense Total Estimate", "SUMMARY", ta.getDocumentGrandTotal(), ta.getTripBegin()));
        }
        if ((accountingDistributions = this.getAccountingDistributionService().buildDistributionFrom(travelDocument)) != null) {
            for (AccountingDistribution ad : accountingDistributions) {
                summary.add(new ExpenseSummaryReport.Detail("Distribution: " + ad.getObjectCode(), "OTHER", (KualiDecimal)ad.getSubTotal().abs(), travelDocument.getTripBegin()));
            }
        }
        travelDocument.refreshReferenceObject("sourceAccountingLines");
        List sourceAccountingLines = travelDocument.getSourceAccountingLines();
        for (TemSourceAccountingLine account : sourceAccountingLines) {
            String accountDetails = account.getAccountNumber() + "-" + account.getFinancialObjectCode();
            summary.add(new ExpenseSummaryReport.Detail("Account: " + accountDetails, "OTHER", account.getAmount(), travelDocument.getTripBegin()));
        }
        if (summary.size() > 0) {
            retval.setSummary(summary);
        }
        if (expenses.size() > 0) {
            retval.setData(expenses);
        }
        return retval;
    }

    protected boolean isTransportationExpense(ActualExpense expense) {
        LOG.debug((Object)("Checking if " + expense + " is a transportation "));
        return this.expenseTypeCodeMatchesParameter(expense.getExpenseTypeCode(), "TRANSPORTATION_TYPE_CODES");
    }

    protected boolean isMealsExpense(ActualExpense expense) {
        return this.getTravelDocumentService().isHostedMeal(expense);
    }

    protected boolean isLodgingExpense(ActualExpense expense) {
        LOG.debug((Object)("Checking if " + expense + " is a lodging "));
        return this.expenseTypeCodeMatchesParameter(expense.getExpenseTypeCode(), "LODGING_TYPE_CODES");
    }

    protected boolean expenseTypeCodeMatchesParameter(String expenseTypeCode, String parameter) {
        return this.getParameterService().getParameterValuesAsString(TravelReimbursementDocument.class, parameter).contains(expenseTypeCode);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public TravelAuthorizationService getTravelAuthorizationService() {
        return this.travelAuthorizationService;
    }

    public void setTravelAuthorizationService(TravelAuthorizationService travelAuthorizationService) {
        this.travelAuthorizationService = travelAuthorizationService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public AccountingDistributionService getAccountingDistributionService() {
        return this.accountingDistributionService;
    }

    public void setAccountingDistributionService(AccountingDistributionService accountingDistributionService) {
        this.accountingDistributionService = accountingDistributionService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

