/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CsvRecordFactory<RecordType> {
    public static Logger LOG = Logger.getLogger(CsvRecordFactory.class);
    final Class<RecordType> recordType;
    private Map<String, String> headerMap;

    public CsvRecordFactory(Class<RecordType> recordType) {
        this.recordType = recordType;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public RecordType newInstance(Map<String, List<Integer>> header, String[] record) throws Exception {
        return (RecordType)Proxy.newProxyInstance(this.recordType.getClassLoader(), new Class[]{this.recordType}, (InvocationHandler)new CsvRecordInvocationHandler(header, record));
    }

    public class CsvRecordInvocationHandler
    implements InvocationHandler {
        protected Map<String, List<Integer>> header;
        protected String[] line;

        public CsvRecordInvocationHandler(Map<String, List<Integer>> header, String[] record) {
            this.setHeader(header);
            this.setRecord(record);
        }

        protected void setRecord(String[] record) {
            this.line = record;
        }

        protected void setHeader(Map<String, List<Integer>> header) {
            this.header = header;
        }

        protected PropertyDescriptor propertyFor(PropertyDescriptor[] properties, Method method) {
            for (PropertyDescriptor property : properties) {
                if (!method.getName().equals(property.getReadMethod().getName())) continue;
                return property;
            }
            return null;
        }

        protected String headerFor(PropertyDescriptor property) {
            LOG.debug((Object)("Checking for header that matches property " + property.getName()));
            if (CsvRecordFactory.this.headerMap.size() < 1) {
                LOG.warn((Object)"Your header map is empty. Won't ever resolve any properties");
            }
            for (Map.Entry entry : CsvRecordFactory.this.headerMap.entrySet()) {
                LOG.debug((Object)("Checking " + (String)entry.getValue()));
                if (!property.getName().equalsIgnoreCase((String)entry.getValue()) || !this.header.containsKey(entry.getKey())) continue;
                return (String)entry.getKey();
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Object retval = null;
            PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors(CsvRecordFactory.this.recordType);
            PropertyDescriptor property = this.propertyFor(properties, method);
            String headerField = this.headerFor(property);
            List<Integer> columns = this.header.get(headerField);
            StringBuffer value = new StringBuffer();
            if (columns != null) {
                for (Integer column : columns) {
                    value.append(this.line[column]).append(" ");
                }
            }
            if (KualiDecimal.class.equals(method.getReturnType())) {
                if (value == null || StringUtils.isBlank((String)value.toString())) {
                    return KualiDecimal.ZERO;
                }
                retval = new KualiDecimal(this.convertToBigDecimal(value.toString().trim()));
            } else if (BigDecimal.class.equals(method.getReturnType())) {
                if (value == null || StringUtils.isBlank((String)value.toString())) {
                    return BigDecimal.ZERO;
                }
                retval = this.convertToBigDecimal(value.toString().trim());
            } else if (Boolean.class.equals(method.getReturnType()) || Boolean.TYPE.equals(method.getReturnType())) {
                retval = new Boolean(value.toString().trim());
                LOG.debug((Object)(headerField + " is " + retval));
            } else if (Date.class.equals(method.getReturnType())) {
                if (!StringUtils.isBlank((String)value.toString())) {
                    try {
                        retval = new Date(new SimpleDateFormat("MM/dd/yyyy").parse(value.toString().trim()).getTime());
                    }
                    catch (Exception exception) {}
                }
            } else {
                retval = value.toString().trim();
            }
            return retval;
        }

        public BigDecimal convertToBigDecimal(String toConvert) {
            if (StringUtils.isBlank((String)toConvert)) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal(StringUtils.replace((String)StringUtils.replace((String)toConvert, (String)"$", (String)""), (String)",", (String)""));
        }
    }
}

