/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileAddress;
import org.kuali.kfs.module.tem.businessobject.TemProfileEmergencyContact;
import org.kuali.kfs.module.tem.businessobject.TemProfileFromCustomer;
import org.kuali.kfs.module.tem.businessobject.TemProfileFromKimPerson;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.businessobject.TravelerDetailEmergencyContact;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.ChartOrgHolderImpl;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenship;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.IdentityManagementService;
import org.springframework.beans.BeanUtils;

public class TravelerServiceImpl
implements TravelerService {
    protected ParameterService parameterService;
    protected PersonService personService;
    protected IdentityManagementService identityManagementService;
    protected BusinessObjectService businessObjectService;
    protected DateTimeService dateTimeService;
    protected TemRoleService temRoleService;
    protected ChartService chartService;
    protected OrganizationService organizationService;
    protected RoleService roleService;
    protected AccountsReceivableModuleService accountsReceivableModuleService;
    protected static Logger LOG = Logger.getLogger(TravelerServiceImpl.class);

    @Override
    public TravelerDetail convertToTraveler(Person person) {
        TravelerDetail retval = new TravelerDetail();
        retval.setPrincipalId(person.getPrincipalId());
        retval.setPrincipalName(person.getPrincipalName());
        retval.setFirstName(person.getFirstName());
        retval.setLastName(person.getLastName());
        retval.setStreetAddressLine1(person.getAddressLine1());
        retval.setStreetAddressLine2(person.getAddressLine2());
        retval.setStateCode(person.getAddressStateProvinceCode());
        retval.setZipCode(person.getAddressPostalCode());
        retval.setCityName(person.getAddressCity());
        retval.setCountryCode(person.getAddressCountryCode());
        retval.setEmailAddress(person.getEmailAddress());
        retval.setPhoneNumber(person.getPhoneNumber());
        retval.setTravelerTypeCode("EMP");
        return retval;
    }

    @Override
    public boolean canIncludeProfileInSearch(TemProfile profile, String docType, Person user, boolean isProfileAdmin, boolean isAssignedArranger, boolean isOrgArranger, boolean isArrangerDoc, boolean isRiskManagement) {
        boolean canInclude = false;
        if (isArrangerDoc || isRiskManagement || user.getPrincipalId().equals(profile.getPrincipalId())) {
            return true;
        }
        if (isProfileAdmin || isOrgArranger) {
            String roleName = isOrgArranger ? "TEM Organization Profile Arranger" : "TEM Profile Administrator";
            canInclude |= this.isArrangeeByOrganizationByRole(user.getPrincipalId(), profile, roleName);
        }
        if (!canInclude && isAssignedArranger) {
            canInclude = ObjectUtils.isNotNull((Object)docType) ? (canInclude |= this.getTemRoleService().isTravelDocumentArrangerForProfile(docType, user.getPrincipalId(), profile.getProfileId())) : (canInclude |= this.getTemRoleService().isArrangerForProfile(user.getPrincipalId(), profile.getProfileId()));
        }
        return canInclude;
    }

    @Override
    public boolean isArrangeeByOrganization(String principalId, TemProfile profile) {
        return this.isArrangeeByOrganizationByRole(principalId, profile, "TEM Organization Profile Arranger") || this.isArrangeeByOrganizationByRole(principalId, profile, "TEM Profile Administrator");
    }

    protected boolean isArrangeeByOrganizationByRole(String principalId, TemProfile profile, String roleName) {
        Organization org = profile.getHomeDeptOrg();
        ChartOrgHolder chartOrg = this.getOrganizationForUser(principalId, roleName);
        if (ObjectUtils.isNotNull((Object)chartOrg)) {
            String roleChartOfAccountsCode = chartOrg.getChartOfAccountsCode();
            String roleOrganizationCode = chartOrg.getOrganizationCode();
            return this.isParentOrg(org.getChartOfAccountsCode(), org.getOrganizationCode(), roleChartOfAccountsCode, roleOrganizationCode, true);
        }
        return false;
    }

    @Override
    public void convertTemProfileToTravelerDetail(TemProfile profile, TravelerDetail detail) {
        if (profile != null) {
            if (detail.getId() == null) {
                SequenceAccessorService sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
                long id = sas.getNextAvailableSequenceNumber("TEM_TRAVELER_DTL_ID_SEQ");
                detail.setId((int)id);
            }
            detail.setFirstName(profile.getFirstName());
            detail.setLastName(profile.getLastName());
            detail.setStreetAddressLine1(profile.getTemProfileAddress().getStreetAddressLine1());
            detail.setStreetAddressLine2(profile.getTemProfileAddress().getStreetAddressLine2());
            detail.setStateCode(profile.getTemProfileAddress().getStateCode());
            detail.setCityName(profile.getTemProfileAddress().getCityName());
            detail.setZipCode(profile.getTemProfileAddress().getZipCode());
            detail.setCountryCode(profile.getTemProfileAddress().getCountryCode());
            detail.setPrincipalId(profile.getPrincipalId());
            if (ObjectUtils.isNotNull((Object)profile.getPrincipal())) {
                detail.setPrincipalName(profile.getPrincipal().getPrincipalName());
            } else {
                detail.setPrincipalName("");
            }
            detail.setCustomer(profile.getCustomer());
            detail.setTravelerType(profile.getTravelerType());
            detail.setTravelerTypeCode(profile.getTravelerTypeCode());
            detail.setCustomerNumber(profile.getCustomerNumber());
            detail.setEmailAddress(profile.getEmailAddress());
            detail.setPhoneNumber(profile.getPhoneNumber());
            detail.setDateOfBirth(profile.getDateOfBirth());
            detail.setGender(profile.getGender());
            detail.setCitizenship(profile.getCitizenship());
            detail.setDriversLicenseExpDate(profile.getDriversLicenseExpDate());
            detail.setDriversLicenseNumber(profile.getDriversLicenseNumber());
            detail.setDriversLicenseState(profile.getDriversLicenseState());
            detail.setNotifyTAFinal(profile.isNotifyTAFinal());
            detail.setNotifyTAStatusChange(profile.isNotifyTAStatusChange());
            detail.setNotifyTERFinal(profile.isNotifyTERFinal());
            detail.setNotifyTERStatusChange(profile.isNotifyTERStatusChange());
            detail.setNonResidentAlien(profile.getNonResidentAlien());
            detail.resetEmergencyContacts();
            if (ObjectUtils.isNotNull(profile.getEmergencyContacts())) {
                int count = 1;
                for (TemProfileEmergencyContact profileContact : profile.getEmergencyContacts()) {
                    TravelerDetailEmergencyContact contact = new TravelerDetailEmergencyContact(profileContact);
                    contact.setDocumentNumber(detail.getDocumentNumber());
                    contact.setFinancialDocumentLineNumber(count);
                    contact.setTravelerDetailId(detail.getId());
                    detail.getEmergencyContacts().add(contact);
                    ++count;
                }
            }
        }
    }

    @Override
    public TravelerDetail copyTravelerDetail(TravelerDetail travelerDetail, String documentNumber) {
        TravelerDetail newTravelerDetail = new TravelerDetail();
        BeanUtils.copyProperties((Object)((Object)travelerDetail), (Object)((Object)newTravelerDetail), (String[])new String[]{"dateOfBirth"});
        newTravelerDetail.setId(null);
        newTravelerDetail.setVersionNumber(null);
        newTravelerDetail.setDocumentNumber(documentNumber);
        newTravelerDetail.setEmergencyContacts(this.copyTravelerDetailEmergencyContact(travelerDetail.getEmergencyContacts(), documentNumber));
        return newTravelerDetail;
    }

    @Override
    public List<TravelerDetailEmergencyContact> copyTravelerDetailEmergencyContact(List<TravelerDetailEmergencyContact> emergencyContacts, String documentNumber) {
        ArrayList<TravelerDetailEmergencyContact> newEmergencyContacts = new ArrayList<TravelerDetailEmergencyContact>();
        if (emergencyContacts != null) {
            for (TravelerDetailEmergencyContact emergencyContact : emergencyContacts) {
                TravelerDetailEmergencyContact newEmergencyContact = new TravelerDetailEmergencyContact();
                BeanUtils.copyProperties((Object)((Object)emergencyContact), (Object)((Object)newEmergencyContact));
                newEmergencyContact.setDocumentNumber(documentNumber);
                newEmergencyContact.setVersionNumber(new Long(1L));
                newEmergencyContact.setObjectId(null);
                newEmergencyContact.setId(null);
                newEmergencyContacts.add(newEmergencyContact);
            }
        }
        return newEmergencyContacts;
    }

    @Override
    public TemProfileFromKimPerson convertToTemProfileFromKim(Person person) {
        TemProfileFromKimPerson retval = new TemProfileFromKimPerson();
        retval.setPrincipalId(person.getPrincipalId());
        retval.setEmployeeId(person.getEmployeeId());
        retval.setPrincipalName(person.getPrincipalName());
        retval.setEntityId(person.getEntityId());
        retval.setFirstName(person.getFirstNameUnmasked());
        retval.setMiddleName(person.getMiddleNameUnmasked());
        retval.setLastName(person.getLastNameUnmasked());
        retval.setEmailAddress(person.getEmailAddressUnmasked());
        retval.setPhoneNumber(person.getPhoneNumber());
        retval.setEmployeeStatusCode(person.getEmployeeStatusCode());
        retval.setEmployeeTypeCode(person.getEmployeeTypeCode());
        retval.setPrimaryDepartmentCode(person.getPrimaryDepartmentCode());
        retval.setCampusCode(person.getCampusCode());
        retval.setActive(person.isActive());
        return retval;
    }

    @Override
    public boolean isEmployee(TravelerDetail traveler) {
        String param = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "EMPLOYEE_TRAVELER_TYPE_CODES");
        List employeeTypes = StrTokenizer.getCSVInstance((String)param).getTokenList();
        return employeeTypes.contains(StringUtils.defaultString((String)traveler.getTravelerTypeCode()));
    }

    @Override
    public TravelerDetail convertToTraveler(AccountsReceivableCustomer customer) {
        TravelerDetail retval = new TravelerDetail();
        AccountsReceivableCustomerAddress address = this.getAddressFor(customer);
        String[] names = customer.getCustomerName().split(" ");
        String firstName = names[0];
        String lastName = names[names.length - 1];
        retval.setCustomerNumber(customer.getCustomerNumber());
        retval.refreshReferenceObject("customer");
        retval.setFirstName(firstName);
        retval.setLastName(lastName);
        retval.setStreetAddressLine1(address.getCustomerLine1StreetAddress());
        retval.setStreetAddressLine2(address.getCustomerLine2StreetAddress());
        retval.setStateCode(address.getCustomerStateCode());
        retval.setZipCode(address.getCustomerZipCode());
        retval.setCityName(address.getCustomerCityName());
        retval.setCountryCode(address.getCustomerCountryCode());
        retval.setEmailAddress(address.getCustomerEmailAddress());
        retval.setPhoneNumber(customer.getCustomerPhoneNumber());
        retval.setTravelerTypeCode("NON");
        return retval;
    }

    @Override
    public TemProfileFromCustomer convertToTemProfileFromCustomer(AccountsReceivableCustomer person) {
        TemProfileFromCustomer retval = new TemProfileFromCustomer();
        AccountsReceivableCustomerAddress address = this.getAddressFor(person);
        BeanUtils.copyProperties((Object)person, (Object)((Object)retval));
        BeanUtils.copyProperties((Object)address, (Object)((Object)retval));
        return retval;
    }

    protected AccountsReceivableCustomerAddress getAddressFor(AccountsReceivableCustomer customer) {
        return this.getAddressFor(customer, null);
    }

    protected AccountsReceivableCustomerAddress getAddressFor(AccountsReceivableCustomer customer, Integer addressId) {
        for (AccountsReceivableCustomerAddress address : customer.getAccountsReceivableCustomerAddresses()) {
            if (ObjectUtils.isNull((Object)addressId) && "P".equals(address.getCustomerAddressTypeCode())) {
                return address;
            }
            if (!address.getCustomerAddressIdentifier().equals(addressId)) continue;
            return address;
        }
        return null;
    }

    @Override
    public TemProfileAddress convertToTemProfileAddressFromCustomer(AccountsReceivableCustomerAddress customerAddress) {
        TemProfileAddress retval = new TemProfileAddress();
        retval.setStreetAddressLine1(customerAddress.getCustomerLine1StreetAddress());
        retval.setStreetAddressLine2(customerAddress.getCustomerLine2StreetAddress());
        retval.setStateCode(customerAddress.getCustomerStateCode());
        retval.setZipCode(customerAddress.getCustomerZipCode());
        retval.setCityName(customerAddress.getCustomerCityName());
        retval.setCountryCode(customerAddress.getCustomerCountryCode());
        retval.setCustomerNumber(customerAddress.getCustomerNumber());
        retval.setCustomerAddressIdentifier(customerAddress.getCustomerAddressIdentifier());
        return retval;
    }

    @Override
    public TemProfileAddress convertToTemProfileAddressFromKimAddress(EntityAddressContract address) {
        TemProfileAddress retval = new TemProfileAddress();
        retval.setStreetAddressLine1(address.getLine1());
        retval.setStreetAddressLine2(address.getLine2());
        retval.setStateCode(address.getStateProvinceCode());
        retval.setZipCode(address.getPostalCode());
        retval.setCityName(address.getCity());
        retval.setCountryCode(address.getCountryCode());
        return retval;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return this.personService;
    }

    @Override
    public void copyTemProfileToCustomer(TemProfile profile, AccountsReceivableCustomer customer) {
        String tempName = profile.getFirstName() + " " + (StringUtils.isEmpty((String)profile.getMiddleName()) ? "" : profile.getMiddleName() + " ") + profile.getLastName();
        if (tempName.length() > 40) {
            tempName = profile.getFirstName() + " " + profile.getLastName();
            while (tempName.length() > 40) {
                tempName = tempName.substring(0, tempName.length() - 1);
            }
        }
        customer.setCustomerName(tempName);
        customer.setCustomerEmailAddress(profile.getEmailAddress());
        customer.setCustomerPhoneNumber(profile.getPhoneNumber());
        AccountsReceivableCustomerAddress customerAddress = null;
        customerAddress = ObjectUtils.isNotNull((Object)((Object)profile.getTemProfileAddress())) && ObjectUtils.isNotNull((Object)profile.getTemProfileAddress().getCustomerAddressIdentifier()) ? this.getAddressFor(customer, profile.getTemProfileAddress().getCustomerAddressIdentifier()) : this.getAddressFor(customer);
        if (customerAddress == null) {
            customerAddress = this.getAccountsReceivableModuleService().createCustomerAddress();
            customerAddress.setCustomerAddressTypeCode("P");
            customerAddress.setCustomerAddressName(tempName);
            customer.setCustomerAddressChangeDate(this.dateTimeService.getCurrentSqlDate());
        } else if (this.compareAddress(customerAddress, profile)) {
            customer.setCustomerAddressChangeDate(this.dateTimeService.getCurrentSqlDate());
        }
        customerAddress.setCustomerLine1StreetAddress(profile.getTemProfileAddress().getStreetAddressLine1());
        customerAddress.setCustomerLine2StreetAddress(profile.getTemProfileAddress().getStreetAddressLine2());
        customerAddress.setCustomerCityName(profile.getTemProfileAddress().getCityName());
        customerAddress.setCustomerStateCode(profile.getTemProfileAddress().getStateCode());
        customerAddress.setCustomerZipCode(profile.getTemProfileAddress().getZipCode());
        customerAddress.setCustomerCountryCode(profile.getTemProfileAddress().getCountryCode());
        customerAddress.setCustomerEmailAddress(profile.getEmailAddress());
        if (customer.getAccountsReceivableCustomerAddresses() == null) {
            customer.setAccountsReceivableCustomerAddresses(new ArrayList());
        }
        if (customer.getAccountsReceivableCustomerAddresses().size() == 0) {
            List customerAddresses = customer.getAccountsReceivableCustomerAddresses();
            customerAddresses.add(customerAddress);
            customer.setAccountsReceivableCustomerAddresses(customerAddresses);
        }
        customer.setCustomerRecordAddDate(this.dateTimeService.getCurrentSqlDate());
        customer.setCustomerLastActivityDate(this.dateTimeService.getCurrentSqlDate());
        customer.setCustomerBirthDate(profile.getDateOfBirth());
    }

    @Override
    public void populateTemProfile(TemProfile profile) {
        if (profile != null) {
            if (!StringUtils.isBlank((String)profile.getPrincipalId())) {
                Person person = this.getPersonService().getPerson(profile.getPrincipalId());
                profile.setPrincipal(person);
                Entity kimEntity = this.identityManagementService.getEntityByPrincipalId(profile.getPrincipalId());
                profile.setKimEntityInfo(kimEntity);
                this.copyKimDataToTemProfile(profile, profile.getPrincipal(), profile.getKimEntityInfo());
            } else if (ObjectUtils.isNotNull((Object)profile.getCustomer())) {
                this.copyCustomerToTemProfile(profile, profile.getCustomer());
            }
        }
    }

    @Override
    public void copyCustomerToTemProfile(TemProfile profile, AccountsReceivableCustomer customer) {
        String[] customerNames = customer.getCustomerName().split(" ");
        if (customerNames.length == 1) {
            profile.setFirstName(customerNames[0]);
        } else if (customerNames.length == 2) {
            profile.setFirstName(customerNames[0]);
            profile.setLastName(customerNames[1]);
        } else if (customerNames.length == 3) {
            profile.setFirstName(customerNames[0]);
            profile.setMiddleName(customerNames[1]);
            profile.setLastName(customerNames[2]);
        } else {
            profile.setFirstName(customerNames[0]);
            profile.setMiddleName(customerNames[1]);
            profile.setLastName(customerNames[2]);
            for (int i = 3; i < customerNames.length; ++i) {
                profile.setLastName(profile.getLastName() + " " + customerNames[i]);
            }
        }
        AccountsReceivableCustomerAddress address = customer.getPrimaryAddress();
        TemProfileAddress profileAddress = new TemProfileAddress();
        if (ObjectUtils.isNotNull((Object)((Object)profile.getTemProfileAddress()))) {
            profileAddress = profile.getTemProfileAddress();
        }
        profileAddress.setProfileId(profile.getProfileId());
        profileAddress.setStreetAddressLine1(address.getCustomerLine1StreetAddress());
        profileAddress.setStreetAddressLine2(address.getCustomerLine2StreetAddress());
        profileAddress.setCityName(address.getCustomerCityName());
        profileAddress.setStateCode(address.getCustomerStateCode());
        profileAddress.setZipCode(address.getCustomerZipCode());
        profileAddress.setCountryCode(address.getCustomerCountryCode());
        profile.setTemProfileAddress(profileAddress);
        profile.setEmailAddress(address.getCustomerEmailAddress());
        profile.setPhoneNumber(customer.getCustomerPhoneNumber());
        profile.setEmployeeId("None");
    }

    @Override
    public void copyKimDataToTemProfile(TemProfile profile, Person principal, Entity kimEntity) {
        if (ObjectUtils.isNotNull((Object)kimEntity)) {
            profile.setFirstName(principal.getFirstName().toUpperCase());
            profile.setMiddleName(principal.getMiddleName().toUpperCase());
            profile.setLastName(principal.getLastName().toUpperCase());
        }
        TemProfileAddress profileAddress = new TemProfileAddress();
        if (ObjectUtils.isNotNull((Object)((Object)profile.getTemProfileAddress()))) {
            profileAddress = profile.getTemProfileAddress();
        }
        profileAddress.setProfileId(profile.getProfileId());
        profileAddress.setStreetAddressLine1(StringUtils.upperCase((String)principal.getAddressLine1Unmasked()));
        profileAddress.setStreetAddressLine2(StringUtils.upperCase((String)principal.getAddressLine2Unmasked()));
        profileAddress.setCityName(StringUtils.upperCase((String)principal.getAddressCity()));
        profileAddress.setStateCode(StringUtils.upperCase((String)principal.getAddressStateProvinceCodeUnmasked()));
        profileAddress.setZipCode(principal.getAddressPostalCodeUnmasked());
        profileAddress.setCountryCode(StringUtils.upperCase((String)principal.getAddressCountryCodeUnmasked()));
        profile.setTemProfileAddress(profileAddress);
        profile.setEmailAddress(StringUtils.upperCase((String)principal.getEmailAddressUnmasked()));
        profile.setPhoneNumber(principal.getPhoneNumberUnmasked());
        String[] primaryDeptCode = principal.getPrimaryDepartmentCode().split("-");
        if (primaryDeptCode != null && primaryDeptCode.length == 2) {
            profile.setHomeDeptChartOfAccountsCode(primaryDeptCode[0]);
            profile.setHomeDeptOrgCode(primaryDeptCode[1]);
        }
        profile.refreshReferenceObject("homeDeptOrg");
        profile.setEmployeeId(principal.getEmployeeId());
        if (ObjectUtils.isNotNull((Object)kimEntity)) {
            List citizenships;
            if (ObjectUtils.isNotNull((Object)kimEntity.getBioDemographics())) {
                String birthDate = kimEntity.getBioDemographics().getBirthDate();
                java.util.Date parsedBirthDate = new java.util.Date();
                try {
                    parsedBirthDate = new SimpleDateFormat("yyyy-MM-dd").parse(birthDate);
                }
                catch (ParseException pe) {
                    LOG.error((Object)("Error parsing EntityBioDemographics birth date: '" + birthDate + "'"), (Throwable)pe);
                }
                Date dateOfBirth = new Date(parsedBirthDate.getTime());
                profile.setDateOfBirth(dateOfBirth);
                profile.setGender(kimEntity.getBioDemographics().getGenderCode());
            }
            if (ObjectUtils.isNotNull((Object)(citizenships = kimEntity.getCitizenships())) && citizenships.size() > 0) {
                profile.setCitizenship(((EntityCitizenship)citizenships.get(0)).getCountryCode());
            }
        }
    }

    @Override
    public boolean isCustomerEmployee(AccountsReceivableCustomer person) {
        ArrayList<String> empParams = new ArrayList<String>(this.getParameterService().getParameterValuesAsString(TemProfile.class, "VALID_TRAVELER_TYPE_BY_CUSTOMER_TYPE"));
        ArrayList<String> empCodes = new ArrayList<String>();
        ArrayList<String> nonEmpCodes = new ArrayList<String>();
        this.splitCodes(empCodes, nonEmpCodes, empParams);
        if (empCodes.contains(person.getCustomerTypeCode())) {
            return true;
        }
        if (nonEmpCodes.contains(person.getCustomerTypeCode())) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isKimPersonEmployee(Person person) {
        ArrayList<String> empParams = new ArrayList<String>(this.getParameterService().getParameterValuesAsString(TemProfile.class, "VALID_KIM_TYPE_AFFILIATION_BY_TRAVER_TYPE"));
        ArrayList<String> empCodes = new ArrayList<String>();
        ArrayList<String> nonEmpCodes = new ArrayList<String>();
        this.splitCodes(empCodes, nonEmpCodes, empParams);
        Entity kimEntity = this.identityManagementService.getEntityByPrincipalId(person.getPrincipalId());
        for (EntityAffiliation affiliation : kimEntity.getAffiliations()) {
            if (empCodes.contains(affiliation.getAffiliationType().getCode())) {
                return true;
            }
            if (!nonEmpCodes.contains(affiliation.getAffiliationType().getCode())) continue;
            return false;
        }
        return false;
    }

    private void splitCodes(List<String> empCodes, List<String> nonEmpCodes, List<String> empParams) {
        for (String param : empParams) {
            String[] splitParams = param.split("=");
            String typeCode = splitParams[1];
            if (typeCode.equals("EMP")) {
                empCodes.add(splitParams[0]);
                continue;
            }
            if (!typeCode.equals("NON")) continue;
            nonEmpCodes.add(splitParams[0]);
        }
    }

    private boolean compareAddress(AccountsReceivableCustomerAddress customerAddress, TemProfile temProfile) {
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerLine1StreetAddress(), (String)temProfile.getTemProfileAddress().getStreetAddressLine1())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerLine2StreetAddress(), (String)temProfile.getTemProfileAddress().getStreetAddressLine2())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerCityName(), (String)temProfile.getTemProfileAddress().getCityName())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerStateCode(), (String)temProfile.getTemProfileAddress().getStateCode())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerZipCode(), (String)temProfile.getTemProfileAddress().getZipCode())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerCountryCode(), (String)temProfile.getTemProfileAddress().getCountryCode())) {
            return true;
        }
        return !StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerEmailAddress(), (String)temProfile.getEmailAddress());
    }

    @Override
    public boolean isParentOrg(String chartCode, String orgCode, String roleChartCode, String roleOrgCode, boolean descendHierarchy) {
        if (StringUtils.isBlank((String)chartCode) || StringUtils.isBlank((String)orgCode)) {
            LOG.debug((Object)"No chart/org qualifications passed into isParentOrg()");
            return false;
        }
        if (ObjectUtils.isNull((Object)roleChartCode) && ObjectUtils.isNull((Object)roleOrgCode)) {
            LOG.debug((Object)("Call to " + this.getClass().getName() + " with no organization role qualifiers; both chart and organization code are null.  Please ensure that qualification data has organization information for this role."));
            return false;
        }
        if (ObjectUtils.isNull((Object)roleOrgCode)) {
            return roleChartCode.equals(chartCode) || descendHierarchy && this.chartService.isParentChart(chartCode, roleChartCode);
        }
        boolean parentOrg = roleChartCode.equals(chartCode) && roleOrgCode.equals(orgCode) || descendHierarchy && this.organizationService.isParentOrganization(chartCode, orgCode, roleChartCode, roleOrgCode);
        return parentOrg;
    }

    protected ChartOrgHolder getOrganizationForUser(String principalId, String roleName) {
        if (principalId == null) {
            return null;
        }
        HashMap<String, String> qualification = new HashMap<String, String>(1);
        qualification.put("performQualifierMatch", "false");
        List roleQualifiers = this.getRoleService().getRoleQualifersForPrincipalByNamespaceAndRolename(principalId, "KFS-TEM", roleName, qualification);
        if (roleQualifiers != null && !roleQualifiers.isEmpty()) {
            ChartOrgHolderImpl chartOrg = new ChartOrgHolderImpl((String)((Map)roleQualifiers.get(0)).get("chartOfAccountsCode"), (String)((Map)roleQualifiers.get(0)).get("organizationCode"));
            return chartOrg;
        }
        return null;
    }

    public IdentityManagementService getIdentityManagementService() {
        return this.identityManagementService;
    }

    public void setIdentityManagementService(IdentityManagementService identityManagementService) {
        this.identityManagementService = identityManagementService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public TemRoleService getTemRoleService() {
        return this.temRoleService;
    }

    public void setTemRoleService(TemRoleService temRoleService) {
        this.temRoleService = temRoleService;
    }

    public ChartService getChartService() {
        return this.chartService;
    }

    public void setChartService(ChartService chartService) {
        this.chartService = chartService;
    }

    public OrganizationService getOrganizationService() {
        return this.organizationService;
    }

    public void setOrganizationService(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    protected AccountsReceivableModuleService getAccountsReceivableModuleService() {
        if (this.accountsReceivableModuleService == null) {
            this.accountsReceivableModuleService = (AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class);
        }
        return this.accountsReceivableModuleService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }
}

