/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.tem.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import java.util.LinkedHashMap;

@Entity
@Table(name = "TEM_TRP_ACCT_INFO_T")
public class TripAccountingInformation extends PersistableBusinessObjectBase {

    private Integer id;

    private Integer agencyStagingDataId;
    private String tripChartCode;
    private String tripAccountNumber;
    private String tripSubAccountNumber;
    private String objectCode;
    private String subObjectCode;
    private String projectCode;
    private String organizationReference;
    private KualiDecimal amount;

    private Account account;
    private SubAccount subAccount;
    private ProjectCode project;


    public TripAccountingInformation() {
    }

    @SuppressWarnings("rawtypes")
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        return null;
    }

    /**
     * Gets the id attribute.
     *
     * @return Returns the id.
     */
    @Id
    @GeneratedValue(generator = "TEM_TRP_ACCT_INFO_ID_SEQ")
    @SequenceGenerator(name = "TEM_TRP_ACCT_INFO_ID_SEQ", sequenceName = "TEM_TRP_ACCT_INFO_ID_SEQ", allocationSize = 5)
    @Column(name = "ID", nullable = false)
    public Integer getId() {
        return id;
    }

    /**
     * Sets the id attribute value.
     *
     * @param id The id to set.
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * Gets the agencyStagingDataId attribute.
     *
     * @return Returns the agencyStagingDataId.
     */
    @Column(name = "AGENCY_ID", nullable = true)
    public Integer getAgencyStagingDataId() {
        return agencyStagingDataId;
    }

    /**
     * Sets the agencyStagingDataId attribute value.
     *
     * @param agencyStagingDataId The agencyStagingDataId to set.
     */
    public void setAgencyStagingDataId(Integer agencyStagingDataId) {
        this.agencyStagingDataId = agencyStagingDataId;
    }

    /**
     * Gets the tripChartCode attribute.
     *
     * @return Returns the tripChartCode.
     */
    @Column(name = "FIN_COA_CD", length = 2, nullable = true)
    public String getTripChartCode() {
        return tripChartCode;
    }

    /**
     * Sets the tripChartCode attribute value.
     *
     * @param tripChartCode The tripChartCode to set.
     */
    public void setTripChartCode(String tripChartCode) {
        this.tripChartCode = tripChartCode;
    }

    /**
     * Gets the tripAccountNumber attribute.
     *
     * @return Returns the tripAccountNumber.
     */
    @Column(name = "ACCT_NBR", length = 7, nullable = true)
    public String getTripAccountNumber() {
        return tripAccountNumber;
    }

    /**
     * Sets the tripAccountNumber attribute value.
     *
     * @param tripAccountNumber The tripAccountNumber to set.
     */
    public void setTripAccountNumber(String tripAccountNumber) {
        this.tripAccountNumber = tripAccountNumber;
    }

    /**
     * Gets the tripSubAccountNumber attribute.
     *
     * @return Returns the tripSubAccountNumber.
     */
    @Column(name = "SUB_ACCT_NBR", length = 5, nullable = true)
    public String getTripSubAccountNumber() {
        return tripSubAccountNumber;
    }

    /**
     * Sets the tripSubAccountNumber attribute value.
     *
     * @param tripSubAccountNumber The tripSubAccountNumber to set.
     */
    public void setTripSubAccountNumber(String tripSubAccountNumber) {
        this.tripSubAccountNumber = tripSubAccountNumber;
    }

    /**
     * Gets the objectCode attribute.
     *
     * @return Returns the objectCode.
     */
    @Column(name = "OBJ_CD", length = 4, nullable = true)
    public String getObjectCode() {
        return objectCode;
    }

    /**
     * Sets the objectCode attribute value.
     *
     * @param objectCode The objectCode to set.
     */
    public void setObjectCode(String objectCode) {
        this.objectCode = objectCode;
    }

    /**
     * Gets the subObjectCode attribute.
     *
     * @return Returns the subObjectCode.
     */
    @Column(name = "SUB_OBJ_CD", length = 3, nullable = true)
    public String getSubObjectCode() {
        return subObjectCode;
    }

    /**
     * Sets the subObjectCode attribute value.
     *
     * @param subObjectCode The subObjectCode to set.
     */
    public void setSubObjectCode(String subObjectCode) {
        this.subObjectCode = subObjectCode;
    }

    /**
     * Gets the projectCode attribute.
     *
     * @return Returns the projectCode.
     */
    @Column(name = "PRJ_CD", length = 10, nullable = true)
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * Sets the projectCode attribute value.
     *
     * @param projectCode The projectCode to set.
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * Gets the organizationReference attribute.
     *
     * @return Returns the organizationReference.
     */
    @Column(name = "ORG_REF", length = 8, nullable = true)
    public String getOrganizationReference() {
        return organizationReference;
    }

    /**
     * Sets the organizationReference attribute value.
     *
     * @param organizationReference The organizationReference to set.
     */
    public void setOrganizationReference(String organizationReference) {
        this.organizationReference = organizationReference;
    }

    /**
     * Gets the amount attribute.
     *
     * @return Returns the amount.
     */
    @Column(name = "AMOUNT", nullable = true)
    public KualiDecimal getAmount() {
        return amount;
    }

    /**
     * Sets the amount attribute value.
     *
     * @param amount The amount to set.
     */
    public void setAmount(KualiDecimal amount) {
        this.amount = amount;
    }

    /**
     * Gets the account attribute.
     *
     * @return Returns the account.
     */
    public Account getAccount() {
        return account;
    }

    /**
     * Sets the account attribute value.
     *
     * @param account The account to set.
     */
    public void setAccount(Account account) {
        this.account = account;
    }

    /**
     * Gets the subAccount attribute.
     *
     * @return Returns the subAccount.
     */
    public SubAccount getSubAccount() {
        return subAccount;
    }

    /**
     * Sets the subAccount attribute value.
     *
     * @param subAccount The subAccount to set.
     */
    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public ProjectCode getProject() {
        return project;
    }

    public void setProject(ProjectCode project) {
        this.project = project;
    }

}
