/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service;

import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class AccountingDocumentRelationshipServiceTest
extends KualiTestBase {
    private AccountingDocumentRelationshipService adrService;
    private static final String TEST_PREFIX = "test";
    private static final Logger LOG = Logger.getLogger(AccountingDocumentRelationshipServiceTest.class);

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.adrService = (AccountingDocumentRelationshipService)SpringContext.getBean(AccountingDocumentRelationshipService.class);
        ArrayList<AccountingDocumentRelationship> adrList = new ArrayList<AccountingDocumentRelationship>();
        int relatedDocNumbers = 5;
        for (int i = 1; i < relatedDocNumbers; ++i) {
            adrList.add(new AccountingDocumentRelationship(TEST_PREFIX + i, TEST_PREFIX + (i + 1)));
        }
        adrList.add(new AccountingDocumentRelationship("test1", "test7"));
        this.adrService.save(adrList);
    }

    @After
    public void tearDown() throws Exception {
        this.adrService = null;
        super.tearDown();
    }

    @Test
    public void testGetAllRelatedDocumentNumbers() {
        Set docNumbers = this.adrService.getAllRelatedDocumentNumbers("test3");
        LOG.info((Object)("docNumbers.toString(): " + docNumbers.toString() + " (" + docNumbers.size() + ")"));
        AccountingDocumentRelationshipServiceTest.assertTrue((boolean)docNumbers.contains("test1"));
        AccountingDocumentRelationshipServiceTest.assertTrue((boolean)docNumbers.contains("test2"));
        AccountingDocumentRelationshipServiceTest.assertFalse((boolean)docNumbers.contains("test3"));
        AccountingDocumentRelationshipServiceTest.assertTrue((boolean)docNumbers.contains("test4"));
        AccountingDocumentRelationshipServiceTest.assertTrue((boolean)docNumbers.contains("test5"));
    }

    @Test
    public void testGetRelatedDocumentNumbers() {
        Set docNumbers = this.adrService.getRelatedDocumentNumbers("test3");
        LOG.info((Object)("docNumbers.toString(): " + docNumbers.toString() + " (" + docNumbers.size() + ")"));
        AccountingDocumentRelationshipServiceTest.assertTrue((boolean)docNumbers.contains("test2"));
        AccountingDocumentRelationshipServiceTest.assertFalse((boolean)docNumbers.contains("test3"));
        AccountingDocumentRelationshipServiceTest.assertTrue((boolean)docNumbers.contains("test4"));
    }

    @Test
    public void testGetRootDocumentNumber() {
        AccountingDocumentRelationshipServiceTest.assertTrue((boolean)"test1".equals(this.adrService.getRootDocumentNumber("test3")));
    }
}

