/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.batch.service.AgencyDataImportService;
import org.kuali.kfs.module.tem.batch.service.DataReportService;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTravelerService;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTripService;
import org.kuali.kfs.module.tem.businessobject.AgencyImportData;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.defaultvalue.NextAgencyStagingDataIdFinder;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.report.BusinessObjectReportHelper;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.transaction.annotation.Transactional;

public class AgencyDataImportServiceImpl
implements AgencyDataImportService {
    public static Logger LOG = Logger.getLogger(AgencyDataImportServiceImpl.class);
    public static final String REPORT_FILE_NAME_PATTERN = "{0}/{1}_{2}{3}";
    private BatchInputFileService batchInputFileService;
    private BusinessObjectService businessObjectService;
    private ExpenseImportByTravelerService expenseImportByTravelerService;
    private ExpenseImportByTripService expenseImportByTripService;
    private TravelExpenseService travelExpenseService;
    private static ConfigurationService configurationService;
    private TravelDocumentService travelDocumentService;
    private List<BatchInputFileType> agencyDataImportFileTypes;
    private String agencyDataFileErrorDirectory;
    private BusinessObjectReportHelper agencyDataTravelerUploadReportHelper;
    private BusinessObjectReportHelper agencyDataTripUploadReportHelper;
    private BusinessObjectReportHelper agencyDataReconciliationReportHelper;
    private DateTimeService dateTimeService;
    private DataReportService dataReportService;
    private String agencyDataReportDirectory;
    private String agencyDataReportFilePrefix;
    private String agencyDataReconciliationReportFilePrefix;

    @Override
    public boolean importAgencyData() {
        boolean success = true;
        LOG.info((Object)"Starting Agency Import Process");
        for (BatchInputFileType inputFileType : this.agencyDataImportFileTypes) {
            List inputFileNames = this.batchInputFileService.listInputFileNamesWithDoneFile(inputFileType);
            for (String dataFileName : inputFileNames) {
                success &= this.importAgencyDataFile(dataFileName, inputFileType);
            }
        }
        LOG.info((Object)"Finished Agency Import Process");
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importAgencyDataFile(String dataFileName, BatchInputFileType inputFileType) {
        try {
            boolean isAllValid;
            FileInputStream fileContents = new FileInputStream(dataFileName);
            byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileContents);
            AgencyImportData agencyData = (AgencyImportData)this.batchInputFileService.parse(inputFileType, fileByteContent);
            IOUtils.closeQuietly((InputStream)fileContents);
            LOG.info((Object)("Agency Import - validating: " + dataFileName));
            List<AgencyStagingData> validAgencyList = this.validateAgencyData(agencyData, dataFileName);
            boolean bl = isAllValid = validAgencyList.size() == agencyData.getAgencyStagingData().size();
            if (!isAllValid) {
                String error = "The agency data records to be loaded are rejected due to data problem. Please check the agency data report.";
                this.moveErrorFile(dataFileName, this.getAgencyDataFileErrorDirectory());
            }
            this.businessObjectService.save(validAgencyList);
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to process the file : " + dataFileName), (Throwable)ex);
            this.moveErrorFile(dataFileName, this.getAgencyDataFileErrorDirectory());
            boolean bl = false;
            return bl;
        }
        finally {
            this.removeDoneFiles(dataFileName);
        }
        return true;
    }

    public void moveErrorFile(String dataFileName, String agencyDataFileErrordirectory) {
        File dataFile = new File(dataFileName);
        if (!dataFile.exists() || !dataFile.canRead()) {
            LOG.error((Object)("Cannot find/read data file " + dataFileName));
        } else {
            try {
                FileUtils.moveToDirectory((File)dataFile, (File)new File(agencyDataFileErrordirectory), (boolean)true);
            }
            catch (IOException ex) {
                LOG.error((Object)("Cannot move the file:" + dataFile + " to the directory: " + agencyDataFileErrordirectory), (Throwable)ex);
            }
        }
    }

    protected void removeDoneFiles(String dataFileName) {
        File doneFile = new File(StringUtils.substringBeforeLast((String)dataFileName, (String)".") + ".done");
        if (doneFile.exists()) {
            doneFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AgencyStagingData> validateAgencyData(AgencyImportData agencyImportData, String dataFileName) {
        PrintStream reportDataStream = this.dataReportService.getReportPrintStream(this.getAgencyDataReportDirectory(), this.getAgencyDataReportFilePrefix());
        BusinessObjectReportHelper reportHelper = this.getReportHelper(TemConstants.ExpenseImport.getExpenseImportByCode(agencyImportData.getImportBy()));
        HashMap<String, AgencyStagingData> validAgencyStagingDataMap = new HashMap<String, AgencyStagingData>();
        try {
            this.dataReportService.writeReportHeader(reportDataStream, dataFileName, "message.batch.tem.agencyDataReportHeader", reportHelper);
            int count = 1;
            List<AgencyStagingData> importedAgencyStagingDataList = agencyImportData.getAgencyStagingData();
            int listSize = importedAgencyStagingDataList.size();
            LOG.info((Object)("Validating agency import by traveler: importing " + listSize + " records"));
            NextAgencyStagingDataIdFinder idFinder = new NextAgencyStagingDataIdFinder();
            for (AgencyStagingData importedAgencyStagingData : importedAgencyStagingDataList) {
                ErrorMessage error;
                String errorCode;
                String key = null;
                importedAgencyStagingData.setId(Integer.valueOf(idFinder.getValue()));
                importedAgencyStagingData.setImportBy(agencyImportData.getImportBy());
                importedAgencyStagingData.setStagingFileName(StringUtils.substringAfterLast((String)dataFileName, (String)File.separator));
                importedAgencyStagingData.setCreationTimestamp(this.getDateTimeService().getCurrentTimestamp());
                String itineraryData = importedAgencyStagingData.getItineraryDataString();
                Object validAgencyStagingData = null;
                ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
                if (importedAgencyStagingData.getExpenseImport() == TemConstants.ExpenseImport.traveler) {
                    key = importedAgencyStagingData.getTravelerId() + "~" + itineraryData + "~" + importedAgencyStagingData.getCreditCardOrAgencyCode() + "~" + importedAgencyStagingData.getTransactionPostingDate() + "~" + importedAgencyStagingData.getTripExpenseAmount() + "~" + importedAgencyStagingData.getTripInvoiceNumber();
                    LOG.info((Object)("Validating agency import by traveler. Record# " + count + " of " + listSize));
                    if (!validAgencyStagingDataMap.containsKey(key)) {
                        errorMessages.addAll(this.expenseImportByTravelerService.validateAgencyData(importedAgencyStagingData));
                        if (errorMessages.isEmpty()) {
                            validAgencyStagingDataMap.put(key, importedAgencyStagingData);
                        } else {
                            errorCode = importedAgencyStagingData.getErrorCode();
                            if (ObjectUtils.isNotNull((Object)errorCode) && !StringUtils.equals((String)"DUP", (String)errorCode)) {
                                validAgencyStagingDataMap.put(key, importedAgencyStagingData);
                            }
                        }
                    } else {
                        error = new ErrorMessage("message.batch.tem.agencyData.traveler.DuplicateRecord", new String[]{importedAgencyStagingData.getTravelerId(), itineraryData, importedAgencyStagingData.getCreditCardOrAgencyCode(), importedAgencyStagingData.getTransactionPostingDate().toString(), importedAgencyStagingData.getTripExpenseAmount().toString(), importedAgencyStagingData.getTripInvoiceNumber()});
                        errorMessages.add(error);
                    }
                } else if (importedAgencyStagingData.getExpenseImport() == TemConstants.ExpenseImport.trip) {
                    key = importedAgencyStagingData.getTravelerId() + "~" + importedAgencyStagingData.getTripId() + "~" + importedAgencyStagingData.getCreditCardOrAgencyCode() + "~" + importedAgencyStagingData.getTransactionPostingDate() + "~" + importedAgencyStagingData.getTripExpenseAmount();
                    LOG.info((Object)("Validating agency import by trip. Record# " + count + " of " + listSize));
                    if (!validAgencyStagingDataMap.containsKey(key)) {
                        errorMessages.addAll(this.expenseImportByTripService.validateAgencyData(importedAgencyStagingData));
                        if (errorMessages.isEmpty()) {
                            validAgencyStagingDataMap.put(key, importedAgencyStagingData);
                        } else {
                            errorCode = importedAgencyStagingData.getErrorCode();
                            if (ObjectUtils.isNotNull((Object)errorCode) && !StringUtils.equals((String)"DUP", (String)errorCode)) {
                                validAgencyStagingDataMap.put(key, importedAgencyStagingData);
                            }
                        }
                    } else {
                        error = new ErrorMessage("message.batch.tem.agencyData.trip.DuplicateRecord", new String[]{importedAgencyStagingData.getTripId(), importedAgencyStagingData.getCreditCardOrAgencyCode(), importedAgencyStagingData.getTransactionPostingDate().toString(), importedAgencyStagingData.getTripExpenseAmount().toString(), itineraryData});
                        errorMessages.add(error);
                    }
                }
                if (!errorMessages.isEmpty()) {
                    this.dataReportService.writeToReport(reportDataStream, importedAgencyStagingData, errorMessages, reportHelper);
                }
                ++count;
            }
        }
        finally {
            if (reportDataStream != null) {
                reportDataStream.flush();
                reportDataStream.close();
            }
        }
        ArrayList<AgencyStagingData> validAgencyRecords = new ArrayList<AgencyStagingData>();
        for (Map.Entry entry : validAgencyStagingDataMap.entrySet()) {
            validAgencyRecords.add((AgencyStagingData)((Object)entry.getValue()));
        }
        return validAgencyRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveAgencyDataToHistoricalExpenseTable() {
        LOG.info((Object)"Starting Agency Expense Distribution/Reconciliation Process");
        List<AgencyStagingData> agencyData = this.travelExpenseService.retrieveValidAgencyData();
        if (ObjectUtils.isNotNull(agencyData) && agencyData.size() > 0) {
            PrintStream reportDataStream = this.dataReportService.getReportPrintStream(this.getAgencyDataReportDirectory(), this.getAgencyDataReconciliationReportFilePrefix());
            BusinessObjectReportHelper reportHelper = this.getAgencyDataReconciliationReportHelper();
            try {
                this.dataReportService.writeReportHeader(reportDataStream, null, "message.batch.tem.agencydatareconciliation.reportHeader", reportHelper);
                HashMap<String, GeneralLedgerPendingEntrySequenceHelper> sequenceHelperMap = new HashMap<String, GeneralLedgerPendingEntrySequenceHelper>();
                GeneralLedgerPendingEntrySequenceHelper sequenceHelper = null;
                for (AgencyStagingData agency : agencyData) {
                    ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
                    if (agency.getExpenseImport() == TemConstants.ExpenseImport.trip) {
                        sequenceHelper = this.getGeneralLedgerPendingEntrySequenceHelper(agency, sequenceHelperMap);
                    }
                    errorMessages.addAll(this.processAgencyStagingExpense(agency, sequenceHelper));
                    this.getBusinessObjectService().save((PersistableBusinessObject)agency);
                    if (!errorMessages.isEmpty()) {
                        this.dataReportService.writeToReport(reportDataStream, agency, errorMessages, reportHelper);
                        LOG.info((Object)("Agency Data Id: " + agency.getId() + " was not processed."));
                        continue;
                    }
                    LOG.info((Object)("Agency Data Id: " + agency.getId() + " was processed."));
                }
            }
            finally {
                if (reportDataStream != null) {
                    reportDataStream.flush();
                    reportDataStream.close();
                }
            }
        }
        LOG.info((Object)"Finished Agency Expense Distribution/Reconciliation Process");
        return true;
    }

    @Override
    @Transactional
    public List<ErrorMessage> processAgencyStagingExpense(AgencyStagingData agency, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        ArrayList<ErrorMessage> errors = new ArrayList<ErrorMessage>();
        agency.setProcessingTimestamp(this.getDateTimeService().getCurrentTimestamp());
        if (agency.getExpenseImport() == TemConstants.ExpenseImport.traveler) {
            errors.addAll(this.expenseImportByTravelerService.distributeExpense(agency));
        }
        if (agency.getExpenseImport() == TemConstants.ExpenseImport.trip) {
            errors.addAll(this.expenseImportByTripService.reconciliateExpense(agency, sequenceHelper));
        }
        return errors;
    }

    protected GeneralLedgerPendingEntrySequenceHelper getGeneralLedgerPendingEntrySequenceHelper(AgencyStagingData agencyStagingData, Map<String, GeneralLedgerPendingEntrySequenceHelper> sequenceHelperMap) {
        String tripId = agencyStagingData.getTripId();
        GeneralLedgerPendingEntrySequenceHelper sequenceHelper = sequenceHelperMap.get(tripId);
        if (ObjectUtils.isNull((Object)sequenceHelper)) {
            Collection<GeneralLedgerPendingEntry> glpes = this.getGeneralLedgerPendingEntriesForDocumentNumber(agencyStagingData);
            if (ObjectUtils.isNotNull(glpes) && !glpes.isEmpty()) {
                Integer maxSequenceNumber = 0;
                for (GeneralLedgerPendingEntry glpe : glpes) {
                    Integer sequenceNumber = glpe.getTransactionLedgerEntrySequenceNumber();
                    maxSequenceNumber = maxSequenceNumber < sequenceNumber ? sequenceNumber : maxSequenceNumber;
                }
                maxSequenceNumber = maxSequenceNumber + 1;
                sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper(maxSequenceNumber.intValue());
            } else {
                sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper();
            }
            sequenceHelperMap.put(tripId, sequenceHelper);
        }
        return sequenceHelper;
    }

    @Override
    public Collection<GeneralLedgerPendingEntry> getGeneralLedgerPendingEntriesForDocumentNumber(AgencyStagingData agencyStagingData) {
        Collection<Object> glpes = new ArrayList<GeneralLedgerPendingEntry>();
        TravelDocument travelDocument = this.getTravelDocumentService().getParentTravelDocument(agencyStagingData.getTripId());
        if (ObjectUtils.isNotNull((Object)travelDocument)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("documentNumber", travelDocument.getDocumentNumber());
            glpes = this.businessObjectService.findMatching(GeneralLedgerPendingEntry.class, fieldValues);
        }
        return glpes;
    }

    protected BusinessObjectReportHelper getReportHelper(TemConstants.ExpenseImport importType) {
        BusinessObjectReportHelper reportHelper = this.getAgencyDataTravelerUploadReportHelper();
        if (TemConstants.ExpenseImport.traveler == importType) {
            reportHelper = this.getAgencyDataTravelerUploadReportHelper();
        } else if (TemConstants.ExpenseImport.trip == importType) {
            reportHelper = this.getAgencyDataTripUploadReportHelper();
        }
        return reportHelper;
    }

    public BatchInputFileService getBatchInputFileService() {
        return this.batchInputFileService;
    }

    public void setBatchInputFileService(BatchInputFileService batchInputFileService) {
        this.batchInputFileService = batchInputFileService;
    }

    public List<BatchInputFileType> getAgencyDataImportFileTypes() {
        return this.agencyDataImportFileTypes;
    }

    public void setAgencyDataImportFileTypes(List<BatchInputFileType> agencyDataImportFileTypes) {
        this.agencyDataImportFileTypes = agencyDataImportFileTypes;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public String getAgencyDataFileErrorDirectory() {
        return this.agencyDataFileErrorDirectory;
    }

    public void setAgencyDataFileErrorDirectory(String agencyDataFileErrorDirectory) {
        this.agencyDataFileErrorDirectory = agencyDataFileErrorDirectory;
    }

    public ExpenseImportByTravelerService getExpenseImportByTravelerService() {
        return this.expenseImportByTravelerService;
    }

    public void setExpenseImportByTravelerService(ExpenseImportByTravelerService expenseImportByTravelerService) {
        this.expenseImportByTravelerService = expenseImportByTravelerService;
    }

    public ExpenseImportByTripService getExpenseImportByTripService() {
        return this.expenseImportByTripService;
    }

    public void setExpenseImportByTripService(ExpenseImportByTripService expenseImportByTripService) {
        this.expenseImportByTripService = expenseImportByTripService;
    }

    public TravelExpenseService getTravelExpenseService() {
        return this.travelExpenseService;
    }

    public void setTravelExpenseService(TravelExpenseService travelExpenseService) {
        this.travelExpenseService = travelExpenseService;
    }

    public BusinessObjectReportHelper getAgencyDataTravelerUploadReportHelper() {
        return this.agencyDataTravelerUploadReportHelper;
    }

    public void setAgencyDataTravelerUploadReportHelper(BusinessObjectReportHelper agencyDataTravelerUploadReportHelper) {
        this.agencyDataTravelerUploadReportHelper = agencyDataTravelerUploadReportHelper;
    }

    public BusinessObjectReportHelper getAgencyDataTripUploadReportHelper() {
        return this.agencyDataTripUploadReportHelper;
    }

    public void setAgencyDataTripUploadReportHelper(BusinessObjectReportHelper agencyDataTripUploadReportHelper) {
        this.agencyDataTripUploadReportHelper = agencyDataTripUploadReportHelper;
    }

    public BusinessObjectReportHelper getAgencyDataReconciliationReportHelper() {
        return this.agencyDataReconciliationReportHelper;
    }

    public void setAgencyDataReconciliationReportHelper(BusinessObjectReportHelper agencyDataReconciliationReportHelper) {
        this.agencyDataReconciliationReportHelper = agencyDataReconciliationReportHelper;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public String getAgencyDataReportDirectory() {
        return this.agencyDataReportDirectory;
    }

    public void setAgencyDataReportDirectory(String agencyDataReportDirectory) {
        this.agencyDataReportDirectory = agencyDataReportDirectory;
    }

    public String getAgencyDataReportFilePrefix() {
        return this.agencyDataReportFilePrefix;
    }

    public void setAgencyDataReportFilePrefix(String agencyDataReportFilePrefix) {
        this.agencyDataReportFilePrefix = agencyDataReportFilePrefix;
    }

    public String getAgencyDataReconciliationReportFilePrefix() {
        return this.agencyDataReconciliationReportFilePrefix;
    }

    public void setAgencyDataReconciliationReportFilePrefix(String agencyDataReconciliationReportFilePrefix) {
        this.agencyDataReconciliationReportFilePrefix = agencyDataReconciliationReportFilePrefix;
    }

    private static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        return configurationService;
    }

    public void setDataReportService(DataReportService dataReportService) {
        this.dataReportService = dataReportService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }
}

