/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.batch.service.CreditCardDataImportService;
import org.kuali.kfs.module.tem.batch.service.DataReportService;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.kfs.module.tem.businessobject.CreditCardImportData;
import org.kuali.kfs.module.tem.businessobject.CreditCardStagingData;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.service.CreditCardAgencyService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.report.BusinessObjectReportHelper;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.transaction.annotation.Transactional;

public class CreditCardDataImportServiceImpl
implements CreditCardDataImportService {
    public static Logger LOG = Logger.getLogger(CreditCardDataImportServiceImpl.class);
    public static final String REPORT_FILE_NAME_PATTERN = "{0}/{1}_{2}{3}";
    private BatchInputFileService batchInputFileService;
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private TemProfileService temProfileService;
    private TravelExpenseService travelExpenseService;
    private CreditCardAgencyService creditCardAgencyService;
    private DataReportService dataReportService;
    private List<BatchInputFileType> creditCardDataImportFileTypes;
    private String creditCardDataFileErrorDirectory;
    private BusinessObjectReportHelper creditCardDataUploadReportHelper;
    private String creditCardDataReportDirectory;
    private String creditCardDataReportFilePrefix;

    @Override
    public boolean importCreditCardData() {
        boolean success = true;
        for (BatchInputFileType inputFileType : this.creditCardDataImportFileTypes) {
            List inputFileNames = this.batchInputFileService.listInputFileNamesWithDoneFile(inputFileType);
            for (String dataFileName : inputFileNames) {
                success &= this.importCreditCardDataFile(dataFileName, inputFileType);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importCreditCardDataFile(String dataFileName, BatchInputFileType inputFileType) {
        try {
            FileInputStream fileContents = new FileInputStream(dataFileName);
            byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileContents);
            CreditCardImportData creditCardData = (CreditCardImportData)this.batchInputFileService.parse(inputFileType, fileByteContent);
            IOUtils.closeQuietly((InputStream)fileContents);
            LOG.info((Object)("Credit Card Import - validating: " + dataFileName));
            List<CreditCardStagingData> validCreditCardList = this.validateCreditCardData(creditCardData, dataFileName);
            if (!validCreditCardList.isEmpty()) {
                this.businessObjectService.save(validCreditCardList);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to process the file : " + dataFileName), (Throwable)ex);
            this.moveErrorFile(dataFileName, this.creditCardDataFileErrorDirectory);
            boolean bl = false;
            return bl;
        }
        finally {
            this.removeDoneFiles(dataFileName);
        }
        return true;
    }

    public void moveErrorFile(String dataFileName, String creditCardDataFileErrorDirectory) {
        File dataFile = new File(dataFileName);
        if (!dataFile.exists() || !dataFile.canRead()) {
            LOG.error((Object)("Cannot find/read data file " + dataFileName));
        } else {
            try {
                FileUtils.moveToDirectory((File)dataFile, (File)new File(creditCardDataFileErrorDirectory), (boolean)true);
            }
            catch (IOException ex) {
                LOG.error((Object)("Cannot move the file:" + dataFile + " to the directory: " + creditCardDataFileErrorDirectory), (Throwable)ex);
            }
        }
    }

    protected void removeDoneFiles(String dataFileName) {
        File doneFile = new File(StringUtils.substringBeforeLast((String)dataFileName, (String)".") + ".done");
        if (doneFile.exists()) {
            doneFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CreditCardStagingData> validateCreditCardData(CreditCardImportData creditCardList, String dataFileName) {
        PrintStream reportDataStream = this.dataReportService.getReportPrintStream(this.getCreditCardDataReportDirectory(), this.getCreditCardDataReportFilePrefix());
        ArrayList<CreditCardStagingData> validData = new ArrayList<CreditCardStagingData>();
        try {
            this.dataReportService.writeReportHeader(reportDataStream, dataFileName, "message.batch.tem.creditcard.DataReportHeader", this.getCreditCardDataUploadReportHelper());
            Integer count = 1;
            for (CreditCardStagingData creditCardData : creditCardList.getCreditCardData()) {
                LOG.info((Object)("Validating credit card import. Record# " + count + " of " + creditCardList.getCreditCardData().size()));
                creditCardData.setErrorCode("OK");
                creditCardData.setImportBy(creditCardList.getImportBy());
                creditCardData.setStagingFileName(StringUtils.substringAfterLast((String)dataFileName, (String)File.separator));
                ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
                if (this.validateAndSetCreditCardAgency(creditCardData)) {
                    if (creditCardData.getExpenseImport() == TemConstants.ExpenseImport.traveler) {
                        TemProfileAccount temProfileAccount = this.findTraveler(creditCardData);
                        if (ObjectUtils.isNotNull((Object)((Object)temProfileAccount))) {
                            ExpenseType expenseType;
                            if (ObjectUtils.isNull((Object)creditCardData.getTravelerId()) || creditCardData.getTravelerId() == 0) {
                                Integer travelerId = (int)new Integer(temProfileAccount.getProfile().getEmployeeId());
                                creditCardData.setTravelerId(travelerId);
                            }
                            creditCardData.setTemProfileId(temProfileAccount.getProfileId());
                            if (creditCardData.getExpenseTypeCode() == null) {
                                creditCardData.setExpenseTypeCode("O");
                            }
                            if (ObjectUtils.isNotNull((Object)((Object)(expenseType = (ExpenseType)this.businessObjectService.findBySinglePrimaryKey(ExpenseType.class, (Object)creditCardData.getExpenseTypeCode()))))) {
                                creditCardData.setCreditCardKey(creditCardData.getTravelerId() + temProfileAccount.getCreditCardAgency().getCreditCardOrAgencyCode() + creditCardData.getCreditCardNumber());
                                if (!this.isDuplicate(creditCardData, errorMessages)) {
                                    creditCardData.setMoveToHistoryIndicator(true);
                                    creditCardData.setProcessingTimestamp(this.dateTimeService.getCurrentTimestamp());
                                    validData.add(creditCardData);
                                }
                            } else {
                                LOG.error((Object)("Invalid expense type code " + creditCardData.getExpenseTypeCode() + " in Credit Card Data record"));
                                errorMessages.add(new ErrorMessage("message.batch.tem.creditcard.InvalidExpenseTypeCode", new String[]{creditCardData.getExpenseTypeCode()}));
                            }
                        } else {
                            LOG.error((Object)("No traveler found for credit card number: " + creditCardData.getCreditCardNumber()));
                            errorMessages.add(new ErrorMessage("message.batch.tem.creditcard.NoTravelerFoundForCardNumber", new String[]{creditCardData.getCreditCardNumber()}));
                        }
                    } else if (creditCardData.getExpenseImport() == TemConstants.ExpenseImport.trip && !this.isDuplicate(creditCardData, errorMessages)) {
                        creditCardData.setProcessingTimestamp(this.dateTimeService.getCurrentTimestamp());
                        validData.add(creditCardData);
                    }
                } else {
                    errorMessages.add(new ErrorMessage("message.batch.tem.agency.creditcard.data.InvalidCreditCardAgency", new String[]{creditCardData.getCreditCardOrAgencyCode()}));
                }
                if (!errorMessages.isEmpty()) {
                    this.dataReportService.writeToReport(reportDataStream, creditCardData, errorMessages, this.getCreditCardDataUploadReportHelper());
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
        }
        finally {
            if (reportDataStream != null) {
                reportDataStream.flush();
                reportDataStream.close();
            }
        }
        return validData;
    }

    @Override
    public boolean isDuplicate(CreditCardStagingData creditCardData, List<ErrorMessage> errorMessages) {
        List creditCardDataList;
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)creditCardData.getCreditCardKey())) {
            fieldValues.put("creditCardKey", creditCardData.getCreditCardKey());
        }
        if (StringUtils.isNotEmpty((String)creditCardData.getReferenceNumber())) {
            fieldValues.put("referenceNumber", creditCardData.getReferenceNumber());
        }
        if (ObjectUtils.isNotNull((Object)creditCardData.getTransactionAmount())) {
            fieldValues.put("transactionAmount", creditCardData.getTransactionAmount());
        }
        if (ObjectUtils.isNotNull((Object)creditCardData.getTransactionDate())) {
            fieldValues.put("transactionDate", creditCardData.getTransactionDate());
        }
        if (ObjectUtils.isNotNull((Object)creditCardData.getBankPostDate())) {
            fieldValues.put("bankPostDate", creditCardData.getBankPostDate());
        }
        if (StringUtils.isNotEmpty((String)creditCardData.getMerchantName())) {
            fieldValues.put("merchantName", creditCardData.getMerchantName());
        }
        if (ObjectUtils.isNull((Object)(creditCardDataList = (List)this.businessObjectService.findMatching(CreditCardStagingData.class, fieldValues))) || creditCardDataList.size() == 0) {
            return false;
        }
        LOG.error((Object)("Found a duplicate entry for credit card. Matching credit card id: " + ((CreditCardStagingData)((Object)creditCardDataList.get(0))).getId()));
        SimpleDateFormat format = new SimpleDateFormat();
        ErrorMessage error = new ErrorMessage("message.batch.tem.creditcard.DuplicateRecord", new String[]{creditCardData.getCreditCardKey(), creditCardData.getReferenceNumber(), creditCardData.getTransactionAmount().toString(), format.format(creditCardData.getTransactionDate()), format.format(creditCardData.getBankPostDate()), creditCardData.getMerchantName()});
        errorMessages.add(error);
        return true;
    }

    @Override
    public TemProfileAccount findTraveler(CreditCardStagingData creditCardData) {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("accountNumber", creditCardData.getCreditCardNumber());
        Collection temProfileAccounts = this.businessObjectService.findMatching(TemProfileAccount.class, criteria);
        if (ObjectUtils.isNotNull((Object)temProfileAccounts) && temProfileAccounts.size() > 0) {
            return (TemProfileAccount)((Object)temProfileAccounts.iterator().next());
        }
        return null;
    }

    @Override
    public boolean validateAndSetCreditCardAgency(CreditCardStagingData creditCardData) {
        CreditCardAgency ccAgency = this.creditCardAgencyService.getCreditCardAgencyByCode(creditCardData.getCreditCardOrAgencyCode());
        if (ObjectUtils.isNull((Object)((Object)ccAgency))) {
            LOG.error((Object)("Mandatory Field Credit Card Or Agency Code is invalid: " + creditCardData.getCreditCardOrAgencyCode()));
            creditCardData.setErrorCode("CCA");
            return false;
        }
        creditCardData.setCreditCardAgency(ccAgency);
        creditCardData.setCreditCardOrAgencyCode(ccAgency.getCreditCardOrAgencyCode());
        return true;
    }

    @Override
    public boolean moveCreditCardDataToHistoricalExpenseTable() {
        List<CreditCardStagingData> creditCardData = this.travelExpenseService.retrieveValidCreditCardData();
        if (ObjectUtils.isNotNull(creditCardData) && creditCardData.size() > 0) {
            for (CreditCardStagingData creditCard : creditCardData) {
                boolean result = this.processCreditCardStagingExpense(creditCard);
                LOG.info((Object)("Credit Card Staging Data Id: " + creditCard.getId() + (result ? " was" : " was not") + " processed."));
            }
        }
        return true;
    }

    @Transactional
    protected boolean processCreditCardStagingExpense(CreditCardStagingData creditCard) {
        LOG.info((Object)("Creating historical travel expense for credit card: " + creditCard.getId()));
        HistoricalTravelExpense expense = this.travelExpenseService.createHistoricalTravelExpense(creditCard);
        this.businessObjectService.save((PersistableBusinessObject)expense);
        creditCard.setErrorCode("HIS");
        LOG.info((Object)("Finished creating historical travel expense for credit card: " + creditCard.getId() + " Historical Travel Expense: " + expense.getId()));
        this.businessObjectService.save((PersistableBusinessObject)creditCard);
        return true;
    }

    public void setBatchInputFileService(BatchInputFileService batchInputFileService) {
        this.batchInputFileService = batchInputFileService;
    }

    public void setCreditCardDataImportFileTypes(List<BatchInputFileType> creditCardDataImportFileTypes) {
        this.creditCardDataImportFileTypes = creditCardDataImportFileTypes;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setCreditCardDataFileErrorDirectory(String creditCardDataFileErrorDirectory) {
        this.creditCardDataFileErrorDirectory = creditCardDataFileErrorDirectory;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }

    public void setTravelExpenseService(TravelExpenseService argTravelExpenseService) {
        this.travelExpenseService = argTravelExpenseService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setCreditCardAgencyService(CreditCardAgencyService creditCardAgencyService) {
        this.creditCardAgencyService = creditCardAgencyService;
    }

    public void setCreditCardDataUploadReportHelper(BusinessObjectReportHelper creditCardDataUploadReportHelper) {
        this.creditCardDataUploadReportHelper = creditCardDataUploadReportHelper;
    }

    public void setCreditCardDataReportDirectory(String creditCardDataReportDirectory) {
        this.creditCardDataReportDirectory = creditCardDataReportDirectory;
    }

    public void setCreditCardDataReportFilePrefix(String creditCardDataReportFilePrefix) {
        this.creditCardDataReportFilePrefix = creditCardDataReportFilePrefix;
    }

    public BusinessObjectReportHelper getCreditCardDataUploadReportHelper() {
        return this.creditCardDataUploadReportHelper;
    }

    public String getCreditCardDataReportDirectory() {
        return this.creditCardDataReportDirectory;
    }

    public String getCreditCardDataReportFilePrefix() {
        return this.creditCardDataReportFilePrefix;
    }

    public DataReportService getDataReportService() {
        return this.dataReportService;
    }

    public void setDataReportService(DataReportService dataReportService) {
        this.dataReportService = dataReportService;
    }
}

