/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.ProjectCodeService;
import org.kuali.kfs.coa.service.SubAccountService;
import org.kuali.kfs.coa.service.SubObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.kfs.module.tem.service.CreditCardAgencyService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ExpenseImportServiceBase {
    private static Logger LOG = Logger.getLogger(ExpenseImportServiceBase.class);

    public boolean isAccountNumberValid(String chartCode, String accountNumber) {
        Account account;
        boolean valid = false;
        if (StringUtils.isNotEmpty((String)chartCode) && StringUtils.isNotEmpty((String)accountNumber) && ObjectUtils.isNotNull((Object)(account = this.getAccountService().getByPrimaryId(chartCode, accountNumber)))) {
            valid = true;
        }
        return valid;
    }

    public boolean isSubAccountNumberValid(String chartCode, String accountNumber, String subAccountNumber) {
        SubAccount subAccount;
        boolean valid = false;
        if (StringUtils.isNotEmpty((String)chartCode) && StringUtils.isNotEmpty((String)accountNumber) && StringUtils.isNotEmpty((String)subAccountNumber) && ObjectUtils.isNotNull((Object)(subAccount = this.getSubAccountService().getByPrimaryId(chartCode, accountNumber, subAccountNumber)))) {
            valid = true;
        }
        return valid;
    }

    public boolean isProjectCodeValid(String projectCode) {
        ProjectCode project;
        boolean valid = false;
        if (StringUtils.isNotEmpty((String)projectCode) && ObjectUtils.isNotNull((Object)(project = this.getProjectCodeService().getByPrimaryId(projectCode)))) {
            valid = true;
        }
        return valid;
    }

    public boolean isObjectCodeValid(String chartCode, String objectCode) {
        ObjectCode code;
        boolean valid = false;
        if (StringUtils.isNotEmpty((String)chartCode) && StringUtils.isNotEmpty((String)objectCode) && ObjectUtils.isNotNull((Object)(code = this.getObjectCode(chartCode, objectCode)))) {
            valid = true;
        }
        return valid;
    }

    public boolean isSubObjectCodeValid(String chartCode, String accountNumber, String objectCode, String subObjectCode) {
        SubObjectCode code;
        boolean valid = false;
        if (StringUtils.isNotEmpty((String)chartCode) && StringUtils.isNotEmpty((String)accountNumber) && StringUtils.isNotEmpty((String)objectCode) && StringUtils.isNotEmpty((String)subObjectCode) && ObjectUtils.isNotNull((Object)(code = this.getSubObjectCodeService().getByPrimaryIdForCurrentYear(chartCode, accountNumber, objectCode, subObjectCode)))) {
            valid = true;
        }
        return valid;
    }

    public boolean isAmountEmpty(KualiDecimal amount) {
        return ObjectUtils.isNull((Object)amount) || amount == KualiDecimal.ZERO;
    }

    public ObjectCode getObjectCode(String chartCode, String objectCode) {
        return this.getObjectCodeService().getByPrimaryIdForCurrentYear(chartCode, objectCode);
    }

    protected final String getEntryValue(String targetValue, String backupValue) {
        if (StringUtils.isNotBlank((String)targetValue)) {
            return targetValue;
        }
        return backupValue;
    }

    public boolean isCreditCardAgencyValid(AgencyStagingData agencyData) {
        CreditCardAgency ccAgency;
        if (StringUtils.isNotEmpty((String)agencyData.getCreditCardOrAgencyCode()) && ObjectUtils.isNotNull((Object)((Object)(ccAgency = this.getCreditCardAgencyService().getCreditCardAgencyByCode(agencyData.getCreditCardOrAgencyCode()))))) {
            agencyData.setCreditCardAgency(ccAgency);
            return true;
        }
        LOG.error((Object)"Invalid Credit Card Agency Code in Agency Data record");
        this.setErrorCode(agencyData, "CCA");
        return false;
    }

    public boolean isTripDataMissing(AgencyStagingData agencyData) {
        return StringUtils.isEmpty((String)agencyData.getAirTicketNumber()) && StringUtils.isEmpty((String)agencyData.getLodgingItineraryNumber()) && StringUtils.isEmpty((String)agencyData.getRentalCarItineraryNumber());
    }

    public void setErrorCode(AgencyStagingData agencyData, String error) {
        if (StringUtils.equals((String)agencyData.getErrorCode(), (String)"OK")) {
            agencyData.setErrorCode(error);
        }
    }

    public AccountService getAccountService() {
        return (AccountService)SpringContext.getBean(AccountService.class);
    }

    public SubAccountService getSubAccountService() {
        return (SubAccountService)SpringContext.getBean(SubAccountService.class);
    }

    public ProjectCodeService getProjectCodeService() {
        return (ProjectCodeService)SpringContext.getBean(ProjectCodeService.class);
    }

    public ObjectCodeService getObjectCodeService() {
        return (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
    }

    public SubObjectCodeService getSubObjectCodeService() {
        return (SubObjectCodeService)SpringContext.getBean(SubObjectCodeService.class);
    }

    public ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    public CreditCardAgencyService getCreditCardAgencyService() {
        return (CreditCardAgencyService)SpringContext.getBean(CreditCardAgencyService.class);
    }
}

