/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.batch.service.ImportedExpensePendingEntryService;
import org.kuali.kfs.module.tem.businessobject.AgencyServiceFee;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.validation.impl.AccountingDocumentRuleBaseConstants;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ImportedExpensePendingEntryServiceImpl
implements ImportedExpensePendingEntryService {
    private static Logger LOG = Logger.getLogger(ImportedExpensePendingEntryServiceImpl.class);
    DateTimeService dateTimeService;
    UniversityDateService universityDateService;
    ParameterService parameterService;
    GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    TravelDocumentService travelDocumentService;
    ObjectCodeService objectCodeService;
    DataDictionaryService dataDictionaryService;

    @Override
    public boolean checkAndAddPendingEntriesToList(List<GeneralLedgerPendingEntry> pendingEntries, List<GeneralLedgerPendingEntry> entryList, AgencyStagingData agencyData, boolean isCredit, boolean generateOffset) {
        int expectedEntrySize;
        boolean result = true;
        int n = expectedEntrySize = generateOffset ? 2 : 1;
        if (pendingEntries.size() != expectedEntrySize) {
            LOG.error((Object)("Failed to create a " + (isCredit ? " CREDIT" : "DEBIT") + " GLPE for agency: " + agencyData.getId() + " tripId: " + agencyData.getTripId()));
            result = false;
        } else {
            entryList.addAll(pendingEntries);
        }
        return result;
    }

    @Override
    public GeneralLedgerPendingEntry buildGeneralLedgerPendingEntry(AgencyStagingData agencyData, TripAccountingInformation info, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, String chartCode, String objectCode, KualiDecimal amount, String glCredtiDebitCode) {
        ObjectCode objectCd = this.getObjectCodeService().getByPrimaryIdForCurrentYear(chartCode, objectCode);
        if (ObjectUtils.isNull((Object)objectCd)) {
            LOG.error((Object)("ERROR: Could not get an ObjectCode for chart code: " + chartCode + " object code: " + objectCode));
            return null;
        }
        GeneralLedgerPendingEntry glpe = this.buildBasicDistributionPendingEntry(sequenceHelper);
        glpe.setDocumentNumber(this.getImportExpenseDocumentNumber(agencyData));
        glpe.setChartOfAccountsCode(chartCode);
        glpe.setFinancialObjectCode(objectCode);
        glpe.setFinancialSubObjectCode(StringUtils.defaultIfEmpty((String)info.getSubObjectCode(), (String)AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankFinancialSubObjectCode()));
        glpe.setFinancialObjectTypeCode(objectCd.getFinancialObjectTypeCode());
        glpe.setProjectCode(StringUtils.defaultIfEmpty((String)info.getProjectCode(), (String)AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankProjectCode()));
        glpe.setTransactionLedgerEntryAmount(amount);
        glpe.setTransactionDebitCreditCode(glCredtiDebitCode);
        glpe.setTransactionDate(agencyData.getTransactionPostingDate());
        glpe.setOrganizationDocumentNumber(StringUtils.isNotEmpty((String)agencyData.getTravelerId()) ? agencyData.getTravelerId() : agencyData.getTripId());
        glpe.setFinancialDocumentApprovedCode("A");
        return glpe;
    }

    protected GeneralLedgerPendingEntry buildBasicDistributionPendingEntry(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        GeneralLedgerPendingEntry glpe = new GeneralLedgerPendingEntry();
        String DIST_INCOME_DOC_TYPE = "DI";
        glpe.setVersionNumber(new Long(1L));
        glpe.setUniversityFiscalYear(this.universityDateService.getCurrentFiscalYear());
        glpe.setFinancialBalanceTypeCode("AC");
        glpe.setFinancialDocumentTypeCode("DI");
        glpe.setFinancialSystemOriginationCode("01");
        glpe.setTransactionLedgerEntryDescription("TEM Imported Expense Re-Distribution");
        glpe.setTransactionLedgerEntrySequenceNumber(new Integer(sequenceHelper.getSequenceCounter()));
        glpe.setOrganizationReferenceId("DI-IMP");
        sequenceHelper.increment();
        return glpe;
    }

    @Override
    public List<GeneralLedgerPendingEntry> buildDebitPendingEntry(AgencyStagingData agencyData, TripAccountingInformation info, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, String objectCode, KualiDecimal amount, boolean generateOffset) {
        ArrayList<GeneralLedgerPendingEntry> entryList = new ArrayList<GeneralLedgerPendingEntry>();
        GeneralLedgerPendingEntry pendingEntry = this.buildGeneralLedgerPendingEntry(agencyData, info, sequenceHelper, info.getTripChartCode(), objectCode, amount, "D");
        if (ObjectUtils.isNotNull((Object)pendingEntry)) {
            pendingEntry.setAccountNumber(info.getTripAccountNumber());
            pendingEntry.setSubAccountNumber(StringUtils.defaultIfEmpty((String)info.getTripSubAccountNumber(), (String)AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankSubAccountNumber()));
            LOG.info((Object)("Created DEBIT GLPE: " + pendingEntry.getDocumentNumber() + " for AGENCY Import Expense: " + agencyData.getId() + " TripId: " + agencyData.getTripId() + "\n\n" + ReflectionToStringBuilder.reflectionToString((Object)pendingEntry, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
            entryList.add(pendingEntry);
            if (generateOffset) {
                this.generateOffsetPendingEntry(entryList, sequenceHelper, pendingEntry);
            }
        }
        return entryList;
    }

    @Override
    public List<GeneralLedgerPendingEntry> buildCreditPendingEntry(AgencyStagingData agencyData, TripAccountingInformation info, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, String objectCode, KualiDecimal amount, boolean generateOffset) {
        ArrayList<GeneralLedgerPendingEntry> entryList = new ArrayList<GeneralLedgerPendingEntry>();
        String chartCode = this.parameterService.getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_CLEARING_CHART");
        GeneralLedgerPendingEntry pendingEntry = this.buildGeneralLedgerPendingEntry(agencyData, info, sequenceHelper, chartCode, objectCode, amount, "C");
        if (ObjectUtils.isNotNull((Object)pendingEntry)) {
            pendingEntry.setAccountNumber(this.parameterService.getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_CLEARING_ACCOUNT"));
            pendingEntry.setSubAccountNumber(AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankSubAccountNumber());
        }
        LOG.info((Object)("Created CREDIT GLPE: " + pendingEntry.getDocumentNumber() + " for AGENCY Import Expense: " + agencyData.getId() + " TripId: " + agencyData.getTripId() + "\n\n" + ReflectionToStringBuilder.reflectionToString((Object)pendingEntry, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
        if (ObjectUtils.isNotNull((Object)pendingEntry)) {
            entryList.add(pendingEntry);
            if (generateOffset) {
                this.generateOffsetPendingEntry(entryList, sequenceHelper, pendingEntry);
            }
        }
        return entryList;
    }

    @Override
    public List<GeneralLedgerPendingEntry> buildDistributionEntriesForCTSExpense(ImportedExpense expense, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, String travelDocumentIdentifier) {
        ArrayList<GeneralLedgerPendingEntry> entries = new ArrayList<GeneralLedgerPendingEntry>();
        String chartCode = this.parameterService.getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_CLEARING_CHART");
        String accountNumber = this.parameterService.getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_CLEARING_ACCOUNT");
        String creditObjectCode = this.parameterService.getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_CLEARING_OBJECT_CODE");
        ObjectCode objectCd = this.getObjectCodeService().getByPrimaryIdForCurrentYear(chartCode, creditObjectCode);
        if (ObjectUtils.isNull((Object)objectCd)) {
            LOG.error((Object)("ERROR: Could not get an ObjectCode for chart code: " + chartCode + " object code: " + creditObjectCode));
            return null;
        }
        GeneralLedgerPendingEntry explicitEntry = this.buildBasicDistributionPendingEntry(sequenceHelper);
        explicitEntry.setDocumentNumber(expense.getDocumentNumber());
        explicitEntry.setChartOfAccountsCode(chartCode);
        explicitEntry.setAccountNumber(accountNumber);
        explicitEntry.setFinancialObjectCode(creditObjectCode);
        explicitEntry.setFinancialObjectTypeCode(objectCd.getFinancialObjectTypeCode());
        explicitEntry.setTransactionLedgerEntryAmount(expense.getConvertedAmount());
        explicitEntry.setTransactionDebitCreditCode("C");
        explicitEntry.setTransactionDate(this.dateTimeService.getCurrentSqlDate());
        explicitEntry.setOrganizationDocumentNumber(travelDocumentIdentifier);
        entries.add(explicitEntry);
        this.generateOffsetPendingEntry(entries, sequenceHelper, explicitEntry);
        return entries;
    }

    @Override
    public List<GeneralLedgerPendingEntry> buildServiceFeeCreditPendingEntry(AgencyStagingData agencyData, TripAccountingInformation info, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, AgencyServiceFee serviceFee, KualiDecimal amount, boolean generateOffset) {
        ArrayList<GeneralLedgerPendingEntry> entryList = new ArrayList<GeneralLedgerPendingEntry>();
        GeneralLedgerPendingEntry pendingEntry = this.buildGeneralLedgerPendingEntry(agencyData, info, sequenceHelper, serviceFee.getCreditChartCode(), serviceFee.getCreditObjectCode(), amount, "C");
        if (ObjectUtils.isNotNull((Object)pendingEntry)) {
            pendingEntry.setAccountNumber(serviceFee.getCreditAccountNumber());
            pendingEntry.setSubAccountNumber(AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankSubAccountNumber());
        }
        LOG.info((Object)("Created ServiceFee CREDIT GLPE: " + pendingEntry.getDocumentNumber() + " for AGENCY Import Expense: " + agencyData.getId() + " TripId: " + agencyData.getTripId() + "\n\n" + ReflectionToStringBuilder.reflectionToString((Object)pendingEntry, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
        if (ObjectUtils.isNotNull((Object)pendingEntry)) {
            entryList.add(pendingEntry);
            if (generateOffset) {
                this.generateOffsetPendingEntry(entryList, sequenceHelper, pendingEntry);
            }
        }
        return entryList;
    }

    private void generateOffsetPendingEntry(List<GeneralLedgerPendingEntry> entryList, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntry pendingEntry) {
        GeneralLedgerPendingEntry offsetEntry = new GeneralLedgerPendingEntry(pendingEntry);
        boolean success = this.generalLedgerPendingEntryService.populateOffsetGeneralLedgerPendingEntry(this.universityDateService.getCurrentFiscalYear(), pendingEntry, sequenceHelper, offsetEntry);
        sequenceHelper.increment();
        if (success) {
            LOG.info((Object)("Created OFFSET GLPE: " + pendingEntry.getDocumentNumber() + "\n" + ReflectionToStringBuilder.reflectionToString((Object)pendingEntry, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
            entryList.add(offsetEntry);
        }
    }

    @Override
    public boolean generateDocumentImportedExpenseGeneralLedgerPendingEntries(TravelDocument travelDocument, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, boolean isCredit, String docType) {
        LOG.debug((Object)"processGenerateGeneralLedgerPendingEntries(TravelDocument, AccountingLine, GeneralLedgerPendingEntrySequenceHelper, boolean) - start");
        glpeSourceDetail.getObjectCode().setChartOfAccountsCode(glpeSourceDetail.getChartOfAccountsCode());
        glpeSourceDetail.getObjectCode().setFinancialObjectCode(glpeSourceDetail.getFinancialObjectCode());
        glpeSourceDetail.getObjectCode().setUniversityFiscalYear(glpeSourceDetail.getPostingYear());
        ((TemSourceAccountingLine)glpeSourceDetail).getObjectTypeCode();
        GeneralLedgerPendingEntry explicitEntry = new GeneralLedgerPendingEntry();
        this.processExplicitGeneralLedgerPendingEntry(travelDocument, sequenceHelper, glpeSourceDetail, explicitEntry);
        explicitEntry.setFinancialDocumentTypeCode(docType);
        explicitEntry.setTransactionLedgerEntryDescription("TEM Imported Expense Re-Distribution");
        explicitEntry.setOrganizationDocumentNumber(travelDocument.getTravelDocumentIdentifier());
        explicitEntry.setDocumentNumber(this.getImportExpenseDocumentNumber(travelDocument));
        explicitEntry.setOrganizationReferenceId(travelDocument.getFinancialDocumentTypeCode() + "-IMP");
        String transactionCode = isCredit ? "C" : "D";
        explicitEntry.setTransactionDebitCreditCode(transactionCode);
        sequenceHelper.increment();
        GeneralLedgerPendingEntry offsetEntry = new GeneralLedgerPendingEntry(explicitEntry);
        explicitEntry.setOrganizationReferenceId(travelDocument.getFinancialDocumentTypeCode() + "-IMP");
        boolean success = this.processOffsetGeneralLedgerPendingEntry(travelDocument, sequenceHelper, glpeSourceDetail, explicitEntry, offsetEntry);
        sequenceHelper.increment();
        LOG.debug((Object)"processGenerateGeneralLedgerPendingEntries(TravelDocument, AccountingLine, GeneralLedgerPendingEntrySequenceHelper, boolean) - end");
        return success;
    }

    private void processExplicitGeneralLedgerPendingEntry(TravelDocument travelDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntry explicitEntry) {
        LOG.debug((Object)"processExplicitGeneralLedgerPendingEntry(TravelDocument, GeneralLedgerPendingEntrySequenceHelper, AccountingLine, GeneralLedgerPendingEntry) ");
        this.generalLedgerPendingEntryService.populateExplicitGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySource)travelDocument, glpeSourceDetail, sequenceHelper, explicitEntry);
        travelDocument.addPendingEntry(explicitEntry);
    }

    private boolean processOffsetGeneralLedgerPendingEntry(TravelDocument travelDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry, GeneralLedgerPendingEntry offsetEntry) {
        LOG.debug((Object)"processOffsetGeneralLedgerPendingEntry(TravelDocument, GeneralLedgerPendingEntrySequenceHelper, AccountingLine, GeneralLedgerPendingEntry, GeneralLedgerPendingEntry) ");
        boolean success = this.generalLedgerPendingEntryService.populateOffsetGeneralLedgerPendingEntry(travelDocument.getPostingYear(), explicitEntry, sequenceHelper, offsetEntry);
        travelDocument.addPendingEntry(offsetEntry);
        return success;
    }

    protected String getImportExpenseDocumentNumber(TravelDocument travelDocument) {
        if (ObjectUtils.isNotNull((Object)travelDocument)) {
            return travelDocument.getDocumentNumber();
        }
        return null;
    }

    protected String getImportExpenseDocumentNumber(AgencyStagingData agencyData) {
        TravelDocument travelDocument = this.getTravelDocumentService().getParentTravelDocument(agencyData.getTripId());
        return this.getImportExpenseDocumentNumber(travelDocument);
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

