/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.sql.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TravelerType;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

public abstract class BaseTemProfile
extends PersistableBusinessObjectBase
implements MutableInactivatable {
    protected Integer id;
    protected String documentNumber;
    protected String principalId;
    protected String principalName;
    protected String firstName;
    protected String middleName;
    protected String lastName;
    protected String streetAddressLine1;
    protected String streetAddressLine2;
    protected String cityName;
    protected String stateCode;
    protected String zipCode;
    protected String countryCode;
    protected String citizenship;
    protected String emailAddress;
    protected Date dateOfBirth;
    protected String gender;
    protected String phoneNumber;
    protected String travelerTypeCode;
    protected TravelerType travelerType;
    protected String customerNumber;
    protected AccountsReceivableCustomer customer;
    protected boolean liabilityInsurance;
    protected String driversLicenseNumber;
    protected String driversLicenseState;
    protected Date driversLicenseExpDate;
    protected boolean notifyTAFinal = Boolean.FALSE;
    protected boolean notifyTAStatusChange = Boolean.FALSE;
    protected boolean notifyTERFinal = Boolean.FALSE;
    protected boolean notifyTERStatusChange = Boolean.FALSE;
    protected boolean active = Boolean.TRUE;
    protected Boolean nonResidentAlien;
    protected boolean motorVehicleRecordCheck = Boolean.FALSE;

    @Column(name="doc_nbr")
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Id
    @GeneratedValue(generator="TEM_TRAVELER_DTL_ID_SEQ")
    @SequenceGenerator(name="TEM_TRAVELER_DTL_ID_SEQ", sequenceName="TEM_TRAVELER_DTL_ID_SEQ", allocationSize=5)
    @Column(name="id", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="first_nm", length=40, nullable=false)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="last_nm", length=40, nullable=false)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(length=40, nullable=true)
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getName() {
        String name = "";
        if (StringUtils.isNotBlank((String)this.getFirstName())) {
            name = name + this.getFirstName();
        }
        if (StringUtils.isNotBlank((String)this.getMiddleName())) {
            name = name + " " + this.getMiddleName();
        }
        if (StringUtils.isNotBlank((String)this.getLastName())) {
            name = name + " " + this.getLastName();
        }
        return name;
    }

    @Column(name="addr_line_1", length=50, nullable=false)
    public String getStreetAddressLine1() {
        return this.streetAddressLine1;
    }

    public void setStreetAddressLine1(String streetAddressLine1) {
        this.streetAddressLine1 = streetAddressLine1;
    }

    @Column(name="addr_line_2", length=50, nullable=true)
    public String getStreetAddressLine2() {
        return this.streetAddressLine2;
    }

    public void setStreetAddressLine2(String streetAddressLine2) {
        this.streetAddressLine2 = streetAddressLine2;
    }

    @Column(name="city_nm", length=50, nullable=true)
    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    @Column(name="postal_state_cd", length=50, nullable=false)
    public String getStateCode() {
        return this.stateCode;
    }

    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    @Column(name="postal_cd", length=50, nullable=false)
    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @Column(name="country_cd", length=50, nullable=true)
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Column(name="email_addr", length=50, nullable=true)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Column(name="phone_nbr", length=20, nullable=true)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Column(name="traveler_typ_cd", length=3, nullable=false)
    public String getTravelerTypeCode() {
        return this.travelerTypeCode;
    }

    public void setTravelerTypeCode(String travelerTypeCode) {
        this.travelerTypeCode = travelerTypeCode;
    }

    @ManyToOne
    @JoinColumn(name="traveler_typ_cd")
    public TravelerType getTravelerType() {
        return this.travelerType;
    }

    public void setTravelerType(TravelerType travelerType) {
        this.travelerType = travelerType;
    }

    @Column(name="EMP_PRINCIPAL_ID")
    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    @Column(name="EMP_PRINCIPAL_ID")
    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    @Column(name="customer_num", length=40, nullable=true)
    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public void setCustomer(AccountsReceivableCustomer customer) {
        this.customer = customer;
    }

    public AccountsReceivableCustomer getCustomer() {
        ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(AccountsReceivableCustomer.class);
        if (moduleService != null) {
            HashMap<String, String> keys = new HashMap<String, String>(1);
            keys.put("customerNumber", this.customerNumber);
            AccountsReceivableCustomer tmpCustomer = (AccountsReceivableCustomer)moduleService.getExternalizableBusinessObject(AccountsReceivableCustomer.class, keys);
            if (ObjectUtils.isNotNull((Object)tmpCustomer)) {
                this.customer = tmpCustomer;
            }
        } else {
            throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
        }
        return this.customer;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this.id);
        map.put("firstName", this.firstName);
        map.put("lastName", this.lastName);
        map.put("streetAddressLine1", this.streetAddressLine1);
        map.put("cityName", this.cityName);
        return map;
    }

    public boolean isLiabilityInsurance() {
        return this.liabilityInsurance;
    }

    public void setLiabilityInsurance(boolean liabilityInsurance) {
        this.liabilityInsurance = liabilityInsurance;
    }

    @Column(name="drive_lic_num", length=20, nullable=true)
    public String getDriversLicenseNumber() {
        return this.driversLicenseNumber;
    }

    public void setDriversLicenseNumber(String driversLicenseNumber) {
        this.driversLicenseNumber = driversLicenseNumber;
    }

    public String getDriversLicenseState() {
        return this.driversLicenseState;
    }

    public void setDriversLicenseState(String driversLicenseState) {
        this.driversLicenseState = driversLicenseState;
    }

    @Column(name="drive_lic_exp_dt", length=10)
    public Date getDriversLicenseExpDate() {
        return this.driversLicenseExpDate;
    }

    public void setDriversLicenseExpDate(Date driversLicenseExpDate) {
        this.driversLicenseExpDate = driversLicenseExpDate;
    }

    public boolean getNotifyTAFinal() {
        return this.notifyTAFinal;
    }

    public boolean getNotifyTAStatusChange() {
        return this.notifyTAStatusChange;
    }

    public boolean getNotifyTERFinal() {
        return this.notifyTERFinal;
    }

    public boolean getNotifyTERStatusChange() {
        return this.notifyTERStatusChange;
    }

    @Column(name="citizenship", length=40, nullable=true)
    public String getCitizenship() {
        return this.citizenship;
    }

    public void setCitizenship(String citizenship) {
        this.citizenship = citizenship;
    }

    @Column(name="ACTV_IND", nullable=false, length=1)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isNotifyTAFinal() {
        return this.notifyTAFinal;
    }

    public void setNotifyTAFinal(boolean notifyTAFinal) {
        this.notifyTAFinal = notifyTAFinal;
    }

    public boolean isNotifyTAStatusChange() {
        return this.notifyTAStatusChange;
    }

    public void setNotifyTAStatusChange(boolean notifyTAStatusChange) {
        this.notifyTAStatusChange = notifyTAStatusChange;
    }

    public boolean isNotifyTERFinal() {
        return this.notifyTERFinal;
    }

    public void setNotifyTERFinal(boolean notifyTERFinal) {
        this.notifyTERFinal = notifyTERFinal;
    }

    public boolean isNotifyTERStatusChange() {
        return this.notifyTERStatusChange;
    }

    public void setNotifyTERStatusChange(boolean notifyTERStatusChange) {
        this.notifyTERStatusChange = notifyTERStatusChange;
    }

    public boolean isMotorVehicleRecordCheck() {
        return this.motorVehicleRecordCheck;
    }

    public void setMotorVehicleRecordCheck(boolean motorVehicleRecordCheck) {
        this.motorVehicleRecordCheck = motorVehicleRecordCheck;
    }

    @Column(name="non_res_alien", length=1, nullable=true)
    public Boolean getNonResidentAlien() {
        return this.nonResidentAlien;
    }

    public void setNonResidentAlien(Boolean nonResidentAlien) {
        this.nonResidentAlien = nonResidentAlien;
    }

    @Column(name="date_of_birth", length=10, nullable=false)
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @Column(name="gender", length=1, nullable=false)
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }
}

