/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.math.BigDecimal;
import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public abstract class ImportedExpenseBase
extends PersistableBusinessObjectBase {
    protected Long id;
    protected String creditCardOrAgencyCode;
    protected CreditCardAgency creditCardAgency;
    protected Date importDate;
    protected String travelCompany;
    protected String location;
    protected String travelExpenseTypeCode;
    protected KualiDecimal amount;
    protected Date transactionPostingDate;
    protected Date reconciliationDate;
    protected String reconciled;
    protected String description;
    protected BigDecimal currencyRate = new BigDecimal(1.0);
    protected KualiDecimal convertedAmount;
    protected Boolean reimbursable = Boolean.TRUE;
    protected Boolean missingReceipt = Boolean.FALSE;
    protected Boolean assigned = Boolean.FALSE;
    protected String documentNumber;
    protected Date expenseNotificationDate;

    @Column(name="ID", nullable=false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="CCA_CD", nullable=false)
    public String getCreditCardOrAgencyCode() {
        return this.creditCardOrAgencyCode;
    }

    public void setCreditCardOrAgencyCode(String creditCardOrAgencyCode) {
        this.creditCardOrAgencyCode = creditCardOrAgencyCode;
    }

    @ManyToOne
    @JoinColumn(name="CREDIT_AGENCY_CD")
    public CreditCardAgency getCreditCardAgency() {
        return this.creditCardAgency;
    }

    public void setCreditCardAgency(CreditCardAgency creditCardAgency) {
        this.creditCardAgency = creditCardAgency;
    }

    @Column(name="IMPORT_DT")
    public Date getImportDate() {
        return this.importDate;
    }

    public void setImportDate(Date importDate) {
        this.importDate = importDate;
    }

    @Column(name="COMPANY")
    public String getTravelCompany() {
        return this.travelCompany;
    }

    public void setTravelCompany(String travelCompany) {
        this.travelCompany = travelCompany;
    }

    @Column(name="LOCATION")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Column(name="EXP_TYP_CD")
    public String getTravelExpenseTypeCode() {
        return this.travelExpenseTypeCode;
    }

    public void setTravelExpenseTypeCode(String travelExpenseTypeCode) {
        this.travelExpenseTypeCode = travelExpenseTypeCode;
    }

    @Column(name="AMOUNT")
    public KualiDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(KualiDecimal amount) {
        this.amount = amount;
    }

    @Column(name="TRANS_POST_DT")
    public Date getTransactionPostingDate() {
        return this.transactionPostingDate;
    }

    public void setTransactionPostingDate(Date transactionPostingDate) {
        this.transactionPostingDate = transactionPostingDate;
    }

    @Column(name="RECON_DT")
    public Date getReconciliationDate() {
        return this.reconciliationDate;
    }

    public void setReconciliationDate(Date reconciliationDate) {
        this.reconciliationDate = reconciliationDate;
    }

    @Column(name="RECONCILED")
    public String getReconciled() {
        return this.reconciled;
    }

    public void setReconciled(String reconciled) {
        this.reconciled = reconciled;
    }

    @Column(name="DESCRIPTION")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="CURR_RT")
    public BigDecimal getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(BigDecimal currencyRate) {
        this.currencyRate = currencyRate;
    }

    @Column(name="CONV_AMT")
    public KualiDecimal getConvertedAmount() {
        if (this.convertedAmount == null) {
            this.convertedAmount = new KualiDecimal(this.amount.bigDecimalValue().multiply(this.currencyRate));
        }
        return this.convertedAmount;
    }

    public void setConvertedAmount(KualiDecimal convertedAmount) {
        this.convertedAmount = convertedAmount;
    }

    @Column(name="REIMB")
    public Boolean getReimbursable() {
        return this.reimbursable;
    }

    public void setReimbursable(Boolean reimbursable) {
        this.reimbursable = reimbursable;
    }

    @Column(name="MISSING_RCPT")
    public Boolean getMissingReceipt() {
        return this.missingReceipt;
    }

    public void setMissingReceipt(Boolean missingReceipt) {
        this.missingReceipt = missingReceipt;
    }

    @Column(name="ASSIGNED")
    public Boolean getAssigned() {
        return this.assigned;
    }

    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    @Column(name="DOC_NBR")
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Column(name="EXP_NTF_DT")
    public Date getExpenseNotificationDate() {
        return this.expenseNotificationDate;
    }

    public void setExpenseNotificationDate(Date expenseNotificationDate) {
        this.expenseNotificationDate = expenseNotificationDate;
    }
}

