/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.AccommodationType;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.MileageRate;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PrimaryDestination;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.MileageRateService;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@Entity
@Table(name="TEM_PER_DIEM_EXP_T")
public class PerDiemExpense
extends PersistableBusinessObjectBase {
    @Id
    @GeneratedValue(generator="TEM_PER_DIEM_EXP_ID_SEQ")
    @SequenceGenerator(name="TEM_PER_DIEM_EXP_ID_SEQ", sequenceName="TEM_PER_DIEM_EXP_ID_SEQ", allocationSize=5)
    @Column(name="ID", nullable=false)
    private Integer id;
    private String documentNumber;
    private String countryState;
    private String county;
    private String primaryDestination;
    private Boolean breakfast = Boolean.TRUE;
    private Boolean lunch = Boolean.TRUE;
    private Boolean dinner = Boolean.TRUE;
    private Boolean personal = Boolean.FALSE;
    private Boolean incidentalsWithMealsOnly;
    private KualiDecimal breakfastValue = KualiDecimal.ZERO;
    private KualiDecimal lunchValue = KualiDecimal.ZERO;
    private KualiDecimal dinnerValue = KualiDecimal.ZERO;
    private KualiDecimal incidentalsValue = KualiDecimal.ZERO;
    private Integer primaryDestinationId;
    private PrimaryDestination primaryDest;
    private PerDiem perDiem;
    private Integer miles = new Integer(0);
    private Timestamp mileageDate;
    private ExpenseType mileageRateExpenseType;
    private String mileageRateExpenseTypeCode;
    private String accommodationTypeCode;
    private String accommodationName;
    private String accommodationPhoneNum;
    private String accommodationAddress;
    private AccommodationType accommodationType;
    private KualiDecimal lodging = KualiDecimal.ZERO;
    private boolean prorated = false;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="FDOC_NBR", length=14, nullable=false)
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Column(name="COUNTRY", length=100, nullable=false)
    public String getCountryState() {
        return this.countryState;
    }

    public void setCountryState(String countryState) {
        this.countryState = countryState;
    }

    @Column(name="COUNTY_CD", length=100, nullable=false)
    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    @Column(name="PRI_DEST", length=100, nullable=false)
    public String getPrimaryDestination() {
        return this.primaryDestination;
    }

    public void setPrimaryDestination(String primaryDestination) {
        this.primaryDestination = primaryDestination;
    }

    @Column(name="BREAKFAST_IND", nullable=false, length=1)
    public Boolean getBreakfast() {
        return this.breakfast;
    }

    public void setBreakfast(Boolean breakfast) {
        this.breakfast = breakfast;
    }

    @Column(name="LUNCH_IND", nullable=false, length=1)
    public Boolean getLunch() {
        return this.lunch;
    }

    public void setLunch(Boolean lunch) {
        this.lunch = lunch;
    }

    @Column(name="DINNER_IND", nullable=false, length=1)
    public Boolean getDinner() {
        return this.dinner;
    }

    public void setDinner(Boolean dinner) {
        this.dinner = dinner;
    }

    public Integer getPrimaryDestinationId() {
        return this.primaryDestinationId;
    }

    public void setPrimaryDestinationId(Integer primaryDestinationId) {
        this.primaryDestinationId = primaryDestinationId;
    }

    public PrimaryDestination getPrimaryDest() {
        return this.primaryDest;
    }

    public void setPrimaryDest(PrimaryDestination primaryDest) {
        this.primaryDest = primaryDest;
    }

    @Column(name="ACCOM_TYP_CD", length=4)
    public String getAccommodationTypeCode() {
        return this.accommodationTypeCode;
    }

    public void setAccommodationTypeCode(String accommodationTypeCode) {
        this.accommodationTypeCode = accommodationTypeCode;
    }

    @ManyToOne
    @JoinColumn(name="ACCOM_TYP_CD")
    public AccommodationType getAccommodationType() {
        return this.accommodationType;
    }

    public void setAccommodationType(AccommodationType accommodationType) {
        this.accommodationType = accommodationType;
    }

    @Column(name="ACCOM_NM")
    public String getAccommodationName() {
        return this.accommodationName;
    }

    public void setAccommodationName(String accommodationName) {
        this.accommodationName = accommodationName;
    }

    @Column(name="ACCOM_PH")
    public String getAccommodationPhoneNum() {
        return this.accommodationPhoneNum;
    }

    public void setAccommodationPhoneNum(String accommodationPhoneNum) {
        this.accommodationPhoneNum = accommodationPhoneNum;
    }

    @Column(name="ACCOM_ADDRESS")
    public String getAccommodationAddress() {
        return this.accommodationAddress;
    }

    public void setAccommodationAddress(String accommodationAddress) {
        this.accommodationAddress = accommodationAddress;
    }

    @Column(name="LODGING", precision=19, scale=2)
    public KualiDecimal getLodging() {
        if (ObjectUtils.isNotNull((Object)this.lodging) && this.lodging.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return this.lodging;
        }
        return KualiDecimal.ZERO;
    }

    public KualiDecimal getUnfilteredLodging() {
        return this.lodging;
    }

    public void setUnfilteredLodging(KualiDecimal lodging) {
        this.lodging = lodging;
    }

    public void setLodging(KualiDecimal lodging) {
        this.lodging = lodging;
    }

    @Column(name="MILES", nullable=false)
    public Integer getMiles() {
        if (ObjectUtils.isNotNull((Object)this.miles) && this.miles > 0) {
            return this.miles;
        }
        return 0;
    }

    public void setMiles(Integer miles) {
        this.miles = miles;
    }

    public Integer getUnfilteredMiles() {
        return this.miles;
    }

    public void setUnfilteredMiles(Integer miles) {
        this.miles = miles;
    }

    public KualiDecimal getBreakfastValue() {
        if (ObjectUtils.isNotNull((Object)this.breakfastValue) && this.breakfastValue.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return this.breakfastValue;
        }
        return KualiDecimal.ZERO;
    }

    public void setBreakfastValue(KualiDecimal breakfastValue) {
        this.breakfastValue = breakfastValue;
    }

    public KualiDecimal getUnfilteredBreakfastValue() {
        return this.breakfastValue;
    }

    public void setUnfilteredBreakfastValue(KualiDecimal breakfastValue) {
        this.breakfastValue = breakfastValue;
    }

    public KualiDecimal getLunchValue() {
        if (ObjectUtils.isNotNull((Object)this.lunchValue) && this.lunchValue.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return this.lunchValue;
        }
        return KualiDecimal.ZERO;
    }

    public void setLunchValue(KualiDecimal lunchValue) {
        this.lunchValue = lunchValue;
    }

    public KualiDecimal getUnfilteredLunchValue() {
        return this.lunchValue;
    }

    public void setUnfilteredLunchValue(KualiDecimal lunchValue) {
        this.lunchValue = lunchValue;
    }

    public KualiDecimal getDinnerValue() {
        if (ObjectUtils.isNotNull((Object)this.dinnerValue) && this.dinnerValue.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return this.dinnerValue;
        }
        return KualiDecimal.ZERO;
    }

    public void setDinnerValue(KualiDecimal dinnerValue) {
        this.dinnerValue = dinnerValue;
    }

    public KualiDecimal getUnfilteredDinnerValue() {
        return this.dinnerValue;
    }

    public void setUnfilteredDinnerValue(KualiDecimal dinnerValue) {
        this.dinnerValue = dinnerValue;
    }

    @ManyToOne
    @JoinColumn(name="MILEAGE_RT_EXP_TYP_CD")
    public ExpenseType getMileageRateExpenseType() {
        return this.mileageRateExpenseType;
    }

    public void setMileageRateExpenseType(ExpenseType mileageRateExpenseType) {
        this.mileageRateExpenseType = mileageRateExpenseType;
    }

    @Column(name="MILEAGE_RT_EXP_TYP_CD")
    public String getMileageRateExpenseTypeCode() {
        return this.mileageRateExpenseTypeCode;
    }

    public void setMileageRateExpenseTypeCode(String mileageRateExpenseTypeCode) {
        this.mileageRateExpenseTypeCode = mileageRateExpenseTypeCode;
    }

    public MileageRate getMileageRate(Date effectiveDate) {
        return ((MileageRateService)SpringContext.getBean(MileageRateService.class)).findMileageRateByExpenseTypeCodeAndDate(this.getMileageRateExpenseTypeCode(), effectiveDate);
    }

    protected boolean isMileageDateWithinMileageRateRange(MileageRate mileageRate) {
        Date fromDate = mileageRate.getActiveFromDate();
        Date toDate = mileageRate.getActiveToDate();
        return !(!KfsDateUtils.isSameDay((java.util.Date)fromDate, (java.util.Date)this.getMileageDate()) && !fromDate.before(this.getMileageDate()) || !KfsDateUtils.isSameDay((java.util.Date)toDate, (java.util.Date)this.getMileageDate()) && !toDate.after(this.getMileageDate()));
    }

    public KualiDecimal getMileageTotal() {
        KualiDecimal total = KualiDecimal.ZERO;
        if (KNSGlobalVariables.getKualiForm() instanceof TravelFormBase) {
            TravelFormBase travelForm = (TravelFormBase)KNSGlobalVariables.getKualiForm();
            if (travelForm == null) {
                return KualiDecimal.ZERO;
            }
            TravelDocument travelDocument = travelForm.getTravelDocument();
            return this.getMileageTotalForDocument(travelDocument);
        }
        return total;
    }

    protected KualiDecimal getMileageTotalForDocument(TravelDocument travelDocument) {
        KualiDecimal total = KualiDecimal.ZERO;
        if (!this.personal.booleanValue()) {
            if (travelDocument == null) {
                return KualiDecimal.ZERO;
            }
            Date effectiveDate = travelDocument.getEffectiveDateForMileageRate(this);
            MileageRate rate = this.getMileageRate(effectiveDate);
            if (ObjectUtils.isNotNull((Object)((Object)rate)) && ObjectUtils.isNotNull((Object)this.miles) && this.miles > 0) {
                total = new KualiDecimal(new BigDecimal(this.miles).multiply(rate.getRate()));
            }
        }
        return total;
    }

    public KualiDecimal getDailyTotal() {
        KualiDecimal total = KualiDecimal.ZERO;
        if (!this.personal.booleanValue()) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getMileageTotal());
            total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getLodging());
            total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getMealsAndIncidentals());
        }
        return total;
    }

    public KualiDecimal getDailyTotalForDocument(TravelDocument travelDoc) {
        KualiDecimal total = KualiDecimal.ZERO;
        if (!this.personal.booleanValue()) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getMileageTotalForDocument(travelDoc));
            total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getLodging());
            total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getMealsAndIncidentals());
        }
        return total;
    }

    public KualiDecimal getMealsTotal() {
        KualiDecimal total = KualiDecimal.ZERO;
        if (!this.personal.booleanValue()) {
            if (this.breakfast.booleanValue()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getBreakfastValue());
            }
            if (this.lunch.booleanValue()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getLunchValue());
            }
            if (this.dinner.booleanValue()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getDinnerValue());
            }
        }
        return total;
    }

    public KualiDecimal getLodgingTotal() {
        if (!this.personal.booleanValue()) {
            return this.getLodging();
        }
        return KualiDecimal.ZERO;
    }

    @Column(name="MLG_DT")
    public Timestamp getMileageDate() {
        return this.mileageDate;
    }

    public KualiDecimal getMealsAndIncidentals() {
        KualiDecimal total = KualiDecimal.ZERO;
        if (!this.personal.booleanValue()) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getMealsTotal());
            total = (KualiDecimal)total.add((AbstractKualiDecimal)this.getIncidentalsValue());
        }
        return total;
    }

    public static KualiDecimal calculateMealsAndIncidentalsProrated(KualiDecimal total, Integer perDiemPercent) {
        KualiDecimal percent = (KualiDecimal)new KualiDecimal(perDiemPercent.intValue()).divide((AbstractKualiDecimal)new KualiDecimal(100));
        total = (KualiDecimal)total.multiply((AbstractKualiDecimal)percent);
        return total;
    }

    public void setMealsAndIncidentals(KualiDecimal mealsAndIncidentals) {
        KualiDecimal meal = (KualiDecimal)mealsAndIncidentals.divide((AbstractKualiDecimal)new KualiDecimal(4));
        this.setBreakfastValue(meal);
        this.setLunchValue(meal);
        this.setDinnerValue(meal);
        this.setIncidentalsValue((KualiDecimal)mealsAndIncidentals.subtract((AbstractKualiDecimal)this.getMealsTotal()));
    }

    @Column(name="PERSONAL", nullable=false, length=1)
    public Boolean getPersonal() {
        return this.personal;
    }

    public void setPersonal(Boolean personal) {
        this.personal = personal;
    }

    public void setMileageDate(Timestamp mileageDate) {
        this.mileageDate = mileageDate;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this.id);
        map.put("countryState", this.countryState);
        map.put("county", this.county);
        map.put("primaryDestination", this.primaryDestination);
        return map;
    }

    public KualiDecimal getDefaultMealsAndIncidentals() {
        KualiDecimal total = KualiDecimal.ZERO;
        if (!this.personal.booleanValue() && this.perDiem != null) {
            if (this.breakfast.booleanValue()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)this.perDiem.getBreakfast());
            }
            if (this.lunch.booleanValue()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)this.perDiem.getLunch());
            }
            if (this.dinner.booleanValue()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)this.perDiem.getDinner());
            }
            if (this.getIncludeIncidentals().booleanValue()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)this.perDiem.getIncidentals());
            }
        }
        return total;
    }

    public boolean isCustomPerDiem() {
        return this.primaryDestinationId == null || this.primaryDestinationId == Integer.MAX_VALUE;
    }

    public Boolean getIncludeIncidentals() {
        return this.breakfast != false || this.lunch != false || this.dinner != false || this.getIncidentalsWithMealsOnly() == false;
    }

    public Boolean getIncidentalsWithMealsOnly() {
        if (this.incidentalsWithMealsOnly == null) {
            boolean incidentalsWithMealsOnlyInd = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "INCIDENTALS_WITH_MEALS_IND", Boolean.FALSE);
            this.incidentalsWithMealsOnly = incidentalsWithMealsOnlyInd;
        }
        return this.incidentalsWithMealsOnly;
    }

    public void setIncidentalsWithMealsOnly(Boolean incidentalsWithMealsOnly) {
        this.incidentalsWithMealsOnly = incidentalsWithMealsOnly;
    }

    public KualiDecimal getIncidentalsValue() {
        if (this.getIncludeIncidentals().booleanValue() && ObjectUtils.isNotNull((Object)this.incidentalsValue) && this.incidentalsValue.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return this.incidentalsValue;
        }
        return KualiDecimal.ZERO;
    }

    public void setIncidentalsValue(KualiDecimal incidentalsValue) {
        this.incidentalsValue = incidentalsValue;
    }

    public KualiDecimal getUnfilteredIncidentalsValue() {
        return this.incidentalsValue;
    }

    public void setUnfilteredIncidentalsValue(KualiDecimal incidentalsValue) {
        this.incidentalsValue = incidentalsValue;
    }

    public boolean isProrated() {
        if (this.isCustomPerDiem()) {
            return false;
        }
        return this.prorated;
    }

    public void setProrated(boolean prorated) {
        this.prorated = prorated;
    }

    public String getCountryStateText() {
        return this.countryState;
    }

    public void setCountryStateText(String countryState) {
        this.countryState = countryState;
    }
}

