/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

@Entity
@Table(name="TEM_PROFILE_ARRANGER_T")
public class TemProfileArranger
extends PersistableBusinessObjectBase
implements MutableInactivatable {
    private Integer arrangerId;
    private String principalId;
    private String principalName;
    private Integer profileId;
    private TemProfile profile;
    private Boolean taInd = Boolean.FALSE;
    private Boolean trInd = Boolean.FALSE;
    private Boolean active = Boolean.TRUE;
    private Boolean primary = Boolean.FALSE;
    private Person principal;

    @Id
    @GeneratedValue(generator="TEM_PROFILE_ARRANGER_ID_SEQ")
    @SequenceGenerator(name="TEM_PROFILE_ARRANGER_ID_SEQ", sequenceName="TEM_PROFILE_ARRANGER_ID_SEQ", allocationSize=5)
    @Column(name="arranger_id", nullable=false)
    public Integer getArrangerId() {
        return this.arrangerId;
    }

    public void setArrangerId(Integer arrangerId) {
        this.arrangerId = arrangerId;
    }

    public Boolean getTaInd() {
        return this.taInd;
    }

    public void setTaInd(Boolean taInd) {
        this.taInd = taInd;
    }

    public Boolean getTrInd() {
        return this.trInd;
    }

    public void setTrInd(Boolean trInd) {
        this.trInd = trInd;
    }

    @Column(name="prncpl_id", length=40, nullable=true)
    public String getPrincipalId() {
        this.setupPrincipal();
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    @Column(name="ACTV_IND", nullable=false, length=1)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="primary_ind", nullable=false, length=1)
    public boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Column(name="profile_id", nullable=false, length=19)
    public Integer getProfileId() {
        return this.profileId;
    }

    public void setProfileId(Integer profileId) {
        this.profileId = profileId;
    }

    @JoinColumn(name="profile_id")
    public TemProfile getProfile() {
        return this.profile;
    }

    public void setProfile(TemProfile profile) {
        this.profile = profile;
    }

    public String getPrincipalName() {
        this.setupPrincipal();
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public void setPrincipal(Person principal) {
        this.principal = principal;
        this.setPrincipalId(principal.getPrincipalId());
        this.setPrincipalName(principal.getPrincipalName());
    }

    public Person getPrincipal() {
        return this.principal;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        return null;
    }

    private void setupPrincipal() {
        if (this.getPrincipal() == null) {
            Person person = null;
            if (this.principalName != null) {
                person = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByPrincipalName(this.principalName);
            } else if (this.principalId != null) {
                person = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(this.principalId);
            }
            if (person != null) {
                this.setPrincipal(person);
            }
        }
    }
}

