/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.inquiry;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.FieldRestriction;
import org.kuali.kfs.kns.inquiry.InquiryRestrictions;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class TemProfileInquirableImpl
extends KualiInquirableImpl {
    private static final Logger LOG = Logger.getLogger(TemProfileInquirableImpl.class);

    public BusinessObject getBusinessObject(Map fieldValues) {
        TemProfile profile = (TemProfile)super.getBusinessObject(fieldValues);
        ((TemProfileService)SpringContext.getBean(TemProfileService.class)).updateACHAccountInfo(profile);
        return profile;
    }

    public List<Section> getSections(BusinessObject bo) {
        List sections = super.getSections(bo);
        Person currUser = GlobalVariables.getUserSession().getPerson();
        InquiryRestrictions inquiryRestrictions = KNSServiceLocator.getBusinessObjectAuthorizationService().getInquiryRestrictions(bo, currUser);
        TemProfile profile = (TemProfile)bo;
        String principalId = profile.getPrincipalId();
        if (StringUtils.isNotBlank((String)principalId) && StringUtils.equalsIgnoreCase((String)currUser.getPrincipalId().trim(), (String)principalId)) {
            for (Section section : sections) {
                List rows = section.getRows();
                for (Row row : rows) {
                    List rowFields = row.getFields();
                    for (Field field : rowFields) {
                        FieldRestriction restriction;
                        if (field.getFieldType().equalsIgnoreCase("container")) {
                            List containerRows = field.getContainerRows();
                            for (Row containerRow : containerRows) {
                                List containerRowFields = containerRow.getFields();
                                for (Field containerRowField : containerRowFields) {
                                    restriction = inquiryRestrictions.getFieldRestriction(containerRowField.getPropertyName());
                                    if (!restriction.isMasked() && !restriction.isPartiallyMasked()) continue;
                                    containerRowField.setSecure(false);
                                }
                            }
                        }
                        if (!(restriction = inquiryRestrictions.getFieldRestriction(field.getPropertyName())).isMasked() && !restriction.isPartiallyMasked()) continue;
                        field.setSecure(false);
                    }
                }
            }
        }
        return sections;
    }
}

