/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.GroupTravelerForLookup;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;

public class GroupTravelerForLookupLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    protected AccountsReceivableModuleService accountsReceivableModuleService;
    protected volatile String facultyAffiliationType = "FCLTY";
    protected volatile String staffAffiliationType = "STAFF";
    protected volatile String studentAffiliationType = "STDNT";

    public void validateSearchParameters(Map fieldValues) {
        super.validateSearchParameters(fieldValues);
        this.checkMinimumFieldsFilled(fieldValues);
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("errors in search criteria");
        }
    }

    public boolean checkMinimumFieldsFilled(Map fieldValues) {
        if (StringUtils.isBlank((String)((String)fieldValues.get("customerNumber"))) && StringUtils.isBlank((String)((String)fieldValues.get("customerName"))) && StringUtils.isBlank((String)((String)fieldValues.get("employeeId"))) && StringUtils.isBlank((String)((String)fieldValues.get("firstName"))) && StringUtils.isBlank((String)((String)fieldValues.get("lastName"))) && StringUtils.isBlank((String)((String)fieldValues.get("person.principalName")))) {
            String customerNumberLabel = this.getAttributeLabel("customerNumber");
            String customerNameLabel = this.getAttributeLabel("customerName");
            String principalNameLabel = this.getAttributeLabel("person.principalName");
            String firstNameLabel = this.getAttributeLabel("firstName");
            String lastNameLabel = this.getAttributeLabel("lastName");
            String employeeIdLabel = this.getAttributeLabel("employeeId");
            GlobalVariables.getMessageMap().putError("person.principalName", "error.groupTraveler.lookupNeedsSomeField", new String[]{customerNumberLabel, customerNameLabel, firstNameLabel, lastNameLabel, principalNameLabel, employeeIdLabel});
            return false;
        }
        return true;
    }

    protected String getAttributeLabel(String attributeName) {
        return this.getDataDictionaryService().getAttributeLabel(GroupTravelerForLookup.class, attributeName);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        ArrayList<GroupTravelerForLookup> searchResults = new ArrayList<GroupTravelerForLookup>();
        if (StringUtils.isNotBlank((String)fieldValues.get("customerNumber")) || StringUtils.isNotBlank((String)fieldValues.get("customerName"))) {
            searchResults.addAll(this.getCustomersAsGroupTravelers(fieldValues));
        } else if (StringUtils.isNotBlank((String)fieldValues.get("employeeId")) || !StringUtils.isBlank((String)fieldValues.get("person.principalName"))) {
            searchResults.addAll(this.getPersonsAsGroupTravelers(fieldValues));
        } else {
            searchResults.addAll(this.getCustomersAsGroupTravelers(fieldValues));
            searchResults.addAll(this.getPersonsAsGroupTravelers(fieldValues));
        }
        return this.sortSearchResults(searchResults);
    }

    protected Map<String, String> getPersonFieldValues(Map<String, String> fieldValues) {
        HashMap<String, String> personFieldValues = new HashMap<String, String>();
        personFieldValues.put("principalName", fieldValues.get("person.principalName"));
        personFieldValues.put("firstName", fieldValues.get("firstName"));
        personFieldValues.put("lastName", fieldValues.get("lastName"));
        if (!StringUtils.isBlank((String)fieldValues.get("employeeId"))) {
            personFieldValues.put("employeeId", fieldValues.get("employeeId"));
            personFieldValues.put("employeeStatusCode", "A");
        }
        personFieldValues.put("active", fieldValues.get("active"));
        return personFieldValues;
    }

    protected GroupTravelerForLookup getGroupTravelerFromPerson(Person personDetail, Map<String, String> fieldValues) {
        GroupTravelerForLookup traveler = new GroupTravelerForLookup();
        traveler.setPrincipalId(personDetail.getPrincipalId());
        traveler.setFirstName(personDetail.getFirstNameUnmasked());
        traveler.setLastName(personDetail.getLastNameUnmasked());
        traveler.setEmployeeId(personDetail.getEmployeeId());
        traveler.setName(personDetail.getNameUnmasked());
        if (personDetail.hasAffiliationOfType(this.getFacultyAffiliationType()) || personDetail.hasAffiliationOfType(this.getStaffAffiliationType())) {
            traveler.setGroupTravelerTypeCode(TemConstants.GroupTravelerType.EMPLOYEE);
        } else if (personDetail.hasAffiliationOfType(this.getStudentAffiliationType())) {
            traveler.setGroupTravelerTypeCode(TemConstants.GroupTravelerType.STUDENT);
        } else {
            traveler.setGroupTravelerTypeCode(TemConstants.GroupTravelerType.OTHER);
        }
        traveler.setActive(personDetail.isActive());
        return traveler;
    }

    protected List<GroupTravelerForLookup> getPersonsAsGroupTravelers(Map<String, String> fieldValues) {
        ArrayList<GroupTravelerForLookup> groupTravelerList = new ArrayList<GroupTravelerForLookup>();
        Map<String, String> fieldsForLookup = this.getPersonFieldValues(fieldValues);
        List persons = ((PersonService)SpringContext.getBean(PersonService.class)).findPeople(fieldsForLookup);
        for (Person personDetail : persons) {
            GroupTravelerForLookup groupTraveler = this.getGroupTravelerFromPerson(personDetail, fieldValues);
            groupTravelerList.add(groupTraveler);
        }
        return groupTravelerList;
    }

    protected Map<String, String> getCustomerFieldValues(Map<String, String> fieldValues) {
        HashMap<String, String> customerFieldValues = new HashMap<String, String>();
        customerFieldValues.put("customerNumber", fieldValues.get("customerNumber"));
        if (!StringUtils.isBlank((String)fieldValues.get("customerName"))) {
            customerFieldValues.put("customerName", fieldValues.get("customerName"));
        } else if (!StringUtils.isBlank((String)fieldValues.get("firstName")) && !StringUtils.isBlank((String)fieldValues.get("lastName"))) {
            String name = fieldValues.get("firstName") + " " + fieldValues.get("lastName");
            customerFieldValues.put("customerName", name);
        } else if (!StringUtils.isBlank((String)fieldValues.get("firstName"))) {
            String name = fieldValues.get("firstName") + "*";
            customerFieldValues.put("customerName", name);
        } else if (!StringUtils.isBlank((String)fieldValues.get("lastName"))) {
            String name = "*" + fieldValues.get("lastName");
            customerFieldValues.put("customerName", name);
        }
        customerFieldValues.put("active", fieldValues.get("active"));
        return customerFieldValues;
    }

    protected GroupTravelerForLookup getGroupTravelerFromCustomer(AccountsReceivableCustomer customer, Map<String, String> fieldValues) {
        GroupTravelerForLookup traveler = new GroupTravelerForLookup();
        traveler.setCustomerName(customer.getCustomerName());
        traveler.setCustomerNumber(customer.getCustomerNumber());
        traveler.setName(customer.getCustomerName());
        traveler.setActive(customer.isActive());
        traveler.setGroupTravelerTypeCode(TemConstants.GroupTravelerType.CUSTOMER);
        return traveler;
    }

    protected List<GroupTravelerForLookup> getCustomersAsGroupTravelers(Map<String, String> fieldValues) {
        ArrayList<GroupTravelerForLookup> groupTravelerList = new ArrayList<GroupTravelerForLookup>();
        Map<String, String> fieldsForLookup = this.getCustomerFieldValues(fieldValues);
        List customerList = (List)this.getAccountsReceivableModuleService().searchForCustomers(fieldsForLookup);
        for (AccountsReceivableCustomer customer : customerList) {
            GroupTravelerForLookup groupTraveler = this.getGroupTravelerFromCustomer(customer, fieldValues);
            groupTravelerList.add(groupTraveler);
        }
        return groupTravelerList;
    }

    protected List<? extends BusinessObject> sortSearchResults(List<GroupTravelerForLookup> searchResults) {
        CollectionIncomplete results = new CollectionIncomplete(searchResults, Long.valueOf(searchResults.size()));
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(results, new BeanPropertyComparator(this.getDefaultSortColumns(), true));
        }
        return results;
    }

    public AccountsReceivableModuleService getAccountsReceivableModuleService() {
        return this.accountsReceivableModuleService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }

    public String getFacultyAffiliationType() {
        return this.facultyAffiliationType;
    }

    public void setFacultyAffiliationType(String facultyAffiliationType) {
        this.facultyAffiliationType = facultyAffiliationType;
    }

    public String getStaffAffiliationType() {
        return this.staffAffiliationType;
    }

    public void setStaffAffiliationType(String staffAffiliationType) {
        this.staffAffiliationType = staffAffiliationType;
    }

    public String getStudentAffiliationType() {
        return this.studentAffiliationType;
    }

    public void setStudentAffiliationType(String studentAffiliationType) {
        this.studentAffiliationType = studentAffiliationType;
    }
}

