/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileFromKimPerson;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.krad.bo.BusinessObject;

public class TemProfileFromKimLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    public static Logger LOG = Logger.getLogger(TemProfileFromKimLookupableHelperServiceImpl.class);
    private TravelerService travelerService;
    private PersonService personService;
    private TemProfileService temProfileService;

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        lookupForm.setSuppressActions(false);
        lookupForm.setSupplementalActionsEnabled(true);
        lookupForm.setHideReturnLink(false);
        lookupForm.setShowMaintenanceLinks(true);
        return super.performLookup(lookupForm, resultTable, bounded);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        ArrayList<TemProfileFromKimPerson> searchResults = new ArrayList<TemProfileFromKimPerson>();
        Map<String, String> kimFieldsForLookup = this.getPersonFieldValues(fieldValues);
        LOG.debug((Object)("Looking up people with criteria " + kimFieldsForLookup));
        List persons = this.personService.findPeople(kimFieldsForLookup);
        for (Person personDetail : persons) {
            if (StringUtils.isBlank((String)personDetail.getPrincipalId())) continue;
            searchResults.add(this.travelerService.convertToTemProfileFromKim(personDetail));
        }
        CollectionIncomplete results = new CollectionIncomplete(searchResults, Long.valueOf(searchResults.size()));
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(results, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return results;
    }

    public Class getBusinessObjectClass() {
        return TemProfileFromKimPerson.class;
    }

    protected Map<String, String> getPersonFieldValues(Map<String, String> fieldValues) {
        BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(PersonImpl.class.getName());
        List lookupFields = businessObjectEntry.getLookupDefinition().getLookupFields();
        HashMap<String, String> personFieldValues = new HashMap<String, String>();
        for (FieldDefinition lookupField : lookupFields) {
            String attrName = lookupField.getAttributeName();
            if (!this.containsAttribute(PersonImpl.class, attrName)) continue;
            personFieldValues.put(attrName, fieldValues.get(attrName));
        }
        return personFieldValues;
    }

    protected boolean containsAttribute(Class boClass, String attributeName) {
        return this.getDataDictionaryService().isAttributeDefined(boClass, attributeName);
    }

    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        return super.getSearchResultsUnbounded(fieldValues);
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        TemRoleService temRoleService = (TemRoleService)SpringContext.getBean(TemRoleService.class);
        boolean profileAdmin = temRoleService.isProfileAdmin(GlobalVariables.getUserSession().getPerson(), ((TemProfileFromKimPerson)businessObject).getPrimaryDepartmentCode());
        if (!profileAdmin) {
            return htmlDataList;
        }
        String principalId = ((TemProfileFromKimPerson)businessObject).getPrincipalId();
        if (!StringUtils.isBlank((String)principalId)) {
            Properties parameters = new Properties();
            parameters.put("businessObjectClassName", TemProfile.class.getName());
            parameters.put("overrideKeys", "principalId");
            parameters.put("refreshCaller", "principalId::" + principalId);
            parameters.put("principalId", principalId);
            HashMap<String, String> criteria = new HashMap<String, String>(2);
            criteria.put("principalId", principalId);
            if (this.temProfileService.findTemProfile(criteria) == null) {
                parameters.put("methodToCall", "start");
                String href = UrlFactory.parameterizeUrl((String)"maintenance.do", (Properties)parameters);
                HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "start", "create new profile");
                htmlDataList.add(anchorHtmlData);
            } else {
                parameters.put("methodToCall", "edit");
                String href = UrlFactory.parameterizeUrl((String)"maintenance.do", (Properties)parameters);
                HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "start", "edit profile");
                htmlDataList.add(anchorHtmlData);
            }
        }
        return htmlDataList;
    }

    public void applyConditionalLogicForFieldDisplay() {
        super.applyConditionalLogicForFieldDisplay();
        LookupForm lookupForm = (LookupForm)KNSGlobalVariables.getKualiForm();
        lookupForm.setShowMaintenanceLinks(true);
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTravelerService(TravelerService travelerService) {
        this.travelerService = travelerService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }
}

