/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerType;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.businessobject.datadictionary.TravelDetailLookupMappedFieldProxy;
import org.kuali.kfs.module.tem.dataaccess.TravelerDao;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.krad.bo.BusinessObject;

public class TravelerLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    public static Logger LOG = Logger.getLogger(TravelerLookupableHelperServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private PersonService personService;
    private TravelerService travelerService;
    private TravelerDao travelerDao;
    private AccountsReceivableModuleService accountsReceivableModuleService;
    private static final int NAME_REQUIRED_FILLED_WITH_WILDCARD = 4;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        ArrayList<TravelerDetail> searchResults = new ArrayList<TravelerDetail>();
        if (this.isEmployeeSearch(fieldValues)) {
            searchResults.addAll(this.getEmployeesAsTravelers(fieldValues));
        } else {
            LOG.debug((Object)"Doing search for customers");
            searchResults.addAll(this.getNonEmployeesAsTravelers(fieldValues));
        }
        CollectionIncomplete results = new CollectionIncomplete(searchResults, Long.valueOf(searchResults.size()));
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(results, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return results;
    }

    public void validateSearchParameters(Map fieldValues) {
        super.validateSearchParameters(fieldValues);
        if (fieldValues.get("travelerTypeCode") == null || fieldValues.get("travelerTypeCode").equals("")) {
            GlobalVariables.getMessageMap().putError("travelerTypeCode", "error.document.tem.travelerSearchEmployeeType", new String[]{(String)fieldValues.get("travelerTypeCode")});
        }
        if (!this.isEmployeeSearch(fieldValues) && !this.isNonEmployeeSearch(fieldValues)) {
            GlobalVariables.getMessageMap().putError("travelerTypeCode", "error.document.tem.travelerSearch", new String[]{(String)fieldValues.get("travelerTypeCode")});
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("errors in search criteria");
        }
    }

    protected Map<String, String> convertFieldValues(Class boClass, Map<String, String> fieldValues) {
        HashMap<String, String> retval = new HashMap<String, String>();
        LOG.debug((Object)("Converting field values " + fieldValues));
        for (FieldDefinition lookupField : this.getLookupFieldsFor(TravelerDetail.class.getName())) {
            String attrName = lookupField.getAttributeName();
            if (lookupField instanceof TravelDetailLookupMappedFieldProxy) {
                TravelDetailLookupMappedFieldProxy mappedField = (TravelDetailLookupMappedFieldProxy)lookupField;
                String key = mappedField.getAttributeMap().get(boClass.getSimpleName());
                String value = fieldValues.get(attrName);
                if (retval.containsKey(key)) {
                    value = (String)retval.get(key) + value;
                }
                if (key != null) {
                    retval.put(key, value);
                    continue;
                }
                LOG.warn((Object)("Got a null key for attribute name " + attrName));
                continue;
            }
            if (!this.containsAttribute(boClass, attrName)) continue;
            retval.put(attrName, fieldValues.get(attrName));
        }
        return retval;
    }

    protected Map<String, String> getPersonFieldValues(Map<String, String> fieldValues) {
        return this.convertFieldValues(PersonImpl.class, fieldValues);
    }

    protected Map<String, String> getCustomerFieldValues(Map<String, String> fieldValues) {
        return this.convertFieldValues(this.getAccountsReceivableModuleService().createCustomer().getClass(), fieldValues);
    }

    protected boolean isEmployeeSearch(Map<String, String> fieldValues) {
        LOG.debug((Object)("Checking traveler type code " + fieldValues.get("travelerTypeCode")));
        String employeeTypes = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "EMPLOYEE_TRAVELER_TYPE_CODES");
        return employeeTypes.indexOf(fieldValues.get("travelerTypeCode")) != -1;
    }

    protected boolean isNonEmployeeSearch(Map<String, String> fieldValues) {
        LOG.debug((Object)("Checking traveler type code " + fieldValues.get("travelerTypeCode")));
        String nonEmployeeTypes = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "NON_EMPLOYEE_TRAVELER_TYPE_CODES");
        return nonEmployeeTypes.indexOf(fieldValues.get("travelerTypeCode")) != -1;
    }

    protected boolean isKimOnlySearch(Map<String, String> fieldValues) {
        return fieldValues.get("principalName") != null || fieldValues.get("principalId") != null;
    }

    protected List<TravelerDetail> getEmployeesAsTravelers(Map<String, String> fieldValues) {
        ArrayList<TravelerDetail> travelers = new ArrayList<TravelerDetail>();
        Map<String, String> kimFieldsForLookup = this.getPersonFieldValues(fieldValues);
        LOG.debug((Object)("Looking up people with criteria " + kimFieldsForLookup));
        List persons = this.getPersonService().findPeople(kimFieldsForLookup);
        for (Person personDetail : persons) {
            travelers.add(this.getTravelerService().convertToTraveler(personDetail));
        }
        if (!this.isKimOnlySearch(fieldValues)) {
            Map<String, String> arFieldsForLookup = this.getCustomerFieldValues(fieldValues);
            Collection<AccountsReceivableCustomer> customers = this.getTravelerDao().findCustomersBy(arFieldsForLookup);
            for (AccountsReceivableCustomer customer : customers) {
                travelers.add(this.getTravelerService().convertToTraveler(customer));
            }
        }
        return travelers;
    }

    protected List<TravelerDetail> getNonEmployeesAsTravelers(Map<String, String> fieldValues) {
        ArrayList<TravelerDetail> travelers = new ArrayList<TravelerDetail>();
        Map<String, String> fieldsForLookup = this.getCustomerFieldValues(fieldValues);
        List customerTypeList = this.getAccountsReceivableModuleService().findByCustomerTypeDescription("Traveler");
        LOG.debug((Object)("Got customer types " + customerTypeList));
        LOG.debug((Object)("Got customer types " + customerTypeList.size()));
        if (customerTypeList != null && customerTypeList.size() > 0) {
            LOG.debug((Object)"Adding customerTypeCode to fields to lookup");
            fieldsForLookup.put("customerTypeCode", ((AccountsReceivableCustomerType)customerTypeList.get(0)).getCustomerTypeCode());
        }
        LOG.debug((Object)("Using fieldsForLookup " + fieldsForLookup));
        Collection<AccountsReceivableCustomer> customers = this.getTravelerDao().findCustomersBy(fieldsForLookup);
        for (AccountsReceivableCustomer customer : customers) {
            travelers.add(this.getTravelerService().convertToTraveler(customer));
        }
        return travelers;
    }

    protected void replaceFieldKeys(Map<String, String> fieldValues, Map<String, String> helperMap) {
        for (String key : helperMap.keySet()) {
            if (!fieldValues.containsKey(key)) continue;
            String value = fieldValues.get(key);
            String newKey = helperMap.get(key);
            fieldValues.remove(key);
            fieldValues.put(newKey, value);
        }
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected Collection<FieldDefinition> getLookupFieldsFor(String className) {
        BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(className);
        return businessObjectEntry.getLookupDefinition().getLookupFields();
    }

    protected boolean containsAttribute(Class boClass, String attributeName) {
        return this.getDataDictionaryService().isAttributeDefined(boClass, attributeName);
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    protected TravelerDao getTravelerDao() {
        return this.travelerDao;
    }

    public void setTravelerDao(TravelerDao travelerDao) {
        this.travelerDao = travelerDao;
    }

    public void setTravelerService(TravelerService travelerService) {
        this.travelerService = travelerService;
    }

    public TravelerService getTravelerService() {
        return this.travelerService;
    }

    protected AccountsReceivableModuleService getAccountsReceivableModuleService() {
        if (this.accountsReceivableModuleService == null) {
            this.accountsReceivableModuleService = (AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class);
        }
        return this.accountsReceivableModuleService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }
}

