/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.fp.document.DisbursementVoucherDocument;
import org.kuali.kfs.integration.purap.PurchasingAccountsPayableModuleService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TravelPayment;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.kfs.sys.batch.service.PaymentSourceExtractionService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.PaymentSourceWireTransfer;
import org.kuali.kfs.sys.businessobject.WireCharge;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.PaymentSource;
import org.kuali.kfs.sys.document.service.PaymentSourceHelperService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public abstract class TEMReimbursementDocument
extends TravelDocumentBase
implements PaymentSource {
    private String paymentMethod = "P";
    private TravelPayment travelPayment;
    private PaymentSourceWireTransfer wireTransfer;
    private volatile transient Person initiator;
    private Date corporateCardPaymentExtractDate;
    private Date corporateCardPaymentPaidDate;
    private Date corporateCardPaymentCancelDate;
    private static volatile transient PaymentSourceHelperService paymentSourceHelperService;
    private static volatile transient PaymentSourceExtractionService paymentSourceExtractionService;
    private static volatile transient AccountingDocumentRelationshipService accountingDocumentRelationshipService;
    private static volatile transient PurchasingAccountsPayableModuleService purapModuleService;

    @Column(name="PAYMENT_METHOD", nullable=true, length=15)
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public TravelPayment getTravelPayment() {
        return this.travelPayment;
    }

    public void setTravelPayment(TravelPayment travelPayment) {
        this.travelPayment = travelPayment;
    }

    public PaymentSourceWireTransfer getWireTransfer() {
        return this.wireTransfer;
    }

    public void setWireTransfer(PaymentSourceWireTransfer wireTransfer) {
        this.wireTransfer = wireTransfer;
    }

    @Override
    public void initiateDocument() {
        super.initiateDocument();
        this.setActualExpenses(new ArrayList<ActualExpense>());
        this.setPerDiemExpenses(new ArrayList<PerDiemExpense>());
        Calendar calendar = TEMReimbursementDocument.getDateTimeService().getCurrentCalendar();
        if (this.getTripBegin() == null) {
            calendar.add(5, 1);
            this.setTripBegin(new Timestamp(calendar.getTimeInMillis()));
        }
        if (this.getTripEnd() == null) {
            calendar.add(5, 2);
            this.setTripEnd(new Timestamp(calendar.getTimeInMillis()));
        }
        this.travelPayment = new TravelPayment();
        this.wireTransfer = new PaymentSourceWireTransfer();
        calendar = TEMReimbursementDocument.getDateTimeService().getCurrentCalendar();
        calendar.add(5, 1);
        this.travelPayment.setDueDate(new Date(calendar.getTimeInMillis()));
        this.travelPayment.setCheckStubText(this.getConfigurationService().getPropertyValueAsString("message.document.tem.reimbursement.payment.checkText.holdingText"));
        this.setDefaultBankCode();
        this.updatePayeeTypeForReimbursable();
    }

    public void updatePayeeTypeForReimbursable() {
        if (!(ObjectUtils.isNull((Object)((Object)this.getTraveler())) || ObjectUtils.isNull((Object)((Object)this.getTravelPayment())) || StringUtils.isBlank((String)this.getTraveler().getTravelerTypeCode()))) {
            if (this.getTravelerService().isEmployee(this.getTraveler())) {
                this.getTravelPayment().setPayeeTypeCode("E");
            } else {
                this.getTravelPayment().setPayeeTypeCode("C");
            }
        }
    }

    @Override
    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        LOG.info((Object)"processDocumentGenerateGeneralLedgerPendingEntries for TEMReimbursementDocument - start");
        boolean success = true;
        boolean doGenerate = true;
        success = super.generateDocumentGeneralLedgerPendingEntries(sequenceHelper);
        KualiDecimal reimbursableToTraveler = this.getAmountForTravelClearing();
        if ("W".equals(this.getTravelPayment().getPaymentMethodCode()) && !this.getWireTransfer().isWireTransferFeeWaiverIndicator()) {
            LOG.debug((Object)"generating wire charge gl pending entries.");
            WireCharge wireCharge = TEMReimbursementDocument.getPaymentSourceHelperService().retrieveCurrentYearWireCharge();
            GeneralLedgerPendingEntry chargeEntry = TEMReimbursementDocument.getPaymentSourceHelperService().processWireChargeDebitEntries((PaymentSource)this, sequenceHelper, wireCharge);
            TEMReimbursementDocument.getPaymentSourceHelperService().processWireChargeCreditEntries((PaymentSource)this, sequenceHelper, wireCharge, chargeEntry);
        }
        if ("W".equals(this.getTravelPayment().getPaymentMethodCode()) || "F".equals(this.getTravelPayment().getPaymentMethodCode())) {
            TEMReimbursementDocument.getPaymentSourceHelperService().generateDocumentBankOffsetEntries((PaymentSource)this, sequenceHelper, this.getWireTransferOrForeignDraftDocumentType());
        }
        LOG.info((Object)"processDocumentGenerateGeneralLedgerPendingEntries for TEMReimbursementDocument - end");
        return success;
    }

    protected KualiDecimal getAmountForTravelClearing() {
        KualiDecimal reimbursableToTraveler = this.getTravelReimbursementService().getReimbursableToTraveler(this);
        return reimbursableToTraveler;
    }

    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        explicitEntry.setFinancialDocumentTypeCode(this.getPaymentDocumentType());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("changing doc type on pending entry " + explicitEntry.getTransactionLedgerEntrySequenceNumber() + " to " + explicitEntry.getFinancialDocumentTypeCode()));
        }
    }

    public String getPaymentDocumentType() {
        if (!StringUtils.isBlank((String)this.getTravelPayment().getPaymentMethodCode())) {
            if ("P".equals(this.getTravelPayment().getPaymentMethodCode())) {
                return this.getAchCheckDocumentType();
            }
            return this.getWireTransferOrForeignDraftDocumentType();
        }
        return this.getDocumentTypeName();
    }

    public abstract String getAchCheckDocumentType();

    public abstract String getWireTransferOrForeignDraftDocumentType();

    public String getCorporateCardPaymentAchCheckDocumentType() {
        return "RCCA";
    }

    @Override
    public KualiDecimal getReimbursableTotal() {
        KualiDecimal eligible = this.getEligibleAmount();
        KualiDecimal expenseLimit = this.getExpenseLimit();
        if (expenseLimit != null && expenseLimit.doubleValue() > 0.0) {
            return eligible.isGreaterThan((AbstractKualiDecimal)expenseLimit) ? expenseLimit : eligible;
        }
        return eligible;
    }

    public KualiDecimal getEligibleAmount() {
        return (KualiDecimal)((KualiDecimal)this.getApprovedAmount().subtract((AbstractKualiDecimal)this.getCTSTotal())).subtract((AbstractKualiDecimal)this.getCorporateCardTotal());
    }

    public KualiDecimal getTotalPaidAmountToVendor() {
        KualiDecimal totalPaidAmountToVendor = KualiDecimal.ZERO;
        List<Document> relatedDisbursementList = this.getTravelDocumentService().getDocumentsRelatedTo(this, "DV");
        for (Document document : relatedDisbursementList) {
            DisbursementVoucherDocument dv;
            if (!(document instanceof DisbursementVoucherDocument) || !(dv = (DisbursementVoucherDocument)document).getDocumentHeader().getWorkflowDocument().isFinal()) continue;
            totalPaidAmountToVendor = (KualiDecimal)totalPaidAmountToVendor.add((AbstractKualiDecimal)dv.getDisbVchrCheckTotalAmount());
        }
        return totalPaidAmountToVendor;
    }

    public KualiDecimal getTotalPaidAmountToRequests() {
        KualiDecimal totalPaidAmountToRequests = KualiDecimal.ZERO;
        Set<String> documentNumbers = TEMReimbursementDocument.getAccountingDocumentRelationshipService().huntForRelatedDocumentNumbersWithDocumentType(this.documentNumber, "REQS");
        if (documentNumbers != null && !documentNumbers.isEmpty()) {
            ArrayList<String> relatedRequisitionDocumentNumbers = new ArrayList<String>();
            relatedRequisitionDocumentNumbers.addAll(documentNumbers);
            totalPaidAmountToRequests = TEMReimbursementDocument.getPurchasingAccountsPayableModuleService().getTotalPaidAmountToRequisitions(relatedRequisitionDocumentNumbers);
        }
        return totalPaidAmountToRequests;
    }

    public KualiDecimal getReimbursableGrandTotal() {
        KualiDecimal grandTotal = KualiDecimal.ZERO;
        grandTotal = (KualiDecimal)((KualiDecimal)this.getApprovedAmount().add((AbstractKualiDecimal)this.getTotalPaidAmountToVendor())).add((AbstractKualiDecimal)this.getTotalPaidAmountToRequests());
        if (!grandTotal.isPositive()) {
            return KualiDecimal.ZERO;
        }
        return grandTotal;
    }

    public KualiDecimal getPaymentAmount() {
        KualiDecimal reimbursableExpenseTotal = this.getEligibleAmount();
        if (reimbursableExpenseTotal.isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return KualiDecimal.ZERO;
        }
        KualiDecimal reimbursableExpenseTotalWithExpenseLimit = this.applyExpenseLimit(reimbursableExpenseTotal);
        return reimbursableExpenseTotalWithExpenseLimit;
    }

    public boolean requiresTravelerApprovalRouting() {
        return this.getTravelDocumentService().requiresTravelerApproval(this);
    }

    @Override
    public KualiDecimal getPerDiemAdjustment() {
        return null;
    }

    @Override
    public void setPerDiemAdjustment(KualiDecimal perDiemAdjustment) {
    }

    @Override
    public String getDefaultCardTypeCode() {
        return "OUT OF POCKET";
    }

    public boolean hasAttachment() {
        return this.getTravelPayment().isAttachmentCode();
    }

    public String getPaymentMethodCode() {
        return this.getTravelPayment().getPaymentMethodCode();
    }

    public Date getCorporateCardPaymentExtractDate() {
        return this.corporateCardPaymentExtractDate;
    }

    public void setCorporateCardPaymentExtractDate(Date corporateCardPaymentExtractDate) {
        this.corporateCardPaymentExtractDate = corporateCardPaymentExtractDate;
    }

    public Date getCorporateCardPaymentPaidDate() {
        return this.corporateCardPaymentPaidDate;
    }

    public void setCorporateCardPaymentPaidDate(Date corporateCardPaymentPaidDate) {
        this.corporateCardPaymentPaidDate = corporateCardPaymentPaidDate;
    }

    public Date getCorporateCardPaymentCancelDate() {
        return this.corporateCardPaymentCancelDate;
    }

    public void setCorporateCardPaymentCancelDate(Date corporateCardPaymentCancelDate) {
        this.corporateCardPaymentCancelDate = corporateCardPaymentCancelDate;
    }

    public String getTemProfileName() {
        if (!ObjectUtils.isNull((Object)((Object)this.getTraveler())) && !StringUtils.isBlank((String)this.getTraveler().getName())) {
            return this.getTraveler().getName().toUpperCase();
        }
        return "";
    }

    public String getCampusCode() {
        return this.getInitiator().getCampusCode();
    }

    protected Person getInitiator() {
        if (this.initiator == null) {
            this.initiator = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(this.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        }
        return this.initiator;
    }

    public void prepareForSave() {
        super.prepareForSave();
        if (this.wireTransfer != null) {
            this.wireTransfer.setDocumentNumber(this.documentNumber);
        }
        if (this.travelPayment != null) {
            this.travelPayment.setDocumentNumber(this.documentNumber);
        }
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed() && this.getTravelPayment().isImmediatePaymentIndicator()) {
            TEMReimbursementDocument.getPaymentSourceExtractionService().extractSingleImmediatePayment((PaymentSource)this);
        }
    }

    @Override
    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return true;
    }

    public boolean isCorporateCardPayable() {
        if (this.getImportedExpenses() != null && !this.getImportedExpenses().isEmpty()) {
            for (ImportedExpense expense : this.getImportedExpenses()) {
                if (!StringUtils.equals((String)expense.getCardType(), (String)"CORP")) continue;
                return true;
            }
        }
        return false;
    }

    public String getCorporateCardPaymentPdpStatus() {
        if (this.corporateCardPaymentCancelDate != null) {
            return "Canceled";
        }
        if (this.corporateCardPaymentPaidDate != null) {
            return "Paid";
        }
        if (this.corporateCardPaymentExtractDate != null) {
            return "Extracted";
        }
        return "Pre-Extraction";
    }

    @Override
    protected boolean shouldRouteByProfileAccount() {
        boolean shouldRouteByProfileAccount = !this.hasReimbursableExpenses() || this.hasOnlyPrepaidExpenses();
        return shouldRouteByProfileAccount;
    }

    public boolean hasReimbursableExpenses() {
        boolean actualExpenses = this.hasReimbursableExpenses(this.getActualExpenses());
        boolean perDiemExpenses = this.getPerDiemExpenses() != null && !this.getPerDiemExpenses().isEmpty();
        boolean reimbursableImportedExpenses = this.hasReimbursableExpenses(this.getImportedExpenses());
        return actualExpenses || perDiemExpenses || reimbursableImportedExpenses;
    }

    protected boolean hasReimbursableExpenses(List<? extends TemExpense> expenses) {
        if (expenses == null || expenses.isEmpty()) {
            return false;
        }
        for (TemExpense temExpense : expenses) {
            if (temExpense.getNonReimbursable().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Date getEffectiveDateForMileageRate(ActualExpense expense) {
        if (expense != null && expense.getExpenseDate() != null) {
            return expense.getExpenseDate();
        }
        return null;
    }

    @Override
    public Date getEffectiveDateForMileageRate(PerDiemExpense expense) {
        if (expense != null && expense.getMileageDate() != null) {
            return new Date(expense.getMileageDate().getTime());
        }
        return null;
    }

    @Override
    public Date getEffectiveDateForPerDiem(PerDiemExpense expense) {
        if (expense != null && expense.getMileageDate() != null) {
            return this.getEffectiveDateForPerDiem(expense.getMileageDate());
        }
        return null;
    }

    @Override
    public Date getEffectiveDateForPerDiem(Timestamp expenseDate) {
        return new Date(expenseDate.getTime());
    }

    @Override
    public Map<String, String> getDisapprovedAppDocStatusMap() {
        return null;
    }

    public static PaymentSourceHelperService getPaymentSourceHelperService() {
        if (paymentSourceHelperService == null) {
            paymentSourceHelperService = (PaymentSourceHelperService)SpringContext.getBean(PaymentSourceHelperService.class);
        }
        return paymentSourceHelperService;
    }

    public static PaymentSourceExtractionService getPaymentSourceExtractionService() {
        if (paymentSourceExtractionService == null) {
            paymentSourceExtractionService = (PaymentSourceExtractionService)SpringContext.getBean(PaymentSourceExtractionService.class, (String)"travelReimbursementsExtractService");
        }
        return paymentSourceExtractionService;
    }

    public static AccountingDocumentRelationshipService getAccountingDocumentRelationshipService() {
        if (accountingDocumentRelationshipService == null) {
            accountingDocumentRelationshipService = (AccountingDocumentRelationshipService)SpringContext.getBean(AccountingDocumentRelationshipService.class);
        }
        return accountingDocumentRelationshipService;
    }

    public static PurchasingAccountsPayableModuleService getPurchasingAccountsPayableModuleService() {
        if (purapModuleService == null) {
            purapModuleService = (PurchasingAccountsPayableModuleService)SpringContext.getBean(PurchasingAccountsPayableModuleService.class);
        }
        return purapModuleService;
    }
}

