/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.document.service.TravelArrangerDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;

public class TravelArrangerDocument
extends FinancialSystemTransactionalDocumentBase {
    private Integer profileId;
    private String arrangerId;
    private String travelerName;
    private Boolean taInd = Boolean.FALSE;
    private Boolean trInd = Boolean.FALSE;
    private Boolean resign = Boolean.FALSE;
    private Boolean primaryInd = Boolean.FALSE;
    private TemProfile profile;
    private Person arranger;

    public Integer getProfileId() {
        return this.profileId;
    }

    public void setProfileId(Integer profileId) {
        this.profileId = profileId;
    }

    public String getArrangerId() {
        return this.arrangerId;
    }

    public void setArrangerId(String arrangerId) {
        this.arrangerId = arrangerId;
    }

    public String getTravelerName() {
        if (ObjectUtils.isNotNull((Object)((Object)this.profile))) {
            return this.profile.getName();
        }
        return "";
    }

    public void setTravelerName(String travelerName) {
        this.travelerName = travelerName;
    }

    public Boolean getTaInd() {
        return this.taInd;
    }

    public void setTaInd(Boolean taInd) {
        this.taInd = taInd;
    }

    public Boolean getTrInd() {
        return this.trInd;
    }

    public void setTrInd(Boolean trInd) {
        this.trInd = trInd;
    }

    public Boolean getResign() {
        return this.resign;
    }

    public void setResign(Boolean resign) {
        this.resign = resign;
    }

    public Boolean getPrimaryInd() {
        return this.primaryInd;
    }

    public void setPrimaryInd(Boolean primaryInd) {
        this.primaryInd = primaryInd;
    }

    public TemProfile getProfile() {
        return this.profile;
    }

    public void setProfile(TemProfile profile) {
        this.profile = profile;
    }

    public Person getArranger() {
        return this.arranger;
    }

    public void setArranger(Person arranger) {
        this.arranger = arranger;
    }

    public void initiateDocument() {
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        this.setArrangerId(currentUser.getPrincipalId());
        this.setArranger(currentUser);
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (DocumentStatus.FINAL.getCode().equals(statusChangeEvent.getNewRouteStatus()) || DocumentStatus.PROCESSED.getCode().equals(statusChangeEvent.getNewRouteStatus())) {
            if (this.getResign().booleanValue()) {
                this.getArrangerDocumentService().inactivateTravelProfileArranger(this);
            } else {
                this.getArrangerDocumentService().createTravelProfileArranger(this);
            }
        }
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("TravelRequiresTravelerApproval")) {
            return this.requiresTravelerApprovalRouting();
        }
        return false;
    }

    private boolean requiresTravelerApprovalRouting() {
        if (!this.getResign().booleanValue()) {
            this.refreshReferenceObject("profile");
            String principalId = this.getProfile().getPrincipalId();
            boolean routeToTraveler = false;
            if (principalId != null) {
                return true;
            }
        }
        return false;
    }

    protected TravelArrangerDocumentService getArrangerDocumentService() {
        return (TravelArrangerDocumentService)SpringContext.getBean(TravelArrangerDocumentService.class);
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }
}

