/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.document.DisbursementVoucherDocument;
import org.kuali.kfs.gl.service.SufficientFundsService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.krad.comparator.StringValueComparator;
import org.kuali.kfs.krad.document.Copyable;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.TemPropertyConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ClassOfService;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.GroupTraveler;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.PrimaryDestination;
import org.kuali.kfs.module.tem.businessobject.SpecialCircumstances;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TransportationModeDetail;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.businessobject.TravelerType;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelReimbursementService;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.module.tem.service.PerDiemService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.module.tem.service.TravelDocumentNotificationService;
import org.kuali.kfs.module.tem.service.TravelEncumbranceService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.module.tem.util.GroupTravelerComparator;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentBase;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.RoleService;

public abstract class TravelDocumentBase
extends AccountingDocumentBase
implements TravelDocument,
Copyable {
    protected static Logger LOG = Logger.getLogger(TravelDocumentBase.class);
    private TripType tripType;
    private String tripTypeCode;
    private Timestamp tripBegin;
    private Timestamp tripEnd;
    private String tripDescription;
    private Boolean primaryDestinationIndicator = false;
    private Integer primaryDestinationId;
    private PrimaryDestination primaryDestination;
    private String primaryDestinationName;
    private String primaryDestinationCountryState;
    private String primaryDestinationCounty;
    private KualiDecimal rate;
    private KualiDecimal expenseLimit;
    private String mealWithoutLodgingReason;
    private String dummyAppDocStatus;
    private String financialDocumentBankCode;
    protected boolean tripProgenitor;
    private Integer temProfileId;
    private TemProfile temProfile;
    private Integer travelerDetailId;
    private TravelerDetail traveler;
    private Bank bank;
    protected List<SpecialCircumstances> specialCircumstances = new ArrayList<SpecialCircumstances>();
    protected List<GroupTraveler> groupTravelers = new ArrayList<GroupTraveler>();
    protected List<PerDiemExpense> perDiemExpenses = new ArrayList<PerDiemExpense>();
    protected List<ActualExpense> actualExpenses = new ArrayList<ActualExpense>();
    protected List<ImportedExpense> importedExpenses = new ArrayList<ImportedExpense>();
    protected List<HistoricalTravelExpense> historicalTravelExpenses = new ArrayList<HistoricalTravelExpense>();
    protected String travelDocumentIdentifier;
    protected Integer travelDocumentLinkIdentifier;
    private Boolean delinquentTRException = false;
    private Boolean blanketTravel = false;
    protected static volatile transient TravelEncumbranceService travelEncumbranceService;
    @Transient
    private List<PropertyChangeListener> propertyChangeListeners = new ArrayList<PropertyChangeListener>();
    @Transient
    private Map<String, String> disabledProperties;
    @Transient
    private Boolean taxSelectable = Boolean.TRUE;

    protected TravelDocumentBase() {
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected TravelEncumbranceService getTravelEncumbranceService() {
        if (travelEncumbranceService == null) {
            travelEncumbranceService = (TravelEncumbranceService)SpringContext.getBean(TravelEncumbranceService.class);
        }
        return travelEncumbranceService;
    }

    protected TravelReimbursementService getTravelReimbursementService() {
        return (TravelReimbursementService)SpringContext.getBean(TravelReimbursementService.class);
    }

    protected TemRoleService getTemRoleService() {
        return (TemRoleService)SpringContext.getBean(TemRoleService.class);
    }

    protected TemProfileService getTemProfileService() {
        return (TemProfileService)SpringContext.getBean(TemProfileService.class);
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    protected ConfigurationService getConfigurationService() {
        return (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
    }

    protected TravelService getTravelService() {
        return (TravelService)SpringContext.getBean(TravelService.class);
    }

    protected TravelExpenseService getTravelExpenseService() {
        return (TravelExpenseService)SpringContext.getBean(TravelExpenseService.class);
    }

    protected TravelerService getTravelerService() {
        return (TravelerService)SpringContext.getBean(TravelerService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        return (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
    }

    protected WorkflowDocumentService getWorkflowDocumentService() {
        return (WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class);
    }

    @Override
    public AccountingDistributionService getAccountingDistributionService() {
        return (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
    }

    @Override
    public String getAppDocStatus() {
        String status = this.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus();
        return status;
    }

    public final boolean saveAppDocStatus() {
        boolean saved = false;
        try {
            this.getWorkflowDocumentService().save(this.getDocumentHeader().getWorkflowDocument(), null);
            saved = true;
        }
        catch (WorkflowException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return saved;
    }

    public String getDummyAppDocStatus() {
        return this.dummyAppDocStatus;
    }

    public void setDummyAppDocStatus(String dummyAppDocStatus) {
        this.dummyAppDocStatus = dummyAppDocStatus;
    }

    @Override
    public Boolean getPrimaryDestinationIndicator() {
        return this.primaryDestinationIndicator;
    }

    @Override
    public void setPrimaryDestinationIndicator(Boolean primaryDestinationIndicator) {
        this.primaryDestinationIndicator = primaryDestinationIndicator;
    }

    @Override
    @Column(name="TRIP_DESC")
    public String getTripDescription() {
        return this.tripDescription;
    }

    @Override
    public Integer getPrimaryDestinationId() {
        return this.primaryDestinationId;
    }

    @Override
    public void setPrimaryDestinationId(Integer primaryDestinationId) {
        this.primaryDestinationId = primaryDestinationId;
    }

    @Override
    public PrimaryDestination getPrimaryDestination() {
        if (this.primaryDestination == null) {
            this.primaryDestination = new PrimaryDestination();
        }
        return this.primaryDestination;
    }

    @Override
    public void setPrimaryDestination(PrimaryDestination primaryDestination) {
        this.primaryDestination = primaryDestination;
        if (primaryDestination != null) {
            this.setPrimaryDestinationCountryState(primaryDestination.getRegion().getRegionName());
            this.setPrimaryDestinationCounty(primaryDestination.getCounty());
            this.setPrimaryDestinationName(primaryDestination.getPrimaryDestinationName());
        } else {
            this.setPrimaryDestinationCountryState(null);
            this.setPrimaryDestinationCounty(null);
            this.setPrimaryDestinationName(null);
        }
    }

    @Override
    public String getPrimaryDestinationName() {
        return this.primaryDestinationName;
    }

    @Override
    public void setPrimaryDestinationName(String primaryDestinationName) {
        this.primaryDestinationName = primaryDestinationName;
    }

    @Override
    public String getPrimaryDestinationCountryState() {
        return this.primaryDestinationCountryState;
    }

    @Override
    public void setPrimaryDestinationCountryState(String primaryDestinationCountryState) {
        if (primaryDestinationCountryState != null) {
            primaryDestinationCountryState = primaryDestinationCountryState.toUpperCase();
        }
        this.primaryDestinationCountryState = primaryDestinationCountryState;
    }

    @Override
    public String getPrimaryDestinationCounty() {
        return this.primaryDestinationCounty;
    }

    @Override
    public void setPrimaryDestinationCounty(String primaryDestinationCounty) {
        this.primaryDestinationCounty = primaryDestinationCounty;
    }

    @Override
    public void setTripDescription(String tripDescription) {
        this.tripDescription = tripDescription;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="TRIP_TYP_CD")
    public TripType getTripType() {
        return this.tripType;
    }

    @Override
    public void setTripType(TripType tripType) {
        this.tripType = tripType;
    }

    @Override
    @Column(name="TRIP_TYP_CD", length=3)
    public String getTripTypeCode() {
        return this.tripTypeCode;
    }

    @Override
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    @Override
    @Column(name="TRVL_ID")
    public String getTravelDocumentIdentifier() {
        return this.travelDocumentIdentifier;
    }

    @Override
    public void setTravelDocumentIdentifier(String travelDocumentIdentifier) {
        this.travelDocumentIdentifier = travelDocumentIdentifier;
    }

    @Override
    @Column(name="TRIP_BGN_DT")
    public Timestamp getTripBegin() {
        return this.tripBegin;
    }

    @Override
    public void setTripBegin(Timestamp tripBegin) {
        this.tripBegin = tripBegin;
    }

    @Override
    @Column(name="TRIP_END_DT")
    public Timestamp getTripEnd() {
        return this.tripEnd;
    }

    @Override
    public void setTripEnd(Timestamp tripEnd) {
        this.tripEnd = tripEnd;
    }

    @Override
    public boolean canReturn() {
        return this.getDocumentHeader().getWorkflowDocument().isEnroute();
    }

    @Override
    public Integer getTravelDocumentLinkIdentifier() {
        return this.travelDocumentLinkIdentifier;
    }

    @Override
    public void setTravelDocumentLinkIdentifier(Integer travelDocumentLinkIdentifier) {
        this.travelDocumentLinkIdentifier = travelDocumentLinkIdentifier;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="traveler_dtl_id")
    public TravelerDetail getTraveler() {
        return this.traveler;
    }

    @Override
    public void setTraveler(TravelerDetail traveler) {
        this.traveler = traveler;
    }

    @Override
    @Column(name="traveler_dtl_id")
    public Integer getTravelerDetailId() {
        return this.travelerDetailId;
    }

    @Override
    public void setTravelerDetailId(Integer travelerDetailId) {
        this.travelerDetailId = travelerDetailId;
    }

    @Override
    @Column(name="expenseLimit", precision=19, scale=2)
    public KualiDecimal getExpenseLimit() {
        return this.expenseLimit;
    }

    @Override
    public void setExpenseLimit(KualiDecimal expenseLimit) {
        this.expenseLimit = expenseLimit;
    }

    public void setPropertyChangeListeners(List<PropertyChangeListener> propertyChangeListeners) {
        this.propertyChangeListeners = propertyChangeListeners;
    }

    public List<PropertyChangeListener> getPropertyChangeListeners() {
        return this.propertyChangeListeners;
    }

    protected void notifyChangeListeners(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.getPropertyChangeListeners()) {
            listener.propertyChange(event);
        }
    }

    @Override
    public void setSpecialCircumstances(List<SpecialCircumstances> specialCircumstances) {
        this.specialCircumstances = specialCircumstances;
    }

    @Override
    public List<SpecialCircumstances> getSpecialCircumstances() {
        return this.specialCircumstances;
    }

    public void prepareForSave(KualiDocumentEvent event) {
        if (ObjectUtils.isNull((Object)this.getTravelDocumentIdentifier())) {
            this.setTravelDocumentIdentifier(this.generateTripId());
            this.getDocumentHeader().setOrganizationDocumentNumber(this.getTravelDocumentIdentifier());
        }
        this.getDocumentHeader().setDocumentDescription(this.generateDescription());
        super.prepareForSave(event);
    }

    protected String getSequenceForTripId() {
        SequenceAccessorService sas = this.getSequenceAccessorService();
        Long trSequenceNumber = sas.getNextAvailableSequenceNumber("TRVL_ID_SEQ", this.getClass());
        return trSequenceNumber.toString();
    }

    protected String getTripIdPrefix() {
        return "T-";
    }

    public String generateTripId() {
        String travelerType = this.getParameterService().getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "INCLUDE_TRAVELER_TYPE_IN_TRIP_ID_IND", Boolean.FALSE) != false && !ObjectUtils.isNull((Object)((Object)this.getTraveler())) && !StringUtils.isBlank((String)this.getTraveler().getTravelerTypeCode()) ? this.getTraveler().getTravelerTypeCode() + "-" : "";
        return this.getTripIdPrefix() + travelerType + this.getSequenceForTripId();
    }

    protected String generateDescription() {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        PersonService ps = (PersonService)SpringContext.getBean(PersonService.class);
        Person person = ps.getPerson(this.getTraveler().getPrincipalId());
        this.getTraveler().refreshReferenceObject("customer");
        AccountsReceivableCustomer customer = this.getTraveler().getCustomer();
        if (person != null) {
            sb.append(person.getLastName() + ", " + person.getFirstName() + " " + person.getMiddleName() + " ");
        } else if (customer != null) {
            sb.append(customer.getCustomerName() + " ");
        } else {
            sb.append(this.getTraveler().getFirstName() + " " + this.getTraveler().getLastName() + " ");
        }
        if (this.getTripBegin() != null) {
            sb.append(format.format(this.getTripBegin()) + " ");
        }
        if (!ObjectUtils.isNull((Object)this.getPrimaryDestination()) && !StringUtils.isBlank((String)this.getPrimaryDestination().getPrimaryDestinationName()) && this.getPrimaryDestinationId() != null && this.getPrimaryDestinationId() != Integer.MAX_VALUE) {
            sb.append(this.getPrimaryDestination().getPrimaryDestinationName());
        } else if (!StringUtils.isBlank((String)this.getPrimaryDestinationName())) {
            sb.append(this.getPrimaryDestinationName());
        }
        String tempStr = sb.toString();
        if (this.getDelinquentAction() != null) {
            tempStr = "(Delinquent) " + tempStr;
        }
        if (tempStr.length() > 40) {
            tempStr = tempStr.substring(0, 39);
        }
        return tempStr;
    }

    public void toCopy() throws WorkflowException {
        super.toCopy();
        this.cleanTravelDocument();
        this.setTransportationModes(this.getTravelDocumentService().copyTransportationModeDetails(this.getTransportationModes(), this.getDocumentNumber()));
        this.setPerDiemExpenses(this.getTravelDocumentService().copyPerDiemExpenses(this.getPerDiemExpenses(), this.getDocumentNumber()));
        this.setSpecialCircumstances(this.getTravelDocumentService().copySpecialCircumstances(this.getSpecialCircumstances(), this.getDocumentNumber()));
        this.setTraveler(this.getTravelerService().copyTravelerDetail(this.getTraveler(), this.getDocumentNumber()));
        this.setGroupTravelers(this.getTravelDocumentService().copyGroupTravelers(this.getGroupTravelers(), this.getDocumentNumber()));
        this.setActualExpenses(this.getTravelDocumentService().copyActualExpenses(this.getActualExpenses(), this.getDocumentNumber()));
        this.setImportedExpenses(new ArrayList<ImportedExpense>());
        this.setNotes(new ArrayList());
        this.setApplicationDocumentStatus("In Process");
    }

    protected void cleanTravelDocument() {
        this.travelDocumentIdentifier = null;
        this.travelerDetailId = null;
        this.getTraveler().setId(null);
        this.getDocumentHeader().setOrganizationDocumentNumber("");
        this.getDocumentHeader().setDocumentDescription("(Description will be filled upon submit)");
        this.setPerDiemAdjustment(KualiDecimal.ZERO);
    }

    @Transient
    public boolean isValidExpenses() {
        if (this.actualExpenses == null) {
            return true;
        }
        int counter = 0;
        for (ActualExpense actualExpense : this.actualExpenses) {
            if (actualExpense.getExpenseDetails().size() > 0) {
                KualiDecimal detailAmount = actualExpense.getTotalDetailExpenseAmount();
                GlobalVariables.getMessageMap().addToErrorPath("document");
                GlobalVariables.getMessageMap().addToErrorPath("actualExpenses[" + counter + "]");
                if (detailAmount.isGreaterThan((AbstractKualiDecimal)actualExpense.getExpenseAmount()) && !"MM".equals(actualExpense.getExpenseTypeCode())) {
                    GlobalVariables.getMessageMap().putError("expenseAmount", "error.document.tem.actualexpense.totaldetailamountexceed", new String[]{detailAmount.toString(), actualExpense.getExpenseAmount().toString()});
                    return false;
                }
                GlobalVariables.getMessageMap().clearErrorPath();
            }
            ++counter;
        }
        return true;
    }

    @Transient
    public KualiDecimal getMealsAndIncidentalsGrandTotal() {
        PerDiemService service = (PerDiemService)SpringContext.getBean(PerDiemService.class);
        return service.getMealsAndIncidentalsGrandTotal(this);
    }

    @Transient
    public KualiDecimal getLodgingGrandTotal() {
        PerDiemService service = (PerDiemService)SpringContext.getBean(PerDiemService.class);
        return service.getLodgingGrandTotal(this);
    }

    @Transient
    public KualiDecimal getMileageTotalGrandTotal() {
        PerDiemService service = (PerDiemService)SpringContext.getBean(PerDiemService.class);
        return service.getMileageTotalGrandTotal(this);
    }

    @Override
    @Transient
    public KualiDecimal getDailyTotalGrandTotal() {
        PerDiemService service = (PerDiemService)SpringContext.getBean(PerDiemService.class);
        return service.getDailyTotalGrandTotal(this);
    }

    @Override
    @Transient
    public KualiDecimal getDocumentGrandTotal() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (TemConstants.ExpenseType expense : EnumSet.allOf(TemConstants.ExpenseType.class)) {
            total = (KualiDecimal)this.getTravelExpenseService().getExpenseServiceByType(expense).getAllExpenseTotal(this, true).add((AbstractKualiDecimal)total);
        }
        return total;
    }

    @Transient
    public Integer getMilesGrandTotal() {
        PerDiemService service = (PerDiemService)SpringContext.getBean(PerDiemService.class);
        return service.getMilesGrandTotal(this);
    }

    @Override
    @OneToMany(mappedBy="documentNumber")
    public List<PerDiemExpense> getPerDiemExpenses() {
        return this.perDiemExpenses;
    }

    @Override
    public void setPerDiemExpenses(List<PerDiemExpense> perDiemExpenses) {
        this.perDiemExpenses = perDiemExpenses;
    }

    @Override
    @OneToMany(mappedBy="documentNumber")
    public List<ActualExpense> getActualExpenses() {
        return this.actualExpenses;
    }

    @Override
    public void setActualExpenses(List<ActualExpense> actualExpenses) {
        this.actualExpenses = actualExpenses;
    }

    @Override
    @Transient
    public void enableExpenseTypeSpecificFields(List<ActualExpense> actualExpenses) {
        for (ActualExpense actualExpense : actualExpenses) {
            actualExpense.enableExpenseTypeSpecificFields();
        }
    }

    @Override
    @Transient
    public KualiDecimal getTotalPendingAmount(ActualExpense actualExpense) {
        KualiDecimal expenseAmount = actualExpense.getExpenseAmount();
        return (KualiDecimal)expenseAmount.subtract((AbstractKualiDecimal)actualExpense.getTotalDetailExpenseAmount());
    }

    @Override
    @Transient
    public KualiDecimal getParentExpenseAmount(List<ActualExpense> actualExpenses, Long id) {
        for (ActualExpense actualExpense : actualExpenses) {
            if (!actualExpense.getId().equals(id)) continue;
            return actualExpense.getExpenseAmount();
        }
        return KualiDecimal.ZERO;
    }

    @Override
    @Transient
    public ActualExpense getParentExpenseRecord(List<ActualExpense> actualExpenses, Long id) {
        for (ActualExpense actualExpense : actualExpenses) {
            if (!actualExpense.getId().equals(id)) continue;
            return actualExpense;
        }
        return null;
    }

    @Override
    @Transient
    public KualiDecimal getActualExpensesTotal() {
        KualiDecimal retval = KualiDecimal.ZERO;
        LOG.debug((Object)"Getting other expense total");
        if (this.actualExpenses != null) {
            for (ActualExpense expense : this.actualExpenses) {
                KualiDecimal expenseAmount = new KualiDecimal(expense.getExpenseAmount().bigDecimalValue().multiply(expense.getCurrencyRate()));
                LOG.debug((Object)("Expense amount gotten is " + expenseAmount));
                retval = (KualiDecimal)retval.add((AbstractKualiDecimal)expenseAmount);
            }
        }
        LOG.debug((Object)("Returning otherExpense Total " + retval));
        return retval;
    }

    @Override
    @Transient
    public void addActualExpense(ActualExpense line) {
        String sequenceName = line.getSequenceName();
        Long sequenceNumber = this.getSequenceAccessorService().getNextAvailableSequenceNumber(sequenceName, ActualExpense.class);
        line.setId(sequenceNumber);
        line.setDocumentNumber(this.documentNumber);
        this.notifyChangeListeners(new PropertyChangeEvent(this, "actualExpenses", null, line));
        line.enableExpenseTypeSpecificFields();
        this.getActualExpenses().add(line);
    }

    @Override
    @Transient
    public void addExpense(TemExpense line) {
        String sequenceName = line.getSequenceName();
        Long sequenceNumber = this.getSequenceAccessorService().getNextAvailableSequenceNumber(sequenceName, ImportedExpense.class);
        line.setId(sequenceNumber);
        line.setDocumentNumber(this.documentNumber);
        if (line instanceof ActualExpense) {
            this.getTravelExpenseService().updateTaxabilityOfActualExpense((ActualExpense)line, this, GlobalVariables.getUserSession().getPerson());
            this.getActualExpenses().add((ActualExpense)line);
            this.notifyChangeListeners(new PropertyChangeEvent(this, "actualExpenses", null, line));
            ((ActualExpense)line).enableExpenseTypeSpecificFields();
        } else {
            this.getImportedExpenses().add((ImportedExpense)line);
            this.notifyChangeListeners(new PropertyChangeEvent(this, "importedExpenses", null, line));
        }
    }

    @Override
    @Transient
    public void addExpenseDetail(TemExpense line, Integer index) {
        String sequenceName = line.getSequenceName();
        Long sequenceNumber = this.getSequenceAccessorService().getNextAvailableSequenceNumber(sequenceName, ImportedExpense.class);
        line.setId(sequenceNumber);
        line.setDocumentNumber(this.documentNumber);
        this.notifyChangeListeners(new PropertyChangeEvent(this, "importedExpenses", null, line));
        if (line instanceof ActualExpense) {
            this.getTravelExpenseService().updateTaxabilityOfActualExpense((ActualExpense)line, this, GlobalVariables.getUserSession().getPerson());
            this.getActualExpenses().get(index).addExpenseDetails(line);
            if (!(ObjectUtils.isNull((Object)((Object)this.getTraveler())) || StringUtils.isBlank((String)this.getTraveler().getTravelerTypeCode()) || StringUtils.isBlank((String)this.getTripTypeCode()))) {
                this.getActualExpenses().get(index).refreshExpenseTypeObjectCode(this.getDocumentTypeName(), this.getTraveler().getTravelerTypeCode(), this.getTripTypeCode());
            }
            this.notifyChangeListeners(new PropertyChangeEvent(this, "actualExpenses", null, line));
        } else {
            this.getImportedExpenses().get(index).addExpenseDetails(line);
            if (!(ObjectUtils.isNull((Object)((Object)this.getTraveler())) || StringUtils.isBlank((String)this.getTraveler().getTravelerTypeCode()) || StringUtils.isBlank((String)this.getTripTypeCode()))) {
                this.getImportedExpenses().get(index).refreshExpenseTypeObjectCode(this.getDocumentTypeName(), this.getTraveler().getTravelerTypeCode(), this.getTripTypeCode());
            }
            this.notifyChangeListeners(new PropertyChangeEvent(this, "importedExpenses", null, line));
        }
    }

    @Override
    @Transient
    public void removeActualExpense(Integer index) {
        ActualExpense line = this.getActualExpenses().remove(index);
        this.notifyChangeListeners(new PropertyChangeEvent(this, "actualExpenses", line, null));
        int nextIndex = -1;
        while ((nextIndex = this.getNextDetailIndex(line.getId())) != -1) {
            ActualExpense detailLine = this.getActualExpenses().remove(nextIndex);
            this.notifyChangeListeners(new PropertyChangeEvent(this, "actualExpenses", detailLine, null));
        }
    }

    @Override
    @Transient
    public void removeExpense(TemExpense expense, Integer index) {
        TemExpense line = null;
        if (expense instanceof ActualExpense) {
            line = this.getActualExpenses().remove(index);
            this.notifyChangeListeners(new PropertyChangeEvent(this, "actualExpenses", line, null));
        } else {
            line = this.getImportedExpenses().remove(index);
            this.notifyChangeListeners(new PropertyChangeEvent(this, "importedExpenses", line, null));
        }
    }

    @Override
    @Transient
    public void removeExpenseDetail(TemExpense expense, Integer index) {
        TemExpense line = expense.getExpenseDetails().remove(index);
        this.notifyChangeListeners(new PropertyChangeEvent(this, "expenseDetails", line, null));
    }

    @Transient
    private int getNextDetailIndex(Long id) {
        int index = 0;
        for (ActualExpense detailLine : this.getActualExpenses()) {
            if (ObjectUtils.isNotNull((Object)detailLine.getExpenseParentId()) && detailLine.getExpenseParentId().equals(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Transient
    public List<Map<String, KualiDecimal>> getPerDiemExpenseTotals() {
        return this.getTravelDocumentService().calculateDailyTotals(this.perDiemExpenses);
    }

    public KualiDecimal getRate() {
        return this.rate;
    }

    public void setRate(KualiDecimal rate) {
        this.rate = rate;
    }

    @Override
    public Map<String, String> getDisabledProperties() {
        if (this.disabledProperties == null) {
            this.disabledProperties = new HashMap<String, String>();
        }
        return this.disabledProperties;
    }

    public void setDisabledProperties(Map<String, String> disabledProperties) {
        this.disabledProperties = disabledProperties;
    }

    @Override
    public Integer getProfileId() {
        return this.temProfileId;
    }

    @Override
    public void setProfileId(Integer profileId) {
        this.temProfileId = profileId;
        HashMap<String, Integer> primaryKeys = new HashMap<String, Integer>();
        primaryKeys.put("profileId", profileId);
        this.setTemProfile((TemProfile)this.getBusinessObjectService().findByPrimaryKey(TemProfile.class, primaryKeys));
    }

    @Override
    public Integer getTemProfileId() {
        return this.temProfileId;
    }

    @Override
    public void setTemProfileId(Integer temProfileId) {
        this.temProfileId = temProfileId;
    }

    @Override
    public TemProfile getTemProfile() {
        return this.temProfile;
    }

    @Override
    public void setTemProfile(TemProfile temProfile) {
        this.temProfile = temProfile;
        if (temProfile != null) {
            this.getTravelerService().populateTemProfile(temProfile);
            if (temProfile.getTravelerType() == null) {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("code", temProfile.getTravelerTypeCode());
                List types = (List)this.getBusinessObjectService().findMatching(TravelerType.class, fieldValues);
                temProfile.setTravelerType((TravelerType)((Object)types.get(0)));
                this.setTemProfileId(temProfile.getProfileId());
            }
            if (this.traveler == null) {
                this.setTraveler(new TravelerDetail());
            }
            this.traveler.setDocumentNumber(this.documentNumber);
            this.getTravelerService().convertTemProfileToTravelerDetail(temProfile, this.traveler == null ? new TravelerDetail() : this.traveler);
        }
    }

    public void configureTraveler(Integer temProfileId, TravelerDetail traveler) {
        if (traveler != null && traveler.getId() != null) {
            this.temProfileId = temProfileId;
            HashMap<String, Integer> primaryKeys = new HashMap<String, Integer>();
            primaryKeys.put("profileId", temProfileId);
            this.temProfile = (TemProfile)this.getBusinessObjectService().findByPrimaryKey(TemProfile.class, primaryKeys);
            this.traveler = this.getTravelerService().copyTravelerDetail(traveler, this.documentNumber);
        } else {
            this.setProfileId(temProfileId);
        }
    }

    private String checkTravelerFieldForChanges(Object o1, Object o2, String propertyName, String noteText, String fieldLabel) {
        String profileFieldValue = (String)ObjectUtils.getPropertyValue((Object)o1, (String)propertyName);
        String travelerDetailFieldValue = (String)ObjectUtils.getPropertyValue((Object)o2, (String)propertyName);
        return this.checkTravelerFieldForChanges(profileFieldValue != null ? profileFieldValue.trim() : "", travelerDetailFieldValue != null ? travelerDetailFieldValue.trim() : "", noteText, fieldLabel);
    }

    private String checkTravelerFieldForChanges(String profileFieldValue, String travelerDetailFieldValue, String noteText, String fieldLabel) {
        if (StringValueComparator.getInstance().compare(profileFieldValue, travelerDetailFieldValue) == 0) {
            return noteText;
        }
        noteText = noteText + fieldLabel + ", ";
        return noteText;
    }

    @Override
    public String getDelinquentAction() {
        if (this.tripEnd != null) {
            Collection delinquentRules = this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "NUMBER_OF_DAYS_DELINQUENT");
            String action = null;
            if (delinquentRules != null) {
                for (String rule : delinquentRules) {
                    String[] arg = rule.split("=");
                    if (arg == null || arg.length != 2) continue;
                    Calendar cal = Calendar.getInstance();
                    cal.add(6, Integer.parseInt(arg[1]) * -1);
                    if (!this.tripEnd.before(cal.getTime())) continue;
                    if (action != null) {
                        if (TemPropertyConstants.delinquentActionsRank().get(action) >= TemPropertyConstants.delinquentActionsRank().get(arg[0])) continue;
                        action = arg[0];
                        continue;
                    }
                    action = arg[0];
                }
            }
            return action;
        }
        return null;
    }

    @Override
    public boolean canDisplayAgencySitesUrl() {
        String value = this.getConfigurationService().getPropertyValueAsString("config.document.travelRelocation.agencySites.enable");
        return value != null && value.length() != 0 && value.equalsIgnoreCase("Y");
    }

    @Override
    public String getAgencySitesUrl() {
        return this.getConfigurationService().getPropertyValueAsString("url.document.travelRelocation.agencySites");
    }

    @Override
    public boolean canPassTripIdToAgencySites() {
        String value = this.getConfigurationService().getPropertyValueAsString("config.document.travelRelocation.agencySites.include.tripId");
        return value != null && value.length() != 0 && value.equalsIgnoreCase("Y");
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getImportedExpenses());
        managedLists.add(this.getPerDiemExpenses());
        managedLists.add(this.getGroupTravelers());
        managedLists.add(this.getAllActualExpensesWithDetails());
        return managedLists;
    }

    public List<TemExpense> getAllActualExpensesWithDetails() {
        ArrayList<TemExpense> expenseList = new ArrayList<TemExpense>();
        if (ObjectUtils.isNotNull(this.getActualExpenses())) {
            for (ActualExpense ae : this.getActualExpenses()) {
                expenseList.add(ae);
                if (ae.getExpenseDetails().isEmpty()) continue;
                expenseList.addAll(ae.getExpenseDetails());
            }
        }
        return expenseList;
    }

    @Override
    public Boolean getDelinquentTRException() {
        return this.delinquentTRException != null ? this.delinquentTRException : false;
    }

    public void setDelinquentTRException(Boolean delinquentTRException) {
        this.delinquentTRException = delinquentTRException;
    }

    @Override
    public Boolean getBlanketTravel() {
        return this.blanketTravel;
    }

    public Boolean isBlanketTravel() {
        return this.getBlanketTravel();
    }

    public void setBlanketTravel(Boolean blanketTravel) {
        this.blanketTravel = blanketTravel;
    }

    public void setTaxSelectable(Boolean argTaxSelectable) {
        this.taxSelectable = argTaxSelectable;
    }

    public Boolean getTaxSelectable() {
        return this.taxSelectable;
    }

    public Boolean isTaxSelectable() {
        return this.taxSelectable;
    }

    protected boolean requiresAccountApprovalRouting() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (AccountingLine line : this.getSourceAccountingLines()) {
            if (!line.getAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    protected boolean requiresDivisionApprovalRouting() {
        return this.getTravelDocumentService().getTotalAuthorizedEncumbrance(this).isGreaterEqual((AbstractKualiDecimal)new KualiDecimal(this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "CUMULATIVE_REIMBURSABLE_AMOUNT_WITHOUT_DIVISION_APPROVAL")));
    }

    protected boolean requiresInternationalTravelReviewRouting() {
        return ObjectUtils.isNotNull((Object)this.getTripTypeCode()) && this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "INTERNATIONAL_TRIP_TYPES").contains(this.getTripTypeCode());
    }

    protected boolean requiresTaxManagerApprovalRouting() {
        for (TemExpense temExpense : this.getAllActualExpensesWithDetails()) {
            if (!temExpense.getTaxable().booleanValue()) continue;
            return true;
        }
        for (TemExpense temExpense : this.getImportedExpenses()) {
            if (!temExpense.getTaxable().booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected boolean requiresSeparationOfDutiesRouting() {
        String code = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "SEPARATION_OF_DUTIES_ROUTING_CHOICE");
        if (code.equals("F")) {
            if (!this.requiresAccountApprovalRouting()) {
                return false;
            }
            if (this.getTraveler().getPrincipalId() != null) {
                return this.getTravelDocumentService().isResponsibleForAccountsOn(this, this.getTraveler().getPrincipalId());
            }
        } else if (code.equals("D")) {
            if (!this.requiresDivisionApprovalRouting()) {
                return false;
            }
            if (this.getTraveler().getPrincipalId() != null) {
                RoleService service = (RoleService)SpringContext.getBean(RoleService.class);
                List principalIds = (List)service.getRoleMemberPrincipalIds("KFS-TEM", "Division Reviewer", null);
                for (String id : principalIds) {
                    if (!id.equals(this.getTraveler().getPrincipalId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean requiresSpecialRequestReviewRouting() {
        for (TemExpense expense : this.getAllActualExpensesWithDetails()) {
            if (!this.checkActualExpenseSpecialRequest(expense)) continue;
            return true;
        }
        return false;
    }

    private boolean checkActualExpenseSpecialRequest(TemExpense expense) {
        ExpenseTypeObjectCode expenseTypeCode;
        if (StringUtils.isNotEmpty((String)expense.getClassOfServiceCode())) {
            HashMap<String, String> searchMap = new HashMap<String, String>();
            searchMap.put("code", expense.getClassOfServiceCode());
            ClassOfService classOfService = (ClassOfService)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(ClassOfService.class, searchMap);
            if (classOfService.isApprovalRequired()) {
                return true;
            }
        }
        if ((expenseTypeCode = expense.getExpenseTypeObjectCode()).isSpecialRequestRequired()) {
            return true;
        }
        return expense.isRentalCar() && expense.getRentalCarInsurance() != false;
    }

    protected boolean isBudgetReviewRequired() {
        List fundsItems;
        UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        GeneralLedgerPendingEntryService generalLedgerPendingEntryService = (GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class);
        SufficientFundsService sufficientFundsService = (SufficientFundsService)SpringContext.getBean(SufficientFundsService.class);
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        Integer fiscalYear = universityDateService.getCurrentFiscalYear();
        if (this.getTripEnd() != null) {
            Calendar tripEndCal = Calendar.getInstance();
            tripEndCal.setTimeInMillis(this.getTripEnd().getTime());
            fiscalYear = new Integer(tripEndCal.get(1));
        }
        return universityDateService.getCurrentFiscalYear().compareTo(fiscalYear) >= 0 && (fundsItems = sufficientFundsService.checkSufficientFunds(this.getPendingLedgerEntriesForSufficientFundsChecking())) != null && fundsItems.size() > 0;
    }

    @Override
    public List<GroupTraveler> getGroupTravelers() {
        Collections.sort(this.groupTravelers, new GroupTravelerComparator());
        return this.groupTravelers;
    }

    @Override
    public void setGroupTravelers(List<GroupTraveler> groupTravelers) {
        this.groupTravelers = groupTravelers;
    }

    @Override
    public void addGroupTravelerLine(GroupTraveler line) {
        line.setFinancialDocumentLineNumber(this.groupTravelers.size() + 1);
        line.setDocumentNumber(this.documentNumber);
        this.groupTravelers.add(line);
    }

    @Override
    public KualiDecimal getTotalFor(String financialObjectCode) {
        KualiDecimal retval = KualiDecimal.ZERO;
        LOG.debug((Object)("Getting total for " + financialObjectCode));
        for (AccountingLine line : this.getSourceAccountingLines()) {
            try {
                LOG.debug((Object)("Comparing " + financialObjectCode + " to " + line.getObjectCode().getCode()));
                if (!line.getObjectCode().getCode().equals(financialObjectCode)) continue;
                retval = (KualiDecimal)retval.add((AbstractKualiDecimal)line.getAmount());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    @Override
    public KualiDecimal getNonReimbursableTotal() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (TemConstants.ExpenseType expense : EnumSet.allOf(TemConstants.ExpenseType.class)) {
            total = (KualiDecimal)this.getTravelExpenseService().getExpenseServiceByType(expense).getNonReimbursableExpenseTotal(this).add((AbstractKualiDecimal)total);
        }
        return total;
    }

    @Override
    public KualiDecimal getApprovedAmount() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (TemConstants.ExpenseType expense : EnumSet.allOf(TemConstants.ExpenseType.class)) {
            total = (KualiDecimal)this.getTravelExpenseService().getExpenseServiceByType(expense).getAllExpenseTotal(this, false).add((AbstractKualiDecimal)total);
        }
        return total;
    }

    @Override
    public String getMealWithoutLodgingReason() {
        return this.mealWithoutLodgingReason;
    }

    public void setMealWithoutLodgingReason(String mealWithoutLodgingReason) {
        this.mealWithoutLodgingReason = mealWithoutLodgingReason;
    }

    public boolean isMealsWithoutLodging() {
        Set<java.sql.Date> daysWithMeals = this.getDaysWithMeals(this.getPerDiemExpenses(), this.getActualExpenses());
        if (KfsDateUtils.isSameDay((Date)this.getTripBegin(), (Date)this.getTripEnd()) && !daysWithMeals.isEmpty()) {
            return true;
        }
        for (java.sql.Date dayWithMeal : daysWithMeals) {
            if (this.hasLodgingExpenseOnDay(dayWithMeal, this.getPerDiemExpenses(), this.getActualExpenses()) || this.getTripEnd() != null && (this.getTripEnd() == null || KfsDateUtils.isSameDay((Date)this.getTripEnd(), (Date)dayWithMeal))) continue;
            return true;
        }
        return false;
    }

    protected Set<java.sql.Date> getDaysWithMeals(List<PerDiemExpense> perDiemExpenses, List<ActualExpense> actualExpenses) {
        HashSet<java.sql.Date> days = new HashSet<java.sql.Date>();
        for (PerDiemExpense perDiemExpense : perDiemExpenses) {
            if (!perDiemExpense.getBreakfastValue().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && !perDiemExpense.getLunchValue().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && !perDiemExpense.getDinnerValue().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            java.sql.Date day = new java.sql.Date(perDiemExpense.getMileageDate().getTime());
            days.add(day);
        }
        for (ActualExpense expense : actualExpenses) {
            if (!expense.isBreakfast() && !expense.isLunch() && !expense.isDinner()) continue;
            days.add(expense.getExpenseDate());
        }
        return days;
    }

    protected boolean hasLodgingExpenseOnDay(java.sql.Date day, List<PerDiemExpense> perDiemExpenses, List<ActualExpense> actualExpenses) {
        for (PerDiemExpense perDiemExpense : perDiemExpenses) {
            java.sql.Date perDiemDate = new java.sql.Date(perDiemExpense.getMileageDate().getTime());
            if (!KfsDateUtils.isSameDay((Date)day, (Date)perDiemDate) || !perDiemExpense.getLodging().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        for (ActualExpense expense : actualExpenses) {
            if (!KfsDateUtils.isSameDay((Date)day, (Date)expense.getExpenseDate()) || !expense.isLodging() && !expense.isLodgingAllowance()) continue;
            return true;
        }
        return false;
    }

    public String getFinancialDocumentBankCode() {
        return this.financialDocumentBankCode;
    }

    public void setFinancialDocumentBankCode(String financialDocumentBankCode) {
        this.financialDocumentBankCode = financialDocumentBankCode;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public void setDefaultBankCode() {
        Bank defaultBank = ((BankService)SpringContext.getBean(BankService.class)).getDefaultBankByDocType(this.getClass());
        if (defaultBank != null) {
            this.financialDocumentBankCode = defaultBank.getBankCode();
            this.bank = defaultBank;
        }
    }

    @Override
    public List<TransportationModeDetail> getTransportationModes() {
        return null;
    }

    @Override
    public void setTransportationModes(List<TransportationModeDetail> transportationModes) {
    }

    @Override
    public List<ImportedExpense> getImportedExpenses() {
        return this.importedExpenses;
    }

    @Override
    public void setImportedExpenses(List<ImportedExpense> importedExpenses) {
        this.importedExpenses = importedExpenses;
    }

    @Override
    public boolean isTripProgenitor() {
        return this.tripProgenitor;
    }

    public void setTripProgenitor(boolean tripProgenitor) {
        this.tripProgenitor = tripProgenitor;
    }

    @Override
    public KualiDecimal getCTSTotal() {
        KualiDecimal lessCtsCharges = this.getTravelExpenseService().getExpenseServiceByType(TemConstants.ExpenseType.importedCTS).getAllExpenseTotal(this, false);
        return lessCtsCharges;
    }

    public KualiDecimal getFullCTSTotal() {
        KualiDecimal lessCtsCharges = this.getTravelExpenseService().getExpenseServiceByType(TemConstants.ExpenseType.importedCTS).getAllExpenseTotal(this, true);
        return lessCtsCharges;
    }

    @Override
    public KualiDecimal getCorporateCardTotal() {
        KualiDecimal lessCorpCardCharges = this.getTravelExpenseService().getExpenseServiceByType(TemConstants.ExpenseType.importedCorpCard).getAllExpenseTotal(this, false);
        return lessCorpCardCharges;
    }

    @Override
    public List<HistoricalTravelExpense> getHistoricalTravelExpenses() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("tripId", this.getTravelDocumentIdentifier());
        this.historicalTravelExpenses = (List)this.getBusinessObjectService().findMatchingOrderBy(HistoricalTravelExpense.class, fieldValues, "transactionPostingDate", true);
        for (HistoricalTravelExpense historicalTravelExpense : this.historicalTravelExpenses) {
            historicalTravelExpense.refreshReferenceObject("creditCardAgency");
            historicalTravelExpense.refreshReferenceObject("agencyStagingData");
            historicalTravelExpense.refreshReferenceObject("creditCardStagingData");
            historicalTravelExpense.getCreditCardAgency().refreshReferenceObject("travelCardType");
        }
        return this.historicalTravelExpenses;
    }

    public List<HistoricalTravelExpense> getReconciledHistoricalTravelExpenses() {
        List<HistoricalTravelExpense> allHistoricalExpenses = this.getHistoricalTravelExpenses();
        ArrayList<HistoricalTravelExpense> reconciledHistoricalExpenses = new ArrayList<HistoricalTravelExpense>();
        for (HistoricalTravelExpense historicalExpense : allHistoricalExpenses) {
            if (!StringUtils.equals((String)historicalExpense.getReconciled(), (String)"R")) continue;
            reconciledHistoricalExpenses.add(historicalExpense);
        }
        return reconciledHistoricalExpenses;
    }

    @Override
    public void setHistoricalTravelExpenses(List<HistoricalTravelExpense> historicalTravelExpenses) {
        this.historicalTravelExpenses = historicalTravelExpenses;
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return false;
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        ArrayList<GeneralLedgerPendingEntrySourceDetail> accountingLines = new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
        if (this.getSourceAccountingLines() != null) {
            for (TemSourceAccountingLine line : this.getSourceAccountingLines()) {
                if (!line.getCardType().equals(this.getDefaultCardTypeCode())) continue;
                accountingLines.add((GeneralLedgerPendingEntrySourceDetail)line);
            }
        }
        return accountingLines;
    }

    @Override
    public void initiateDocument() {
        TemProfile temProfile;
        this.getDocumentHeader().setDocumentDescription("(Description will be filled upon submit)");
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        if (!this.getTemRoleService().isTravelArranger(currentUser) && (temProfile = this.getTemProfileService().findTemProfileByPrincipalId(currentUser.getPrincipalId())) != null) {
            this.setTemProfile(temProfile);
        }
    }

    @Override
    public KualiDecimal getEncumbranceTotal() {
        return KualiDecimal.ZERO;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        this.refreshNonUpdateableReferences();
        ((TravelDocumentNotificationService)SpringContext.getBean(TravelDocumentNotificationService.class)).sendNotificationOnChange(this, statusChangeEvent);
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            this.getTravelExpenseService().getExpenseServiceByType(TemConstants.ExpenseType.importedCTS).updateExpense(this);
            this.getTravelExpenseService().getExpenseServiceByType(TemConstants.ExpenseType.importedCorpCard).updateExpense(this);
        }
        LOG.debug((Object)("Handling Route Status changing to [" + statusChangeEvent.getNewRouteStatus() + "]"));
        String currStatus = this.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus();
        if (ObjectUtils.isNotNull((Object)currStatus)) {
            try {
                this.updateAndSaveAppDocStatus(currStatus);
            }
            catch (WorkflowException ex) {
                throw new RuntimeException("Could not update application document status", ex);
            }
        }
        if (DocumentStatus.DISAPPROVED.getCode().equals(statusChangeEvent.getNewRouteStatus())) {
            try {
                this.updateAndSaveAppDocStatus(this.getDisapprovedAppDocStatusMap().get(this.getAppDocStatus()));
            }
            catch (WorkflowException ex) {
                throw new RuntimeException("Could not update application document status on document disapproval", ex);
            }
        }
        if (DocumentStatus.CANCELED.getCode().equals(statusChangeEvent.getNewRouteStatus())) {
            try {
                this.updateAndSaveAppDocStatus("Cancelled");
            }
            catch (WorkflowException we) {
                throw new RuntimeException("Could not update application document status on document disapproval", we);
            }
        }
    }

    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        this.getTravelExpenseService().getExpenseServiceByType(TemConstants.ExpenseType.importedCTS).processExpense(this, sequenceHelper);
        this.getTravelExpenseService().getExpenseServiceByType(TemConstants.ExpenseType.importedCorpCard).processExpense(this, sequenceHelper);
        return true;
    }

    @Override
    public String getDocumentTypeName() {
        return this.getDataDictionaryEntry().getDocumentTypeName();
    }

    public boolean canPayDVToVendor() {
        return this.getDocumentHeader() != null && !this.getDocumentHeader().getWorkflowDocument().isCanceled() && !this.getDocumentHeader().getWorkflowDocument().isInitiated() && !this.getDocumentHeader().getWorkflowDocument().isException() && !this.getDocumentHeader().getWorkflowDocument().isDisapproved() && !this.getDocumentHeader().getWorkflowDocument().isSaved();
    }

    @Override
    public void populateVendorPayment(DisbursementVoucherDocument disbursementVoucherDocument) {
        disbursementVoucherDocument.getDocumentHeader().setDocumentDescription("Created by " + this.getDocumentTypeName() + " document" + (this.getTravelDocumentIdentifier() == null ? "." : ": " + this.getTravelDocumentIdentifier()));
        disbursementVoucherDocument.getDocumentHeader().setOrganizationDocumentNumber(this.getTravelDocumentIdentifier());
        String reasonCode = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "VENDOR_PAYMENT_REASON_CODE");
        disbursementVoucherDocument.getDvPayeeDetail().setDisbVchrPaymentReasonCode(reasonCode);
        disbursementVoucherDocument.getDocumentHeader().setOrganizationDocumentNumber(this.getTravelDocumentIdentifier());
        Calendar dueDate = Calendar.getInstance();
        dueDate.add(5, 1);
        disbursementVoucherDocument.setDisbursementVoucherDueDate(new java.sql.Date(dueDate.getTimeInMillis()));
        Person initiator = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(this.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        if (initiator == null) {
            throw new RuntimeException("Initiator could not be found in KIM!  Which is super-strange...this block should never execute in reality");
        }
        disbursementVoucherDocument.setDisbVchrContactPersonName(initiator.getPrincipalName());
        disbursementVoucherDocument.setDisbVchrContactPhoneNumber(initiator.getPhoneNumber());
    }

    @Override
    public List<SourceAccountingLine> getReimbursableSourceAccountingLines() {
        ArrayList<SourceAccountingLine> reimbursableLines = new ArrayList<SourceAccountingLine>();
        for (TemSourceAccountingLine line : this.getSourceAccountingLines()) {
            if (!"OUT OF POCKET".equals(line.getCardType())) continue;
            reimbursableLines.add(line);
        }
        return reimbursableLines;
    }

    @Override
    public String getDefaultAccountingLineCardAgencyType() {
        return this.getDefaultCardTypeCode();
    }

    @Override
    public boolean hasCustomDVDistribution() {
        return false;
    }

    public boolean isTripGenerateEncumbrance() {
        return this.getTripType() != null && this.getTripType().isGenerateEncumbrance() && !this.hasOnlyPrepaidExpenses();
    }

    @Override
    public boolean isSpecialCircumstancesDefaultOpen() {
        boolean isOpen = false;
        if (this.expenseLimit != null) {
            isOpen = true;
        } else {
            for (SpecialCircumstances circumstance : this.getSpecialCircumstances()) {
                if (!circumstance.getResponse().booleanValue()) continue;
                isOpen = true;
                break;
            }
        }
        return isOpen;
    }

    @Override
    public boolean isEmergencyContactDefaultOpen() {
        boolean isOpen = false;
        Collection internationalTrips = this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "INTERNATIONAL_TRIP_TYPES");
        if (internationalTrips.contains(this.getTripTypeCode())) {
            isOpen = this.traveler.getEmergencyContacts().isEmpty();
        }
        return isOpen;
    }

    @Override
    public abstract Map<String, String> getDisapprovedAppDocStatusMap();

    @Override
    public boolean isTravelAuthorizationDoc() {
        return TemConstants.TravelDocTypes.getAuthorizationDocTypes().contains(this.getDocumentTypeName());
    }

    @Override
    public boolean shouldRefreshExpenseTypeObjectCode() {
        if (!StringUtils.isBlank((String)this.getDocumentHeader().getDocumentNumber()) && !ObjectUtils.isNull((Object)this.getDocumentHeader()) && this.getDocumentHeader().getWorkflowDocument() != null && (this.getDocumentHeader().getWorkflowDocument().isInitiated() || this.getDocumentHeader().getWorkflowDocument().isSaved())) {
            return !ObjectUtils.isNull((Object)((Object)this.getTraveler())) && !StringUtils.isBlank((String)this.getTraveler().getTravelerTypeCode()) && !StringUtils.isBlank((String)this.getTripTypeCode());
        }
        return false;
    }

    @Override
    public void refreshExpenseTypeObjectCodesForExpenses() {
        for (ActualExpense actualExpense : this.getActualExpenses()) {
            actualExpense.refreshExpenseTypeObjectCode(this.getDocumentTypeName(), this.getTraveler().getTravelerTypeCode(), this.getTripTypeCode());
        }
        for (ImportedExpense importedExpense : this.getImportedExpenses()) {
            importedExpense.refreshExpenseTypeObjectCode(this.getDocumentTypeName(), this.getTraveler().getTravelerTypeCode(), this.getTripTypeCode());
        }
    }

    @Override
    public boolean isOnTripBegin(PerDiemExpense perDiemExpense) {
        if (this.getTripBegin() == null || perDiemExpense.getMileageDate() == null) {
            return false;
        }
        return KfsDateUtils.isSameDay((Date)this.getTripBegin(), (Date)perDiemExpense.getMileageDate());
    }

    @Override
    public boolean isOnTripEnd(PerDiemExpense perDiemExpense) {
        if (this.getTripEnd() == null || perDiemExpense.getMileageDate() == null) {
            return false;
        }
        return KfsDateUtils.isSameDay((Date)this.getTripEnd(), (Date)perDiemExpense.getMileageDate());
    }

    @Override
    public KualiDecimal getTotalAccountLineAmount() {
        KualiDecimal approvedAmount = this.getApprovedAmount();
        KualiDecimal totalAccountingLineAmount = new KualiDecimal(approvedAmount.bigDecimalValue());
        for (HistoricalTravelExpense expense : this.getHistoricalTravelExpenses()) {
            totalAccountingLineAmount = (KualiDecimal)totalAccountingLineAmount.subtract((AbstractKualiDecimal)expense.getConvertedAmount());
        }
        return totalAccountingLineAmount;
    }

    @Override
    public KualiDecimal applyExpenseLimit(KualiDecimal totalAmount) {
        if (this.getExpenseLimit() == null || !this.getExpenseLimit().isPositive()) {
            return totalAmount;
        }
        if (this.getExpenseLimit().isGreaterEqual((AbstractKualiDecimal)totalAmount)) {
            return totalAmount;
        }
        return this.getExpenseLimit();
    }

    public String getTotalDollarAmountForRouting() {
        if (!this.shouldRouteByProfileAccount()) {
            return "";
        }
        return this.getTotalDollarAmount().toString();
    }

    public String getProfileChartForRouting() {
        if (!this.shouldRouteByProfileAccount()) {
            return "";
        }
        if (ObjectUtils.isNotNull((Object)((Object)this.getTemProfile()))) {
            return this.getTemProfile().getDefaultChartCode();
        }
        return "";
    }

    public String getProfileAccountForRouting() {
        if (!this.shouldRouteByProfileAccount()) {
            return "";
        }
        if (ObjectUtils.isNotNull((Object)((Object)this.getTemProfile()))) {
            return this.getTemProfile().getDefaultAccount();
        }
        return "";
    }

    protected abstract boolean shouldRouteByProfileAccount();

    @Override
    public boolean hasOnlyPrepaidExpenses() {
        if (this.getPerDiemExpenses() != null && !this.getPerDiemExpenses().isEmpty()) {
            return false;
        }
        if (this.getImportedExpenses() != null && !this.getImportedExpenses().isEmpty()) {
            for (ImportedExpense importedExpense : this.getImportedExpenses()) {
                if (importedExpense.getNonReimbursable().booleanValue()) continue;
                return false;
            }
        }
        if (this.getActualExpenses() == null || this.getActualExpenses().isEmpty()) {
            return false;
        }
        for (ActualExpense actualExpense : this.getActualExpenses()) {
            if (!StringUtils.isBlank((String)actualExpense.getExpenseTypeCode()) && ObjectUtils.isNull((Object)((Object)actualExpense.getExpenseType()))) {
                actualExpense.refreshReferenceObject("expenseType");
            }
            if (ObjectUtils.isNull((Object)((Object)actualExpense.getExpenseType())) || actualExpense.getExpenseType().isPrepaidExpense()) continue;
            return false;
        }
        return true;
    }

    public boolean documentPerformsSufficientFundsCheck() {
        return false;
    }
}

