/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.authorization.TravelAuthorizationFamilyDocumentPresentationController;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;

public class TravelAuthorizationDocumentPresentationController
extends TravelAuthorizationFamilyDocumentPresentationController {
    @Override
    public Set<String> getEditModes(Document document) {
        WorkflowDocument wfDocument = document.getDocumentHeader().getWorkflowDocument();
        Set<String> editModes = super.getEditModes(document);
        this.addFullEntryEditMode(document, editModes);
        editModes.remove("checkAmountEntry");
        editModes.add("advancePaymentEntry");
        if (this.shouldAllowBlanketTravelEntry(document)) {
            editModes.add("blanketTravelEntry");
        }
        if (!wfDocument.isInitiated() && !wfDocument.isSaved()) {
            editModes.add("blanketTravelView");
        }
        if (document instanceof TravelAuthorizationDocument && ((TravelAuthorizationDocument)document).shouldProcessAdvanceForDocument() && this.isAtTravelerNode(wfDocument) || wfDocument.isInitiated() || wfDocument.isSaved()) {
            editModes.add("advancePolicyEntry");
        }
        if (document instanceof TravelAuthorizationDocument && ((TravelAuthorizationDocument)document).shouldProcessAdvanceForDocument() && this.isAtTravelNode(wfDocument)) {
            editModes.add("clearAdvanceMode");
        }
        Set nodeNames = document.getDocumentHeader().getWorkflowDocument().getNodeNames();
        if (wfDocument.isInitiated() || wfDocument.isSaved() || nodeNames != null && !nodeNames.isEmpty() && (nodeNames.contains("Tax") || nodeNames.contains("Travel"))) {
            editModes.add("expenseTaxableEntry");
        }
        if (wfDocument.isInitiated() || wfDocument.isSaved() || nodeNames != null && !nodeNames.isEmpty() && nodeNames.contains("Travel")) {
            editModes.add("expenseLimitEntry");
        }
        return editModes;
    }

    protected boolean shouldAllowBlanketTravelEntry(Document document) {
        if (!(document instanceof TravelAuthorizationDocument)) {
            return false;
        }
        TravelAuthorizationDocument travelAuthorization = (TravelAuthorizationDocument)document;
        if (!travelAuthorization.getDocumentHeader().getWorkflowDocument().isInitiated() && !travelAuthorization.getDocumentHeader().getWorkflowDocument().isSaved() || StringUtils.isBlank((String)travelAuthorization.getTripTypeCode())) {
            return false;
        }
        if (ObjectUtils.isNull((Object)((Object)travelAuthorization.getTripType()))) {
            travelAuthorization.refreshReferenceObject("tripType");
        }
        return !ObjectUtils.isNull((Object)((Object)travelAuthorization.getTripType())) && travelAuthorization.getTripType().isBlanketTravel();
    }

    public boolean isAtTravelNode(WorkflowDocument workflowDocument) {
        return workflowDocument.getCurrentNodeNames().contains("Travel");
    }

    public boolean isAtTravelerNode(WorkflowDocument workflowDocument) {
        return workflowDocument.getCurrentNodeNames().contains("Traveler");
    }

    public Set<String> getDocumentActions(Document document) {
        Set actions = super.getDocumentActions(document);
        TravelAuthorizationDocument travelAuth = (TravelAuthorizationDocument)document;
        if (this.canAmend(travelAuth)) {
            actions.add("canAmend");
        }
        if (this.canHold(travelAuth)) {
            actions.add("canHold");
        }
        if (this.canRemoveHold(travelAuth)) {
            actions.add("canRemoveHold");
        }
        if (this.canCloseAuthorization(travelAuth)) {
            actions.add("canCloseTA");
        }
        if (this.canCancelAuthorization(travelAuth)) {
            actions.add("canCancelTA");
        }
        if (this.canNewReimbursement(travelAuth)) {
            actions.add("canNewReimbursement");
        }
        if (this.canPayVendor(travelAuth)) {
            actions.add("canPayVendor");
        }
        return actions;
    }

    public boolean canAmend(TravelAuthorizationDocument document) {
        boolean can;
        boolean bl = can = this.isOpen(document) && this.isFinalOrProcessed(document);
        if (can) {
            TravelDocumentService travelDocumentService = (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
            List<Document> trRelatedDocumentList = travelDocumentService.getDocumentsRelatedTo(document, "TR");
            for (Document trDocument : trRelatedDocumentList) {
                can &= trDocument.getDocumentHeader().getWorkflowDocument().isCanceled() || trDocument.getDocumentHeader().getWorkflowDocument().isDisapproved();
            }
        }
        return can;
    }

    public boolean canHold(TravelAuthorizationDocument document) {
        return this.isOpen(document) && this.isFinalOrProcessed(document);
    }

    public boolean canRemoveHold(TravelAuthorizationDocument document) {
        return this.isHeld(document) && this.isFinalOrProcessed(document);
    }

    public boolean canCloseAuthorization(TravelAuthorizationDocument document) {
        return this.isOpen(document) && this.isFinalOrProcessed(document) && this.hasReimbursements(document) && !this.hasEnrouteReimbursements(document);
    }

    public boolean canCancelAuthorization(TravelAuthorizationDocument document) {
        boolean can;
        boolean bl = can = this.isOpen(document) && this.isFinalOrProcessed(document);
        if (can && this.hasReimbursements(document)) {
            can = false;
        }
        return can;
    }

    public boolean canNewReimbursement(TravelAuthorizationDocument document) {
        String documentType = document.getDocumentTypeName();
        boolean documentStatusCheck = this.isFinalOrProcessed(document);
        String appDocStatus = document.getApplicationDocumentStatus();
        boolean appDocStatusCheck = !appDocStatus.equals("Reimbursement On Hold") && !appDocStatus.equals("Cancelled") && !appDocStatus.equals("Pending Amendment") && !appDocStatus.equals("Retired Version") && !appDocStatus.equals("Closed");
        boolean statusCheck = documentStatusCheck && appDocStatusCheck;
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean hasInitAccess = false;
        if (this.getTemRoleService().canAccessTravelDocument(document, user) && !ObjectUtils.isNull((Object)((Object)document.getTraveler())) && document.getTemProfileId() != null && !ObjectUtils.isNull((Object)((Object)document.getTemProfile()))) {
            hasInitAccess = user.getPrincipalId().equals(document.getTraveler().getPrincipalId()) || this.getTemRoleService().isTravelDocumentArrangerForProfile(documentType, user.getPrincipalId(), document.getTemProfileId()) || this.getTemRoleService().isTravelArranger(user, document.getTemProfile().getHomeDepartment(), document.getTemProfileId().toString(), documentType);
        }
        boolean checkRelatedDocs = true;
        List<Document> docs = this.getTravelDocumentService().getDocumentsRelatedTo(document, "TR");
        for (Document doc : docs) {
            TravelReimbursementDocument trDoc = (TravelReimbursementDocument)doc;
            if (!trDoc.getDocumentHeader().getWorkflowDocument().isEnroute()) continue;
            checkRelatedDocs &= false;
        }
        if (StringUtils.equalsIgnoreCase((String)documentType, (String)"TAC")) {
            documentStatusCheck = document.getDocumentHeader().getWorkflowDocument().isFinal();
            appDocStatusCheck = appDocStatus.equals("Closed");
            statusCheck = documentStatusCheck && appDocStatusCheck;
        }
        return statusCheck && hasInitAccess && checkRelatedDocs;
    }

    protected boolean isHeld(TravelAuthorizationDocument document) {
        return "Reimbursement On Hold".equals(document.getAppDocStatus());
    }

    protected boolean hasReimbursements(TravelAuthorizationDocument document) {
        List<TravelReimbursementDocument> reimbursements = this.getTravelDocumentService().findReimbursementDocuments(document.getTravelDocumentIdentifier());
        return reimbursements != null && !reimbursements.isEmpty();
    }

    protected boolean hasEnrouteReimbursements(TravelAuthorizationDocument document) {
        List<TravelReimbursementDocument> reimbursements = this.getTravelDocumentService().findReimbursementDocuments(document.getTravelDocumentIdentifier());
        for (TravelReimbursementDocument reimbursement : reimbursements) {
            if (!StringUtils.equals((String)"R", (String)reimbursement.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode())) continue;
            return true;
        }
        return false;
    }
}

