/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.authorization.TravelDocumentPresentationController;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.context.SpringContext;

public abstract class TravelAuthorizationFamilyDocumentPresentationController
extends TravelDocumentPresentationController {
    protected TravelDocumentService travelDocumentService;

    public boolean canPayVendor(TravelAuthorizationDocument document) {
        if (this.getTravelDocumentService().isUnsuccessful(document)) {
            return false;
        }
        boolean enablePayments = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "VENDOR_PAYMENT_ALLOWED_BEFORE_FINAL_APPROVAL_IND");
        if (enablePayments) {
            return !this.isRetired(document) && !this.isCancelled(document) && document.getDocumentHeader() != null && !document.getDocumentHeader().getWorkflowDocument().isCanceled() && !document.getDocumentHeader().getWorkflowDocument().isInitiated() && !document.getDocumentHeader().getWorkflowDocument().isException() && !document.getDocumentHeader().getWorkflowDocument().isDisapproved() && !document.getDocumentHeader().getWorkflowDocument().isSaved();
        }
        return this.isOpen(document) && this.isFinalOrProcessed(document);
    }

    protected boolean isOpen(TravelAuthorizationDocument document) {
        return "Open For Reimbursement".equals(document.getAppDocStatus());
    }

    protected boolean isFinalOrProcessed(TravelAuthorizationDocument document) {
        return document.getDocumentHeader().getWorkflowDocument().isProcessed() || document.getDocumentHeader().getWorkflowDocument().isFinal();
    }

    protected boolean isRetired(TravelAuthorizationDocument document) {
        return "Retired Version".equals(document.getAppDocStatus());
    }

    protected boolean isCancelled(TravelAuthorizationDocument document) {
        return "Cancelled".equals(document.getAppDocStatus());
    }

    @Override
    protected TravelDocumentService getTravelDocumentService() {
        if (this.travelDocumentService == null) {
            this.travelDocumentService = (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
        }
        return this.travelDocumentService;
    }
}

