/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.listener;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.context.SpringContext;

public class ActualExpenseListener
implements PropertyChangeListener,
Serializable {
    public static Logger LOG = Logger.getLogger(ActualExpenseListener.class);
    protected volatile TravelDocumentService travelDocumentService;

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        TravelDocumentBase document = (TravelDocumentBase)event.getSource();
        if (event.getNewValue() instanceof ActualExpense) {
            ActualExpense newActualExpenseLine = (ActualExpense)event.getNewValue();
            this.getTravelDocumentService().disableDuplicateExpenses(document, newActualExpenseLine);
        } else if (event.getOldValue() instanceof ActualExpense) {
            ActualExpense newActualExpenseLine = (ActualExpense)event.getOldValue();
            LOG.debug((Object)("Removing expense " + newActualExpenseLine));
            if (this.getTravelDocumentService().isHostedMeal(newActualExpenseLine)) {
                int i = 0;
                Map<String, String> disabled = document.getDisabledProperties();
                for (PerDiemExpense perDiem : document.getPerDiemExpenses()) {
                    String mileageDate = new SimpleDateFormat("MM/dd/yyyy").format(perDiem.getMileageDate());
                    String expenseDate = new SimpleDateFormat("MM/dd/yyyy").format(newActualExpenseLine.getExpenseDate());
                    LOG.debug((Object)("Comparing " + mileageDate + " to " + expenseDate));
                    if (mileageDate.equals(expenseDate)) {
                        for (String meal : new String[]{"breakfast", "lunch", "dinner"}) {
                            String property = String.format("document.perDiemExpenses[%d].%s", i, meal);
                            disabled.remove(property);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected TravelDocumentService getTravelDocumentService() {
        if (this.travelDocumentService == null) {
            this.travelDocumentService = (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
        }
        return this.travelDocumentService;
    }
}

