/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLineTotalPercentage;
import org.kuali.kfs.module.tem.dataaccess.TravelDocumentDao;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelPaymentsHelperService;
import org.kuali.kfs.module.tem.document.service.TravelReimbursementService;
import org.kuali.kfs.pdp.businessobject.PaymentAccountDetail;
import org.kuali.kfs.pdp.businessobject.PaymentDetail;
import org.kuali.kfs.pdp.businessobject.PaymentGroup;
import org.kuali.kfs.sys.batch.service.PaymentSourceToExtractService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.document.PaymentSource;
import org.kuali.kfs.sys.document.service.PaymentSourceHelperService;
import org.kuali.kfs.sys.document.validation.event.AccountingDocumentSaveWithNoLedgerEntryGenerationEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ReimbursableDocumentExtractionHelperServiceImpl
implements PaymentSourceToExtractService<TEMReimbursementDocument> {
    Logger LOG = Logger.getLogger(ReimbursableDocumentExtractionHelperServiceImpl.class);
    protected DocumentService documentService;
    protected PaymentSourceHelperService paymentSourceHelperService;
    protected TravelDocumentDao travelDocumentDao;
    protected TravelPaymentsHelperService travelPaymentsHelperService;
    protected TravelReimbursementService travelReimbursementService;
    protected ParameterService parameterService;

    public Map<String, List<TEMReimbursementDocument>> retrievePaymentSourcesByCampus(boolean immediatesOnly) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"retrievePaymentSourcesByCampus() started");
        }
        HashMap<String, List<TEMReimbursementDocument>> documentsByCampus = new HashMap<String, List<TEMReimbursementDocument>>();
        List<TEMReimbursementDocument> reimbursables = this.retrieveAllApprovedReimbursableDocuments(immediatesOnly);
        HashMap<String, String> initiatorCampuses = new HashMap<String, String>();
        for (TEMReimbursementDocument document : reimbursables) {
            String campusCode = this.getTravelPaymentsHelperService().findCampusForDocument(document, initiatorCampuses);
            if (StringUtils.isBlank((String)campusCode)) continue;
            ArrayList<TEMReimbursementDocument> documentsForCampus = (ArrayList<TEMReimbursementDocument>)documentsByCampus.get(campusCode);
            if (documentsForCampus == null) {
                documentsForCampus = new ArrayList<TEMReimbursementDocument>();
                documentsByCampus.put(campusCode, documentsForCampus);
            }
            documentsForCampus.add(document);
        }
        return documentsByCampus;
    }

    protected List<TEMReimbursementDocument> retrieveAllApprovedReimbursableDocuments(boolean immediatesOnly) {
        ArrayList<TEMReimbursementDocument> allReimbursables = new ArrayList<TEMReimbursementDocument>();
        allReimbursables.addAll(this.getTravelDocumentDao().getReimbursementDocumentsByHeaderStatus("A", immediatesOnly));
        allReimbursables.addAll(this.getTravelDocumentDao().getRelocationDocumentsByHeaderStatus("A", immediatesOnly));
        allReimbursables.addAll(this.getTravelDocumentDao().getEntertainmentDocumentsByHeaderStatus("A", immediatesOnly));
        return allReimbursables;
    }

    public void cancelPayment(TEMReimbursementDocument reimbursableDoc, Date cancelDate) {
        if (reimbursableDoc.getTravelPayment().getCancelDate() == null) {
            try {
                reimbursableDoc.getTravelPayment().setCancelDate(cancelDate);
                this.getPaymentSourceHelperService().handleEntryCancellation((PaymentSource)reimbursableDoc, (PaymentSourceToExtractService)this);
                reimbursableDoc.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("X");
                this.getDocumentService().saveDocument((Document)reimbursableDoc, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
            }
            catch (WorkflowException we) {
                this.LOG.error((Object)("encountered workflow exception while attempting to save Disbursement Voucher: " + reimbursableDoc.getDocumentNumber() + " " + (Object)((Object)we)));
                throw new RuntimeException(we);
            }
        }
    }

    public boolean shouldRollBackPendingEntry(GeneralLedgerPendingEntry entry) {
        return StringUtils.equals((String)"TRCA", (String)entry.getFinancialDocumentTypeCode()) || StringUtils.equals((String)"TRWF", (String)entry.getFinancialDocumentTypeCode()) || StringUtils.equals((String)"ENCA", (String)entry.getFinancialDocumentTypeCode()) || StringUtils.equals((String)"ENWF", (String)entry.getFinancialDocumentTypeCode()) || StringUtils.equals((String)"RECA", (String)entry.getFinancialDocumentTypeCode()) || StringUtils.equals((String)"REWF", (String)entry.getFinancialDocumentTypeCode());
    }

    public PaymentGroup createPaymentGroup(TEMReimbursementDocument reimbursableDoc, Date processRunDate) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"createPaymentGroupForReimbursable() started");
        }
        PaymentGroup pg = this.getTravelPaymentsHelperService().buildGenericPaymentGroup(reimbursableDoc.getTraveler(), reimbursableDoc.getTemProfile(), reimbursableDoc.getTravelPayment(), reimbursableDoc.getFinancialDocumentBankCode());
        PaymentDetail paymentDetail = this.buildPaymentDetail(reimbursableDoc, processRunDate);
        pg.addPaymentDetails(paymentDetail);
        paymentDetail.setPaymentGroup(pg);
        return pg;
    }

    protected PaymentDetail buildPaymentDetail(TEMReimbursementDocument document, Date processRunDate) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"buildPaymentDetail() started");
        }
        PaymentDetail pd = this.getTravelPaymentsHelperService().buildGenericPaymentDetail(document.getDocumentHeader(), processRunDate, document.getTravelPayment(), this.getTravelPaymentsHelperService().getInitiator(document), document.getAchCheckDocumentType());
        pd.setPurchaseOrderNbr(document.getTravelDocumentIdentifier());
        pd.setOrganizationDocNbr(document.getTravelDocumentIdentifier());
        List<TemSourceAccountingLine> paymentAccountingLines = this.getAccountingLinesForPayment(document);
        List<PaymentAccountDetail> paymentAccounts = this.getTravelPaymentsHelperService().buildGenericPaymentAccountDetails(paymentAccountingLines);
        for (PaymentAccountDetail pad : paymentAccounts) {
            pd.addAccountDetail(pad);
        }
        return pd;
    }

    protected List<TemSourceAccountingLine> getAccountingLinesForPayment(TEMReimbursementDocument document) {
        List<TemSourceAccountingLine> outOfPocketAccountingLines = this.getOutOfPocketSourceAccountingLines(document.getSourceAccountingLines());
        if (this.shouldRedistributeDifferentTotal(document, outOfPocketAccountingLines)) {
            List<TemSourceAccountingLineTotalPercentage> accountingLinesTotalPercentages = this.getTravelReimbursementService().getPercentagesForLines(outOfPocketAccountingLines);
            List<TemSourceAccountingLine> redistributedLines = this.getTravelReimbursementService().createAccountingLinesFromPercentages(accountingLinesTotalPercentages, document.getTravelPayment().getCheckTotalAmount(), document.getDocumentNumber());
            return redistributedLines;
        }
        return outOfPocketAccountingLines;
    }

    protected List<TemSourceAccountingLine> getOutOfPocketSourceAccountingLines(List<TemSourceAccountingLine> sourceAccountingLines) {
        ArrayList<TemSourceAccountingLine> outOfPocketLines = new ArrayList<TemSourceAccountingLine>();
        for (TemSourceAccountingLine sourceAccountingLine : sourceAccountingLines) {
            if (!StringUtils.equals((String)sourceAccountingLine.getCardType(), (String)"OUT OF POCKET")) continue;
            outOfPocketLines.add(sourceAccountingLine);
        }
        return outOfPocketLines;
    }

    protected boolean shouldRedistributeDifferentTotal(TEMReimbursementDocument document, List<TemSourceAccountingLine> outOfPocketAccountingLines) {
        KualiDecimal outOfPocketTotal = this.getTravelReimbursementService().calculateLinesTotal(outOfPocketAccountingLines);
        return !outOfPocketTotal.equals((Object)document.getTravelPayment().getCheckTotalAmount());
    }

    public String getPreDisbursementCustomerProfileUnit() {
        String unit = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "PRE_DISBURSEMENT_EXTRACT_ORGANIZATION");
        return unit;
    }

    public String getPreDisbursementCustomerProfileSubUnit() {
        String subUnit = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "PRE_DISBURSEMENT_EXTRACT_SUB_UNIT");
        return subUnit;
    }

    public void markAsExtracted(TEMReimbursementDocument document, Date sqlProcessRunDate, KualiInteger paymentGroupId) {
        try {
            document.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("E");
            document.getTravelPayment().setExtractDate(sqlProcessRunDate);
            this.getDocumentService().saveDocument((Document)document, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        catch (WorkflowException we) {
            this.LOG.error((Object)("Could not save TEMReimbursementDocument document #" + document.getDocumentNumber() + ": " + (Object)((Object)we)));
            throw new RuntimeException(we);
        }
    }

    public KualiDecimal getPaymentAmount(TEMReimbursementDocument document) {
        return document.getTravelPayment().getCheckTotalAmount();
    }

    public String getImmediateExtractEMailFromAddress() {
        return this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "IMMEDIATE_EXTRACT_NOTIFICATION_FROM_EMAIL_ADDRESS");
    }

    public List<String> getImmediateExtractEmailToAddresses() {
        ArrayList<String> toAddresses = new ArrayList<String>();
        toAddresses.addAll(this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "IMMEDIATE_EXTRACT_NOTIFICATION_TO_EMAIL_ADDRESSES"));
        return toAddresses;
    }

    public void markAsPaid(TEMReimbursementDocument doc, Date processDate) {
        try {
            doc.getTravelPayment().setPaidDate(processDate);
            this.getDocumentService().saveDocument((Document)doc, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        catch (WorkflowException we) {
            this.LOG.error((Object)("encountered workflow exception while attempting to save Disbursement Voucher: " + doc.getDocumentNumber() + " " + (Object)((Object)we)));
            throw new RuntimeException(we);
        }
    }

    public void resetFromExtraction(TEMReimbursementDocument doc) {
        try {
            doc.getTravelPayment().setExtractDate(null);
            doc.getTravelPayment().setPaidDate(null);
            doc.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("A");
            this.getDocumentService().saveDocument((Document)doc, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        catch (WorkflowException we) {
            this.LOG.error((Object)("encountered workflow exception while attempting to save Disbursement Voucher: " + doc.getDocumentNumber() + " " + (Object)((Object)we)));
            throw new RuntimeException(we);
        }
    }

    public String getAchCheckDocumentType(TEMReimbursementDocument paymentSource) {
        return paymentSource.getAchCheckDocumentType();
    }

    public boolean handlesAchCheckDocumentType(String achCheckDocumentType) {
        return StringUtils.equals((String)achCheckDocumentType, (String)"TRCA") || StringUtils.equals((String)achCheckDocumentType, (String)"ENCA") || StringUtils.equals((String)achCheckDocumentType, (String)"RECA");
    }

    public boolean shouldExtractPayment(TEMReimbursementDocument paymentSource) {
        return KualiDecimal.ZERO.isLessThan((AbstractKualiDecimal)this.getPaymentAmount(paymentSource));
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public PaymentSourceHelperService getPaymentSourceHelperService() {
        return this.paymentSourceHelperService;
    }

    public void setPaymentSourceHelperService(PaymentSourceHelperService paymentSourceHelperService) {
        this.paymentSourceHelperService = paymentSourceHelperService;
    }

    public TravelDocumentDao getTravelDocumentDao() {
        return this.travelDocumentDao;
    }

    public void setTravelDocumentDao(TravelDocumentDao travelDocumentDao) {
        this.travelDocumentDao = travelDocumentDao;
    }

    public TravelPaymentsHelperService getTravelPaymentsHelperService() {
        return this.travelPaymentsHelperService;
    }

    public void setTravelPaymentsHelperService(TravelPaymentsHelperService travelPaymentsHelperService) {
        this.travelPaymentsHelperService = travelPaymentsHelperService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public TravelReimbursementService getTravelReimbursementService() {
        return this.travelReimbursementService;
    }

    public void setTravelReimbursementService(TravelReimbursementService travelReimbursementService) {
        this.travelReimbursementService = travelReimbursementService;
    }
}

